/*
 * Decompiled with CFR 0.152.
 */
package tdb.cmdline;

import arq.cmd.CmdException;
import arq.cmdline.ArgDecl;
import arq.cmdline.CmdArgModule;
import arq.cmdline.CmdGeneral;
import arq.cmdline.ModDataset;
import com.hp.hpl.jena.query.Dataset;
import com.hp.hpl.jena.query.Query;
import com.hp.hpl.jena.query.QueryExecution;
import com.hp.hpl.jena.query.QueryExecutionFactory;
import com.hp.hpl.jena.query.QueryFactory;
import com.hp.hpl.jena.query.ResultSet;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.shared.JenaException;
import com.hp.hpl.jena.sparql.core.assembler.AssemblerUtils;
import com.hp.hpl.jena.sparql.core.assembler.DatasetAssemblerVocab;
import com.hp.hpl.jena.tdb.TDBFactory;
import com.hp.hpl.jena.tdb.assembler.VocabTDB;
import com.hp.hpl.jena.tdb.base.file.Location;
import com.hp.hpl.jena.tdb.transaction.DatasetGraphTransaction;
import com.hp.hpl.jena.util.FileManager;
import java.util.ArrayList;
import java.util.List;
import org.apache.jena.atlas.logging.Log;
import org.apache.jena.riot.RDFDataMgr;
import tdb.cmdline.ModTDBAssembler;

public class ModTDBDataset
extends ModDataset {
    private ArgDecl argMem = new ArgDecl(true, "mem", "data");
    private ModTDBAssembler modAssembler = new ModTDBAssembler();
    private String inMemFile = null;

    @Override
    public void registerWith(CmdGeneral cmdLine) {
        cmdLine.add(this.argMem, "--mem=FILE", "Execute on an in-memory TDB database (for testing)");
        cmdLine.addModule(this.modAssembler);
    }

    @Override
    public void processArgs(CmdArgModule cmdLine) {
        this.inMemFile = cmdLine.getValue(this.argMem);
        this.modAssembler.processArgs(cmdLine);
    }

    @Override
    public Dataset createDataset() {
        if (this.inMemFile != null) {
            Dataset ds = TDBFactory.createDataset();
            RDFDataMgr.read(ds, this.inMemFile);
            return ds;
        }
        if (this.modAssembler.getAssemblerFile() != null) {
            Dataset thing = null;
            try {
                thing = (Dataset)AssemblerUtils.build(this.modAssembler.getAssemblerFile(), VocabTDB.tDatasetTDB);
                if (thing != null && !(thing.asDatasetGraph() instanceof DatasetGraphTransaction)) {
                    Log.warn(this, "Unexpected: Not a TDB dataset for type DatasetTDB");
                }
                if (thing == null) {
                    thing = (Dataset)AssemblerUtils.build(this.modAssembler.getAssemblerFile(), DatasetAssemblerVocab.tDataset);
                }
            }
            catch (JenaException ex) {
                throw ex;
            }
            catch (Exception ex) {
                throw new CmdException("Error creating", ex);
            }
            return thing;
        }
        if (this.modAssembler.getLocation() == null) {
            throw new CmdException("No assembler file nor location provided");
        }
        Dataset ds = TDBFactory.createDataset(this.modAssembler.getLocation());
        return ds;
    }

    public Location getLocation() {
        List<String> x = this.locations();
        if (x.size() == 0) {
            return null;
        }
        return Location.create(x.get(0));
    }

    public List<String> locations() {
        ArrayList<String> locations = new ArrayList<String>();
        if (this.modAssembler.getLocation() != null) {
            locations.add(this.modAssembler.getLocation().getDirectoryPath());
        }
        if (this.modAssembler.getAssemblerFile() != null) {
            Model m = FileManager.get().loadModel(this.modAssembler.getAssemblerFile());
            Query query2 = QueryFactory.create("PREFIX tdb:     <http://jena.hpl.hp.com/2008/tdb#> SELECT ?dir { [] tdb:location ?dir FILTER (isURI(?dir)) }");
            try (QueryExecution qExec = QueryExecutionFactory.create(query2, m);){
                ResultSet rs = qExec.execSelect();
                while (rs.hasNext()) {
                    String x = rs.nextSolution().getResource("dir").getURI();
                    locations.add(x);
                }
            }
        }
        return locations;
    }
}

