/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.wagon.providers.ssh;

import java.io.File;
import java.io.IOException;
import java.util.List;
import org.apache.maven.wagon.AbstractWagon;
import org.apache.maven.wagon.CommandExecutionException;
import org.apache.maven.wagon.CommandExecutor;
import org.apache.maven.wagon.PathUtils;
import org.apache.maven.wagon.PermissionModeUtils;
import org.apache.maven.wagon.ResourceDoesNotExistException;
import org.apache.maven.wagon.Streams;
import org.apache.maven.wagon.TransferFailedException;
import org.apache.maven.wagon.authentication.AuthenticationException;
import org.apache.maven.wagon.authentication.AuthenticationInfo;
import org.apache.maven.wagon.authorization.AuthorizationException;
import org.apache.maven.wagon.providers.ssh.LSParser;
import org.apache.maven.wagon.providers.ssh.SshWagon;
import org.apache.maven.wagon.providers.ssh.interactive.InteractiveUserInfo;
import org.apache.maven.wagon.providers.ssh.interactive.NullInteractiveUserInfo;
import org.apache.maven.wagon.providers.ssh.knownhost.KnownHostsProvider;
import org.apache.maven.wagon.repository.RepositoryPermissions;
import org.apache.maven.wagon.resource.Resource;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.plexus.util.StringUtils;

public abstract class AbstractSshWagon
extends AbstractWagon
implements CommandExecutor,
SshWagon {
    protected KnownHostsProvider knownHostsProvider;
    protected InteractiveUserInfo interactiveUserInfo;
    protected static final char PATH_SEPARATOR = '/';
    protected static final int DEFAULT_SSH_PORT = 22;

    public boolean getIfNewer(String resourceName, File destination, long timestamp) throws TransferFailedException, ResourceDoesNotExistException, AuthorizationException {
        this.fireSessionDebug("getIfNewer in SCP wagon is not supported - performing an unconditional get");
        this.get(resourceName, destination);
        return true;
    }

    protected String getOctalMode(RepositoryPermissions permissions) {
        String mode = "0644";
        if (permissions != null && permissions.getFileMode() != null) {
            if (permissions.getFileMode().matches("[0-9]{3,4}")) {
                mode = permissions.getFileMode();
                if (mode.length() == 3) {
                    mode = "0" + mode;
                }
            } else {
                this.fireSessionDebug("Not using non-octal permissions: " + mode);
            }
        }
        return mode;
    }

    protected int getDirectoryMode(RepositoryPermissions permissions) {
        int ret = -1;
        if (permissions != null) {
            ret = this.getOctalMode(permissions.getDirectoryMode());
        }
        return ret;
    }

    protected int getOctalMode(String mode) {
        int ret;
        try {
            ret = Integer.valueOf(mode, 8);
        }
        catch (NumberFormatException e) {
            this.fireTransferDebug("the file mode must be a numerical mode for SFTP");
            ret = -1;
        }
        return ret;
    }

    protected static String getResourceDirectory(String resourceName) {
        String dir = PathUtils.dirname(resourceName);
        dir = StringUtils.replace(dir, "\\", "/");
        return dir;
    }

    protected static String getResourceFilename(String r) {
        String filename = r.lastIndexOf(47) > 0 ? r.substring(r.lastIndexOf(47) + 1) : r;
        return filename;
    }

    protected static Resource getResource(String resourceName) {
        String r = StringUtils.replace(resourceName, "\\", "/");
        return new Resource(r);
    }

    public void openConnection() throws AuthenticationException {
        if (this.authenticationInfo == null) {
            this.authenticationInfo = new AuthenticationInfo();
        }
        if (this.authenticationInfo.getUserName() == null) {
            this.authenticationInfo.setUserName(System.getProperty("user.name"));
        }
        if (!this.interactive) {
            this.interactiveUserInfo = new NullInteractiveUserInfo();
        }
    }

    protected File getPrivateKey() {
        File privateKey = null;
        if (this.authenticationInfo.getPassword() == null && (privateKey = this.authenticationInfo.getPrivateKey() != null ? new File(this.authenticationInfo.getPrivateKey()) : this.findPrivateKey()).exists()) {
            if (this.authenticationInfo.getPassphrase() == null) {
                this.authenticationInfo.setPassphrase("");
            }
            this.fireSessionDebug("Using private key: " + privateKey);
        }
        return privateKey;
    }

    protected int getPort() {
        int port = this.getRepository().getPort();
        if (port == -1) {
            port = 22;
        }
        return port;
    }

    private File findPrivateKey() {
        File privateKey;
        String privateKeyDirectory = System.getProperty("wagon.privateKeyDirectory");
        if (privateKeyDirectory == null) {
            privateKeyDirectory = System.getProperty("user.home");
        }
        if (!(privateKey = new File(privateKeyDirectory, ".ssh/id_dsa")).exists()) {
            privateKey = new File(privateKeyDirectory, ".ssh/id_rsa");
        }
        return privateKey;
    }

    public void executeCommand(String command) throws CommandExecutionException {
        this.fireTransferDebug("Executing command: " + command);
        this.executeCommand(command, false);
    }

    public final KnownHostsProvider getKnownHostsProvider() {
        return this.knownHostsProvider;
    }

    public final void setKnownHostsProvider(KnownHostsProvider knownHostsProvider) {
        if (knownHostsProvider == null) {
            throw new IllegalArgumentException("knownHostsProvider can't be null");
        }
        this.knownHostsProvider = knownHostsProvider;
    }

    public InteractiveUserInfo getInteractiveUserInfo() {
        return this.interactiveUserInfo;
    }

    public void setInteractiveUserInfo(InteractiveUserInfo interactiveUserInfo) {
        if (interactiveUserInfo == null) {
            throw new IllegalArgumentException("interactiveUserInfo can't be null");
        }
        this.interactiveUserInfo = interactiveUserInfo;
    }

    public void putDirectory(File sourceDirectory, String destinationDirectory) throws TransferFailedException, ResourceDoesNotExistException, AuthorizationException {
        File zipFile;
        String basedir = this.getRepository().getBasedir();
        String destDir = StringUtils.replace(destinationDirectory, "\\", "/");
        String path = AbstractWagon.getPath(basedir, destDir);
        try {
            String dirPerms;
            if (this.getRepository().getPermissions() != null && (dirPerms = this.getRepository().getPermissions().getDirectoryMode()) != null) {
                String umaskCmd = "umask " + PermissionModeUtils.getUserMaskFor(dirPerms);
                this.executeCommand(umaskCmd);
            }
            String mkdirCmd = "mkdir -p " + path;
            this.executeCommand(mkdirCmd);
        }
        catch (CommandExecutionException e) {
            throw new TransferFailedException("Error performing commands for file transfer", e);
        }
        try {
            zipFile = File.createTempFile("wagon", ".zip");
            zipFile.deleteOnExit();
            List files = FileUtils.getFileNames(sourceDirectory, "**/**", "", false);
            this.createZip(files, zipFile, sourceDirectory);
        }
        catch (IOException e) {
            throw new TransferFailedException("Unable to create ZIP archive of directory", e);
        }
        this.put(zipFile, AbstractWagon.getPath(destDir, zipFile.getName()));
        try {
            this.executeCommand("cd " + path + "; unzip -q -o " + zipFile.getName() + "; rm -f " + zipFile.getName());
            zipFile.delete();
            RepositoryPermissions permissions = this.getRepository().getPermissions();
            if (permissions != null && permissions.getGroup() != null) {
                this.executeCommand("chgrp -Rf " + permissions.getGroup() + " " + path);
            }
            if (permissions != null && permissions.getFileMode() != null) {
                this.executeCommand("chmod -Rf " + permissions.getFileMode() + " " + path);
            }
        }
        catch (CommandExecutionException e) {
            throw new TransferFailedException("Error performing commands for file transfer", e);
        }
    }

    public boolean supportsDirectoryCopy() {
        return true;
    }

    public List getFileList(String destinationDirectory) throws TransferFailedException, ResourceDoesNotExistException, AuthorizationException {
        try {
            String path = AbstractWagon.getPath(this.getRepository().getBasedir(), destinationDirectory);
            Streams streams = this.executeCommand("ls -la " + path, false);
            return new LSParser().parseFiles(streams.getOut());
        }
        catch (CommandExecutionException e) {
            if (e.getMessage().trim().endsWith("No such file or directory")) {
                throw new ResourceDoesNotExistException(e.getMessage().trim());
            }
            throw new TransferFailedException("Error performing file listing.", e);
        }
    }

    public boolean resourceExists(String resourceName) throws TransferFailedException, AuthorizationException {
        try {
            String path = AbstractWagon.getPath(this.getRepository().getBasedir(), resourceName);
            this.executeCommand("ls " + path);
            return true;
        }
        catch (CommandExecutionException e) {
            return false;
        }
    }

    protected void handleGetException(Resource resource, Exception e, File destination) throws TransferFailedException, ResourceDoesNotExistException {
        boolean deleted;
        this.fireTransferError(resource, e, 5);
        if (destination.exists() && !(deleted = destination.delete())) {
            destination.deleteOnExit();
        }
        String msg = "Error occured while downloading '" + resource + "' from the remote repository:" + this.getRepository();
        throw new TransferFailedException(msg, e);
    }

    public abstract /* synthetic */ Streams executeCommand(String var1, boolean var2) throws CommandExecutionException;

    public abstract /* synthetic */ void put(File var1, String var2) throws AuthorizationException, ResourceDoesNotExistException, TransferFailedException;

    public abstract /* synthetic */ void get(String var1, File var2) throws AuthorizationException, ResourceDoesNotExistException, TransferFailedException;
}

