/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.client.solrj.io.comp;

import java.io.IOException;
import java.io.Serializable;
import java.util.Comparator;
import org.apache.solr.client.solrj.io.Tuple;
import org.apache.solr.client.solrj.io.comp.ExpressibleComparator;
import org.apache.solr.client.solrj.io.stream.expr.StreamExpressionParameter;
import org.apache.solr.client.solrj.io.stream.expr.StreamExpressionValue;
import org.apache.solr.client.solrj.io.stream.expr.StreamFactory;

public class MultiComp
implements Comparator<Tuple>,
ExpressibleComparator,
Serializable {
    private static final long serialVersionUID = 1L;
    private Comparator<Tuple>[] comps;

    public MultiComp(Comparator<Tuple> ... comps) {
        this.comps = comps;
    }

    @Override
    public int compare(Tuple t1, Tuple t2) {
        for (Comparator<Tuple> comp : this.comps) {
            int i = comp.compare(t1, t2);
            if (i == 0) continue;
            return i;
        }
        return 0;
    }

    @Override
    public StreamExpressionParameter toExpression(StreamFactory factory) throws IOException {
        StringBuilder sb = new StringBuilder();
        for (Comparator<Tuple> comp : this.comps) {
            if (comp instanceof ExpressibleComparator) {
                if (sb.length() > 0) {
                    sb.append(",");
                }
            } else {
                throw new IOException("This MultiComp contains a non-expressible comparator - it cannot be converted to an expression");
            }
            sb.append(((ExpressibleComparator)((Object)comp)).toExpression(factory));
        }
        return new StreamExpressionValue(sb.toString());
    }
}

