/*
 * Decompiled with CFR 0.152.
 */
package org.dataone.cn.dao;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.sql.DataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dataone.cn.dao.MetacatDataSourceFactory;
import org.dataone.cn.dao.ReplicationPolicyEntry;
import org.dataone.cn.dao.SystemMetadataDao;
import org.dataone.cn.dao.SystemMetadataStatus;
import org.dataone.cn.dao.exceptions.DataAccessException;
import org.dataone.exceptions.MarshallingException;
import org.dataone.service.exceptions.InvalidSystemMetadata;
import org.dataone.service.types.v1.AccessPolicy;
import org.dataone.service.types.v1.AccessRule;
import org.dataone.service.types.v1.Checksum;
import org.dataone.service.types.v1.Identifier;
import org.dataone.service.types.v1.NodeReference;
import org.dataone.service.types.v1.ObjectFormatIdentifier;
import org.dataone.service.types.v1.Permission;
import org.dataone.service.types.v1.Replica;
import org.dataone.service.types.v1.ReplicationPolicy;
import org.dataone.service.types.v1.ReplicationStatus;
import org.dataone.service.types.v1.Subject;
import org.dataone.service.types.v2.SystemMetadata;
import org.dataone.service.util.TypeMarshaller;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.PreparedStatementCreator;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.datasource.DataSourceTransactionManager;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.AbstractPlatformTransactionManager;
import org.springframework.transaction.support.TransactionCallback;
import org.springframework.transaction.support.TransactionTemplate;

public class SystemMetadataDaoMetacatImpl
implements SystemMetadataDao {
    private static final Log log = LogFactory.getLog(SystemMetadataDaoMetacatImpl.class);
    protected static int documentIdCounter = 0;
    public static final String IDENTIFIER_TABLE = "identifier";
    public static final String SYSMETA_TABLE = "systemmetadata";
    public static final String SM_POLICY_TABLE = "smreplicationpolicy";
    public static final String SM_STATUS_TABLE = "smreplicationstatus";
    public static final String ACCESS_TABLE = "xml_access";
    private JdbcTemplate jdbcTemplate;
    protected static Map<String, String> tableMap = new HashMap<String, String>();
    private AbstractPlatformTransactionManager txManager;
    private TransactionTemplate txTemplate;

    public SystemMetadataDaoMetacatImpl() {
        this(MetacatDataSourceFactory.getMetacatDataSource());
    }

    public SystemMetadataDaoMetacatImpl(DataSource dataSource) {
        this.jdbcTemplate = new JdbcTemplate(dataSource);
        this.txManager = new DataSourceTransactionManager(dataSource);
        this.txTemplate = new TransactionTemplate(this.txManager);
        this.txTemplate.setIsolationLevel(2);
    }

    @Override
    public int getSystemMetadataCount() throws DataAccessException {
        return this.getSystemMetadataCount(tableMap);
    }

    @Override
    public List<SystemMetadataStatus> listSystemMetadataStatus(int pageNumber, int pageSize) throws DataAccessException {
        return this.listSystemMetadataStatus(pageNumber, pageSize, tableMap);
    }

    @Override
    public SystemMetadata getSystemMetadata(Identifier pid) throws DataAccessException {
        return this.getSystemMetadata(pid, tableMap);
    }

    public int getSystemMetadataCount(Map<String, String> tableMap) throws DataAccessException {
        String sqlStatement = "SELECT count(guid) FROM " + tableMap.get(SYSMETA_TABLE);
        int count = 0;
        try {
            count = this.jdbcTemplate.queryForInt(sqlStatement);
        }
        catch (org.springframework.dao.DataAccessException dae) {
            this.handleJdbcDataAccessException(dae);
        }
        return count;
    }

    public List<SystemMetadataStatus> listSystemMetadataStatus(int pageNumber, int pageSize, Map<String, String> tableMap) throws DataAccessException {
        ArrayList<SystemMetadataStatus> sysMetaStatusList = new ArrayList();
        if (pageNumber < 1) {
            pageNumber = 0;
        }
        if (pageSize < 0) {
            pageSize = 0;
        }
        final int finalPageNumber = pageNumber;
        final int finalPageSize = pageSize;
        final int offset = (pageNumber - 1) * pageSize;
        final Map<String, String> finalTableMap = tableMap;
        try {
            sysMetaStatusList = this.jdbcTemplate.query(new PreparedStatementCreator(){

                @Override
                public PreparedStatement createPreparedStatement(Connection conn) throws SQLException {
                    String sqlStatement = "SELECT guid, serial_version, date_modified, archived FROM " + (String)finalTableMap.get(SystemMetadataDaoMetacatImpl.SYSMETA_TABLE) + " ORDER BY guid";
                    if (finalPageSize > 0 && finalPageNumber > 0) {
                        sqlStatement = sqlStatement + " LIMIT " + finalPageSize;
                    }
                    if (finalPageNumber > 0) {
                        sqlStatement = sqlStatement + " OFFSET " + offset;
                    }
                    sqlStatement = sqlStatement + ";";
                    PreparedStatement statement = conn.prepareStatement(sqlStatement);
                    log.debug("sysMetaStatusList statement is: " + statement);
                    return statement;
                }
            }, new SystemMetadataStatusMapper());
        }
        catch (org.springframework.dao.DataAccessException dae) {
            throw new DataAccessException(dae);
        }
        return sysMetaStatusList;
    }

    private List<AccessRule> listAccessRules(final Identifier pid, Map<String, String> tableMap) throws SQLException {
        ArrayList<AccessRule> accessEntries = new ArrayList();
        final Map<String, String> finalTableMap = tableMap;
        accessEntries = this.jdbcTemplate.query(new PreparedStatementCreator(){

            @Override
            public PreparedStatement createPreparedStatement(Connection conn) throws SQLException {
                String sqlStatement = "SELECT guid, principal_name, permission FROM " + (String)finalTableMap.get(SystemMetadataDaoMetacatImpl.ACCESS_TABLE) + " WHERE perm_type = 'allow' AND guid = ?;";
                PreparedStatement statement = conn.prepareStatement(sqlStatement);
                statement.setString(1, pid.getValue());
                return statement;
            }
        }, new AccessRuleMapper());
        return accessEntries;
    }

    private List<Replica> listReplicaEntries(Identifier pid, Map<String, String> tableMap) throws SQLException {
        ArrayList<Replica> replicaEntries = new ArrayList();
        final String pidStr = pid.getValue();
        final Map<String, String> finalTableMap = tableMap;
        replicaEntries = this.jdbcTemplate.query(new PreparedStatementCreator(){

            @Override
            public PreparedStatement createPreparedStatement(Connection conn) throws SQLException {
                String sqlStatement = "SELECT guid, member_node, status, date_verified FROM " + (String)finalTableMap.get(SystemMetadataDaoMetacatImpl.SM_STATUS_TABLE) + " WHERE guid = ?";
                PreparedStatement statement = conn.prepareStatement(sqlStatement);
                statement.setString(1, pidStr);
                return statement;
            }
        }, new ReplicaEntryMapper());
        return replicaEntries;
    }

    private List<ReplicationPolicyEntry> listReplicationPolicies(Identifier pid, Map<String, String> tableMap) throws SQLException {
        ArrayList<ReplicationPolicyEntry> replicationPolicyEntryList = new ArrayList();
        final Map<String, String> finalTableMap = tableMap;
        final String pidStr = pid.getValue();
        replicationPolicyEntryList = this.jdbcTemplate.query(new PreparedStatementCreator(){

            @Override
            public PreparedStatement createPreparedStatement(Connection conn) throws SQLException {
                String sqlStatement = "SELECT guid, policy, member_node FROM " + (String)finalTableMap.get(SystemMetadataDaoMetacatImpl.SM_POLICY_TABLE) + " WHERE guid = ?";
                PreparedStatement statement = conn.prepareStatement(sqlStatement);
                statement.setString(1, pidStr);
                return statement;
            }
        }, new ReplicationPolicyEntryMapper());
        return replicationPolicyEntryList;
    }

    public SystemMetadata getSystemMetadata(final Identifier pid, Map<String, String> tableMap) throws DataAccessException {
        List<Object> systemMetadataList = new ArrayList();
        SystemMetadata systemMetadata = null;
        final String sysMetaTable = tableMap.get(SYSMETA_TABLE);
        try {
            systemMetadataList = this.jdbcTemplate.query(new PreparedStatementCreator(){

                @Override
                public PreparedStatement createPreparedStatement(Connection conn) throws SQLException {
                    String sqlStatement = "SELECT guid, series_id, date_uploaded, rights_holder, checksum, checksum_algorithm, origin_member_node, authoritive_member_node, date_modified, submitter, object_format, size, replication_allowed, number_replicas, obsoletes, obsoleted_by, serial_version, archived FROM " + sysMetaTable + " WHERE guid = ?;";
                    PreparedStatement statement = conn.prepareStatement(sqlStatement);
                    statement.setString(1, pid.getValue());
                    return statement;
                }
            }, new SystemMetadataMapper(tableMap));
        }
        catch (org.springframework.dao.DataAccessException dae) {
            this.handleJdbcDataAccessException(dae);
        }
        if (systemMetadataList.size() > 0) {
            systemMetadata = (SystemMetadata)systemMetadataList.get(0);
        }
        return systemMetadata;
    }

    public Identifier saveSystemMetadata(SystemMetadata systemMetadata, Map<String, String> tableMap) throws DataAccessException {
        Boolean updated = new Boolean(false);
        final Identifier pid = systemMetadata.getIdentifier();
        if (pid.getValue() == null) {
            throw new DataAccessException(new InvalidSystemMetadata("0000", "Identifier cannot be null"));
        }
        this.txTemplate.setName(pid.getValue());
        this.txTemplate.setReadOnly(false);
        SystemMetadata currentSysMeta = this.getSystemMetadata(pid, tableMap);
        if (currentSysMeta == null) {
            Boolean inserted = new Boolean(false);
            final String finalSysMetaTable = tableMap.get(SYSMETA_TABLE);
            inserted = this.txTemplate.execute(new TransactionCallback<Boolean>(){

                @Override
                public Boolean doInTransaction(TransactionStatus arg0) {
                    Boolean success = new Boolean(false);
                    int rows = SystemMetadataDaoMetacatImpl.this.jdbcTemplate.update("INSERT INTO " + finalSysMetaTable + " (guid) VALUES (?);", new Object[]{pid.getValue()}, new int[]{-1});
                    if (rows == 1) {
                        success = new Boolean(true);
                    }
                    return success;
                }
            });
        }
        if (!(updated = this.updateSystemMetadata(systemMetadata, tableMap)).equals(true)) {
            throw new DataAccessException(new Exception("Failed to update identifier " + pid.getValue()));
        }
        return pid;
    }

    protected Boolean updateSystemMetadata(SystemMetadata sysMeta, Map<String, String> tableMap) throws DataAccessException {
        Boolean updated = new Boolean(false);
        final Identifier pid = sysMeta.getIdentifier();
        if (pid.getValue() == null) {
            throw new DataAccessException(new InvalidSystemMetadata("0000", "Identifier cannot be null"));
        }
        BigInteger size = sysMeta.getSize();
        if (size == null) {
            throw new DataAccessException(new InvalidSystemMetadata("0000", "Size cannot be null"));
        }
        Checksum checksum = sysMeta.getChecksum();
        if (checksum == null) {
            throw new DataAccessException(new InvalidSystemMetadata("0000", "Checksum cannot be null"));
        }
        final SystemMetadata finalSysMeta = sysMeta;
        final String sysMetaTable = tableMap.get(SYSMETA_TABLE);
        final String smReplPolicyTable = tableMap.get(SM_POLICY_TABLE);
        final String smReplStatusTable = tableMap.get(SM_STATUS_TABLE);
        final String xmlAccessTable = tableMap.get(ACCESS_TABLE);
        updated = this.txTemplate.execute(new TransactionCallback<Boolean>(){

            @Override
            public Boolean doInTransaction(TransactionStatus status) {
                boolean success = false;
                String sqlStatement = SystemMetadataDaoMetacatImpl.this.getSysMetaUpdateStatement(sysMetaTable);
                Map<String, Object> sysMetaMap = SystemMetadataDaoMetacatImpl.this.extractSystemMetadataAttrs(finalSysMeta, sysMetaTable);
                Object[] values = SystemMetadataDaoMetacatImpl.this.getSysMetaAttrValues(sysMetaMap);
                int[] types = SystemMetadataDaoMetacatImpl.this.getSysMetaAttrTypes();
                int sysMetaRows = SystemMetadataDaoMetacatImpl.this.jdbcTemplate.update(sqlStatement, values, types);
                if (sysMetaRows == 1) {
                    success = true;
                }
                ReplicationPolicy replPolicy = finalSysMeta.getReplicationPolicy();
                int totalReplPolicies = 0;
                int updatedReplPolicies = 0;
                if (replPolicy != null) {
                    List<NodeReference> preferredNodes = replPolicy.getPreferredMemberNodeList();
                    List<NodeReference> blockedNodes = replPolicy.getBlockedMemberNodeList();
                    if (preferredNodes != null || blockedNodes != null) {
                        SystemMetadataDaoMetacatImpl.this.jdbcTemplate.update("DELETE FROM " + smReplPolicyTable + " WHERE guid = ?", pid.getValue());
                    }
                    if (preferredNodes != null) {
                        totalReplPolicies += preferredNodes.size();
                        for (NodeReference preferredNode : preferredNodes) {
                            String preferredNodeStr = preferredNode.getValue();
                            int preferredRows = SystemMetadataDaoMetacatImpl.this.jdbcTemplate.update("INSERT INTO " + smReplPolicyTable + " (guid, member_node, policy) VALUES (?, ?, ?);", new Object[]{pid.getValue(), preferredNodeStr, "preferred"}, new int[]{-1, 12, 12});
                            updatedReplPolicies += preferredRows;
                        }
                    }
                    if (blockedNodes != null) {
                        totalReplPolicies += blockedNodes.size();
                        for (NodeReference blockedNode : blockedNodes) {
                            int blockedRows = SystemMetadataDaoMetacatImpl.this.jdbcTemplate.update("INSERT INTO " + smReplPolicyTable + " (guid, member_node, policy) VALUES (?, ?, ?);", new Object[]{pid.getValue(), blockedNode.getValue(), "blocked"}, new int[]{-1, 12, 12});
                            updatedReplPolicies += blockedRows;
                        }
                    }
                    if (updatedReplPolicies == totalReplPolicies) {
                        success = true;
                    } else {
                        success = false;
                        log.error("For identifier " + pid.getValue() + ", only " + updatedReplPolicies + "replication policies of " + totalReplPolicies + "were inserted.");
                    }
                }
                List<Replica> replicas = finalSysMeta.getReplicaList();
                int totalReplicas = 0;
                int updatedReplicas = 0;
                if (replicas != null) {
                    totalReplicas += replicas.size();
                    SystemMetadataDaoMetacatImpl.this.jdbcTemplate.update("DELETE FROM " + smReplStatusTable + " WHERE guid = ?", pid.getValue());
                    for (Replica replica : replicas) {
                        int replicaRows = SystemMetadataDaoMetacatImpl.this.jdbcTemplate.update("INSERT INTO " + smReplStatusTable + " (guid, member_node, status, date_verified) VALUES (?, ?, ?, ?)", new Object[]{pid.getValue(), replica.getReplicaMemberNode().getValue(), replica.getReplicationStatus().toString(), new Timestamp(replica.getReplicaVerified().getTime())}, new int[]{-1, 12, 12, 93});
                        updatedReplicas += replicaRows;
                    }
                }
                if (updatedReplicas == totalReplicas) {
                    success = true;
                } else {
                    success = false;
                    log.error("For identifier " + pid.getValue() + ", only " + updatedReplicas + "replicas of " + totalReplicas + "were inserted.");
                }
                AccessPolicy accessPolicy = finalSysMeta.getAccessPolicy();
                int updatedAccessRows = 0;
                int numberOfSubjects = 0;
                List<Object> accessRules = new ArrayList();
                if (accessPolicy != null) {
                    accessRules = accessPolicy.getAllowList();
                    SystemMetadataDaoMetacatImpl.this.jdbcTemplate.update("DELETE FROM " + xmlAccessTable + " WHERE guid = ?", pid.getValue());
                    for (AccessRule accessRule : accessRules) {
                        List<Subject> subjects = accessRule.getSubjectList();
                        numberOfSubjects += subjects.size();
                        List<Permission> permissions = accessRule.getPermissionList();
                        Integer perm = null;
                        for (Permission permission : permissions) {
                            if (perm != null) {
                                perm = perm | SystemMetadataDaoMetacatImpl.this.convertPermission(permission);
                                continue;
                            }
                            perm = SystemMetadataDaoMetacatImpl.this.convertPermission(permission);
                        }
                        for (Subject subject : subjects) {
                            int accessRows = SystemMetadataDaoMetacatImpl.this.jdbcTemplate.update("INSERT INTO " + xmlAccessTable + " (guid, principal_name, permission, perm_type, perm_order) " + " VALUES (?, ?, ?, ?, ?)", new Object[]{pid.getValue(), subject.getValue(), perm, "allow", "allowFirst"}, new int[]{-1, 12, 4, 12, 12});
                            updatedAccessRows += accessRows;
                        }
                    }
                    if (updatedAccessRows == numberOfSubjects) {
                        success = true;
                    } else {
                        success = false;
                        log.error("For identifier " + pid.getValue() + ", only " + updatedAccessRows + "replicas of " + numberOfSubjects + "were inserted.");
                    }
                }
                return new Boolean(success);
            }
        });
        return updated;
    }

    protected Map<String, Object> extractSystemMetadataAttrs(SystemMetadata systemMetadata, String tableName) {
        HashMap<String, Object> attrMap = new HashMap<String, Object>();
        Identifier seriesId = systemMetadata.getSeriesId();
        String seriesIdStr = seriesId == null ? null : seriesId.getValue();
        attrMap.put("series_id", seriesIdStr);
        BigInteger serialVersion = systemMetadata.getSerialVersion();
        String versionStr = serialVersion.toString() == null ? null : serialVersion.toString();
        attrMap.put("serial_version", versionStr);
        Date dateUploaded = systemMetadata.getDateUploaded();
        Timestamp uploadedTime = dateUploaded == null ? null : new Timestamp(dateUploaded.getTime());
        attrMap.put("date_uploaded", uploadedTime);
        Subject rightsHolder = systemMetadata.getRightsHolder();
        String rightsHolderStr = rightsHolder == null ? null : rightsHolder.getValue();
        attrMap.put("rights_holder", rightsHolderStr);
        Checksum checksum = systemMetadata.getChecksum();
        String checksumStr = checksum == null ? null : checksum.getValue();
        attrMap.put("checksum", checksumStr);
        String algorithm = null;
        if (checksum != null) {
            algorithm = checksum.getAlgorithm();
            algorithm = algorithm == null ? null : algorithm;
        }
        attrMap.put("checksum_algorithm", algorithm);
        NodeReference originNodeid = systemMetadata.getOriginMemberNode();
        String originNodeidStr = originNodeid == null ? null : originNodeid.getValue();
        attrMap.put("origin_member_node", originNodeidStr);
        NodeReference authNodeid = systemMetadata.getAuthoritativeMemberNode();
        String authNodeidStr = authNodeid == null ? null : authNodeid.getValue();
        attrMap.put("authoritive_member_node", authNodeidStr);
        Date dateModified = systemMetadata.getDateSysMetadataModified();
        Timestamp modTime = dateModified == null ? null : new Timestamp(dateModified.getTime());
        attrMap.put("date_modified", modTime);
        Subject submitter = systemMetadata.getSubmitter();
        String submitterStr = submitter == null ? null : submitter.getValue();
        attrMap.put("submitter", submitterStr);
        ObjectFormatIdentifier formatId = systemMetadata.getFormatId();
        String formatIdStr = formatId == null ? null : formatId.getValue();
        attrMap.put("object_format", formatIdStr);
        BigInteger size = systemMetadata.getSize();
        String sizeStr = size == null ? null : size.toString();
        attrMap.put("size", sizeStr);
        Boolean archived = systemMetadata.getArchived();
        archived = archived == null ? false : archived;
        attrMap.put("archived", archived);
        Boolean replicationAllowed = null;
        Integer numberReplicas = null;
        ReplicationPolicy replicationPolicy = systemMetadata.getReplicationPolicy();
        if (replicationPolicy != null) {
            replicationAllowed = replicationPolicy.getReplicationAllowed();
            replicationAllowed = replicationAllowed == null ? false : replicationAllowed;
            numberReplicas = replicationPolicy.getNumberReplicas();
            replicationAllowed = replicationAllowed == null ? false : replicationAllowed;
            numberReplicas = numberReplicas == null ? -1 : numberReplicas;
        }
        attrMap.put("replication_allowed", replicationAllowed);
        attrMap.put("number_replicas", numberReplicas);
        Identifier obsoletes = systemMetadata.getObsoletes();
        String obsoletesStr = obsoletes == null ? null : obsoletes.getValue();
        attrMap.put("obsoletes", obsoletesStr);
        Identifier obsoletedBy = systemMetadata.getObsoletedBy();
        String obsoletedByStr = obsoletedBy == null ? null : obsoletedBy.getValue();
        attrMap.put("obsoleted_by", obsoletedByStr);
        Identifier pid = systemMetadata.getIdentifier();
        String pidStr = pid == null ? null : pid.getValue();
        attrMap.put("guid", pidStr);
        return attrMap;
    }

    protected String getSysMetaUpdateStatement(String sysMetaTable) {
        StringBuilder sql = new StringBuilder();
        sql.append("UPDATE " + sysMetaTable + " SET ");
        sql.append("series_id\t\t        = ?, ");
        sql.append("serial_version          = ?, ");
        sql.append("date_uploaded           = ?, ");
        sql.append("rights_holder           = ?, ");
        sql.append("checksum                = ?, ");
        sql.append("checksum_algorithm      = ?, ");
        sql.append("origin_member_node      = ?, ");
        sql.append("authoritive_member_node = ?, ");
        sql.append("date_modified           = ?, ");
        sql.append("submitter               = ?, ");
        sql.append("object_format           = ?, ");
        sql.append("size                    = ?, ");
        sql.append("archived                = ?, ");
        sql.append("replication_allowed     = ?, ");
        sql.append("number_replicas         = ?, ");
        sql.append("obsoletes               = ?, ");
        sql.append("obsoleted_by            = ?");
        sql.append(" WHERE guid = ? ;");
        return sql.toString();
    }

    protected Object[] getSysMetaAttrValues(Map<String, Object> sysMetaMap) {
        Object[] values = new Object[]{(String)sysMetaMap.get("series_id"), (String)sysMetaMap.get("serial_version"), (Timestamp)sysMetaMap.get("date_uploaded"), (String)sysMetaMap.get("rights_holder"), (String)sysMetaMap.get("checksum"), (String)sysMetaMap.get("checksum_algorithm"), (String)sysMetaMap.get("origin_member_node"), (String)sysMetaMap.get("authoritive_member_node"), (Timestamp)sysMetaMap.get("date_modified"), (String)sysMetaMap.get("submitter"), (String)sysMetaMap.get("object_format"), (String)sysMetaMap.get("size"), (Boolean)sysMetaMap.get("archived"), (Boolean)sysMetaMap.get("replication_allowed"), (Integer)sysMetaMap.get("number_replicas"), (String)sysMetaMap.get("obsoletes"), (String)sysMetaMap.get("obsoleted_by"), (String)sysMetaMap.get("guid")};
        return values;
    }

    protected int[] getSysMetaAttrTypes() {
        int[] types = new int[]{-1, 12, 93, 12, 12, 12, 12, 12, 93, 12, 12, 12, 16, 16, -5, -1, -1, -1};
        return types;
    }

    private void createMapping(String guid, String localId) throws DataAccessException {
        String docid;
        String rev;
        String separator = ".";
        Identifier identifier = new Identifier();
        if (localId == null || guid == null) {
            throw new DataAccessException(new Exception("The given id was null"));
        }
        try {
            int lastIndex = localId.lastIndexOf(separator);
            int secondToLastIndex = localId.lastIndexOf(separator, lastIndex);
            rev = localId.substring(lastIndex + 1);
            String docNumber = localId.substring(secondToLastIndex, lastIndex - 1);
            docid = localId.substring(0, secondToLastIndex - 1);
            int revAsInt = new Integer(rev);
            int docNumberAsInt = new Integer(docNumber);
            if (log.isDebugEnabled()) {
                log.debug("Creating mapping for - docid: " + docid + ", docNumber: " + docNumber + ", rev: " + rev);
            }
        }
        catch (IndexOutOfBoundsException iobe) {
            throw new DataAccessException(iobe.getCause());
        }
        catch (NumberFormatException nfe) {
            throw new DataAccessException(nfe.getCause());
        }
        identifier.setValue(guid);
        if (this.hasMapping(identifier)) {
            log.info("The database already has a mapping for " + guid + ". Skipping the create.");
            return;
        }
        String sqlStatement = "INSERT into identifier (guid, docid, rev) VALUES (?, ?, ?);";
        this.jdbcTemplate.update(sqlStatement, new Object[]{guid, docid, rev}, new int[]{12, 12, 4});
        log.info("Created mapping for " + guid + "and " + localId);
    }

    private String generateDocumentId(String idPrefix, int revision) {
        StringBuffer docid = idPrefix != null ? new StringBuffer(idPrefix) : new StringBuffer("autogen");
        docid.append(".");
        GregorianCalendar calendar = new GregorianCalendar();
        Date trialTime = new Date();
        calendar.setTime(trialTime);
        if (documentIdCounter > 100) {
            documentIdCounter = 0;
        }
        docid.append(String.format("%04d%02d%02d%02d%02d%02d%03d%02d", calendar.get(1), calendar.get(2) + 1, calendar.get(5), calendar.get(11), calendar.get(12), calendar.get(13), calendar.get(14), documentIdCounter++));
        if (revision > 0) {
            docid.append(".").append(revision);
        }
        return docid.toString();
    }

    private boolean hasMapping(Identifier pid) throws DataAccessException {
        boolean mapped = false;
        int countReturned = 0;
        if (pid.getValue() == null) {
            throw new DataAccessException(new Exception("The given identifier was null"));
        }
        String sqlStatement = "SELECT guid FROM identifierwhere guid = ?";
        countReturned = this.jdbcTemplate.queryForInt(sqlStatement, pid.getValue());
        if (countReturned > 0) {
            mapped = true;
        }
        return mapped;
    }

    private boolean hasSystemMetadata(Identifier pid) throws DataAccessException {
        boolean hasSysMeta = false;
        int countReturned = 0;
        if (pid.getValue() == null) {
            throw new DataAccessException(new Exception("The given identifier was null"));
        }
        String sqlStatement = "SELECT guid FROM systemmetadatawhere guid = ?";
        countReturned = this.jdbcTemplate.queryForInt(sqlStatement, pid.getValue());
        if (countReturned > 0) {
            hasSysMeta = true;
        }
        return hasSysMeta;
    }

    private void handleJdbcDataAccessException(org.springframework.dao.DataAccessException dae) throws DataAccessException {
        log.error("Jdbc Data access exception occurred: " + dae.getRootCause().getMessage());
        dae.printStackTrace();
        throw dae;
    }

    public int convertPermission(Permission permission) {
        boolean CHMOD = true;
        int WRITE = 2;
        int READ = 4;
        int ALL = 7;
        if (permission.equals(Permission.READ)) {
            return 4;
        }
        if (permission.equals(Permission.WRITE)) {
            return 2;
        }
        if (permission.equals(Permission.CHANGE_PERMISSION)) {
            return 1;
        }
        return -1;
    }

    private List<Permission> convertPermission(int value) {
        ArrayList<Permission> permissions = new ArrayList<Permission>();
        boolean CHMOD = true;
        int WRITE = 2;
        int READ = 4;
        int ALL = 7;
        if (value == 7) {
            permissions.add(Permission.READ);
            permissions.add(Permission.WRITE);
            permissions.add(Permission.CHANGE_PERMISSION);
            return permissions;
        }
        if ((value & 1) == 1) {
            permissions.add(Permission.CHANGE_PERMISSION);
        }
        if ((value & 4) == 4) {
            permissions.add(Permission.READ);
        }
        if ((value & 2) == 2) {
            permissions.add(Permission.WRITE);
        }
        return permissions;
    }

    static {
        tableMap.put(IDENTIFIER_TABLE, IDENTIFIER_TABLE);
        tableMap.put(SYSMETA_TABLE, SYSMETA_TABLE);
        tableMap.put(SM_POLICY_TABLE, SM_POLICY_TABLE);
        tableMap.put(SM_STATUS_TABLE, SM_STATUS_TABLE);
        tableMap.put(ACCESS_TABLE, ACCESS_TABLE);
    }

    public final class SystemMetadataMapper
    implements RowMapper<SystemMetadata> {
        private Map<String, String> localTableMap;

        public SystemMetadataMapper(Map<String, String> tableMap) {
            this.localTableMap = tableMap;
        }

        @Override
        public SystemMetadata mapRow(ResultSet resultSet, int rowNumber) throws SQLException {
            String obsoletedBy;
            String submitter;
            SystemMetadata systemMetadata = new SystemMetadata();
            ReplicationPolicy replPolicy = new ReplicationPolicy();
            AccessPolicy accessPolicy = new AccessPolicy();
            Identifier pid = new Identifier();
            pid.setValue(resultSet.getString("guid"));
            systemMetadata.setIdentifier(pid);
            Identifier seriesId = new Identifier();
            seriesId.setValue(resultSet.getString("series_id"));
            systemMetadata.setSeriesId(seriesId);
            BigInteger serialVersion = new BigInteger(resultSet.getString("serial_version"));
            systemMetadata.setSerialVersion(serialVersion);
            Timestamp dateSystemMetadataLastModified = resultSet.getTimestamp("date_modified");
            systemMetadata.setDateSysMetadataModified(dateSystemMetadataLastModified);
            boolean archived = resultSet.getBoolean("archived");
            if (!resultSet.wasNull()) {
                systemMetadata.setArchived(new Boolean(archived));
            }
            Timestamp dateUploaded = resultSet.getTimestamp("date_uploaded");
            systemMetadata.setDateUploaded(dateUploaded);
            Subject rightsHolderSubject = new Subject();
            String rightsHolder = resultSet.getString("rights_holder");
            rightsHolderSubject.setValue(rightsHolder);
            systemMetadata.setRightsHolder(rightsHolderSubject);
            String checksum = resultSet.getString("checksum");
            String checksumAlgorithm = resultSet.getString("checksum_algorithm");
            Checksum checksumObject = new Checksum();
            checksumObject.setValue(checksum);
            checksumObject.setAlgorithm(checksumAlgorithm);
            systemMetadata.setChecksum(checksumObject);
            String originMemberNode = resultSet.getString("origin_member_node");
            if (originMemberNode != null) {
                NodeReference omn = new NodeReference();
                omn.setValue(originMemberNode);
                systemMetadata.setOriginMemberNode(omn);
            }
            String authoritativeMemberNode = resultSet.getString("authoritive_member_node");
            if (originMemberNode != null) {
                NodeReference amn = new NodeReference();
                amn.setValue(authoritativeMemberNode);
                systemMetadata.setAuthoritativeMemberNode(amn);
            }
            if ((submitter = resultSet.getString("submitter")) != null) {
                Subject submitterSubject = new Subject();
                submitterSubject.setValue(submitter);
                systemMetadata.setSubmitter(submitterSubject);
            }
            String fmtidStr = resultSet.getString("object_format");
            ObjectFormatIdentifier fmtid = new ObjectFormatIdentifier();
            fmtid.setValue(fmtidStr);
            systemMetadata.setFormatId(fmtid);
            String size = resultSet.getString("size");
            systemMetadata.setSize(new BigInteger(size));
            String obsoletes = resultSet.getString("obsoletes");
            if (obsoletes != null) {
                Identifier obsoletesId = new Identifier();
                obsoletesId.setValue(obsoletes);
                systemMetadata.setObsoletes(obsoletesId);
            }
            if ((obsoletedBy = resultSet.getString("obsoleted_by")) != null) {
                Identifier obsoletedById = new Identifier();
                obsoletedById.setValue(obsoletedBy);
                systemMetadata.setObsoletedBy(obsoletedById);
            }
            boolean replAllowed = resultSet.getBoolean("replication_allowed");
            if (!resultSet.wasNull()) {
                ReplicationPolicy replicationPolicy = new ReplicationPolicy();
                replicationPolicy.setReplicationAllowed(new Boolean(replAllowed));
                int numberOfReplicas = resultSet.getInt("number_replicas");
                if (numberOfReplicas > 0) {
                    replicationPolicy.setNumberReplicas(new Integer(numberOfReplicas));
                }
                List replPolicies = new ArrayList();
                ArrayList<NodeReference> preferredNodes = new ArrayList<NodeReference>();
                ArrayList<NodeReference> blockedNodes = new ArrayList<NodeReference>();
                replPolicies = SystemMetadataDaoMetacatImpl.this.listReplicationPolicies(pid, this.localTableMap);
                for (ReplicationPolicyEntry policy : replPolicies) {
                    Identifier id = policy.getPid();
                    String entryPolicy = policy.getPolicy();
                    NodeReference node = policy.getMemberNode();
                    if (entryPolicy.equals("preferred")) {
                        preferredNodes.add(node);
                        continue;
                    }
                    if (!entryPolicy.equals("blocked")) continue;
                    blockedNodes.add(node);
                }
                replicationPolicy.setPreferredMemberNodeList(preferredNodes);
                replicationPolicy.setBlockedMemberNodeList(blockedNodes);
                systemMetadata.setReplicationPolicy(replicationPolicy);
            } else {
                systemMetadata.setReplicationPolicy(null);
            }
            ArrayList<Replica> replicas = new ArrayList();
            replicas = SystemMetadataDaoMetacatImpl.this.listReplicaEntries(pid, this.localTableMap);
            systemMetadata.setReplicaList(replicas);
            ArrayList<AccessRule> accessRules = new ArrayList();
            accessRules = SystemMetadataDaoMetacatImpl.this.listAccessRules(pid, this.localTableMap);
            accessPolicy.setAllowList(accessRules);
            systemMetadata.setAccessPolicy(accessPolicy);
            if (log.isDebugEnabled()) {
                try {
                    ByteArrayOutputStream baos = new ByteArrayOutputStream();
                    TypeMarshaller.marshalTypeToOutputStream(systemMetadata, baos);
                    log.debug("SystemMetadata for pid " + pid.getValue() + " is: " + baos.toString());
                }
                catch (MarshallingException e) {
                    e.printStackTrace();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            return systemMetadata;
        }
    }

    public final class AccessRuleMapper
    implements RowMapper<AccessRule> {
        @Override
        public AccessRule mapRow(ResultSet resultSet, int rowNumber) throws SQLException {
            AccessRule accessRule = new AccessRule();
            Subject subject = new Subject();
            subject.setValue(resultSet.getString("principal_name"));
            accessRule.addSubject(subject);
            List permissions = SystemMetadataDaoMetacatImpl.this.convertPermission(resultSet.getInt("permission"));
            accessRule.setPermissionList(permissions);
            return accessRule;
        }
    }

    public final class ReplicationPolicyEntryMapper
    implements RowMapper<ReplicationPolicyEntry> {
        @Override
        public ReplicationPolicyEntry mapRow(ResultSet resultSet, int rowNumber) throws SQLException {
            ReplicationPolicyEntry replPolicyEntry = new ReplicationPolicyEntry();
            Identifier pid = new Identifier();
            pid.setValue(resultSet.getString("guid"));
            replPolicyEntry.setPid(pid);
            String policy = resultSet.getString("policy");
            replPolicyEntry.setPolicy(policy);
            String nodeid = resultSet.getString("member_node");
            NodeReference nodeRef = new NodeReference();
            nodeRef.setValue(nodeid);
            replPolicyEntry.setMemberNode(nodeRef);
            return replPolicyEntry;
        }
    }

    public final class ReplicaEntryMapper
    implements RowMapper<Replica> {
        @Override
        public Replica mapRow(ResultSet resultSet, int rowNumber) throws SQLException {
            Replica replica = new Replica();
            NodeReference nodeid = new NodeReference();
            nodeid.setValue(resultSet.getString("member_node"));
            replica.setReplicaMemberNode(nodeid);
            String status = resultSet.getString("status");
            ReplicationStatus replStatus = ReplicationStatus.valueOf(status);
            replica.setReplicationStatus(replStatus);
            Timestamp dateVerified = resultSet.getTimestamp("date_verified");
            replica.setReplicaVerified(dateVerified);
            return replica;
        }
    }

    public final class SystemMetadataStatusMapper
    implements RowMapper<SystemMetadataStatus> {
        @Override
        public SystemMetadataStatus mapRow(ResultSet resultSet, int rowNumber) throws SQLException {
            SystemMetadataStatus systemMetadataStatus = new SystemMetadataStatus();
            Identifier pid = new Identifier();
            pid.setValue(resultSet.getString("guid"));
            systemMetadataStatus.setPid(pid);
            BigInteger serialVersion = new BigInteger(resultSet.getString("serial_version"));
            systemMetadataStatus.setSerialVersion(serialVersion);
            Timestamp dateSystemMetadataLastModified = resultSet.getTimestamp("date_modified");
            systemMetadataStatus.setLastSystemMetadataModificationDate(dateSystemMetadataLastModified);
            boolean archived = resultSet.getBoolean("archived");
            systemMetadataStatus.setDeleted(new Boolean(archived));
            return systemMetadataStatus;
        }
    }
}

