/*
 * Decompiled with CFR 0.152.
 */
package org.dataone.cn.ldap;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.naming.Name;
import javax.naming.NameNotFoundException;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.BasicAttribute;
import javax.naming.directory.BasicAttributes;
import javax.naming.directory.DirContext;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import javax.naming.ldap.LdapName;
import javax.naming.ldap.Rdn;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class LDAPService {
    public static Log log = LogFactory.getLog(LDAPService.class);
    private String base;

    protected boolean removeEntry(DirContext ctx, String dn) {
        try {
            ctx.destroySubcontext(new LdapName(dn));
            log.debug("Removed entry: " + dn);
        }
        catch (NamingException e) {
            log.error("Error removing entry: " + dn, e);
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean checkAttribute(DirContext ctx, String dn, String attributeName, String attributeValue) {
        NamingEnumeration<SearchResult> results = null;
        boolean result = false;
        try {
            SearchControls ctls = new SearchControls();
            ctls.setSearchScope(0);
            ctls.setReturningAttributes(new String[0]);
            attributeValue = attributeValue.replace("\\", "\\5c");
            String searchCriteria = attributeName + "=" + attributeValue;
            results = ctx.search((Name)new LdapName(dn), searchCriteria, ctls);
            boolean bl = result = results != null && results.hasMoreElements();
            if (result) {
                log.debug("Found matching attribute: " + searchCriteria);
            } else {
                log.warn("Did not find matching attribute: " + searchCriteria);
            }
        }
        catch (NamingException e) {
            log.warn("Problem checking attribute: " + attributeName, e);
        }
        finally {
            if (results != null) {
                try {
                    results.close();
                }
                catch (NamingException ex) {
                    log.error("Problem closing results search for " + attributeName, ex);
                }
            }
        }
        return result;
    }

    protected List<Object> getAttributeValues(DirContext ctx, String dn, String attributeName) throws NamingException {
        SearchControls ctls = new SearchControls();
        ctls.setSearchScope(0);
        ctls.setReturningAttributes(new String[]{attributeName});
        String searchCriteria = attributeName + "=*";
        NamingEnumeration<SearchResult> results = null;
        try {
            results = ctx.search((Name)new LdapName(dn), searchCriteria, ctls);
        }
        catch (NameNotFoundException nnfe) {
            log.warn("Could not find LDAP entry for DN: " + dn);
            return null;
        }
        if (results != null) {
            log.debug("Found matching attribute: " + searchCriteria);
            ArrayList<Object> values = new ArrayList<Object>();
            while (results.hasMore()) {
                SearchResult result = results.next();
                NamingEnumeration<? extends Attribute> attributes = result.getAttributes().getAll();
                while (attributes.hasMore()) {
                    Attribute attribute = attributes.next();
                    NamingEnumeration<?> attributeValues = attribute.getAll();
                    while (attributeValues.hasMore()) {
                        Object value = attributeValues.next();
                        values.add(value);
                        log.debug("Attribute value: " + value);
                    }
                }
            }
            return values;
        }
        return null;
    }

    protected String parseAttribute(String original, String attribute) {
        String result = null;
        try {
            String temp = original;
            int start = temp.toLowerCase().indexOf(attribute.toLowerCase() + "=");
            int end = temp.indexOf(",", start);
            temp = end < 0 ? temp.substring(start) : temp.substring(start, end);
            start = temp.indexOf("=") + 1;
            result = temp = temp.substring(start);
            result = (String)Rdn.unescapeValue(result);
        }
        catch (Exception e) {
            log.warn("could not parse attribute from string: " + original, e);
        }
        return result;
    }

    protected boolean constructTree(DirContext ctx, String dn) throws NamingException {
        LdapName ldapName = new LdapName(dn);
        List<Rdn> rdns = ldapName.getRdns();
        LdapName partialDn = null;
        for (int i = 0; i < rdns.size(); ++i) {
            Rdn rdn = rdns.get(i);
            if (partialDn == null) {
                partialDn = new LdapName(Arrays.asList(rdn));
            } else {
                partialDn.add(rdn);
            }
            boolean exists = false;
            try {
                exists = this.checkAttribute(ctx, partialDn.toString(), rdn.getType(), rdn.getValue().toString());
            }
            catch (Exception e) {
                exists = false;
            }
            if (exists) continue;
            String type = rdn.getType();
            if (type.equalsIgnoreCase("c")) {
                this.addCountry(ctx, partialDn.toString());
            }
            if (type.equalsIgnoreCase("o")) {
                this.addOrg(ctx, partialDn.toString());
            }
            if (type.equalsIgnoreCase("ou")) {
                this.addOrgUnit(ctx, partialDn.toString());
            }
            if (!type.equalsIgnoreCase("dc")) continue;
            this.addDc(ctx, partialDn.toString());
        }
        return true;
    }

    protected boolean addOrg(DirContext ctx, String dn) throws NamingException {
        BasicAttribute objClasses = new BasicAttribute("objectclass");
        objClasses.add("organization");
        String org = this.parseAttribute(dn, "o");
        BasicAttribute oAttribute = new BasicAttribute("o", org);
        BasicAttributes orig = new BasicAttributes();
        orig.put(objClasses);
        orig.put(oAttribute);
        ctx.createSubcontext(dn, (Attributes)orig);
        log.debug("Added entry " + dn);
        return true;
    }

    protected boolean addOrgUnit(DirContext ctx, String dn) throws NamingException {
        BasicAttribute objClasses = new BasicAttribute("objectclass");
        objClasses.add("organizationalUnit");
        String orgUnit = this.parseAttribute(dn, "ou");
        BasicAttribute oAttribute = new BasicAttribute("ou", orgUnit);
        BasicAttributes orig = new BasicAttributes();
        orig.put(objClasses);
        orig.put(oAttribute);
        ctx.createSubcontext(dn, (Attributes)orig);
        log.debug("Added entry " + dn);
        return true;
    }

    protected boolean addDc(DirContext ctx, String dn) throws NamingException {
        BasicAttribute objClasses = new BasicAttribute("objectclass");
        objClasses.add("dcObject");
        objClasses.add("organization");
        String dc = this.parseAttribute(dn, "dc");
        BasicAttribute dcAttribute = new BasicAttribute("dc", dc);
        BasicAttribute oAttribute = new BasicAttribute("o", dc);
        BasicAttributes orig = new BasicAttributes();
        orig.put(objClasses);
        orig.put(dcAttribute);
        orig.put(oAttribute);
        ctx.createSubcontext(dn, (Attributes)orig);
        log.debug("Added entry " + dn);
        return true;
    }

    protected boolean addCountry(DirContext ctx, String dn) throws NamingException {
        BasicAttribute objClasses = new BasicAttribute("objectclass");
        objClasses.add("country");
        String country = this.parseAttribute(dn, "c");
        BasicAttribute cAttribute = new BasicAttribute("c", country);
        BasicAttributes orig = new BasicAttributes();
        orig.put(objClasses);
        orig.put(cAttribute);
        ctx.createSubcontext(dn, (Attributes)orig);
        log.debug("Added entry " + dn);
        return true;
    }

    public String getEnumerationValueString(NamingEnumeration namingEnum) throws NamingException {
        if (namingEnum.hasMore()) {
            return (String)namingEnum.next();
        }
        return "";
    }

    public String getBase() {
        return this.base;
    }

    public void setBase(String base) {
        this.base = base;
    }
}

