/*
 * Decompiled with CFR 0.152.
 */
package org.dataone.service.types.v1.util;

import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.log4j.Logger;
import org.dataone.service.types.v1.AccessRule;
import org.dataone.service.types.v1.Group;
import org.dataone.service.types.v1.Permission;
import org.dataone.service.types.v1.Person;
import org.dataone.service.types.v1.Session;
import org.dataone.service.types.v1.Subject;
import org.dataone.service.types.v1.SubjectInfo;
import org.dataone.service.types.v1.SystemMetadata;

public class AuthUtils {
    private static final Logger logger = Logger.getLogger(AuthUtils.class);

    private static Subject buildSubject(String value) {
        Subject s = new Subject();
        s.setValue(value);
        return s;
    }

    public static Set<Subject> authorizedClientSubjects(Session session) {
        HashSet<Subject> subjects = new HashSet<Subject>();
        subjects.add(AuthUtils.buildSubject("public"));
        if (session != null) {
            SubjectInfo subjectInfo;
            Subject primarySubject = session.getSubject();
            if (primarySubject != null) {
                subjects.add(primarySubject);
                if (!primarySubject.getValue().equals("public")) {
                    subjects.add(AuthUtils.buildSubject("authenticatedUser"));
                } else {
                    session.setSubjectInfo(null);
                }
            }
            if ((subjectInfo = session.getSubjectInfo()) != null) {
                AuthUtils.findPersonsSubjects(subjects, subjectInfo, primarySubject);
            }
        }
        return subjects;
    }

    public static void findPersonsSubjects(Set<Subject> foundSubjects, SubjectInfo subjectInfo, Subject targetSubject) {
        foundSubjects.add(targetSubject);
        List<Group> groupList = null;
        if (subjectInfo != null) {
            groupList = subjectInfo.getGroupList();
        }
        if (subjectInfo != null && subjectInfo.getPersonList() != null) {
            for (Person p : subjectInfo.getPersonList()) {
                List<Subject> equivList;
                List<Subject> memberOfList;
                if (!p.getSubject().equals(targetSubject)) continue;
                logger.debug("traversing person: " + targetSubject.getValue());
                if (p.getVerified() != null && p.getVerified().booleanValue()) {
                    foundSubjects.add(AuthUtils.buildSubject("verifiedUser"));
                }
                if ((memberOfList = p.getIsMemberOfList()) != null) {
                    for (Subject g : memberOfList) {
                        foundSubjects.add(g);
                    }
                }
                if (groupList != null) {
                    for (Group group : groupList) {
                        if (group.getHasMemberList() == null) continue;
                        for (Subject member : group.getHasMemberList()) {
                            if (!member.equals(p.getSubject())) continue;
                            foundSubjects.add(group.getSubject());
                        }
                    }
                }
                if ((equivList = p.getEquivalentIdentityList()) == null) continue;
                for (Subject eqId : equivList) {
                    if (foundSubjects.contains(eqId)) continue;
                    AuthUtils.findPersonsSubjects(foundSubjects, subjectInfo, eqId);
                }
            }
        }
    }

    public static boolean isAuthorized(Collection<Subject> subjectSet, Permission requestedPerm, SystemMetadata systemMetadata) {
        boolean allowed;
        block6: {
            if (CollectionUtils.isEmpty(subjectSet)) {
                return false;
            }
            if (subjectSet.contains(systemMetadata.getRightsHolder())) {
                return true;
            }
            allowed = false;
            try {
                List<AccessRule> allows = systemMetadata.getAccessPolicy().getAllowList();
                if (allows == null) break block6;
                for (AccessRule accessRule : allows) {
                    if (accessRule.sizePermissionList() <= 0) continue;
                    for (Subject s : subjectSet) {
                        if (!accessRule.getSubjectList().contains(s) || !(allowed = AuthUtils.comparePermissions(requestedPerm, accessRule.getPermissionList()))) continue;
                        break block6;
                    }
                }
            }
            catch (Exception e) {
                logger.error("Problem checking authorization - defaulting to deny", e);
                allowed = false;
            }
        }
        return allowed;
    }

    public static boolean comparePermissions(Permission requested, Collection<Permission> allowed) {
        if (CollectionUtils.isEmpty(allowed)) {
            return false;
        }
        if (requested.equals(Permission.READ)) {
            return true;
        }
        if (allowed.contains(Permission.CHANGE_PERMISSION)) {
            return true;
        }
        return requested.equals(Permission.WRITE) && allowed.contains(Permission.WRITE);
    }
}

