/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.bytecode.cglib;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.security.ProtectionDomain;
import net.sf.cglib.core.ClassNameReader;
import net.sf.cglib.core.DebuggingClassWriter;
import net.sf.cglib.transform.ClassReaderGenerator;
import net.sf.cglib.transform.ClassTransformer;
import net.sf.cglib.transform.TransformingClassGenerator;
import net.sf.cglib.transform.impl.InterceptFieldEnabled;
import net.sf.cglib.transform.impl.InterceptFieldFilter;
import net.sf.cglib.transform.impl.InterceptFieldTransformer;
import org.hibernate.HibernateException;
import org.hibernate.bytecode.AbstractClassTransformerImpl;
import org.hibernate.bytecode.util.ClassFilter;
import org.hibernate.bytecode.util.FieldFilter;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.Type;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
public class CglibClassTransformer
extends AbstractClassTransformerImpl {
    private static Logger log = LoggerFactory.getLogger(CglibClassTransformer.class.getName());

    public CglibClassTransformer(ClassFilter classFilter, FieldFilter fieldFilter) {
        super(classFilter, fieldFilter);
    }

    protected byte[] doTransform(ClassLoader loader, String className, Class classBeingRedefined, ProtectionDomain protectionDomain, byte[] classfileBuffer) {
        ClassReader reader;
        try {
            reader = new ClassReader(new ByteArrayInputStream(classfileBuffer));
        }
        catch (IOException e) {
            log.error("Unable to read class", e);
            throw new HibernateException("Unable to read class: " + e.getMessage());
        }
        String[] names = ClassNameReader.getClassInfo(reader);
        DebuggingClassWriter w = new DebuggingClassWriter(1);
        ClassTransformer t = this.getClassTransformer(names);
        if (t != null) {
            byte[] result;
            if (log.isDebugEnabled()) {
                log.debug("Enhancing " + className);
            }
            try {
                reader = new ClassReader(new ByteArrayInputStream(classfileBuffer));
                new TransformingClassGenerator(new ClassReaderGenerator(reader, this.skipDebug()), t).generateClass(w);
                ByteArrayOutputStream out = new ByteArrayOutputStream();
                out.write(((ClassWriter)((Object)w)).toByteArray());
                result = out.toByteArray();
                out.close();
            }
            catch (Exception e) {
                log.error("Unable to transform class", e);
                throw new HibernateException("Unable to transform class: " + e.getMessage());
            }
            return result;
        }
        return classfileBuffer;
    }

    private int skipDebug() {
        return 2;
    }

    private ClassTransformer getClassTransformer(final String[] classInfo) {
        if (this.isAlreadyInstrumented(classInfo)) {
            return null;
        }
        return new InterceptFieldTransformer(new InterceptFieldFilter(){

            public boolean acceptRead(Type owner, String name) {
                return CglibClassTransformer.this.fieldFilter.shouldTransformFieldAccess(classInfo[0], owner.getClassName(), name);
            }

            public boolean acceptWrite(Type owner, String name) {
                return CglibClassTransformer.this.fieldFilter.shouldTransformFieldAccess(classInfo[0], owner.getClassName(), name);
            }
        });
    }

    private boolean isAlreadyInstrumented(String[] classInfo) {
        for (int i = 1; i < classInfo.length; ++i) {
            if (!InterceptFieldEnabled.class.getName().equals(classInfo[i])) continue;
            return true;
        }
        return false;
    }
}

