/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ejb;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.persistence.CacheRetrieveMode;
import javax.persistence.CacheStoreMode;
import javax.persistence.EntityExistsException;
import javax.persistence.EntityManager;
import javax.persistence.EntityNotFoundException;
import javax.persistence.EntityTransaction;
import javax.persistence.FlushModeType;
import javax.persistence.LockModeType;
import javax.persistence.LockTimeoutException;
import javax.persistence.NoResultException;
import javax.persistence.PersistenceContextType;
import javax.persistence.PersistenceException;
import javax.persistence.PessimisticLockScope;
import javax.persistence.TransactionRequiredException;
import javax.persistence.Tuple;
import javax.persistence.TupleElement;
import javax.persistence.TypedQuery;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Selection;
import javax.persistence.metamodel.Metamodel;
import javax.persistence.spi.PersistenceUnitTransactionType;
import javax.transaction.SystemException;
import javax.transaction.TransactionManager;
import org.hibernate.AssertionFailure;
import org.hibernate.CacheMode;
import org.hibernate.FlushMode;
import org.hibernate.HibernateException;
import org.hibernate.LockMode;
import org.hibernate.LockOptions;
import org.hibernate.MappingException;
import org.hibernate.NonUniqueObjectException;
import org.hibernate.NonUniqueResultException;
import org.hibernate.ObjectDeletedException;
import org.hibernate.ObjectNotFoundException;
import org.hibernate.OptimisticLockException;
import org.hibernate.PessimisticLockException;
import org.hibernate.Query;
import org.hibernate.QueryException;
import org.hibernate.QueryTimeoutException;
import org.hibernate.SQLQuery;
import org.hibernate.Session;
import org.hibernate.StaleObjectStateException;
import org.hibernate.StaleStateException;
import org.hibernate.Transaction;
import org.hibernate.TransientObjectException;
import org.hibernate.TypeMismatchException;
import org.hibernate.UnresolvableObjectException;
import org.hibernate.ejb.EntityManagerFactoryImpl;
import org.hibernate.ejb.HibernateEntityManagerFactory;
import org.hibernate.ejb.HibernateEntityManagerImplementor;
import org.hibernate.ejb.QueryImpl;
import org.hibernate.ejb.TransactionImpl;
import org.hibernate.ejb.criteria.CriteriaQueryCompiler;
import org.hibernate.ejb.criteria.ValueHandlerFactory;
import org.hibernate.ejb.criteria.expression.CompoundSelectionImpl;
import org.hibernate.ejb.transaction.JoinableCMTTransaction;
import org.hibernate.ejb.util.CacheModeHelper;
import org.hibernate.ejb.util.ConfigurationHelper;
import org.hibernate.ejb.util.LockModeTypeHelper;
import org.hibernate.engine.NamedSQLQueryDefinition;
import org.hibernate.engine.ResultSetMappingDefinition;
import org.hibernate.engine.SessionFactoryImplementor;
import org.hibernate.engine.SessionImplementor;
import org.hibernate.engine.query.HQLQueryPlan;
import org.hibernate.engine.query.sql.NativeSQLQueryReturn;
import org.hibernate.engine.query.sql.NativeSQLQueryRootReturn;
import org.hibernate.proxy.HibernateProxy;
import org.hibernate.transaction.TransactionFactory;
import org.hibernate.transaction.synchronization.AfterCompletionAction;
import org.hibernate.transaction.synchronization.BeforeCompletionManagedFlushChecker;
import org.hibernate.transaction.synchronization.CallbackCoordinator;
import org.hibernate.transaction.synchronization.ExceptionMapper;
import org.hibernate.transform.BasicTransformerAdapter;
import org.hibernate.type.Type;
import org.hibernate.util.CollectionHelper;
import org.hibernate.util.JTAHelper;
import org.hibernate.util.ReflectHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractEntityManagerImpl
implements HibernateEntityManagerImplementor,
Serializable {
    private static final Logger log = LoggerFactory.getLogger(AbstractEntityManagerImpl.class);
    private static final List<String> entityManagerSpecificProperties = new ArrayList<String>();
    private EntityManagerFactoryImpl entityManagerFactory;
    protected transient TransactionImpl tx = new TransactionImpl(this);
    protected PersistenceContextType persistenceContextType;
    private PersistenceUnitTransactionType transactionType;
    private Map<String, Object> properties;
    private LockOptions lockOptions;
    private CriteriaQueryCompiler criteriaQueryCompiler;

    protected AbstractEntityManagerImpl(EntityManagerFactoryImpl entityManagerFactory, PersistenceContextType type, PersistenceUnitTransactionType transactionType, Map properties) {
        this.entityManagerFactory = entityManagerFactory;
        this.persistenceContextType = type;
        this.transactionType = transactionType;
        this.lockOptions = new LockOptions();
        this.properties = new HashMap<String, Object>();
        if (properties != null) {
            for (String key : entityManagerSpecificProperties) {
                if (!properties.containsKey(key)) continue;
                this.properties.put(key, properties.get(key));
            }
        }
    }

    protected void postInit() {
        if (PersistenceUnitTransactionType.JTA.equals((Object)this.transactionType)) {
            this.joinTransaction(true);
        }
        this.setDefaultProperties();
        this.applyProperties();
    }

    private void applyProperties() {
        this.getSession().setFlushMode(ConfigurationHelper.getFlushMode(this.properties.get("org.hibernate.flushMode")));
        this.setLockOptions(this.properties, this.lockOptions);
        this.getSession().setCacheMode(CacheModeHelper.interpretCacheMode(this.currentCacheStoreMode(), this.currentCacheRetrieveMode()));
    }

    private javax.persistence.Query applyProperties(javax.persistence.Query query) {
        Object queryTimeout;
        if (this.lockOptions.getLockMode() != LockMode.NONE) {
            query.setLockMode(this.getLockMode(this.lockOptions.getLockMode()));
        }
        if ((queryTimeout = this.getProperties().get("javax.persistence.query.timeout")) != null) {
            query.setHint("javax.persistence.query.timeout", queryTimeout);
        }
        return query;
    }

    private CacheRetrieveMode currentCacheRetrieveMode() {
        return this.determineCacheRetrieveMode(this.properties);
    }

    private CacheRetrieveMode determineCacheRetrieveMode(Map<String, Object> settings) {
        return (CacheRetrieveMode)((Object)settings.get("javax.persistence.cache.retrieveMode"));
    }

    private CacheStoreMode currentCacheStoreMode() {
        return this.determineCacheStoreMode(this.properties);
    }

    private CacheStoreMode determineCacheStoreMode(Map<String, Object> settings) {
        return (CacheStoreMode)((Object)this.properties.get("javax.persistence.cache.storeMode"));
    }

    private void setLockOptions(Map<String, Object> props, LockOptions options) {
        Object lockScope = props.get("javax.persistence.lock.scope");
        if (lockScope instanceof String && PessimisticLockScope.valueOf((String)lockScope) == PessimisticLockScope.EXTENDED) {
            options.setScope(true);
        } else if (lockScope instanceof PessimisticLockScope) {
            boolean extended = PessimisticLockScope.EXTENDED.equals((Object)((PessimisticLockScope)((Object)lockScope)));
            options.setScope(extended);
        } else if (lockScope != null) {
            throw new PersistenceException("Unable to parse javax.persistence.lock.scope: " + lockScope);
        }
        Object lockTimeout = props.get("javax.persistence.lock.timeout");
        int timeout = 0;
        boolean timeoutSet = false;
        if (lockTimeout instanceof String) {
            timeout = Integer.parseInt((String)lockTimeout);
            timeoutSet = true;
        } else if (lockTimeout instanceof Number) {
            timeout = ((Number)lockTimeout).intValue();
            timeoutSet = true;
        } else if (lockTimeout != null) {
            throw new PersistenceException("Unable to parse javax.persistence.lock.timeout: " + lockTimeout);
        }
        if (timeoutSet) {
            if (timeout < 0) {
                options.setTimeOut(-1);
            } else if (timeout == 0) {
                options.setTimeOut(0);
            } else {
                options.setTimeOut(timeout);
            }
        }
    }

    private void setDefaultProperties() {
        if (this.properties.get("org.hibernate.flushMode") == null) {
            this.properties.put("org.hibernate.flushMode", this.getSession().getFlushMode().toString());
        }
        if (this.properties.get("javax.persistence.lock.scope") == null) {
            this.properties.put("javax.persistence.lock.scope", PessimisticLockScope.EXTENDED.name());
        }
        if (this.properties.get("javax.persistence.lock.timeout") == null) {
            this.properties.put("javax.persistence.lock.timeout", -1);
        }
        if (this.properties.get("javax.persistence.cache.retrieveMode") == null) {
            this.properties.put("javax.persistence.cache.retrieveMode", (Object)CacheModeHelper.DEFAULT_RETRIEVE_MODE);
        }
        if (this.properties.get("javax.persistence.cache.storeMode") == null) {
            this.properties.put("javax.persistence.cache.storeMode", (Object)CacheModeHelper.DEFAULT_STORE_MODE);
        }
    }

    @Override
    public javax.persistence.Query createQuery(String jpaqlString) {
        try {
            return this.applyProperties(new QueryImpl(this.getSession().createQuery(jpaqlString), this));
        }
        catch (HibernateException he) {
            throw this.convert(he);
        }
    }

    @Override
    public <T> TypedQuery<T> createQuery(String jpaqlString, Class<T> resultClass) {
        try {
            Query hqlQuery = this.getSession().createQuery(jpaqlString);
            if (!Object[].class.equals(resultClass)) {
                if (Tuple.class.equals(resultClass)) {
                    TupleBuilderTransformer tupleTransformer = new TupleBuilderTransformer(hqlQuery);
                    hqlQuery.setResultTransformer(tupleTransformer);
                } else {
                    SessionImplementor session = this.unwrap(SessionImplementor.class);
                    HQLQueryPlan queryPlan = session.getFactory().getQueryPlanCache().getHQLQueryPlan(jpaqlString, false, session.getLoadQueryInfluencers().getEnabledFilters());
                    Class dynamicInstantiationClass = queryPlan.getDynamicInstantiationResultType();
                    if (dynamicInstantiationClass != null) {
                        if (!resultClass.isAssignableFrom(dynamicInstantiationClass)) {
                            throw new IllegalArgumentException("Mismatch in requested result type [" + resultClass.getName() + "] and actual result type [" + dynamicInstantiationClass.getName() + "]");
                        }
                    } else if (hqlQuery.getReturnTypes().length == 1) {
                        if (!resultClass.isAssignableFrom(hqlQuery.getReturnTypes()[0].getReturnedClass())) {
                            throw new IllegalArgumentException("Type specified for TypedQuery [" + resultClass.getName() + "] is incompatible with query return type [" + hqlQuery.getReturnTypes()[0].getReturnedClass() + "]");
                        }
                    } else {
                        throw new IllegalArgumentException("Cannot create TypedQuery for query with more than one return using requested result type [" + resultClass.getName() + "]");
                    }
                }
            }
            return new QueryImpl(hqlQuery, this);
        }
        catch (HibernateException he) {
            throw this.convert(he);
        }
    }

    @Override
    public <T> TypedQuery<T> createQuery(String jpaqlString, Class<T> resultClass, Selection selection, HibernateEntityManagerImplementor.Options options) {
        try {
            List<Selection<?>> tupleElements;
            Query hqlQuery = this.getSession().createQuery(jpaqlString);
            if (options.getValueHandlers() == null) {
                options.getResultMetadataValidator().validate(hqlQuery.getReturnTypes());
            }
            List<Selection<?>> list = tupleElements = Tuple.class.equals(resultClass) ? ((CompoundSelectionImpl)selection).getCompoundSelectionItems() : null;
            if (options.getValueHandlers() != null || tupleElements != null) {
                hqlQuery.setResultTransformer(new CriteriaQueryTransformer(options.getValueHandlers(), tupleElements));
            }
            return new QueryImpl(hqlQuery, this, options.getNamedParameterExplicitTypes());
        }
        catch (HibernateException he) {
            throw this.convert(he);
        }
    }

    @Override
    public <T> TypedQuery<T> createQuery(CriteriaQuery<T> criteriaQuery) {
        if (this.criteriaQueryCompiler == null) {
            this.criteriaQueryCompiler = new CriteriaQueryCompiler(this);
        }
        return this.criteriaQueryCompiler.compile(criteriaQuery);
    }

    @Override
    public javax.persistence.Query createNamedQuery(String name) {
        try {
            Query namedQuery = this.getSession().getNamedQuery(name);
            try {
                return new QueryImpl(namedQuery, this);
            }
            catch (HibernateException he) {
                throw this.convert(he);
            }
        }
        catch (MappingException e) {
            throw new IllegalArgumentException("Named query not found: " + name);
        }
    }

    @Override
    public <T> TypedQuery<T> createNamedQuery(String name, Class<T> resultClass) {
        try {
            Query namedQuery = this.getSession().getNamedQuery(name);
            SessionFactoryImplementor factoryImplementor = (SessionFactoryImplementor)this.entityManagerFactory.getSessionFactory();
            NamedSQLQueryDefinition queryDefinition = factoryImplementor.getNamedSQLQuery(name);
            try {
                if (queryDefinition != null) {
                    NativeSQLQueryReturn[] queryReturns;
                    if (queryDefinition.getQueryReturns() != null) {
                        queryReturns = queryDefinition.getQueryReturns();
                    } else if (queryDefinition.getResultSetRef() != null) {
                        ResultSetMappingDefinition rsMapping = factoryImplementor.getResultSetMapping(queryDefinition.getResultSetRef());
                        queryReturns = rsMapping.getQueryReturns();
                    } else {
                        throw new AssertionFailure("Unsupported named query model. Please report the bug in Hibernate EntityManager");
                    }
                    if (queryReturns.length > 1) {
                        throw new IllegalArgumentException("Cannot create TypedQuery for query with more than one return");
                    }
                    NativeSQLQueryReturn nativeSQLQueryReturn = queryReturns[0];
                    if (nativeSQLQueryReturn instanceof NativeSQLQueryRootReturn) {
                        Class actualReturnedClass;
                        String entityClassName = ((NativeSQLQueryRootReturn)nativeSQLQueryReturn).getReturnEntityName();
                        try {
                            actualReturnedClass = ReflectHelper.classForName(entityClassName, AbstractEntityManagerImpl.class);
                        }
                        catch (ClassNotFoundException e) {
                            throw new AssertionFailure("Unable to instantiate class declared on named native query: " + name + " " + entityClassName);
                        }
                        if (!resultClass.isAssignableFrom(actualReturnedClass)) {
                            throw this.buildIncompatibleException(resultClass, actualReturnedClass);
                        }
                    }
                } else {
                    if (namedQuery.getReturnTypes().length != 1) {
                        throw new IllegalArgumentException("Cannot create TypedQuery for query with more than one return");
                    }
                    if (!resultClass.isAssignableFrom(namedQuery.getReturnTypes()[0].getReturnedClass())) {
                        throw this.buildIncompatibleException(resultClass, namedQuery.getReturnTypes()[0].getReturnedClass());
                    }
                }
                return new QueryImpl(namedQuery, this);
            }
            catch (HibernateException he) {
                throw this.convert(he);
            }
        }
        catch (MappingException e) {
            throw new IllegalArgumentException("Named query not found: " + name);
        }
    }

    private IllegalArgumentException buildIncompatibleException(Class<?> resultClass, Class<?> actualResultClass) {
        return new IllegalArgumentException("Type specified for TypedQuery [" + resultClass.getName() + "] is incompatible with query return type [" + actualResultClass + "]");
    }

    @Override
    public javax.persistence.Query createNativeQuery(String sqlString) {
        try {
            SQLQuery q = this.getSession().createSQLQuery(sqlString);
            return new QueryImpl(q, this);
        }
        catch (HibernateException he) {
            throw this.convert(he);
        }
    }

    @Override
    public javax.persistence.Query createNativeQuery(String sqlString, Class resultClass) {
        try {
            SQLQuery q = this.getSession().createSQLQuery(sqlString);
            q.addEntity("alias1", resultClass.getName(), LockMode.READ);
            return new QueryImpl(q, this);
        }
        catch (HibernateException he) {
            throw this.convert(he);
        }
    }

    @Override
    public javax.persistence.Query createNativeQuery(String sqlString, String resultSetMapping) {
        try {
            SQLQuery q = this.getSession().createSQLQuery(sqlString);
            q.setResultSetMapping(resultSetMapping);
            return new QueryImpl(q, this);
        }
        catch (HibernateException he) {
            throw this.convert(he);
        }
    }

    @Override
    public <T> T getReference(Class<T> entityClass, Object primaryKey) {
        try {
            return (T)this.getSession().load(entityClass, (Serializable)primaryKey);
        }
        catch (MappingException e) {
            throw new IllegalArgumentException(e.getMessage(), e);
        }
        catch (TypeMismatchException e) {
            throw new IllegalArgumentException(e.getMessage(), e);
        }
        catch (ClassCastException e) {
            throw new IllegalArgumentException(e.getMessage(), e);
        }
        catch (HibernateException he) {
            throw this.convert(he);
        }
    }

    public <A> A find(Class<A> entityClass, Object primaryKey) {
        return this.find(entityClass, primaryKey, (LockModeType)null, (Map<String, Object>)null);
    }

    @Override
    public <T> T find(Class<T> entityClass, Object primaryKey, Map<String, Object> properties) {
        return this.find((Class)entityClass, primaryKey, (LockModeType)null, properties);
    }

    public <A> A find(Class<A> entityClass, Object primaryKey, LockModeType lockModeType) {
        return this.find(entityClass, primaryKey, lockModeType, (Map<String, Object>)null);
    }

    public <A> A find(Class<A> entityClass, Object primaryKey, LockModeType lockModeType, Map<String, Object> properties) {
        CacheMode previousCacheMode = this.getSession().getCacheMode();
        CacheMode cacheMode = this.determineAppropriateLocalCacheMode(properties);
        LockOptions lockOptions = null;
        try {
            this.getSession().setCacheMode(cacheMode);
            if (lockModeType != null) {
                Object object = this.getSession().get(entityClass, (Serializable)primaryKey, this.getLockRequest(lockModeType, properties));
                return (A)object;
            }
            Object object = this.getSession().get(entityClass, (Serializable)primaryKey);
            return (A)object;
        }
        catch (ObjectDeletedException e) {
            A a = null;
            return a;
        }
        catch (ObjectNotFoundException e) {
            throw new IllegalArgumentException(e.getMessage(), e);
        }
        catch (MappingException e) {
            throw new IllegalArgumentException(e.getMessage(), e);
        }
        catch (TypeMismatchException e) {
            throw new IllegalArgumentException(e.getMessage(), e);
        }
        catch (ClassCastException e) {
            throw new IllegalArgumentException(e.getMessage(), e);
        }
        catch (HibernateException he) {
            throw this.convert(he, lockOptions);
        }
        finally {
            this.getSession().setCacheMode(previousCacheMode);
        }
    }

    public CacheMode determineAppropriateLocalCacheMode(Map<String, Object> localProperties) {
        CacheRetrieveMode retrieveMode = null;
        CacheStoreMode storeMode = null;
        if (localProperties != null) {
            retrieveMode = this.determineCacheRetrieveMode(localProperties);
            storeMode = this.determineCacheStoreMode(localProperties);
        }
        if (retrieveMode == null) {
            retrieveMode = this.determineCacheRetrieveMode(this.properties);
        }
        if (storeMode == null) {
            storeMode = this.determineCacheStoreMode(this.properties);
        }
        return CacheModeHelper.interpretCacheMode(storeMode, retrieveMode);
    }

    private void checkTransactionNeeded() {
        if (this.persistenceContextType == PersistenceContextType.TRANSACTION && !this.isTransactionInProgress()) {
            throw new TransactionRequiredException("no transaction is in progress for a TRANSACTION type persistence context");
        }
    }

    @Override
    public void persist(Object entity) {
        this.checkTransactionNeeded();
        try {
            this.getSession().persist(entity);
        }
        catch (MappingException e) {
            throw new IllegalArgumentException(e.getMessage());
        }
        catch (RuntimeException e) {
            throw this.convert(e);
        }
    }

    public <A> A merge(A entity) {
        this.checkTransactionNeeded();
        try {
            return (A)this.getSession().merge(entity);
        }
        catch (ObjectDeletedException sse) {
            throw new IllegalArgumentException(sse);
        }
        catch (MappingException e) {
            throw new IllegalArgumentException(e.getMessage(), e);
        }
        catch (RuntimeException e) {
            throw this.convert(e);
        }
    }

    @Override
    public void remove(Object entity) {
        this.checkTransactionNeeded();
        try {
            this.getSession().delete(entity);
        }
        catch (MappingException e) {
            throw new IllegalArgumentException(e.getMessage(), e);
        }
        catch (RuntimeException e) {
            throw this.convert(e);
        }
    }

    @Override
    public void refresh(Object entity) {
        this.refresh(entity, null, null);
    }

    @Override
    public void refresh(Object entity, Map<String, Object> properties) {
        this.refresh(entity, null, properties);
    }

    @Override
    public void refresh(Object entity, LockModeType lockModeType) {
        this.refresh(entity, lockModeType, null);
    }

    @Override
    public void refresh(Object entity, LockModeType lockModeType, Map<String, Object> properties) {
        this.checkTransactionNeeded();
        CacheMode previousCacheMode = this.getSession().getCacheMode();
        CacheMode localCacheMode = this.determineAppropriateLocalCacheMode(properties);
        LockOptions lockOptions = null;
        try {
            this.getSession().setCacheMode(localCacheMode);
            if (!this.getSession().contains(entity)) {
                throw new IllegalArgumentException("Entity not managed");
            }
            if (lockModeType != null) {
                lockOptions = this.getLockRequest(lockModeType, properties);
                this.getSession().refresh(entity, lockOptions);
            } else {
                this.getSession().refresh(entity);
            }
        }
        catch (MappingException e) {
            throw new IllegalArgumentException(e.getMessage(), e);
        }
        catch (HibernateException he) {
            throw this.convert(he, lockOptions);
        }
        finally {
            this.getSession().setCacheMode(previousCacheMode);
        }
    }

    @Override
    public boolean contains(Object entity) {
        try {
            if (entity != null && !(entity instanceof HibernateProxy) && this.getSession().getSessionFactory().getClassMetadata(entity.getClass()) == null) {
                throw new IllegalArgumentException("Not an entity:" + entity.getClass());
            }
            return this.getSession().contains(entity);
        }
        catch (MappingException e) {
            throw new IllegalArgumentException(e.getMessage(), e);
        }
        catch (HibernateException he) {
            throw this.convert(he);
        }
    }

    @Override
    public LockModeType getLockMode(Object entity) {
        if (!this.contains(entity)) {
            throw new IllegalArgumentException("entity not in the persistence context");
        }
        return AbstractEntityManagerImpl.getLockModeType(this.getSession().getCurrentLockMode(entity));
    }

    @Override
    public void setProperty(String s, Object o) {
        if (entityManagerSpecificProperties.contains(s)) {
            this.properties.put(s, o);
            this.applyProperties();
        } else {
            log.debug("Trying to set a property which is not supported on entity manager level");
        }
    }

    @Override
    public Map<String, Object> getProperties() {
        return Collections.unmodifiableMap(this.properties);
    }

    @Override
    public void flush() {
        if (!this.isTransactionInProgress()) {
            throw new TransactionRequiredException("no transaction is in progress");
        }
        try {
            this.getSession().flush();
        }
        catch (RuntimeException e) {
            throw this.convert(e);
        }
    }

    @Override
    public abstract Session getSession();

    protected abstract Session getRawSession();

    @Override
    public EntityTransaction getTransaction() {
        if (this.transactionType == PersistenceUnitTransactionType.JTA) {
            throw new IllegalStateException("A JTA EntityManager cannot use getTransaction()");
        }
        return this.tx;
    }

    @Override
    public EntityManagerFactoryImpl getEntityManagerFactory() {
        return this.entityManagerFactory;
    }

    @Override
    public HibernateEntityManagerFactory getFactory() {
        return this.entityManagerFactory;
    }

    @Override
    public CriteriaBuilder getCriteriaBuilder() {
        return this.getEntityManagerFactory().getCriteriaBuilder();
    }

    @Override
    public Metamodel getMetamodel() {
        return this.getEntityManagerFactory().getMetamodel();
    }

    @Override
    public void setFlushMode(FlushModeType flushModeType) {
        if (flushModeType == FlushModeType.AUTO) {
            this.getSession().setFlushMode(FlushMode.AUTO);
        } else if (flushModeType == FlushModeType.COMMIT) {
            this.getSession().setFlushMode(FlushMode.COMMIT);
        } else {
            throw new AssertionFailure("Unknown FlushModeType: " + (Object)((Object)flushModeType));
        }
    }

    @Override
    public void clear() {
        try {
            this.getSession().clear();
        }
        catch (HibernateException he) {
            throw this.convert(he);
        }
    }

    @Override
    public void detach(Object entity) {
        try {
            this.getSession().evict(entity);
        }
        catch (HibernateException he) {
            throw this.convert(he);
        }
    }

    @Override
    public FlushModeType getFlushMode() {
        FlushMode mode = this.getSession().getFlushMode();
        if (mode == FlushMode.AUTO) {
            return FlushModeType.AUTO;
        }
        if (mode == FlushMode.COMMIT) {
            return FlushModeType.COMMIT;
        }
        return null;
    }

    @Override
    public void lock(Object entity, LockModeType lockMode) {
        this.lock(entity, lockMode, null);
    }

    @Override
    public void lock(Object entity, LockModeType lockModeType, Map<String, Object> properties) {
        LockOptions lockOptions = null;
        if (!this.isTransactionInProgress()) {
            throw new TransactionRequiredException("no transaction is in progress");
        }
        try {
            if (!this.contains(entity)) {
                throw new IllegalArgumentException("entity not in the persistence context");
            }
            lockOptions = this.getLockRequest(lockModeType, properties);
            this.getSession().buildLockRequest(lockOptions).lock(entity);
        }
        catch (HibernateException he) {
            throw this.convert(he, lockOptions);
        }
    }

    @Override
    public LockOptions getLockRequest(LockModeType lockModeType, Map<String, Object> properties) {
        LockOptions lockOptions = new LockOptions();
        LockOptions.copy(this.lockOptions, lockOptions);
        lockOptions.setLockMode(AbstractEntityManagerImpl.getLockMode(lockModeType));
        if (properties != null) {
            this.setLockOptions(properties, lockOptions);
        }
        return lockOptions;
    }

    private static LockModeType getLockModeType(LockMode lockMode) {
        return LockModeTypeHelper.getLockModeType(lockMode);
    }

    private static LockMode getLockMode(LockModeType lockMode) {
        return LockModeTypeHelper.getLockMode(lockMode);
    }

    @Override
    public boolean isTransactionInProgress() {
        return ((SessionImplementor)((Object)this.getRawSession())).isTransactionInProgress();
    }

    protected void markAsRollback() {
        log.debug("mark transaction for rollback");
        if (this.tx.isActive()) {
            this.tx.setRollbackOnly();
        } else if (PersistenceUnitTransactionType.JTA == this.transactionType) {
            TransactionManager transactionManager = ((SessionFactoryImplementor)this.getRawSession().getSessionFactory()).getTransactionManager();
            if (transactionManager == null) {
                throw new PersistenceException("Using a JTA persistence context wo setting hibernate.transaction.manager_lookup_class");
            }
            try {
                if (transactionManager.getStatus() != 6) {
                    transactionManager.setRollbackOnly();
                }
            }
            catch (SystemException e) {
                throw new PersistenceException("Unable to set the JTA transaction as RollbackOnly", e);
            }
        }
    }

    @Override
    public void joinTransaction() {
        this.joinTransaction(false);
    }

    @Override
    public <T> T unwrap(Class<T> clazz) {
        if (Session.class.isAssignableFrom(clazz)) {
            return (T)this.getSession();
        }
        if (SessionImplementor.class.isAssignableFrom(clazz)) {
            return (T)this.getSession();
        }
        if (EntityManager.class.isAssignableFrom(clazz)) {
            return (T)this;
        }
        throw new PersistenceException("Hibernate cannot unwrap " + clazz);
    }

    private void joinTransaction(boolean ignoreNotJoining) {
        this.getSession().isOpen();
        if (this.transactionType == PersistenceUnitTransactionType.JTA) {
            try {
                log.debug("Looking for a JTA transaction to join");
                final Session session = this.getSession();
                final Transaction transaction = session.getTransaction();
                if (transaction != null && transaction instanceof JoinableCMTTransaction) {
                    JoinableCMTTransaction joinableCMTTransaction = (JoinableCMTTransaction)transaction;
                    if (joinableCMTTransaction.getStatus() == JoinableCMTTransaction.JoinStatus.JOINED) {
                        log.debug("Transaction already joined");
                        return;
                    }
                    joinableCMTTransaction.markForJoined();
                    session.isOpen();
                    if (joinableCMTTransaction.getStatus() == JoinableCMTTransaction.JoinStatus.NOT_JOINED) {
                        if (ignoreNotJoining) {
                            log.debug("No JTA transaction found");
                            return;
                        }
                        throw new TransactionRequiredException("No active JTA transaction on joinTransaction call");
                    }
                    if (joinableCMTTransaction.getStatus() == JoinableCMTTransaction.JoinStatus.MARKED_FOR_JOINED) {
                        throw new AssertionFailure("Transaction MARKED_FOR_JOINED after isOpen() call");
                    }
                    log.trace("Adding flush() and close() synchronization");
                    CallbackCoordinator callbackCoordinator = ((SessionImplementor)((Object)this.getSession())).getJDBCContext().getJtaSynchronizationCallbackCoordinator();
                    if (callbackCoordinator == null) {
                        throw new AssertionFailure("Expecting CallbackCoordinator to be non-null");
                    }
                    callbackCoordinator.setBeforeCompletionManagedFlushChecker(new BeforeCompletionManagedFlushChecker(){

                        public boolean shouldDoManagedFlush(TransactionFactory.Context ctx, javax.transaction.Transaction jtaTransaction) throws SystemException {
                            if (transaction == null) {
                                log.warn("Transaction not available on beforeCompletion: assuming valid");
                            }
                            return !ctx.isFlushModeNever() && (jtaTransaction == null || !JTAHelper.isRollback(jtaTransaction.getStatus()));
                        }
                    });
                    callbackCoordinator.setAfterCompletionAction(new AfterCompletionAction(){

                        public void doAction(TransactionFactory.Context ctx, int status) {
                            try {
                                if (!ctx.isClosed()) {
                                    if (4 == status && AbstractEntityManagerImpl.this.transactionType == PersistenceUnitTransactionType.JTA) {
                                        session.clear();
                                    }
                                    JoinableCMTTransaction joinable = (JoinableCMTTransaction)session.getTransaction();
                                    joinable.resetStatus();
                                }
                            }
                            catch (HibernateException e) {
                                throw AbstractEntityManagerImpl.this.convert(e);
                            }
                        }
                    });
                    callbackCoordinator.setExceptionMapper(new ExceptionMapper(){

                        public RuntimeException mapStatusCheckFailure(String message, SystemException systemException) {
                            throw new PersistenceException(message, systemException);
                        }

                        public RuntimeException mapManagedFlushFailure(String message, RuntimeException failure) {
                            if (HibernateException.class.isInstance(failure)) {
                                throw AbstractEntityManagerImpl.this.convert(failure);
                            }
                            if (PersistenceException.class.isInstance(failure)) {
                                throw failure;
                            }
                            throw new PersistenceException(message, failure);
                        }
                    });
                }
                log.warn("Cannot join transaction: do not override {}", (Object)"hibernate.transaction.factory_class");
            }
            catch (HibernateException he) {
                throw this.convert(he);
            }
        } else if (!ignoreNotJoining) {
            log.warn("Calling joinTransaction() on a non JTA EntityManager");
        }
    }

    @Override
    public Object getDelegate() {
        return this.getSession();
    }

    private void writeObject(ObjectOutputStream oos) throws IOException {
        oos.defaultWriteObject();
    }

    private void readObject(ObjectInputStream ois) throws IOException, ClassNotFoundException {
        ois.defaultReadObject();
        this.tx = new TransactionImpl(this);
    }

    @Override
    public void handlePersistenceException(PersistenceException e) {
        if (e instanceof NoResultException) {
            return;
        }
        if (e instanceof javax.persistence.NonUniqueResultException) {
            return;
        }
        if (e instanceof LockTimeoutException) {
            return;
        }
        if (e instanceof javax.persistence.QueryTimeoutException) {
            return;
        }
        try {
            this.markAsRollback();
        }
        catch (Exception ne) {
            log.error("Unable to mark for rollback on PersistenceException: ", ne);
        }
    }

    @Override
    public void throwPersistenceException(PersistenceException e) {
        this.handlePersistenceException(e);
        throw e;
    }

    @Override
    public RuntimeException convert(HibernateException e) {
        return this.convert(e, null);
    }

    public RuntimeException convert(RuntimeException e) {
        RuntimeException result = e;
        if (e instanceof HibernateException) {
            result = this.convert((HibernateException)e);
        } else {
            this.markAsRollback();
        }
        return result;
    }

    @Override
    public RuntimeException convert(HibernateException e, LockOptions lockOptions) {
        if (e instanceof StaleStateException) {
            PersistenceException converted = this.wrapStaleStateException((StaleStateException)e);
            this.handlePersistenceException(converted);
            return converted;
        }
        if (e instanceof OptimisticLockException) {
            PersistenceException converted = this.wrapLockException(e, lockOptions);
            this.handlePersistenceException(converted);
            return converted;
        }
        if (e instanceof PessimisticLockException) {
            PersistenceException converted = this.wrapLockException(e, lockOptions);
            this.handlePersistenceException(converted);
            return converted;
        }
        if (e instanceof QueryTimeoutException) {
            javax.persistence.QueryTimeoutException converted = new javax.persistence.QueryTimeoutException(e.getMessage(), e);
            this.handlePersistenceException(converted);
            return converted;
        }
        if (e instanceof ObjectNotFoundException) {
            EntityNotFoundException converted = new EntityNotFoundException(e.getMessage());
            this.handlePersistenceException(converted);
            return converted;
        }
        if (e instanceof NonUniqueObjectException) {
            EntityExistsException converted = new EntityExistsException(e.getMessage());
            this.handlePersistenceException(converted);
            return converted;
        }
        if (e instanceof NonUniqueResultException) {
            javax.persistence.NonUniqueResultException converted = new javax.persistence.NonUniqueResultException(e.getMessage());
            this.handlePersistenceException(converted);
            return converted;
        }
        if (e instanceof UnresolvableObjectException) {
            EntityNotFoundException converted = new EntityNotFoundException(e.getMessage());
            this.handlePersistenceException(converted);
            return converted;
        }
        if (e instanceof QueryException) {
            return new IllegalArgumentException(e);
        }
        if (e instanceof TransientObjectException) {
            try {
                this.markAsRollback();
            }
            catch (Exception ne) {
                log.error("Unable to mark for rollback on TransientObjectException: ", ne);
            }
            return new IllegalStateException(e);
        }
        PersistenceException converted = new PersistenceException(e);
        this.handlePersistenceException(converted);
        return converted;
    }

    @Override
    public void throwPersistenceException(HibernateException e) {
        throw this.convert(e);
    }

    @Override
    public PersistenceException wrapStaleStateException(StaleStateException e) {
        javax.persistence.OptimisticLockException pe;
        block7: {
            if (e instanceof StaleObjectStateException) {
                StaleObjectStateException sose = (StaleObjectStateException)e;
                Serializable identifier = sose.getIdentifier();
                if (identifier != null) {
                    try {
                        Object entity = this.getRawSession().load(sose.getEntityName(), identifier);
                        if (entity instanceof Serializable) {
                            pe = new javax.persistence.OptimisticLockException(null, e, entity);
                            break block7;
                        }
                        pe = new javax.persistence.OptimisticLockException(e);
                    }
                    catch (EntityNotFoundException enfe) {
                        pe = new javax.persistence.OptimisticLockException(e);
                    }
                } else {
                    pe = new javax.persistence.OptimisticLockException(e);
                }
            } else {
                pe = new javax.persistence.OptimisticLockException(e);
            }
        }
        return pe;
    }

    public PersistenceException wrapLockException(HibernateException e, LockOptions lockOptions) {
        PersistenceException pe;
        if (e instanceof OptimisticLockException) {
            OptimisticLockException ole = (OptimisticLockException)e;
            pe = new javax.persistence.OptimisticLockException(ole.getMessage(), ole, ole.getEntity());
        } else if (e instanceof PessimisticLockException) {
            PessimisticLockException ple = (PessimisticLockException)e;
            pe = lockOptions != null && lockOptions.getTimeOut() > -1 ? new LockTimeoutException(ple.getMessage(), ple, ple.getEntity()) : new javax.persistence.PessimisticLockException(ple.getMessage(), ple, ple.getEntity());
        } else {
            pe = new javax.persistence.OptimisticLockException(e);
        }
        return pe;
    }

    static {
        entityManagerSpecificProperties.add("javax.persistence.lock.scope");
        entityManagerSpecificProperties.add("javax.persistence.lock.timeout");
        entityManagerSpecificProperties.add("org.hibernate.flushMode");
        entityManagerSpecificProperties.add("javax.persistence.cache.retrieveMode");
        entityManagerSpecificProperties.add("javax.persistence.cache.storeMode");
        entityManagerSpecificProperties.add("javax.persistence.query.timeout");
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class CriteriaQueryTransformer
    extends BasicTransformerAdapter {
        private final List<ValueHandlerFactory.ValueHandler> valueHandlers;
        private final List tupleElements;

        private CriteriaQueryTransformer(List<ValueHandlerFactory.ValueHandler> valueHandlers, List tupleElements) {
            this.valueHandlers = valueHandlers;
            this.tupleElements = tupleElements;
        }

        @Override
        public Object transformTuple(Object[] tuple, String[] aliases) {
            Object[] valueHandlerResult;
            if (this.valueHandlers == null) {
                valueHandlerResult = tuple;
            } else {
                valueHandlerResult = new Object[tuple.length];
                for (int i = 0; i < tuple.length; ++i) {
                    ValueHandlerFactory.ValueHandler valueHandler = this.valueHandlers.get(i);
                    valueHandlerResult[i] = valueHandler == null ? tuple[i] : valueHandler.convert(tuple[i]);
                }
            }
            return this.tupleElements == null ? (valueHandlerResult.length == 1 ? valueHandlerResult[0] : valueHandlerResult) : new TupleImpl(tuple);
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private class TupleImpl
        implements Tuple {
            private final Object[] tuples;

            private TupleImpl(Object[] tuples) {
                if (tuples.length != CriteriaQueryTransformer.this.tupleElements.size()) {
                    throw new IllegalArgumentException("Size mismatch between tuple result [" + tuples.length + "] and expected tuple elements [" + CriteriaQueryTransformer.this.tupleElements.size() + "]");
                }
                this.tuples = tuples;
            }

            @Override
            public <X> X get(TupleElement<X> tupleElement) {
                int index = CriteriaQueryTransformer.this.tupleElements.indexOf(tupleElement);
                if (index < 0) {
                    throw new IllegalArgumentException("Requested tuple element did not correspond to element in the result tuple");
                }
                return (X)this.tuples[index];
            }

            @Override
            public Object get(String alias) {
                int index = -1;
                if (alias != null && (alias = alias.trim()).length() > 0) {
                    int i = 0;
                    for (TupleElement selection : CriteriaQueryTransformer.this.tupleElements) {
                        if (alias.equals(selection.getAlias())) {
                            index = i;
                            break;
                        }
                        ++i;
                    }
                }
                if (index < 0) {
                    throw new IllegalArgumentException("Given alias [" + alias + "] did not correspond to an element in the result tuple");
                }
                return this.tuples[index];
            }

            @Override
            public <X> X get(String alias, Class<X> type) {
                return (X)this.get(alias);
            }

            @Override
            public Object get(int i) {
                if (i >= this.tuples.length) {
                    throw new IllegalArgumentException("Given index [" + i + "] was outside the range of result tuple size [" + this.tuples.length + "] ");
                }
                return this.tuples[i];
            }

            @Override
            public <X> X get(int i, Class<X> type) {
                return (X)this.get(i);
            }

            @Override
            public Object[] toArray() {
                return this.tuples;
            }

            @Override
            public List<TupleElement<?>> getElements() {
                return CriteriaQueryTransformer.this.tupleElements;
            }
        }
    }

    public static class TupleBuilderTransformer
    extends BasicTransformerAdapter {
        private List<TupleElement<?>> tupleElements;
        private Map<String, HqlTupleElementImpl> tupleElementsByAlias;

        public TupleBuilderTransformer(Query hqlQuery) {
            Type[] resultTypes = hqlQuery.getReturnTypes();
            int tupleSize = resultTypes.length;
            this.tupleElements = CollectionHelper.arrayList(tupleSize);
            String[] aliases = hqlQuery.getReturnAliases();
            boolean hasAliases = aliases != null && aliases.length > 0;
            this.tupleElementsByAlias = hasAliases ? CollectionHelper.mapOfSize(tupleSize) : Collections.emptyMap();
            for (int i = 0; i < tupleSize; ++i) {
                String alias;
                HqlTupleElementImpl tupleElement = new HqlTupleElementImpl(i, aliases == null ? null : aliases[i], resultTypes[i]);
                this.tupleElements.add(tupleElement);
                if (!hasAliases || (alias = aliases[i]) == null) continue;
                this.tupleElementsByAlias.put(alias, tupleElement);
            }
        }

        public Object transformTuple(Object[] tuple, String[] aliases) {
            if (tuple.length != this.tupleElements.size()) {
                throw new IllegalArgumentException("Size mismatch between tuple result [" + tuple.length + "] and expected tuple elements [" + this.tupleElements.size() + "]");
            }
            return new HqlTupleImpl(tuple);
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class HqlTupleImpl
        implements Tuple {
            private Object[] tuple;

            public HqlTupleImpl(Object[] tuple) {
                this.tuple = tuple;
            }

            @Override
            public <X> X get(String alias, Class<X> type) {
                return (X)this.get(alias);
            }

            @Override
            public Object get(String alias) {
                HqlTupleElementImpl tupleElement = (HqlTupleElementImpl)TupleBuilderTransformer.this.tupleElementsByAlias.get(alias);
                if (tupleElement == null) {
                    throw new IllegalArgumentException("Unknown alias [" + alias + "]");
                }
                return this.tuple[tupleElement.getPosition()];
            }

            @Override
            public <X> X get(int i, Class<X> type) {
                return (X)this.get(i);
            }

            @Override
            public Object get(int i) {
                if (i < 0) {
                    throw new IllegalArgumentException("requested tuple index must be greater than zero");
                }
                if (i > this.tuple.length) {
                    throw new IllegalArgumentException("requested tuple index exceeds actual tuple size");
                }
                return this.tuple[i];
            }

            @Override
            public Object[] toArray() {
                return this.tuple;
            }

            @Override
            public List<TupleElement<?>> getElements() {
                return TupleBuilderTransformer.this.tupleElements;
            }

            @Override
            public <X> X get(TupleElement<X> tupleElement) {
                if (HqlTupleElementImpl.class.isInstance(tupleElement)) {
                    return this.get(((HqlTupleElementImpl)tupleElement).getPosition(), tupleElement.getJavaType());
                }
                return this.get(tupleElement.getAlias(), tupleElement.getJavaType());
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static class HqlTupleElementImpl<X>
        implements TupleElement<X> {
            private final int position;
            private final String alias;
            private final Type hibernateType;

            public HqlTupleElementImpl(int position, String alias, Type hibernateType) {
                this.position = position;
                this.alias = alias;
                this.hibernateType = hibernateType;
            }

            @Override
            public Class getJavaType() {
                return this.hibernateType.getReturnedClass();
            }

            @Override
            public String getAlias() {
                return this.alias;
            }

            public int getPosition() {
                return this.position;
            }

            public Type getHibernateType() {
                return this.hibernateType;
            }
        }
    }
}

