/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ejb.criteria.path;

import java.io.Serializable;
import java.lang.reflect.Member;
import java.util.Map;
import javax.persistence.metamodel.Attribute;
import javax.persistence.metamodel.Bindable;
import javax.persistence.metamodel.ManagedType;
import javax.persistence.metamodel.MapAttribute;
import javax.persistence.metamodel.SingularAttribute;
import javax.persistence.metamodel.Type;
import org.hibernate.ejb.criteria.CriteriaBuilderImpl;
import org.hibernate.ejb.criteria.MapJoinImplementor;
import org.hibernate.ejb.criteria.PathImplementor;
import org.hibernate.ejb.criteria.path.AbstractPathImpl;
import org.hibernate.engine.SessionFactoryImplementor;
import org.hibernate.persister.collection.CollectionPersister;

public class MapKeyHelpers {
    private MapKeyHelpers() {
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class MapKeyAttribute<K>
    implements SingularAttribute<Map<K, ?>, K>,
    Bindable<K>,
    Serializable {
        private final MapAttribute<?, K, ?> attribute;
        private final CollectionPersister mapPersister;
        private final org.hibernate.type.Type mapKeyType;
        private final Type<K> jpaType;
        private final Bindable.BindableType jpaBindableType;
        private final Class<K> jpaBinableJavaType;
        private final Attribute.PersistentAttributeType persistentAttributeType;

        public MapKeyAttribute(CriteriaBuilderImpl criteriaBuilder, MapAttribute<?, K, ?> attribute) {
            this.attribute = attribute;
            this.jpaType = attribute.getKeyType();
            this.jpaBinableJavaType = attribute.getKeyJavaType();
            this.jpaBindableType = Type.PersistenceType.ENTITY.equals((Object)this.jpaType.getPersistenceType()) ? Bindable.BindableType.ENTITY_TYPE : Bindable.BindableType.SINGULAR_ATTRIBUTE;
            String guessedRoleName = this.determineRole(attribute);
            SessionFactoryImplementor sfi = (SessionFactoryImplementor)criteriaBuilder.getEntityManagerFactory().getSessionFactory();
            this.mapPersister = sfi.getCollectionPersister(guessedRoleName);
            if (this.mapPersister == null) {
                throw new IllegalStateException("Could not locate collection persister [" + guessedRoleName + "]");
            }
            this.mapKeyType = this.mapPersister.getIndexType();
            if (this.mapKeyType == null) {
                throw new IllegalStateException("Could not determine map-key type [" + guessedRoleName + "]");
            }
            this.persistentAttributeType = this.mapKeyType.isEntityType() ? Attribute.PersistentAttributeType.MANY_TO_ONE : (this.mapKeyType.isComponentType() ? Attribute.PersistentAttributeType.EMBEDDED : Attribute.PersistentAttributeType.BASIC);
        }

        private String determineRole(MapAttribute<?, K, ?> attribute) {
            return attribute.getDeclaringType().getJavaType().getName() + '.' + attribute.getName();
        }

        @Override
        public String getName() {
            return "map-key";
        }

        @Override
        public Attribute.PersistentAttributeType getPersistentAttributeType() {
            return this.persistentAttributeType;
        }

        @Override
        public ManagedType<Map<K, ?>> getDeclaringType() {
            return null;
        }

        @Override
        public Class<K> getJavaType() {
            return this.attribute.getKeyJavaType();
        }

        @Override
        public Member getJavaMember() {
            return null;
        }

        @Override
        public boolean isAssociation() {
            return this.mapKeyType.isEntityType();
        }

        @Override
        public boolean isCollection() {
            return false;
        }

        @Override
        public boolean isId() {
            return false;
        }

        @Override
        public boolean isVersion() {
            return false;
        }

        @Override
        public boolean isOptional() {
            return false;
        }

        @Override
        public Type<K> getType() {
            return this.jpaType;
        }

        @Override
        public Bindable.BindableType getBindableType() {
            return this.jpaBindableType;
        }

        @Override
        public Class<K> getBindableJavaType() {
            return this.jpaBinableJavaType;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class MapKeySource<K, V>
    extends AbstractPathImpl<Map<K, V>>
    implements PathImplementor<Map<K, V>>,
    Serializable {
        private final MapAttribute<?, K, V> mapAttribute;
        private final MapJoinImplementor<?, K, V> mapJoin;

        public MapKeySource(CriteriaBuilderImpl criteriaBuilder, Class<Map<K, V>> javaType, MapJoinImplementor<?, K, V> mapJoin, MapAttribute<?, K, V> attribute) {
            super(criteriaBuilder, javaType, null);
            this.mapJoin = mapJoin;
            this.mapAttribute = attribute;
        }

        public MapAttribute<?, K, V> getAttribute() {
            return this.mapAttribute;
        }

        @Override
        public Bindable<Map<K, V>> getModel() {
            return this.mapAttribute;
        }

        @Override
        public PathImplementor<?> getParentPath() {
            return (PathImplementor)this.mapJoin.getParentPath();
        }

        @Override
        protected boolean canBeDereferenced() {
            return false;
        }

        @Override
        protected Attribute locateAttributeInternal(String attributeName) {
            throw new IllegalArgumentException("Map [" + this.mapJoin.getPathIdentifier() + "] cannot be dereferenced");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class MapKeyPath<K>
    extends AbstractPathImpl<K>
    implements PathImplementor<K>,
    Serializable {
        private final MapKeyAttribute<K> mapKeyAttribute;

        public MapKeyPath(CriteriaBuilderImpl criteriaBuilder, MapKeySource<K, ?> source, MapKeyAttribute<K> mapKeyAttribute) {
            super(criteriaBuilder, mapKeyAttribute.getJavaType(), source);
            this.mapKeyAttribute = mapKeyAttribute;
        }

        @Override
        public MapKeySource getPathSource() {
            return (MapKeySource)super.getPathSource();
        }

        public MapKeyAttribute<K> getAttribute() {
            return this.mapKeyAttribute;
        }

        private boolean isBasicTypeKey() {
            return Attribute.PersistentAttributeType.BASIC == this.mapKeyAttribute.getPersistentAttributeType();
        }

        @Override
        protected boolean canBeDereferenced() {
            return !this.isBasicTypeKey();
        }

        @Override
        protected Attribute locateAttributeInternal(String attributeName) {
            if (!this.canBeDereferenced()) {
                throw new IllegalArgumentException("Map key [" + this.getPathSource().getPathIdentifier() + "] cannot be dereferenced");
            }
            throw new UnsupportedOperationException("Not yet supported!");
        }

        @Override
        public Bindable<K> getModel() {
            return this.mapKeyAttribute;
        }
    }
}

