/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.jpa.repository.support;

import java.util.Arrays;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import org.apache.openjpa.persistence.OpenJPAQuery;
import org.eclipse.persistence.jpa.JpaQuery;
import org.hibernate.ejb.HibernateQuery;
import org.springframework.data.jpa.repository.query.QueryExtractor;
import org.springframework.data.jpa.repository.utils.JpaClassUtils;
import org.springframework.util.Assert;

public enum PersistenceProvider implements QueryExtractor
{
    HIBERNATE(new String[]{"org.hibernate.jpa.HibernateEntityManager", "org.hibernate.ejb.HibernateEntityManager"}){

        @Override
        public String extractQueryString(Query query) {
            return ((HibernateQuery)query).getHibernateQuery().getQueryString();
        }

        @Override
        protected String getCountQueryPlaceholder() {
            return "*";
        }
    }
    ,
    ECLIPSELINK(new String[]{"org.eclipse.persistence.jpa.JpaEntityManager"}){

        @Override
        public String extractQueryString(Query query) {
            return ((JpaQuery)query).getDatabaseQuery().getJPQLString();
        }
    }
    ,
    OPEN_JPA(new String[]{"org.apache.openjpa.persistence.OpenJPAEntityManager"}){

        @Override
        public String extractQueryString(Query query) {
            return ((OpenJPAQuery)query).getQueryString();
        }
    }
    ,
    GENERIC_JPA(new String[]{"javax.persistence.EntityManager"}){

        @Override
        public String extractQueryString(Query query) {
            return null;
        }

        @Override
        public boolean canExtractQuery() {
            return false;
        }
    };

    private List<String> entityManagerClassNames;

    private PersistenceProvider(String ... entityManagerClassNames) {
        Assert.notEmpty(entityManagerClassNames, "EntityManagerClassNames must not be empty!");
        this.entityManagerClassNames = Arrays.asList(entityManagerClassNames);
    }

    public static PersistenceProvider fromEntityManager(EntityManager em) {
        Assert.notNull(em);
        for (PersistenceProvider provider : PersistenceProvider.values()) {
            for (String entityManagerClassName : provider.entityManagerClassNames) {
                if (!JpaClassUtils.isEntityManagerOfType(em, entityManagerClassName)) continue;
                return provider;
            }
        }
        return GENERIC_JPA;
    }

    @Override
    public boolean canExtractQuery() {
        return true;
    }

    protected String getCountQueryPlaceholder() {
        return "x";
    }

    static interface Constants {
        public static final String GENERIC_JPA_ENTITY_MANAGER_INTERFACE = "javax.persistence.EntityManager";
        public static final String OPENJPA_ENTITY_MANAGER_INTERFACE = "org.apache.openjpa.persistence.OpenJPAEntityManager";
        public static final String ECLIPSELINK_ENTITY_MANAGER_INTERFACE = "org.eclipse.persistence.jpa.JpaEntityManager";
        public static final String HIBERNATE_ENTITY_MANAGER_INTERFACE = "org.hibernate.ejb.HibernateEntityManager";
        public static final String HIBERNATE43_ENTITY_MANAGER_INTERFACE = "org.hibernate.jpa.HibernateEntityManager";
    }
}

