/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.jdbc.core.namedparam;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.springframework.dao.InvalidDataAccessApiUsageException;
import org.springframework.jdbc.core.SqlParameter;
import org.springframework.jdbc.core.SqlParameterValue;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;
import org.springframework.jdbc.core.namedparam.ParsedSql;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;
import org.springframework.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class NamedParameterUtils {
    private static final char[] PARAMETER_SEPARATORS = new char[]{'\"', '\'', ':', '&', ',', ';', '(', ')', '|', '=', '+', '-', '*', '%', '/', '\\', '<', '>', '^'};
    private static final String[] START_SKIP = new String[]{"'", "\"", "--", "/*"};
    private static final String[] STOP_SKIP = new String[]{"'", "\"", "\n", "*/"};

    /*
     * Unable to fully structure code
     */
    public static ParsedSql parseSqlStatement(String sql) {
        Assert.notNull(sql, "SQL must not be null");
        namedParameters = new HashSet<String>();
        sqlToUse = sql;
        parameterList = new ArrayList<ParameterHolder>();
        statement = sql.toCharArray();
        namedParameterCount = 0;
        unnamedParameterCount = 0;
        totalParameterCount = 0;
        escapes = 0;
        i = 0;
        while (i < statement.length) {
            block13: {
                block11: {
                    block12: {
                        skipToPosition = i;
                        while (i < statement.length) {
                            skipToPosition = NamedParameterUtils.skipCommentsAndQuotes(statement, i);
                            if (i == skipToPosition) break;
                            i = skipToPosition;
                        }
                        if (i >= statement.length) break;
                        c = statement[i];
                        if (c != ':' && c != '&') break block11;
                        j = i + 1;
                        if (j < statement.length && statement[j] == ':' && c == ':') {
                            i += 2;
                            continue;
                        }
                        parameter = null;
                        if (j >= statement.length || c != ':' || statement[j] != '{') ** GOTO lbl39
                        while (j < statement.length && '}' != statement[j]) {
                            if (':' != statement[++j] && '{' != statement[j]) continue;
                            throw new InvalidDataAccessApiUsageException("Parameter name contains invalid character '" + statement[j] + "' at position " + i + " in statement " + sql);
                        }
                        if (j >= statement.length) {
                            throw new InvalidDataAccessApiUsageException("Non-terminated named parameter declaration at position " + i + " in statement " + sql);
                        }
                        if (j - i > 3) {
                            parameter = sql.substring(i + 2, j);
                            namedParameterCount = NamedParameterUtils.addNewNamedParameter(namedParameters, namedParameterCount, parameter);
                            totalParameterCount = NamedParameterUtils.addNamedParameter(parameterList, totalParameterCount, escapes, i, j + 1, parameter);
                        }
                        ++j;
                        break block12;
lbl-1000:
                        // 1 sources

                        {
                            ++j;
lbl39:
                            // 2 sources

                            ** while (j < statement.length && !NamedParameterUtils.isParameterSeparator((char)statement[j]))
                        }
lbl40:
                        // 1 sources

                        if (j - i > 1) {
                            parameter = sql.substring(i + 1, j);
                            namedParameterCount = NamedParameterUtils.addNewNamedParameter(namedParameters, namedParameterCount, parameter);
                            totalParameterCount = NamedParameterUtils.addNamedParameter(parameterList, totalParameterCount, escapes, i, j, parameter);
                        }
                    }
                    i = j - 1;
                    break block13;
                }
                if (c == '\\' && (j = i + 1) < statement.length && statement[j] == ':') {
                    sqlToUse = String.valueOf(sqlToUse.substring(0, i - escapes)) + sqlToUse.substring(i - escapes + 1);
                    ++escapes;
                    i += 2;
                    continue;
                }
                if (c == '?') {
                    ++unnamedParameterCount;
                    ++totalParameterCount;
                }
            }
            ++i;
        }
        parsedSql = new ParsedSql(sqlToUse);
        for (ParameterHolder ph : parameterList) {
            parsedSql.addNamedParameter(ph.getParameterName(), ph.getStartIndex(), ph.getEndIndex());
        }
        parsedSql.setNamedParameterCount(namedParameterCount);
        parsedSql.setUnnamedParameterCount(unnamedParameterCount);
        parsedSql.setTotalParameterCount(totalParameterCount);
        return parsedSql;
    }

    private static int addNamedParameter(List<ParameterHolder> parameterList, int totalParameterCount, int escapes, int i, int j, String parameter) {
        parameterList.add(new ParameterHolder(parameter, i - escapes, j - escapes));
        return ++totalParameterCount;
    }

    private static int addNewNamedParameter(Set<String> namedParameters, int namedParameterCount, String parameter) {
        if (!namedParameters.contains(parameter)) {
            namedParameters.add(parameter);
            ++namedParameterCount;
        }
        return namedParameterCount;
    }

    private static int skipCommentsAndQuotes(char[] statement, int position) {
        int i = 0;
        while (i < START_SKIP.length) {
            if (statement[position] == START_SKIP[i].charAt(0)) {
                boolean match2 = true;
                int j = 1;
                while (j < START_SKIP[i].length()) {
                    if (statement[position + j] != START_SKIP[i].charAt(j)) {
                        match2 = false;
                        break;
                    }
                    ++j;
                }
                if (match2) {
                    int offset = START_SKIP[i].length();
                    int m = position + offset;
                    while (m < statement.length) {
                        if (statement[m] == STOP_SKIP[i].charAt(0)) {
                            boolean endMatch = true;
                            int endPos = m;
                            int n = 1;
                            while (n < STOP_SKIP[i].length()) {
                                if (m + n >= statement.length) {
                                    return statement.length;
                                }
                                if (statement[m + n] != STOP_SKIP[i].charAt(n)) {
                                    endMatch = false;
                                    break;
                                }
                                endPos = m + n;
                                ++n;
                            }
                            if (endMatch) {
                                return endPos + 1;
                            }
                        }
                        ++m;
                    }
                    return statement.length;
                }
            }
            ++i;
        }
        return position;
    }

    public static String substituteNamedParameters(ParsedSql parsedSql, SqlParameterSource paramSource) {
        String originalSql = parsedSql.getOriginalSql();
        StringBuilder actualSql = new StringBuilder();
        List<String> paramNames = parsedSql.getParameterNames();
        int lastIndex = 0;
        int i = 0;
        while (i < paramNames.size()) {
            String paramName = paramNames.get(i);
            int[] indexes = parsedSql.getParameterIndexes(i);
            int startIndex = indexes[0];
            int endIndex = indexes[1];
            actualSql.append(originalSql.substring(lastIndex, startIndex));
            if (paramSource != null && paramSource.hasValue(paramName)) {
                Object value = paramSource.getValue(paramName);
                if (value instanceof SqlParameterValue) {
                    value = ((SqlParameterValue)value).getValue();
                }
                if (value instanceof Collection) {
                    Iterator entryIter = ((Collection)value).iterator();
                    int k = 0;
                    while (entryIter.hasNext()) {
                        if (k > 0) {
                            actualSql.append(", ");
                        }
                        ++k;
                        Object entryItem = entryIter.next();
                        if (entryItem instanceof Object[]) {
                            Object[] expressionList = (Object[])entryItem;
                            actualSql.append("(");
                            int m = 0;
                            while (m < expressionList.length) {
                                if (m > 0) {
                                    actualSql.append(", ");
                                }
                                actualSql.append("?");
                                ++m;
                            }
                            actualSql.append(")");
                            continue;
                        }
                        actualSql.append("?");
                    }
                } else {
                    actualSql.append("?");
                }
            } else {
                actualSql.append("?");
            }
            lastIndex = endIndex;
            ++i;
        }
        actualSql.append(originalSql.substring(lastIndex, originalSql.length()));
        return actualSql.toString();
    }

    public static Object[] buildValueArray(ParsedSql parsedSql, SqlParameterSource paramSource, List<SqlParameter> declaredParams) {
        Object[] paramArray = new Object[parsedSql.getTotalParameterCount()];
        if (parsedSql.getNamedParameterCount() > 0 && parsedSql.getUnnamedParameterCount() > 0) {
            throw new InvalidDataAccessApiUsageException("You can't mix named and traditional ? placeholders. You have " + parsedSql.getNamedParameterCount() + " named parameter(s) and " + parsedSql.getUnnamedParameterCount() + " traditonal placeholder(s) in [" + parsedSql.getOriginalSql() + "]");
        }
        List<String> paramNames = parsedSql.getParameterNames();
        int i = 0;
        while (i < paramNames.size()) {
            String paramName = paramNames.get(i);
            try {
                Object value = paramSource.getValue(paramName);
                SqlParameter param = NamedParameterUtils.findParameter(declaredParams, paramName, i);
                paramArray[i] = param != null ? new SqlParameterValue(param, value) : value;
            }
            catch (IllegalArgumentException ex) {
                throw new InvalidDataAccessApiUsageException("No value supplied for the SQL parameter '" + paramName + "': " + ex.getMessage());
            }
            ++i;
        }
        return paramArray;
    }

    private static SqlParameter findParameter(List<SqlParameter> declaredParams, String paramName, int paramIndex) {
        if (declaredParams != null) {
            SqlParameter declaredParam2;
            for (SqlParameter declaredParam2 : declaredParams) {
                if (!paramName.equals(declaredParam2.getName())) continue;
                return declaredParam2;
            }
            if (paramIndex < declaredParams.size() && (declaredParam2 = declaredParams.get(paramIndex)).getName() == null) {
                return declaredParam2;
            }
        }
        return null;
    }

    private static boolean isParameterSeparator(char c) {
        if (Character.isWhitespace(c)) {
            return true;
        }
        char[] cArray = PARAMETER_SEPARATORS;
        int n = PARAMETER_SEPARATORS.length;
        int n2 = 0;
        while (n2 < n) {
            char separator = cArray[n2];
            if (c == separator) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public static int[] buildSqlTypeArray(ParsedSql parsedSql, SqlParameterSource paramSource) {
        int[] sqlTypes = new int[parsedSql.getTotalParameterCount()];
        List<String> paramNames = parsedSql.getParameterNames();
        int i = 0;
        while (i < paramNames.size()) {
            String paramName = paramNames.get(i);
            sqlTypes[i] = paramSource.getSqlType(paramName);
            ++i;
        }
        return sqlTypes;
    }

    public static List<SqlParameter> buildSqlParameterList(ParsedSql parsedSql, SqlParameterSource paramSource) {
        List<String> paramNames = parsedSql.getParameterNames();
        LinkedList<SqlParameter> params = new LinkedList<SqlParameter>();
        for (String paramName : paramNames) {
            SqlParameter param = new SqlParameter(paramName, paramSource.getSqlType(paramName), paramSource.getTypeName(paramName));
            params.add(param);
        }
        return params;
    }

    public static String parseSqlStatementIntoString(String sql) {
        ParsedSql parsedSql = NamedParameterUtils.parseSqlStatement(sql);
        return NamedParameterUtils.substituteNamedParameters(parsedSql, null);
    }

    public static String substituteNamedParameters(String sql, SqlParameterSource paramSource) {
        ParsedSql parsedSql = NamedParameterUtils.parseSqlStatement(sql);
        return NamedParameterUtils.substituteNamedParameters(parsedSql, paramSource);
    }

    public static Object[] buildValueArray(String sql, Map<String, ?> paramMap) {
        ParsedSql parsedSql = NamedParameterUtils.parseSqlStatement(sql);
        return NamedParameterUtils.buildValueArray(parsedSql, new MapSqlParameterSource(paramMap), null);
    }

    private static class ParameterHolder {
        private String parameterName;
        private int startIndex;
        private int endIndex;

        public ParameterHolder(String parameterName, int startIndex, int endIndex) {
            this.parameterName = parameterName;
            this.startIndex = startIndex;
            this.endIndex = endIndex;
        }

        public String getParameterName() {
            return this.parameterName;
        }

        public int getStartIndex() {
            return this.startIndex;
        }

        public int getEndIndex() {
            return this.endIndex;
        }
    }
}

