/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.test.jdbc;

import java.io.IOException;
import java.io.LineNumberReader;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.core.io.support.EncodedResource;
import org.springframework.dao.DataAccessException;
import org.springframework.dao.DataAccessResourceFailureException;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JdbcTestUtils {
    private static final Log logger = LogFactory.getLog(JdbcTestUtils.class);
    private static final String DEFAULT_COMMENT_PREFIX = "--";
    private static final char DEFAULT_STATEMENT_SEPARATOR = ';';

    public static int countRowsInTable(JdbcTemplate jdbcTemplate, String tableName) {
        return jdbcTemplate.queryForInt("SELECT COUNT(0) FROM " + tableName);
    }

    public static int countRowsInTableWhere(JdbcTemplate jdbcTemplate, String tableName, String whereClause) {
        String sql = "SELECT COUNT(0) FROM " + tableName;
        if (StringUtils.hasText(whereClause)) {
            sql = String.valueOf(sql) + " WHERE " + whereClause;
        }
        return jdbcTemplate.queryForInt(sql);
    }

    public static int deleteFromTables(JdbcTemplate jdbcTemplate, String ... tableNames) {
        int totalRowCount = 0;
        String[] stringArray = tableNames;
        int n = tableNames.length;
        int n2 = 0;
        while (n2 < n) {
            String tableName = stringArray[n2];
            int rowCount = jdbcTemplate.update("DELETE FROM " + tableName);
            totalRowCount += rowCount;
            if (logger.isInfoEnabled()) {
                logger.info("Deleted " + rowCount + " rows from table " + tableName);
            }
            ++n2;
        }
        return totalRowCount;
    }

    public static void dropTables(JdbcTemplate jdbcTemplate, String ... tableNames) {
        String[] stringArray = tableNames;
        int n = tableNames.length;
        int n2 = 0;
        while (n2 < n) {
            String tableName = stringArray[n2];
            jdbcTemplate.execute("DROP TABLE " + tableName);
            if (logger.isInfoEnabled()) {
                logger.info("Dropped table " + tableName);
            }
            ++n2;
        }
    }

    public static void executeSqlScript(JdbcTemplate jdbcTemplate, ResourceLoader resourceLoader, String sqlResourcePath, boolean continueOnError) throws DataAccessException {
        Resource resource = resourceLoader.getResource(sqlResourcePath);
        JdbcTestUtils.executeSqlScript(jdbcTemplate, resource, continueOnError);
    }

    public static void executeSqlScript(JdbcTemplate jdbcTemplate, Resource resource, boolean continueOnError) throws DataAccessException {
        JdbcTestUtils.executeSqlScript(jdbcTemplate, new EncodedResource(resource), continueOnError);
    }

    public static void executeSqlScript(JdbcTemplate jdbcTemplate, EncodedResource resource, boolean continueOnError) throws DataAccessException {
        if (logger.isInfoEnabled()) {
            logger.info("Executing SQL script from " + resource);
        }
        long startTime = System.currentTimeMillis();
        LinkedList<String> statements = new LinkedList<String>();
        LineNumberReader reader = null;
        try {
            try {
                reader = new LineNumberReader(resource.getReader());
                String script = JdbcTestUtils.readScript(reader);
                char delimiter = ';';
                if (!JdbcTestUtils.containsSqlScriptDelimiters(script, delimiter)) {
                    delimiter = '\n';
                }
                JdbcTestUtils.splitSqlScript(script, delimiter, statements);
                int lineNumber = 0;
                for (String statement : statements) {
                    ++lineNumber;
                    try {
                        int rowsAffected = jdbcTemplate.update(statement);
                        if (!logger.isDebugEnabled()) continue;
                        logger.debug(String.valueOf(rowsAffected) + " rows affected by SQL: " + statement);
                    }
                    catch (DataAccessException ex) {
                        if (continueOnError) {
                            if (!logger.isWarnEnabled()) continue;
                            logger.warn("Failed to execute SQL script statement at line " + lineNumber + " of resource " + resource + ": " + statement, ex);
                            continue;
                        }
                        throw ex;
                    }
                }
                long elapsedTime = System.currentTimeMillis() - startTime;
                if (logger.isInfoEnabled()) {
                    logger.info(String.format("Executed SQL script from %s in %s ms.", resource, elapsedTime));
                }
            }
            catch (IOException ex) {
                throw new DataAccessResourceFailureException("Failed to open SQL script from " + resource, ex);
            }
        }
        catch (Throwable throwable) {
            try {
                if (reader != null) {
                    reader.close();
                }
            }
            catch (IOException iOException) {}
            throw throwable;
        }
        try {
            if (reader != null) {
                reader.close();
            }
        }
        catch (IOException iOException) {}
    }

    public static String readScript(LineNumberReader lineNumberReader) throws IOException {
        return JdbcTestUtils.readScript(lineNumberReader, DEFAULT_COMMENT_PREFIX);
    }

    public static String readScript(LineNumberReader lineNumberReader, String commentPrefix) throws IOException {
        String currentStatement = lineNumberReader.readLine();
        StringBuilder scriptBuilder = new StringBuilder();
        while (currentStatement != null) {
            if (StringUtils.hasText(currentStatement) && commentPrefix != null && !currentStatement.startsWith(commentPrefix)) {
                if (scriptBuilder.length() > 0) {
                    scriptBuilder.append('\n');
                }
                scriptBuilder.append(currentStatement);
            }
            currentStatement = lineNumberReader.readLine();
        }
        return scriptBuilder.toString();
    }

    public static boolean containsSqlScriptDelimiters(String script, char delim) {
        boolean inLiteral = false;
        char[] content = script.toCharArray();
        int i = 0;
        while (i < script.length()) {
            if (content[i] == '\'') {
                boolean bl = inLiteral = !inLiteral;
            }
            if (content[i] == delim && !inLiteral) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static void splitSqlScript(String script, char delim, List<String> statements) {
        JdbcTestUtils.splitSqlScript(script, "" + delim, statements);
    }

    /*
     * Unable to fully structure code
     */
    private static void splitSqlScript(String script, String delim, List<String> statements) {
        sb = new StringBuilder();
        inLiteral = false;
        inEscape = false;
        content = script.toCharArray();
        i = 0;
        while (i < script.length()) {
            block8: {
                block9: {
                    block7: {
                        c = content[i];
                        if (!inEscape) break block7;
                        inEscape = false;
                        sb.append((char)c);
                        break block8;
                    }
                    if (c != 92) break block9;
                    inEscape = true;
                    sb.append((char)c);
                    break block8;
                }
                if (c == 39) {
                    v0 = inLiteral = inLiteral == false;
                }
                if (inLiteral) ** GOTO lbl32
                if (JdbcTestUtils.startsWithDelimiter(script, i, delim)) {
                    if (sb.length() > 0) {
                        statements.add(sb.toString());
                        sb = new StringBuilder();
                    }
                    i += delim.length() - 1;
                } else {
                    if (c == 10 || c == 9) {
                        c = 32;
                    }
lbl32:
                    // 4 sources

                    sb.append((char)c);
                }
            }
            ++i;
        }
        if (StringUtils.hasText(sb)) {
            statements.add(sb.toString());
        }
    }

    private static boolean startsWithDelimiter(String source, int startIndex, String delim) {
        int endIndex = startIndex + delim.length();
        if (source.length() < endIndex) {
            return false;
        }
        return source.substring(startIndex, endIndex).equals(delim);
    }
}

