/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.examples;

import com.hazelcast.core.Hazelcast;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.IMap;
import com.hazelcast.util.Clock;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.logging.Level;
import java.util.logging.Logger;

public class LongRunningTest {
    private static final int STATS_SECONDS = 10;
    private List<TheNode> nodes = new CopyOnWriteArrayList<TheNode>();
    private int nodeIdGen = 0;
    private final Logger logger = Logger.getLogger(LongRunningTest.class.getName());
    private int starts;
    private int stops;
    private int restarts = 0;

    public static void main(String[] args) {
        LongRunningTest t = new LongRunningTest();
        t.run();
    }

    public void run() {
        Runtime.getRuntime().addShutdownHook(new Thread(){

            public void run() {
                LongRunningTest.this.log("Shutting down " + LongRunningTest.this.nodes.size());
                while (LongRunningTest.this.nodes.size() > 0) {
                    LongRunningTest.this.removeNode();
                }
            }
        });
        while (true) {
            if (this.nodes.size() > 4) {
                this.removeNode();
            } else if (this.nodes.size() == 0) {
                this.addNode();
                this.addNode();
                this.addNode();
            } else if (this.nodes.size() < 2) {
                this.addNode();
            } else {
                int action = this.random(3);
                switch (action) {
                    case 0: {
                        this.removeNode();
                        break;
                    }
                    case 1: {
                        this.addNode();
                        break;
                    }
                    case 2: {
                        this.restartNode();
                    }
                }
            }
            try {
                int nextSeconds = this.random(60, 260);
                this.log("Next Action after " + nextSeconds + " seconds.");
                this.log("members:" + this.nodes.size() + ", starts: " + this.starts + ", stops:" + this.stops + ", restart:" + this.restarts);
                Thread.sleep(nextSeconds * 1000);
            }
            catch (InterruptedException interruptedException) {
            }
        }
    }

    void log(Object obj) {
        this.logger.log(Level.INFO, "LRT-" + obj);
    }

    void addNode() {
        ++this.starts;
        int entryCount = this.random(10000);
        int threadCount = this.random(10, 50);
        int valueSizeMax = entryCount < 1000 ? 50000 : 1000;
        int valueSize = this.random(10, valueSizeMax);
        TheNode node = new TheNode(this.nodeIdGen++, entryCount, threadCount, valueSize);
        this.nodes.add(node);
        node.start();
        this.log("Started " + node);
    }

    void restartNode() {
        ++this.restarts;
        this.log("Restarting...");
        this.removeNode();
        try {
            Thread.sleep(this.random(10) * 1000);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.addNode();
    }

    void removeNode() {
        ++this.stops;
        TheNode node = this.nodes.remove(this.random(this.nodes.size()));
        node.stop();
        this.log("Stopped " + node);
    }

    int random(int length) {
        return (int)(Math.random() * 1.0E7) % length;
    }

    int random(int from, int to) {
        double diff = to - from;
        return (int)(diff * Math.random() + (double)from);
    }

    class Stats {
        public AtomicLong mapPuts = new AtomicLong();
        public AtomicLong mapGets = new AtomicLong();
        public AtomicLong mapRemoves = new AtomicLong();

        Stats() {
        }

        public Stats getAndReset() {
            long mapPutsNow = this.mapPuts.getAndSet(0L);
            long mapGetsNow = this.mapGets.getAndSet(0L);
            long mapRemovesNow = this.mapRemoves.getAndSet(0L);
            Stats newOne = new Stats();
            newOne.mapPuts.set(mapPutsNow);
            newOne.mapGets.set(mapGetsNow);
            newOne.mapRemoves.set(mapRemovesNow);
            return newOne;
        }

        public long total() {
            return this.mapPuts.get() + this.mapGets.get() + this.mapRemoves.get();
        }

        public String toString() {
            return "total= " + this.total() + ", puts:" + this.mapPuts.get() + ", gets:" + this.mapGets.get() + ", remove:" + this.mapRemoves.get();
        }
    }

    class TheNode {
        final int entryCount;
        final int threadCount;
        final int valueSize;
        final int nodeId;
        final long createTime;
        final ExecutorService es;
        final ExecutorService esStats;
        final HazelcastInstance hazelcast;
        volatile boolean running = true;

        TheNode(int nodeId, int entryCount, int threadCount, int valueSize) {
            this.entryCount = entryCount;
            this.threadCount = threadCount;
            this.valueSize = valueSize;
            this.nodeId = nodeId;
            this.es = Executors.newFixedThreadPool(threadCount);
            this.hazelcast = Hazelcast.newHazelcastInstance(null);
            this.esStats = Executors.newSingleThreadExecutor();
            this.createTime = Clock.currentTimeMillis();
        }

        public void stop() {
            try {
                this.running = false;
                this.es.shutdown();
                this.es.awaitTermination(10L, TimeUnit.SECONDS);
                this.esStats.shutdown();
                this.hazelcast.shutdown();
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }

        public void start() {
            final Stats stats = new Stats();
            for (int i = 0; i < this.threadCount; ++i) {
                this.es.submit(new Runnable(){

                    public void run() {
                        IMap<String, byte[]> map = TheNode.this.hazelcast.getMap("default");
                        while (TheNode.this.running) {
                            try {
                                int key = (int)(Math.random() * (double)TheNode.this.entryCount);
                                int operation = (int)(Math.random() * 100.0) % 10;
                                if (operation < 4) {
                                    map.put(String.valueOf(key), new byte[TheNode.this.valueSize]);
                                    stats.mapPuts.incrementAndGet();
                                    continue;
                                }
                                if (operation < 8) {
                                    map.get(String.valueOf(key));
                                    stats.mapGets.incrementAndGet();
                                    continue;
                                }
                                map.remove(String.valueOf(key));
                                stats.mapRemoves.incrementAndGet();
                            }
                            catch (Throwable throwable) {}
                        }
                    }
                });
            }
            this.esStats.submit(new Runnable(){

                public void run() {
                    while (TheNode.this.running) {
                        try {
                            Thread.sleep(10000L);
                            int clusterSize = TheNode.this.hazelcast.getCluster().getMembers().size();
                            Stats currentStats = stats.getAndReset();
                            LongRunningTest.this.log("Cluster size: " + clusterSize + ", Operations per Second: " + currentStats.total() / 10L);
                        }
                        catch (Exception e2) {
                            e2.printStackTrace();
                        }
                    }
                }
            });
        }

        public String toString() {
            return "TheNode{nodeId=" + this.nodeId + ", entryCount=" + this.entryCount + ", threadCount=" + this.threadCount + ", valueSize=" + this.valueSize + ", liveSeconds=" + (Clock.currentTimeMillis() - this.createTime) / 1000L + ", running=" + this.running + '}';
        }
    }
}

