/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.impl.management;

import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.HazelcastInstanceAware;
import com.hazelcast.logging.ILogger;
import com.hazelcast.logging.Logger;
import com.hazelcast.nio.DataSerializable;
import com.hazelcast.nio.SerializationHelper;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.logging.Level;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ScriptExecutorCallable<V>
implements DataSerializable,
Callable<V>,
HazelcastInstanceAware {
    private static final long serialVersionUID = -4729129143589252665L;
    private static final ILogger logger = Logger.getLogger(ScriptExecutorCallable.class.getName());
    private static final String SCRIPT_ENGINE_MANAGER_CLASS = "javax.script.ScriptEngineManager";
    private static final Object scriptEngineManager;
    private static final Method mGetEngineByName;
    private static final Exception scriptEngineLoadError;
    private String engineName;
    private String script;
    private Map<String, Object> bindings;
    private transient HazelcastInstance hazelcast;

    public ScriptExecutorCallable() {
    }

    public ScriptExecutorCallable(String engineName, String script) {
        this.engineName = engineName;
        this.script = script;
    }

    public ScriptExecutorCallable(String engineName, String script, Map<String, Object> bindings2) {
        this.engineName = engineName;
        this.script = script;
        this.bindings = bindings2;
    }

    @Override
    public V call() throws Exception {
        if (scriptEngineLoadError != null) {
            throw new ExecutionException("ScriptEngineManager could not be loaded!", scriptEngineLoadError);
        }
        Object engine = mGetEngineByName.invoke(scriptEngineManager, this.engineName);
        if (engine == null) {
            throw new IllegalArgumentException("Could not find ScriptEngine named '" + this.engineName + "'.");
        }
        Method put = engine.getClass().getMethod("put", String.class, Object.class);
        put.invoke(engine, "hazelcast", this.hazelcast);
        if (this.bindings != null) {
            Set<Map.Entry<String, Object>> entries = this.bindings.entrySet();
            for (Map.Entry<String, Object> entry : entries) {
                put.invoke(engine, entry.getKey(), entry.getValue());
            }
        }
        Method eval2 = engine.getClass().getMethod("eval", String.class);
        Object result = eval2.invoke(engine, this.script);
        if (result == null) {
            return null;
        }
        return (V)result;
    }

    @Override
    public void writeData(DataOutput out) throws IOException {
        out.writeUTF(this.engineName);
        out.writeUTF(this.script);
        if (this.bindings != null) {
            out.writeInt(this.bindings.size());
            Set<Map.Entry<String, Object>> entries = this.bindings.entrySet();
            for (Map.Entry<String, Object> entry : entries) {
                out.writeUTF(entry.getKey());
                SerializationHelper.writeObject(out, entry.getValue());
            }
        } else {
            out.writeInt(0);
        }
    }

    @Override
    public void readData(DataInput in) throws IOException {
        this.engineName = in.readUTF();
        this.script = in.readUTF();
        int size = in.readInt();
        if (size > 0) {
            this.bindings = new HashMap<String, Object>(size);
            for (int i = 0; i < size; ++i) {
                String key = in.readUTF();
                Object value = SerializationHelper.readObject(in);
                this.bindings.put(key, value);
            }
        }
    }

    @Override
    public void setHazelcastInstance(HazelcastInstance hazelcastInstance) {
        this.hazelcast = hazelcastInstance;
    }

    public void setBindings(Map<String, Object> bindings2) {
        this.bindings = bindings2;
    }

    static {
        Object manager = null;
        Method method = null;
        Exception error = null;
        try {
            Class<?> scriptEngineManagerClass = Class.forName(SCRIPT_ENGINE_MANAGER_CLASS);
            manager = scriptEngineManagerClass.newInstance();
            method = scriptEngineManagerClass.getMethod("getEngineByName", String.class);
        }
        catch (Exception e2) {
            error = e2;
            logger.log(Level.WARNING, "ScriptEngineManager could not be loaded!", e2);
        }
        scriptEngineManager = manager;
        mGetEngineByName = method;
        scriptEngineLoadError = error;
    }
}

