/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.spring.cache;

import com.hazelcast.core.IMap;
import com.hazelcast.nio.DataSerializable;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.concurrent.TimeUnit;
import org.springframework.cache.Cache;
import org.springframework.cache.support.SimpleValueWrapper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HazelcastCache
implements Cache {
    private static final DataSerializable NULL = new NullDataSerializable();
    private final IMap<Object, Object> map;

    public HazelcastCache(IMap<Object, Object> map) {
        this.map = map;
    }

    @Override
    public String getName() {
        return this.map.getName();
    }

    @Override
    public Object getNativeCache() {
        return this.map;
    }

    @Override
    public Cache.ValueWrapper get(Object key) {
        if (key == null) {
            return null;
        }
        Object value = this.map.get(key);
        return value != null ? new SimpleValueWrapper(this.fromStoreValue(value)) : null;
    }

    @Override
    public void put(Object key, Object value) {
        if (key != null) {
            this.map.set(key, this.toStoreValue(value), 0L, TimeUnit.SECONDS);
        }
    }

    protected Object toStoreValue(Object value) {
        if (value == null) {
            return NULL;
        }
        return value;
    }

    protected Object fromStoreValue(Object value) {
        if (NULL.equals(value)) {
            return null;
        }
        return value;
    }

    @Override
    public void evict(Object key) {
        if (key != null) {
            this.map.evict(key);
        }
    }

    @Override
    public void clear() {
        this.map.clear();
    }

    static final class NullDataSerializable
    implements DataSerializable {
        NullDataSerializable() {
        }

        public void writeData(DataOutput out) throws IOException {
        }

        public void readData(DataInput in) throws IOException {
        }

        public boolean equals(Object obj) {
            return obj != null && obj.getClass() == this.getClass();
        }

        public int hashCode() {
            return 0;
        }
    }
}

