/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.spring.mongodb;

import com.hazelcast.spring.mongodb.MongoDBConverter;
import com.hazelcast.spring.mongodb.ValueWrapper;
import com.mongodb.BasicDBObject;
import com.mongodb.DBObject;
import com.mongodb.Mongo;
import java.util.Date;
import java.util.UUID;
import java.util.regex.Pattern;
import org.bson.BSONObject;
import org.bson.types.ObjectId;
import org.springframework.data.mongodb.core.MongoTemplate;

public class SpringMongoDBConverter
implements MongoDBConverter {
    private MongoTemplate mongoTemplate;

    public SpringMongoDBConverter(Mongo mongo, String dbname) {
        this.mongoTemplate = new MongoTemplate(mongo, dbname);
    }

    public SpringMongoDBConverter(MongoTemplate mongoTemplate) {
        this.mongoTemplate = mongoTemplate;
    }

    public DBObject toDBObject(Object obj) {
        BasicDBObject dbObject = new BasicDBObject();
        if (SpringMongoDBConverter.isStandardClass(obj.getClass())) {
            obj = new ValueWrapper(obj);
        }
        this.mongoTemplate.getConverter().write(obj, (Object)dbObject);
        return dbObject;
    }

    public Object toObject(Class clazz, DBObject dbObject) {
        if (clazz.equals(ValueWrapper.class)) {
            return dbObject.get("value");
        }
        return this.mongoTemplate.getConverter().read(clazz, (Object)dbObject);
    }

    public static boolean isStandardClass(Class clazz) {
        if (clazz.isAssignableFrom(Date.class)) {
            return true;
        }
        if (clazz.isAssignableFrom(Number.class)) {
            return true;
        }
        if (clazz.isAssignableFrom(String.class)) {
            return true;
        }
        if (clazz.isAssignableFrom(ObjectId.class)) {
            return true;
        }
        if (clazz.isAssignableFrom(BSONObject.class)) {
            return true;
        }
        if (clazz.isAssignableFrom(Boolean.class)) {
            return true;
        }
        if (clazz.isAssignableFrom(Double.class)) {
            return true;
        }
        if (clazz.isAssignableFrom(Integer.class)) {
            return true;
        }
        if (clazz.isAssignableFrom(Long.class)) {
            return true;
        }
        if (clazz.isAssignableFrom(Pattern.class)) {
            return true;
        }
        return clazz.isAssignableFrom(UUID.class);
    }
}

