/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.query;

import com.hp.hpl.jena.sparql.ARQConstants;
import com.hp.hpl.jena.sparql.SystemARQ;
import com.hp.hpl.jena.sparql.engine.http.Service;
import com.hp.hpl.jena.sparql.engine.main.StageBuilder;
import com.hp.hpl.jena.sparql.lib.Metadata;
import com.hp.hpl.jena.sparql.mgt.ARQMgt;
import com.hp.hpl.jena.sparql.mgt.Explain;
import com.hp.hpl.jena.sparql.mgt.SystemInfo;
import com.hp.hpl.jena.sparql.util.Context;
import com.hp.hpl.jena.sparql.util.MappingRegistry;
import com.hp.hpl.jena.sparql.util.Symbol;
import org.apache.jena.riot.RIOT;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ARQ {
    public static final String logExecName = "com.hp.hpl.jena.arq.exec";
    public static final String logInfoName = "com.hp.hpl.jena.arq.info";
    public static final String logHttpRequestName = "com.hp.hpl.jena.arq.service";
    private static final Logger logExec = LoggerFactory.getLogger("com.hp.hpl.jena.arq.exec");
    private static final Logger logInfo = LoggerFactory.getLogger("com.hp.hpl.jena.arq.info");
    private static final Logger logHttpRequest = LoggerFactory.getLogger("com.hp.hpl.jena.arq.service");
    public static final Symbol symLogExec = ARQConstants.allocSymbol("logExec");
    public static final String arqIRI = "http://jena.hpl.hp.com/#arq";
    public static final String arqParamNS = "http://jena.hpl.hp.com/ARQ#";
    public static final String arqSymbolPrefix = "arq";
    public static final Symbol strictSPARQL = ARQConstants.allocSymbol("strictSPARQL");
    public static final Symbol constantBNodeLabels = ARQConstants.allocSymbol("constantBNodeLabels");
    public static final Symbol enablePropertyFunctions = ARQConstants.allocSymbol("enablePropertyFunctions");
    public static final Symbol enableExecutionTimeLogging = ARQConstants.allocSymbol("enableExecutionTimeLogging");
    public static final Symbol outputGraphBNodeLabels = ARQConstants.allocSymbol("outputGraphBNodeLabels");
    public static final Symbol inputGraphBNodeLabels = ARQConstants.allocSymbol("inputGraphBNodeLabels");
    public static final Symbol queryTimeout = ARQConstants.allocSymbol("queryTimeout");
    public static final Symbol stageGenerator = ARQConstants.allocSymbol("stageGenerator");
    public static final Symbol hideNonDistiguishedVariables = ARQConstants.allocSymbol("hideNonDistiguishedVariables");
    public static final Symbol useSAX = ARQConstants.allocSymbol("useSAX");
    public static final boolean allowDuplicateSelectColumns = false;
    public static final Symbol regexImpl = ARQConstants.allocSymbol("regexImpl");
    public static final Symbol javaRegex = ARQConstants.allocSymbol("javaRegex");
    public static final Symbol xercesRegex = ARQConstants.allocSymbol("xercesRegex");
    public static final Symbol serviceParams = ARQConstants.allocSymbol("serviceParams");
    public static final Symbol serviceAllowed = Service.serviceAllowed;
    public static final Symbol spillToDiskThreshold = ARQConstants.allocSymbol("spillToDiskThreshold");
    public static final Symbol optimization = ARQConstants.allocSymbol("optimization");
    public static final Symbol optPathFlatten = ARQConstants.allocSymbol("optPathFlatten");
    public static final Symbol optFilterPlacement = ARQConstants.allocSymbol("optFilterPlacement");
    public static final Symbol optFilterPlacementBGP = ARQConstants.allocSymbol("optFilterPlacementBGP");
    public static final Symbol optFilterPlacementConservative = ARQConstants.allocSymbol("optFilterPlacementConservative");
    public static final Symbol optTopNSorting = ARQConstants.allocSymbol("optTopNSorting");
    public static final Symbol optDistinctToReduced = ARQConstants.allocSymbol("optDistinctToReduced");
    public static final Symbol optOrderByDistinctApplication = ARQConstants.allocSymbol("optOrderByDistinctApplication");
    public static final Symbol optFilterEquality = ARQConstants.allocSymbol("optFilterEquality");
    public static final Symbol optFilterInequality = ARQConstants.allocSymbol("optFilterInequality");
    public static final Symbol optFilterImplicitJoin = ARQConstants.allocSymbol("optFilterImplicitJoin");
    public static final Symbol optImplicitLeftJoin = ARQConstants.allocSymbol("optImplicitLeftJoin");
    public static final Symbol optTermStrings = ARQConstants.allocSymbol("optTermStrings");
    public static final Symbol optExprConstantFolding = ARQConstants.allocSymbol("optExprConstantFolding");
    public static final Symbol optFilterConjunction = ARQConstants.allocSymbol("optFilterConjunction");
    public static final Symbol optFilterExpandOneOf = ARQConstants.allocSymbol("optFilterExpandOneOf");
    public static final Symbol optFilterDisjunction = ARQConstants.allocSymbol("optFilterDisjunction");
    public static final Symbol optPromoteTableEmpty = ARQConstants.allocSymbol("optPromoteTableEmpty");
    public static final Symbol optIndexJoinStrategy = ARQConstants.allocSymbol("optIndexJoinStrategy");
    public static final Symbol optMergeBGPs = ARQConstants.allocSymbol("optMergeBGPs");
    public static final Symbol optMergeExtends = ARQConstants.allocSymbol("optMergeExtends");
    public static final Symbol propertyFunctions = ARQConstants.allocSymbol("propertyFunctions");
    public static final Symbol extensionValueTypes = ARQConstants.allocSymbol("extensionValueTypesExpr");
    public static final Symbol generateToList = ARQConstants.allocSymbol("generateToList");
    public static final String PATH = "org.apache.jena.arq";
    private static String metadataLocation = "org/apache/jena/arq/arq-properties.xml";
    private static Metadata metadata = new Metadata(metadataLocation);
    public static final String NAME = "ARQ";
    public static final String VERSION = metadata.get("org.apache.jena.arq.version", "unknown");
    public static final String BUILD_DATE = metadata.get("org.apache.jena.arq.build.datetime", "unset");
    private static volatile boolean initialized = false;
    private static final Object initLock = new Object();
    private static Context globalContext = null;

    public static Logger getExecLogger() {
        return logExec;
    }

    public static Logger getInfoLogger() {
        return logInfo;
    }

    public static Logger getHttpRequestLogger() {
        return logHttpRequest;
    }

    public static Explain.InfoLevel getExecutionLogging() {
        return (Explain.InfoLevel)((Object)ARQ.getContext().get(symLogExec));
    }

    public static void setExecutionLogging(Explain.InfoLevel infoLevel) {
        if (Explain.InfoLevel.NONE.equals((Object)infoLevel)) {
            ARQ.getContext().unset(symLogExec);
            return;
        }
        ARQ.getContext().set(symLogExec, (Object)infoLevel);
    }

    public static void enableBlankNodeResultLabels() {
        ARQ.enableBlankNodeResultLabels(true);
    }

    public static void enableBlankNodeResultLabels(boolean val) {
        Boolean b = val;
        globalContext.set(inputGraphBNodeLabels, b);
        globalContext.set(outputGraphBNodeLabels, b);
    }

    public static void enableOptimizer(boolean state) {
        ARQ.enableOptimizer(ARQ.getContext(), state);
    }

    public static void enableOptimizer(Context context, boolean state) {
        context.set(optimization, state);
    }

    public static void setStrictMode() {
        ARQ.setStrictMode(ARQ.getContext());
    }

    public static void setStrictMode(Context context) {
        SystemARQ.StrictDateTimeFO = true;
        SystemARQ.ValueExtensions = false;
        SystemARQ.EnableRomanNumerals = false;
        context.set(optimization, false);
        context.set(hideNonDistiguishedVariables, true);
        context.set(strictSPARQL, true);
        context.set(enablePropertyFunctions, false);
        context.set(extensionValueTypes, false);
        context.set(constantBNodeLabels, false);
        context.set(generateToList, true);
        context.set(regexImpl, xercesRegex);
    }

    public static boolean isStrictMode() {
        return ARQ.getContext().isTrue(strictSPARQL);
    }

    public static void setNormalMode() {
        SystemARQ.StrictDateTimeFO = false;
        SystemARQ.ValueExtensions = true;
        SystemARQ.EnableRomanNumerals = false;
        ARQ.setNormalMode(ARQ.getContext());
    }

    public static void setNormalMode(Context context) {
        context.set(optimization, true);
        context.set(hideNonDistiguishedVariables, false);
        context.set(strictSPARQL, false);
        context.set(enablePropertyFunctions, true);
        context.set(extensionValueTypes, true);
        context.set(constantBNodeLabels, true);
        context.set(generateToList, false);
        context.set(regexImpl, javaRegex);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void init() {
        if (initialized) {
            return;
        }
        Object object = initLock;
        synchronized (object) {
            if (initialized) {
                return;
            }
            initialized = true;
            globalContext = ARQ.defaultSettings();
            RIOT.init();
            StageBuilder.init();
            ARQMgt.init();
            MappingRegistry.addPrefixMapping(arqSymbolPrefix, arqParamNS);
            SystemInfo sysInfo = new SystemInfo(arqIRI, PATH, VERSION, BUILD_DATE);
            SystemARQ.registerSubSystem(sysInfo);
            RIOT.register();
        }
    }

    private static Context defaultSettings() {
        SystemARQ.StrictDateTimeFO = false;
        SystemARQ.ValueExtensions = true;
        SystemARQ.EnableRomanNumerals = false;
        Context context = new Context();
        context.unset(optimization);
        context.set(strictSPARQL, false);
        context.set(constantBNodeLabels, true);
        context.set(enablePropertyFunctions, true);
        context.set(regexImpl, javaRegex);
        return context;
    }

    public static Context getContext() {
        return globalContext;
    }

    public static void set(Symbol symbol, boolean value) {
        ARQ.getContext().set(symbol, value);
    }

    public static void setTrue(Symbol symbol) {
        ARQ.getContext().setTrue(symbol);
    }

    public static void setFalse(Symbol symbol) {
        ARQ.getContext().setFalse(symbol);
    }

    public static void unset(Symbol symbol) {
        ARQ.getContext().unset(symbol);
    }

    public static boolean isTrue(Symbol symbol) {
        return ARQ.getContext().isTrue(symbol);
    }

    public static boolean isFalse(Symbol symbol) {
        return ARQ.getContext().isFalse(symbol);
    }

    public static boolean isTrueOrUndef(Symbol symbol) {
        return ARQ.getContext().isTrueOrUndef(symbol);
    }

    public static boolean isFalseOrUndef(Symbol symbol) {
        return ARQ.getContext().isFalseOrUndef(symbol);
    }

    static {
        ARQ.init();
    }
}

