/*
 * Decompiled with CFR 0.152.
 */
package jena.cmdline;

import com.hp.hpl.jena.util.FileUtils;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import jena.cmdline.Arg;
import jena.cmdline.ArgDecl;
import jena.cmdline.ArgHandler;

public class CommandLine {
    protected ArgHandler argHook = null;
    protected String usage = null;
    protected Map<String, ArgDecl> argMap = new HashMap<String, ArgDecl>();
    protected Map<String, Arg> args = new HashMap<String, Arg>();
    String indirectionMarker = "@";
    protected boolean allowItemIndirect = false;
    boolean ignoreIndirectionMarker = false;
    protected List<String> items = new ArrayList<String>();

    public void setHook(ArgHandler argHandler) {
        this.argHook = argHandler;
    }

    public void setUsage(String usageMessage) {
        this.usage = usageMessage;
    }

    public boolean hasArgs() {
        return this.args.size() > 0;
    }

    public boolean hasItems() {
        return this.items.size() > 0;
    }

    public Iterator<Arg> args() {
        return this.args.values().iterator();
    }

    public int numArgs() {
        return this.args.size();
    }

    public int numItems() {
        return this.items.size();
    }

    public void pushItem(String s) {
        this.items.add(s);
    }

    public boolean isIndirectItem(int i) {
        return this.allowItemIndirect && this.items.get(i).startsWith(this.indirectionMarker);
    }

    public String getItem(int i) {
        return this.getItem(i, this.allowItemIndirect);
    }

    public String getItem(int i, boolean withIndirect) {
        if (i < 0 || i >= this.items.size()) {
            return null;
        }
        String item = this.items.get(i);
        if (withIndirect && item.startsWith(this.indirectionMarker)) {
            item = item.substring(1);
            try {
                item = FileUtils.readWholeFileAsUTF8(item);
            }
            catch (Exception ex) {
                throw new IllegalArgumentException("Failed to read '" + item + "': " + ex.getMessage());
            }
        }
        return item;
    }

    public void process(String[] argv) throws IllegalArgumentException {
        String argStr;
        int i;
        ArrayList<String> argList = new ArrayList<String>();
        argList.addAll(Arrays.asList(argv));
        for (i = 0; i < argList.size() && !this.endProcessing(argStr = (String)argList.get(i)); ++i) {
            if (this.ignoreArgument(argStr)) continue;
            int j1 = argStr.indexOf(61);
            int j2 = argStr.indexOf(58);
            int j = Integer.MAX_VALUE;
            if (j1 > 0 && j1 < j) {
                j = j1;
            }
            if (j2 > 0 && j2 < j) {
                j = j2;
            }
            if (j != Integer.MAX_VALUE) {
                String a2 = argStr.substring(j + 1);
                argList.add(i + 1, a2);
                argStr = argStr.substring(0, j);
            }
            argStr = ArgDecl.canonicalForm(argStr);
            String val = null;
            if (this.argMap.containsKey(argStr)) {
                if (!this.args.containsKey(argStr)) {
                    this.args.put(argStr, new Arg(argStr));
                }
                Arg arg = this.args.get(argStr);
                ArgDecl argDecl = this.argMap.get(argStr);
                if (argDecl.takesValue()) {
                    if (i == argList.size() - 1) {
                        throw new IllegalArgumentException("No value for argument: " + arg.getName());
                    }
                    val = (String)argList.get(++i);
                    arg.setValue(val);
                    arg.addValue(val);
                }
                if (this.argHook != null) {
                    this.argHook.action(argStr, val);
                }
                argDecl.trigger(arg);
                continue;
            }
            this.handleUnrecognizedArg((String)argList.get(i));
        }
        if (i < argList.size()) {
            if (((String)argList.get(i)).equals("-") || ((String)argList.get(i)).equals("--")) {
                ++i;
            }
            while (i < argList.size()) {
                String item = (String)argList.get(i);
                this.items.add(item);
                ++i;
            }
        }
    }

    public boolean ignoreArgument(String argStr) {
        return false;
    }

    public boolean endProcessing(String argStr) {
        return !argStr.startsWith("-") || argStr.equals("--") || argStr.equals("-");
    }

    public void handleUnrecognizedArg(String argStr) {
        throw new IllegalArgumentException("Unknown argument: " + argStr);
    }

    public boolean contains(ArgDecl argDecl) {
        return this.getArg(argDecl) != null;
    }

    public boolean contains(String s) {
        return this.getArg(s) != null;
    }

    public boolean hasArg(String argName) {
        return this.getArg(argName) != null;
    }

    public boolean hasArg(ArgDecl argDecl) {
        return this.getArg(argDecl) != null;
    }

    public Arg getArg(ArgDecl argDecl) {
        Arg arg = null;
        for (Arg a : this.args.values()) {
            if (!argDecl.matches(a)) continue;
            arg = a;
        }
        return arg;
    }

    public Arg getArg(String arg) {
        arg = ArgDecl.canonicalForm(arg);
        return this.args.get(arg);
    }

    public String getValue(ArgDecl argDecl) {
        Arg arg = this.getArg(argDecl);
        if (arg == null) {
            return null;
        }
        if (arg.hasValue()) {
            return arg.getValue();
        }
        return null;
    }

    public String getValue(String argName) {
        Arg arg = this.getArg(argName);
        if (arg == null) {
            return null;
        }
        return arg.getValue();
    }

    public List<String> getValues(ArgDecl argDecl) {
        Arg arg = this.getArg(argDecl);
        if (arg == null) {
            return null;
        }
        return arg.getValues();
    }

    public List<String> getValues(String argName) {
        Arg arg = this.getArg(argName);
        if (arg == null) {
            return null;
        }
        return arg.getValues();
    }

    public CommandLine add(String argName, boolean hasValue) {
        return this.add(new ArgDecl(hasValue, argName));
    }

    public CommandLine add(boolean hasValue, String argName) {
        return this.add(new ArgDecl(hasValue, argName));
    }

    public CommandLine add(ArgDecl arg) {
        Iterator<String> iter = arg.names();
        while (iter.hasNext()) {
            this.argMap.put(iter.next(), arg);
        }
        return this;
    }

    public boolean allowItemIndirect() {
        return this.allowItemIndirect;
    }

    public void setAllowItemIndirect(boolean allowItemIndirect) {
        this.allowItemIndirect = allowItemIndirect;
    }

    public boolean isIgnoreIndirectionMarker() {
        return this.ignoreIndirectionMarker;
    }

    public String getIndirectionMarker() {
        return this.indirectionMarker;
    }

    public void setIndirectionMarker(String indirectionMarker) {
        this.indirectionMarker = indirectionMarker;
    }

    public void setIgnoreIndirectionMarker(boolean ignoreIndirectionMarker) {
        this.ignoreIndirectionMarker = ignoreIndirectionMarker;
    }

    public ArgHandler trace() {
        final PrintStream _out = System.err;
        return new ArgHandler(){

            @Override
            public void action(String arg, String val) {
                if (_out != null) {
                    _out.println("Seen: " + arg + (val != null ? " = " + val : ""));
                }
            }
        };
    }
}

