/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.ma.json;

import java.util.HashSet;
import java.util.Set;
import java.util.Stack;
import java.util.function.IntPredicate;
import net.sf.saxon.event.PipelineConfiguration;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.event.StartTagBuffer;
import net.sf.saxon.expr.parser.Location;
import net.sf.saxon.om.NamespaceBindingSet;
import net.sf.saxon.om.NodeName;
import net.sf.saxon.trans.Err;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.util.FastStringBuffer;
import net.sf.saxon.type.SchemaType;
import net.sf.saxon.type.SimpleType;
import net.sf.saxon.type.StringConverter;
import net.sf.saxon.value.DoubleValue;
import net.sf.saxon.value.StringToDouble11;
import net.sf.saxon.value.Whitespace;

public class JsonReceiver
implements Receiver {
    private PipelineConfiguration pipe;
    private FastStringBuffer output;
    private FastStringBuffer textBuffer = new FastStringBuffer(128);
    private Stack<NodeName> stack = new Stack();
    private boolean atStart = true;
    private StartTagBuffer startTagBuffer;
    private boolean indenting = false;
    private boolean escaped = false;
    private Stack<Set<String>> keyChecker = new Stack();
    private static final String ERR_INPUT = "FOJS0006";

    public JsonReceiver(PipelineConfiguration pipe) {
        this.setPipelineConfiguration(pipe);
    }

    @Override
    public void setPipelineConfiguration(PipelineConfiguration pipe) {
        this.pipe = pipe;
        this.startTagBuffer = (StartTagBuffer)pipe.getComponent(StartTagBuffer.class.getName());
    }

    @Override
    public PipelineConfiguration getPipelineConfiguration() {
        return this.pipe;
    }

    @Override
    public void setSystemId(String systemId) {
    }

    public void setIndenting(boolean indenting) {
        this.indenting = indenting;
    }

    public boolean isIndenting() {
        return this.indenting;
    }

    @Override
    public void open() throws XPathException {
        this.output = new FastStringBuffer(2048);
    }

    @Override
    public void startDocument(int properties) throws XPathException {
        if (this.output == null) {
            this.output = new FastStringBuffer(2048);
        }
    }

    @Override
    public void endDocument() throws XPathException {
    }

    @Override
    public void setUnparsedEntity(String name, String systemID, String publicID) throws XPathException {
    }

    @Override
    public void startElement(NodeName elemName, SchemaType typeCode, Location location, int properties) throws XPathException {
        String parent = this.stack.empty() ? null : this.stack.peek().getLocalPart();
        boolean inMap = "map".equals(parent);
        this.stack.push(elemName);
        if (!elemName.hasURI("http://www.w3.org/2005/xpath-functions")) {
            throw new XPathException("xml-to-json: element found in wrong namespace: " + elemName.getStructuredQName().getEQName(), ERR_INPUT);
        }
        if (!this.atStart) {
            this.output.append(',');
            if (this.indenting) {
                this.indent(this.stack.size());
            }
        }
        if (inMap) {
            if (this.startTagBuffer == null) {
                this.startTagBuffer = (StartTagBuffer)this.pipe.getComponent(StartTagBuffer.class.getName());
            }
            if (this.startTagBuffer == null) {
                throw new IllegalStateException();
            }
            String key = this.startTagBuffer.getAttribute("", "key");
            if (key == null) {
                throw new XPathException("xml-to-json: Child elements of <map> must have a key attribute", ERR_INPUT);
            }
            String keyEscaped = this.startTagBuffer.getAttribute("", "escaped-key");
            boolean alreadyEscaped = false;
            if (keyEscaped != null) {
                try {
                    alreadyEscaped = StringConverter.StringToBoolean.INSTANCE.convertString(keyEscaped).asAtomic().effectiveBooleanValue();
                }
                catch (XPathException e2) {
                    throw new XPathException("xml-to-json: Value of escaped-key attribute '" + Err.wrap(keyEscaped) + "' is not a valid xs:boolean", ERR_INPUT);
                }
            }
            key = (alreadyEscaped ? JsonReceiver.handleEscapedString(key) : JsonReceiver.escape(key, false, new ControlChar())).toString();
            String normalizedKey = alreadyEscaped ? JsonReceiver.unescape(key) : key;
            boolean added = this.keyChecker.peek().add(normalizedKey);
            if (!added) {
                throw new XPathException("xml-to-json: duplicate key value " + Err.wrap(key), ERR_INPUT);
            }
            this.output.append('\"');
            this.output.append(key);
            this.output.append('\"');
            this.output.append(this.indenting ? " : " : ":");
        }
        String local = elemName.getLocalPart();
        this.escaped = false;
        if (local.equals("array")) {
            if (this.indenting) {
                this.indent(this.stack.size());
                this.output.append("[ ");
            } else {
                this.output.append('[');
            }
            this.atStart = true;
        } else if (local.equals("map")) {
            if (this.indenting) {
                this.indent(this.stack.size());
                this.output.append("{ ");
            } else {
                this.output.append('{');
            }
            this.atStart = true;
            this.keyChecker.push(new HashSet());
        } else if (local.equals("null")) {
            this.checkParent(local, parent);
            this.output.append("null");
            this.atStart = false;
        } else if (local.equals("string")) {
            String escapeAtt;
            if (this.startTagBuffer == null) {
                this.startTagBuffer = (StartTagBuffer)this.pipe.getComponent(StartTagBuffer.class.getName());
            }
            if ((escapeAtt = this.startTagBuffer.getAttribute("", "escaped")) != null) {
                try {
                    this.escaped = StringConverter.StringToBoolean.INSTANCE.convertString(escapeAtt).asAtomic().effectiveBooleanValue();
                }
                catch (XPathException e3) {
                    throw new XPathException("xml-to-json: value of escaped attribute (" + escapeAtt + ") is not a valid xs:boolean", ERR_INPUT);
                }
            }
            this.checkParent(local, parent);
            this.atStart = false;
        } else if (local.equals("boolean") || local.equals("number")) {
            this.checkParent(local, parent);
            this.atStart = false;
        } else {
            throw new XPathException("xml-to-json: unknown element <" + local + ">", ERR_INPUT);
        }
        this.textBuffer.setLength(0);
    }

    private void checkParent(String child, String parent) throws XPathException {
        if ("null".equals(parent) || "string".equals(parent) || "number".equals(parent) || "boolean".equals(parent)) {
            throw new XPathException("xml-to-json: A " + Err.wrap(child, 1) + " element cannot appear as a child of " + Err.wrap(parent, 1), ERR_INPUT);
        }
    }

    @Override
    public void namespace(NamespaceBindingSet namespaceBindings, int properties) throws XPathException {
    }

    @Override
    public void attribute(NodeName attName, SimpleType typeCode, CharSequence value, Location locationId, int properties) throws XPathException {
        if (attName.hasURI("") && (attName.getLocalPart().equals("key") || attName.getLocalPart().equals("escaped-key"))) {
            boolean inMap;
            boolean bl = inMap = this.stack.size() == 1 || ((NodeName)this.stack.get(this.stack.size() - 2)).getLocalPart().equals("map");
            if (!inMap) {
                throw new XPathException("xml-to-json: The " + attName.getLocalPart() + " attribute is allowed only on elements within a map", ERR_INPUT);
            }
        } else if (attName.hasURI("") && attName.getLocalPart().equals("escaped")) {
            boolean allowed;
            boolean bl = allowed = this.stack.size() == 1 || this.stack.size() > 1 && this.stack.peek().getLocalPart().equals("string");
            if (!allowed) {
                throw new XPathException("xml-to-json: The escaped attribute is allowed only on the <string> element", ERR_INPUT);
            }
        } else if (attName.hasURI("") || attName.hasURI("http://www.w3.org/2005/xpath-functions")) {
            throw new XPathException("xml-to-json: Disallowed attribute in input: " + attName.getDisplayName(), ERR_INPUT);
        }
    }

    @Override
    public void startContent() throws XPathException {
    }

    @Override
    public void endElement() throws XPathException {
        NodeName name = this.stack.pop();
        String local = name.getLocalPart();
        if (local.equals("boolean")) {
            try {
                boolean b = StringConverter.StringToBoolean.INSTANCE.convertString(this.textBuffer).asAtomic().effectiveBooleanValue();
                this.output.append(b ? "true" : "false");
            }
            catch (XPathException e2) {
                throw new XPathException("xml-to-json: Value of <boolean> element is not a valid xs:boolean", ERR_INPUT);
            }
        } else if (local.equals("number")) {
            try {
                double d = StringToDouble11.getInstance().stringToNumber(this.textBuffer);
                if (Double.isNaN(d) || Double.isInfinite(d)) {
                    throw new XPathException("xml-to-json: Infinity and NaN are not allowed", ERR_INPUT);
                }
                this.output.append(new DoubleValue(d).getStringValueCS());
            }
            catch (NumberFormatException e3) {
                throw new XPathException("xml-to-json: Invalid number: " + this.textBuffer, ERR_INPUT);
            }
        } else if (local.equals("string")) {
            this.output.append('\"');
            String str2 = this.textBuffer.toString();
            if (this.escaped) {
                this.output.append(JsonReceiver.handleEscapedString(str2));
            } else {
                this.output.append(JsonReceiver.escape(str2, false, new ControlChar()));
            }
            this.output.append('\"');
        } else if (!Whitespace.isWhite(this.textBuffer)) {
            throw new XPathException("xml-to-json: Element " + name.getDisplayName() + " must have no text content", ERR_INPUT);
        }
        this.textBuffer.setLength(0);
        this.escaped = false;
        if (local.equals("array")) {
            this.output.append(this.indenting ? " ]" : "]");
        } else if (local.equals("map")) {
            this.keyChecker.pop();
            this.output.append(this.indenting ? " }" : "}");
        }
        this.atStart = false;
    }

    private static CharSequence handleEscapedString(String str2) throws XPathException {
        JsonReceiver.unescape(str2);
        FastStringBuffer out = new FastStringBuffer(str2.length() * 2);
        boolean afterEscapeChar = false;
        for (int i = 0; i < str2.length(); ++i) {
            char c = str2.charAt(i);
            if (c == '\"' && !afterEscapeChar) {
                out.append("\\\"");
            } else if (c < ' ' || c >= '\u007f' && c < '\u00a0') {
                if (c == '\b') {
                    out.append("\\b");
                } else if (c == '\f') {
                    out.append("\\f");
                } else if (c == '\n') {
                    out.append("\\n");
                } else if (c == '\r') {
                    out.append("\\r");
                } else if (c == '\t') {
                    out.append("\\t");
                } else {
                    out.append("\\u");
                    String hex = Integer.toHexString(c).toUpperCase();
                    while (hex.length() < 4) {
                        hex = "0" + hex;
                    }
                    out.append(hex);
                }
            } else if (c == '/' && !afterEscapeChar) {
                out.append("\\/");
            } else {
                out.append(c);
            }
            afterEscapeChar = c == '\\' && !afterEscapeChar;
        }
        return out;
    }

    public static CharSequence escape(CharSequence in, boolean forXml, IntPredicate hexEscapes) throws XPathException {
        FastStringBuffer out = new FastStringBuffer(in.length());
        block10: for (int i = 0; i < in.length(); ++i) {
            char c = in.charAt(i);
            switch (c) {
                case '\"': {
                    out.append(forXml ? "\"" : "\\\"");
                    continue block10;
                }
                case '\b': {
                    out.append("\\b");
                    continue block10;
                }
                case '\f': {
                    out.append("\\f");
                    continue block10;
                }
                case '\n': {
                    out.append("\\n");
                    continue block10;
                }
                case '\r': {
                    out.append("\\r");
                    continue block10;
                }
                case '\t': {
                    out.append("\\t");
                    continue block10;
                }
                case '/': {
                    out.append(forXml ? "/" : "\\/");
                    continue block10;
                }
                case '\\': {
                    out.append("\\\\");
                    continue block10;
                }
                default: {
                    if (hexEscapes.test(c)) {
                        out.append("\\u");
                        String hex = Integer.toHexString(c).toUpperCase();
                        while (hex.length() < 4) {
                            hex = "0" + hex;
                        }
                        out.append(hex);
                        continue block10;
                    }
                    out.append(c);
                }
            }
        }
        return out;
    }

    @Override
    public void characters(CharSequence chars, Location locationId, int properties) throws XPathException {
        this.textBuffer.append(chars);
    }

    @Override
    public void processingInstruction(String name, CharSequence data, Location locationId, int properties) throws XPathException {
    }

    @Override
    public void comment(CharSequence content, Location locationId, int properties) throws XPathException {
    }

    @Override
    public void close() throws XPathException {
    }

    @Override
    public boolean usesTypeAnnotations() {
        return false;
    }

    @Override
    public String getSystemId() {
        return null;
    }

    public String getJsonString() {
        return this.output.toString();
    }

    private void indent(int depth) {
        this.output.append('\n');
        for (int i = 0; i < depth; ++i) {
            this.output.append("  ");
        }
    }

    private static String unescape(String literal) throws XPathException {
        if (literal.indexOf(92) < 0) {
            return literal;
        }
        FastStringBuffer buffer = new FastStringBuffer(literal.length());
        for (int i = 0; i < literal.length(); ++i) {
            char c = literal.charAt(i);
            if (c == '\\') {
                if (i++ == literal.length() - 1) {
                    throw new XPathException("String '" + Err.wrap(literal) + "' ends in backslash ", "FOJS0007");
                }
                switch (literal.charAt(i)) {
                    case '\"': {
                        buffer.append('\"');
                        break;
                    }
                    case '\\': {
                        buffer.append('\\');
                        break;
                    }
                    case '/': {
                        buffer.append('/');
                        break;
                    }
                    case 'b': {
                        buffer.append('\b');
                        break;
                    }
                    case 'f': {
                        buffer.append('\f');
                        break;
                    }
                    case 'n': {
                        buffer.append('\n');
                        break;
                    }
                    case 'r': {
                        buffer.append('\r');
                        break;
                    }
                    case 't': {
                        buffer.append('\t');
                        break;
                    }
                    case 'u': {
                        try {
                            String hex = literal.substring(i + 1, i + 5);
                            int code = Integer.parseInt(hex, 16);
                            buffer.append((char)code);
                            i += 4;
                            break;
                        }
                        catch (Exception e2) {
                            throw new XPathException("Invalid hex escape sequence in string '" + Err.wrap(literal) + "'", "FOJS0007");
                        }
                    }
                    default: {
                        char next = literal.charAt(i);
                        String xx = next < '\u0100' ? next + "" : "x" + Integer.toHexString(next);
                        throw new XPathException("Unknown escape sequence \\" + xx, "FOJS0007");
                    }
                }
                continue;
            }
            buffer.append(c);
        }
        return buffer.toString();
    }

    private static class ControlChar
    implements IntPredicate {
        private ControlChar() {
        }

        @Override
        public boolean test(int c) {
            return c < 31 || c >= 127 && c <= 159;
        }
    }
}

