/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.style;

import java.math.BigDecimal;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.StringTokenizer;
import javax.xml.transform.SourceLocator;
import javax.xml.transform.TransformerException;
import net.sf.saxon.Configuration;
import net.sf.saxon.expr.Component;
import net.sf.saxon.expr.ErrorExpression;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.LetExpression;
import net.sf.saxon.expr.Literal;
import net.sf.saxon.expr.Operand;
import net.sf.saxon.expr.StringLiteral;
import net.sf.saxon.expr.instruct.Actor;
import net.sf.saxon.expr.instruct.Block;
import net.sf.saxon.expr.instruct.ConditionalBlock;
import net.sf.saxon.expr.instruct.SavedNamespaceContext;
import net.sf.saxon.expr.instruct.SequenceInstr;
import net.sf.saxon.expr.instruct.SlotManager;
import net.sf.saxon.expr.instruct.TraceExpression;
import net.sf.saxon.expr.instruct.ValueOf;
import net.sf.saxon.expr.instruct.WithParam;
import net.sf.saxon.expr.parser.CodeInjector;
import net.sf.saxon.expr.parser.ExplicitLocation;
import net.sf.saxon.expr.parser.ExpressionTool;
import net.sf.saxon.expr.parser.ExpressionVisitor;
import net.sf.saxon.expr.parser.Location;
import net.sf.saxon.expr.parser.RetainedStaticContext;
import net.sf.saxon.expr.parser.XPathParser;
import net.sf.saxon.expr.sort.SortKeyDefinition;
import net.sf.saxon.expr.sort.SortKeyDefinitionList;
import net.sf.saxon.functions.Current;
import net.sf.saxon.lib.Feature;
import net.sf.saxon.lib.NamespaceConstant;
import net.sf.saxon.lib.StringCollator;
import net.sf.saxon.lib.Validation;
import net.sf.saxon.om.FingerprintedQName;
import net.sf.saxon.om.NameChecker;
import net.sf.saxon.om.NameOfNode;
import net.sf.saxon.om.NamespaceBinding;
import net.sf.saxon.om.NamespaceResolver;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.NodeName;
import net.sf.saxon.om.QNameException;
import net.sf.saxon.om.QNameParser;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.pattern.AnyNodeTest;
import net.sf.saxon.pattern.BasePatternWithPredicate;
import net.sf.saxon.pattern.NodeTestPattern;
import net.sf.saxon.pattern.Pattern;
import net.sf.saxon.pattern.PatternThatSetsCurrent;
import net.sf.saxon.style.AbsentExtensionElement;
import net.sf.saxon.style.AttributeValueTemplate;
import net.sf.saxon.style.Compilation;
import net.sf.saxon.style.ComponentDeclaration;
import net.sf.saxon.style.ExpressionContext;
import net.sf.saxon.style.LiteralResultElement;
import net.sf.saxon.style.PrincipalStylesheetModule;
import net.sf.saxon.style.SourceBinding;
import net.sf.saxon.style.StylesheetComponent;
import net.sf.saxon.style.StylesheetPackage;
import net.sf.saxon.style.TextValueTemplateNode;
import net.sf.saxon.style.XSLCallTemplate;
import net.sf.saxon.style.XSLContextItem;
import net.sf.saxon.style.XSLCopy;
import net.sf.saxon.style.XSLDocument;
import net.sf.saxon.style.XSLElement;
import net.sf.saxon.style.XSLFallback;
import net.sf.saxon.style.XSLGeneralVariable;
import net.sf.saxon.style.XSLLocalParam;
import net.sf.saxon.style.XSLLocalVariable;
import net.sf.saxon.style.XSLModuleRoot;
import net.sf.saxon.style.XSLOnCompletion;
import net.sf.saxon.style.XSLOnEmpty;
import net.sf.saxon.style.XSLOnNonEmpty;
import net.sf.saxon.style.XSLSort;
import net.sf.saxon.style.XSLSortOrMergeKey;
import net.sf.saxon.style.XSLStylesheet;
import net.sf.saxon.style.XSLTemplate;
import net.sf.saxon.style.XSLWithParam;
import net.sf.saxon.trans.Err;
import net.sf.saxon.trans.Mode;
import net.sf.saxon.trans.SymbolicName;
import net.sf.saxon.trans.Visibility;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.AttributeLocation;
import net.sf.saxon.tree.iter.AxisIterator;
import net.sf.saxon.tree.iter.ListIterator;
import net.sf.saxon.tree.linked.ElementImpl;
import net.sf.saxon.tree.linked.NodeImpl;
import net.sf.saxon.tree.linked.TextImpl;
import net.sf.saxon.tree.util.FastStringBuffer;
import net.sf.saxon.tree.util.NamespaceIterator;
import net.sf.saxon.tree.util.Navigator;
import net.sf.saxon.type.BuiltInType;
import net.sf.saxon.type.ConversionResult;
import net.sf.saxon.type.ErrorType;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.SchemaType;
import net.sf.saxon.type.SimpleType;
import net.sf.saxon.type.Type;
import net.sf.saxon.type.ValidationFailure;
import net.sf.saxon.value.BigDecimalValue;
import net.sf.saxon.value.SequenceType;
import net.sf.saxon.value.Whitespace;

public abstract class StyleElement
extends ElementImpl {
    protected String[] extensionNamespaces = null;
    private String[] excludedNamespaces = null;
    protected int version = -1;
    protected ExpressionContext staticContext = null;
    protected XPathException validationError = null;
    protected int reportingCircumstances = 1;
    protected String defaultXPathNamespace = null;
    protected String defaultCollationName = null;
    protected StructuredQName defaultMode;
    protected boolean expandText = false;
    private boolean explaining = false;
    private StructuredQName objectName;
    private String baseURI;
    private Compilation compilation;
    private ExplicitLocation savedLocation = null;
    private int defaultValidation = 0;
    public static final int REPORT_ALWAYS = 1;
    public static final int REPORT_UNLESS_FORWARDS_COMPATIBLE = 2;
    public static final int REPORT_IF_INSTANTIATED = 3;
    public static final int REPORT_STATICALLY_UNLESS_FALLBACK_AVAILABLE = 4;
    public static final int REPORT_DYNAMICALLY_UNLESS_FALLBACK_AVAILABLE = 5;
    public static final int IGNORED_INSTRUCTION = 6;
    protected int actionsCompleted = 0;
    public static final int ACTION_VALIDATE = 1;
    public static final int ACTION_COMPILE = 2;
    public static final int ACTION_TYPECHECK = 4;
    public static final int ACTION_OPTIMIZE = 8;
    public static final int ACTION_FIXUP = 16;
    public static final int ACTION_PROCESS_ATTRIBUTES = 32;
    protected static final String[] YES_NO = new String[]{"0", "1", "false", "no", "true", "yes"};

    public Compilation getCompilation() {
        return this.compilation;
    }

    public void setCompilation(Compilation compilation) {
        this.compilation = compilation;
    }

    public StylesheetPackage getPackageData() {
        return this.getPrincipalStylesheetModule().getStylesheetPackage();
    }

    @Override
    public Configuration getConfiguration() {
        return this.compilation.getConfiguration();
    }

    public ExpressionContext getStaticContext() {
        if (this.staticContext == null) {
            this.staticContext = new ExpressionContext(this, null);
        }
        return this.staticContext;
    }

    public ExpressionContext getStaticContext(StructuredQName attributeName) {
        return new ExpressionContext(this, attributeName);
    }

    @Override
    public String getBaseURI() {
        if (this.baseURI == null) {
            this.baseURI = super.getBaseURI();
        }
        return this.baseURI;
    }

    public ExpressionVisitor makeExpressionVisitor() {
        return ExpressionVisitor.make(this.getStaticContext());
    }

    public boolean isSchemaAware() {
        return this.getCompilation().isSchemaAware();
    }

    protected boolean isExplaining() {
        return this.explaining;
    }

    public void substituteFor(StyleElement temp) {
        this.setRawParent(temp.getRawParent());
        this.setAttributeList(temp.getAttributeList());
        this.setNamespaceList(temp.getNamespaceList());
        this.setNodeName(temp.getNodeName());
        this.setRawSequenceNumber(temp.getRawSequenceNumber());
        this.extensionNamespaces = temp.extensionNamespaces;
        this.excludedNamespaces = temp.excludedNamespaces;
        this.version = temp.version;
        this.staticContext = temp.staticContext;
        this.validationError = temp.validationError;
        this.reportingCircumstances = temp.reportingCircumstances;
        this.compilation = temp.compilation;
    }

    public void setValidationError(TransformerException reason, int circumstances) {
        this.validationError = XPathException.makeXPathException(reason);
        this.reportingCircumstances = circumstances;
    }

    public void setIgnoreInstruction() {
        this.reportingCircumstances = 6;
    }

    public boolean isInstruction() {
        return false;
    }

    public boolean isDeclaration() {
        return false;
    }

    public Visibility getVisibility() {
        String vis = this.getAttributeValue("", "visibility");
        if (vis == null) {
            return Visibility.PRIVATE;
        }
        return this.interpretVisibilityValue(vis, "");
    }

    public Visibility getDeclaredVisibility() {
        String vis = this.getAttributeValue("", "visibility");
        if (vis == null) {
            return null;
        }
        return this.interpretVisibilityValue(vis, "");
    }

    protected boolean markTailCalls() {
        return false;
    }

    protected boolean mayContainSequenceConstructor() {
        return false;
    }

    protected boolean mayContainFallback() {
        return this.mayContainSequenceConstructor();
    }

    protected boolean mayContainParam() {
        return false;
    }

    public XSLModuleRoot getContainingStylesheet() {
        NodeImpl parent = this.getParent();
        if (parent instanceof XSLModuleRoot) {
            return (XSLModuleRoot)parent;
        }
        if (parent instanceof StyleElement) {
            return ((StyleElement)parent).getContainingStylesheet();
        }
        return null;
    }

    public int getDefaultValidation() {
        int v = this.defaultValidation;
        NodeInfo p = this;
        while (v == 0) {
            if (!((p = p.getParent()) instanceof StyleElement)) {
                return 4;
            }
            v = p.defaultValidation;
        }
        return v;
    }

    public final StructuredQName makeQName(String lexicalQName) throws XPathException {
        StructuredQName qName;
        try {
            qName = StructuredQName.fromLexicalQName(lexicalQName, false, true, this);
        }
        catch (XPathException e2) {
            e2.setIsStaticError(true);
            String code = e2.getErrorCodeLocalPart();
            if ("FONS0004".equals(code)) {
                e2.setErrorCode("XTSE0280");
            } else if ("FOCA0002".equals(code)) {
                e2.setErrorCode("XTSE0020");
            } else if (code == null) {
                e2.setErrorCode("XTSE0020");
            }
            e2.setLocator(this);
            throw e2;
        }
        if (NamespaceConstant.isReserved(qName.getURI())) {
            if (qName.hasURI("http://www.w3.org/1999/XSL/Transform")) {
                if (qName.getLocalPart().equals("initial-template") && (this instanceof XSLTemplate || this instanceof XSLCallTemplate)) {
                    return qName;
                }
                if (qName.getLocalPart().equals("original") && this.findAncestorElement(186) != null) {
                    return qName;
                }
            }
            XPathException err = new XPathException("Namespace prefix " + qName.getPrefix() + " refers to a reserved namespace");
            err.setIsStaticError(true);
            err.setErrorCode("XTSE0080");
            throw err;
        }
        return qName;
    }

    public StyleElement findAncestorElement(int fingerprint) {
        Optional<NodeInfo> ancestor = this.iterateAxis((byte)0).firstWith(node -> node instanceof StyleElement && node.getFingerprint() == fingerprint);
        return ancestor.orElse(null);
    }

    public StylesheetPackage getUsedPackage() {
        return null;
    }

    public Actor getXslOriginal(int componentKind) throws XPathException {
        StyleElement container2;
        StyleElement styleElement = container2 = componentKind == this.getFingerprint() ? this : this.findAncestorElement(componentKind);
        if (!(container2 instanceof StylesheetComponent)) {
            throw new XPathException("A reference to xsl:original appears within the wrong kind of component: in this case, it must be within xsl:" + this.getNamePool().getLocalName(componentKind), "XTSE0650", this);
        }
        SymbolicName originalName = ((StylesheetComponent)((Object)container2)).getSymbolicName();
        StyleElement xslOverride = container2.findAncestorElement(186);
        if (xslOverride == null) {
            throw new XPathException("A reference to xsl:original can be used only within an xsl:override element");
        }
        StyleElement usePackage = xslOverride.findAncestorElement(204);
        if (usePackage == null) {
            throw new XPathException("The parent of xsl:override must be an xsl:use-package element", "XTSE0010", xslOverride);
        }
        Component overridden = usePackage.getUsedPackage().getComponent(originalName);
        if (overridden == null) {
            return null;
        }
        return overridden.getActor();
    }

    public Component getOverriddenComponent() {
        if (!(this instanceof StylesheetComponent)) {
            return null;
        }
        SymbolicName originalName = ((StylesheetComponent)((Object)this)).getSymbolicName();
        StyleElement xslOverride = this.findAncestorElement(186);
        if (xslOverride == null) {
            return null;
        }
        StyleElement usePackage = xslOverride.findAncestorElement(204);
        if (usePackage == null) {
            return null;
        }
        return usePackage.getUsedPackage().getComponent(originalName);
    }

    public SavedNamespaceContext makeNamespaceContext() {
        StylesheetPackage pack = this.getPackageData();
        return new SavedNamespaceContext(NamespaceIterator.iterateNamespaces(this));
    }

    public RetainedStaticContext makeRetainedStaticContext() {
        return this.getStaticContext().makeRetainedStaticContext();
    }

    public boolean changesRetainedStaticContext() {
        NodeImpl parent = this.getParent();
        return parent == null || !ExpressionTool.equalOrNull(this.getBaseURI(), parent.getBaseURI()) || this.defaultCollationName != null || this.defaultXPathNamespace != null || this.getDeclaredNamespaces(NamespaceBinding.EMPTY_ARRAY).length != 0 || !(parent instanceof StyleElement) || this.getEffectiveVersion() != ((StyleElement)this.getParent()).getEffectiveVersion();
    }

    public NamespaceResolver getNamespaceResolver() {
        return this;
    }

    public void processAllAttributes() throws XPathException {
        this.processDefaultCollationAttribute();
        this.processDefaultMode();
        this.staticContext = new ExpressionContext(this, null);
        this.processAttributes();
        this.iterateAxis((byte)3).forEachOrFail(child -> {
            if (child instanceof StyleElement) {
                ((StyleElement)child).processAllAttributes();
                if (((StyleElement)child).explaining) {
                    this.explaining = true;
                }
            }
        });
    }

    public void processStandardAttributes(String namespace2) {
        this.processExtensionElementAttribute(namespace2);
        this.processExcludedNamespaces(namespace2);
        this.processVersionAttribute(namespace2);
        this.processDefaultXPathNamespaceAttribute(namespace2);
        this.processDefaultValidationAttribute(namespace2);
        this.processExpandTextAttribute(namespace2);
    }

    public String getAttributeValue(String clarkName) {
        FingerprintedQName nn = FingerprintedQName.fromClarkName(clarkName);
        return this.getAttributeValue(nn.getURI(), nn.getLocalPart());
    }

    protected final void processAttributes() {
        try {
            this.prepareAttributes();
        }
        catch (XPathException err) {
            this.compileError(err);
        }
    }

    protected void checkUnknownAttribute(NodeName nc) {
        String attributeURI = nc.getURI();
        String elementURI = this.getURI();
        String clarkName = nc.getStructuredQName().getClarkName();
        if (clarkName.equals("{http://saxon.sf.net/}explain")) {
            String value = this.getAttributeValue(clarkName);
            this.explaining = this.processBooleanAttribute("saxon:explain", value);
        }
        if (this.forwardsCompatibleModeIsEnabled()) {
            return;
        }
        if (this.isInstruction() && attributeURI.equals("http://www.w3.org/1999/XSL/Transform") && !elementURI.equals("http://www.w3.org/1999/XSL/Transform") && (clarkName.endsWith("}default-collation") || clarkName.endsWith("}default-mode") || clarkName.endsWith("}xpath-default-namespace") || clarkName.endsWith("}expand-text") || clarkName.endsWith("}extension-element-prefixes") || clarkName.endsWith("}exclude-result-prefixes") || clarkName.endsWith("}version") || clarkName.endsWith("}default-validation") || clarkName.endsWith("}use-when"))) {
            return;
        }
        if (elementURI.equals("http://www.w3.org/1999/XSL/Transform") && (clarkName.equals("default-collation") || clarkName.equals("default-mode") || clarkName.equals("expand-text") || clarkName.equals("xpath-default-namespace") || clarkName.equals("extension-element-prefixes") || clarkName.equals("exclude-result-prefixes") || clarkName.equals("version") || clarkName.equals("default-validation") || clarkName.equals("use-when"))) {
            return;
        }
        if ("".equals(attributeURI) || "http://www.w3.org/1999/XSL/Transform".equals(attributeURI)) {
            this.compileErrorInAttribute("Attribute " + Err.wrap(nc.getDisplayName(), 2) + " is not allowed on element " + Err.wrap(this.getDisplayName(), 1), "XTSE0090", clarkName);
        } else if ("http://saxon.sf.net/".equals(attributeURI)) {
            this.compileWarning("Unrecognized attribute in Saxon namespace: " + nc.getDisplayName(), "XTSE0090");
        }
    }

    protected abstract void prepareAttributes() throws XPathException;

    protected StyleElement getLastChildInstruction() {
        NodeInfo child;
        StyleElement last = null;
        AxisIterator kids = this.iterateAxis((byte)3);
        while ((child = kids.next()) != null) {
            if (child instanceof StyleElement) {
                last = (StyleElement)child;
                continue;
            }
            last = null;
        }
        return last;
    }

    public Expression makeExpression(String expression, int attIndex) {
        try {
            ExpressionContext env = this.staticContext;
            if (attIndex >= 0) {
                StructuredQName attName = this.getAttributeList().getNodeName(attIndex).getStructuredQName();
                env = this.getStaticContext(attName);
            }
            return ExpressionTool.make(expression, env, 0, 0, this.getCompilation().getCompilerInfo().getCodeInjector());
        }
        catch (XPathException err) {
            err.maybeSetLocation(this.allocateLocation());
            if (err.isReportableStatically()) {
                this.compileError(err);
            }
            ErrorExpression erexp = new ErrorExpression(err);
            erexp.setRetainedStaticContext(this.makeRetainedStaticContext());
            erexp.setLocation(this.allocateLocation());
            return erexp;
        }
    }

    public Pattern makePattern(String pattern, String attributeName) {
        try {
            ExpressionContext env = this.getStaticContext(new StructuredQName("", "", attributeName));
            Pattern p = Pattern.make(pattern, env, this.getCompilation().getPackageData());
            p.setLocation(this.allocateLocation());
            return p;
        }
        catch (XPathException err) {
            if ("XPST0003".equals(err.getErrorCodeLocalPart())) {
                err.setErrorCode("XTSE0340");
            }
            this.compileError(err);
            NodeTestPattern nsp = new NodeTestPattern(AnyNodeTest.getInstance());
            nsp.setLocation(this.allocateLocation());
            return nsp;
        }
    }

    protected Expression makeAttributeValueTemplate(String expression, int attIndex) {
        ExpressionContext env;
        ExpressionContext expressionContext = env = attIndex == -1 ? this.staticContext : this.getStaticContext(this.getAttributeList().getNodeName(attIndex).getStructuredQName());
        if (attIndex >= 0) {
            StructuredQName attName = this.getAttributeList().getNodeName(attIndex).getStructuredQName();
            env = this.getStaticContext(attName);
        }
        try {
            return AttributeValueTemplate.make(expression, env);
        }
        catch (XPathException err) {
            this.compileError(err);
            return new StringLiteral(expression);
        }
    }

    protected void checkAttributeValue(String name, String value, boolean avt, String[] allowed) {
        if (avt && value.contains("{")) {
            return;
        }
        if (Arrays.binarySearch(allowed, value) < 0) {
            FastStringBuffer sb = new FastStringBuffer(64);
            sb.append("Invalid value for ");
            sb.append("@");
            sb.append(name);
            sb.append(". Value must be one of (");
            for (int i = 0; i < allowed.length; ++i) {
                sb.append(i == 0 ? "" : "|");
                sb.append(allowed[i]);
            }
            sb.append(")");
            this.compileError(sb.toString(), "XTSE0020");
        }
    }

    public boolean processBooleanAttribute(String name, String value) {
        String s = Whitespace.trim(value);
        if (StyleElement.isYes(s)) {
            return true;
        }
        if (StyleElement.isNo(s)) {
            return false;
        }
        this.invalidAttribute(name, "yes|no | true|false | 1|0");
        return false;
    }

    static boolean isYes(String s) {
        return "yes".equals(s) || "true".equals(s) || "1".equals(s);
    }

    static boolean isNo(String s) {
        return "no".equals(s) || "false".equals(s) || "0".equals(s);
    }

    boolean processStreamableAtt(String streamableAtt) {
        boolean streamable = this.processBooleanAttribute("streamable", streamableAtt);
        if (streamable) {
            if (!this.getConfiguration().isLicensedFeature(2)) {
                this.compileWarning("Request for streaming ignored: this Saxon configuration does not support streaming", "SXST0068");
                return false;
            }
            if ("off".equals(this.getConfiguration().getConfigurationProperty(Feature.STREAMABILITY))) {
                this.compileWarning("Request for streaming ignored: streaming is disabled in this Saxon configuration", "SXST0068");
                return false;
            }
        }
        return streamable;
    }

    public SequenceType makeSequenceType(String sequenceType) throws XPathException {
        ExpressionContext env = this.getStaticContext();
        int languageLevel = env.getXPathVersion();
        if (languageLevel == 30) {
            languageLevel = 305;
        }
        XPathParser parser = this.getConfiguration().newExpressionParser("XP", false, languageLevel);
        QNameParser qp = new QNameParser(this.staticContext.getNamespaceResolver());
        qp.setAcceptEQName(this.staticContext.getXPathVersion() >= 30);
        qp.setDefaultNamespace("");
        qp.setErrorOnBadSyntax("XPST0003");
        qp.setErrorOnUnresolvedPrefix("XPST0081");
        parser.setQNameParser(qp);
        return parser.parseSequenceType(sequenceType, this.staticContext);
    }

    public SequenceType makeExtendedSequenceType(String sequenceType) throws XPathException {
        this.getStaticContext();
        XPathParser parser = this.getConfiguration().newExpressionParser("XP", false, 31);
        QNameParser qp = new QNameParser(this.staticContext.getNamespaceResolver());
        qp.setAcceptEQName(this.staticContext.getXPathVersion() >= 30);
        qp.setDefaultNamespace("");
        qp.setErrorOnBadSyntax("XPST0003");
        qp.setErrorOnUnresolvedPrefix("XPST0081");
        parser.setQNameParser(qp);
        return parser.parseExtendedSequenceType(sequenceType, this.staticContext);
    }

    protected void processExtensionElementAttribute(String ns) {
        String ext = this.getAttributeValue(ns, "extension-element-prefixes");
        if (ext != null) {
            int count = 0;
            StringTokenizer st1 = new StringTokenizer(ext, " \t\n\r", false);
            while (st1.hasMoreTokens()) {
                st1.nextToken();
                ++count;
            }
            this.extensionNamespaces = new String[count];
            count = 0;
            StringTokenizer st2 = new StringTokenizer(ext, " \t\n\r", false);
            while (st2.hasMoreTokens()) {
                String uri;
                String s = st2.nextToken();
                if ("#default".equals(s)) {
                    s = "";
                }
                if ((uri = this.getURIForPrefix(s, false)) == null) {
                    this.compileError("Namespace prefix " + s + " is undeclared", "XTSE1430");
                    this.extensionNamespaces[count++] = "http://saxon.sf.net/";
                    continue;
                }
                if (NamespaceConstant.isReserved(uri)) {
                    this.compileError("Namespace " + uri + " is reserved: it cannot be used for extension instructions (perhaps exclude-result-prefixes was intended).", "XTSE0085");
                    this.extensionNamespaces[count++] = "http://saxon.sf.net/";
                    continue;
                }
                this.extensionNamespaces[count++] = uri;
            }
        }
    }

    protected void processExcludedNamespaces(String ns) {
        String ext = this.getAttributeValue(ns, "exclude-result-prefixes");
        if (ext != null) {
            if ("#all".equals(Whitespace.trim(ext))) {
                Iterator<NamespaceBinding> codes = NamespaceIterator.iterateNamespaces(this);
                ArrayList<String> excluded = new ArrayList<String>();
                while (codes.hasNext()) {
                    excluded.add(codes.next().getURI());
                }
                this.excludedNamespaces = excluded.toArray(new String[0]);
            } else {
                int count = 0;
                StringTokenizer st1 = new StringTokenizer(ext, " \t\n\r", false);
                while (st1.hasMoreTokens()) {
                    st1.nextToken();
                    ++count;
                }
                this.excludedNamespaces = new String[count];
                count = 0;
                StringTokenizer st2 = new StringTokenizer(ext, " \t\n\r", false);
                while (st2.hasMoreTokens()) {
                    String s = st2.nextToken();
                    if ("#default".equals(s)) {
                        s = "";
                    } else if ("#all".equals(s)) {
                        this.compileError("In exclude-result-prefixes, cannot mix #all with other values", "XTSE0020");
                    }
                    String uri = this.getURIForPrefix(s, true);
                    if (uri == null) {
                        this.excludedNamespaces = null;
                        this.compileError("Namespace prefix " + s + " is not declared", "XTSE0808");
                        break;
                    }
                    this.excludedNamespaces[count++] = uri;
                    if (!s.isEmpty() || !uri.isEmpty()) continue;
                    this.compileError("Cannot exclude the #default namespace when no default namespace is declared", "XTSE0809");
                }
            }
        }
    }

    protected void processVersionAttribute(String ns) {
        String v = Whitespace.trim(this.getAttributeValue(ns, "version"));
        if (v != null) {
            ConversionResult val = BigDecimalValue.makeDecimalValue(v, true);
            if (val instanceof ValidationFailure) {
                this.version = 30;
                this.compileError("The version attribute must be a decimal literal", "XTSE0110");
            } else {
                this.version = ((BigDecimalValue)val).getDecimalValue().multiply(BigDecimal.TEN).intValue();
                if (this.version < 20 && this.version != 10) {
                    this.issueWarning("Unrecognized version " + val + ": treated as 1.0", this);
                    this.version = 10;
                } else if (this.version > 20 && this.version < 30) {
                    this.issueWarning("Unrecognized version " + val + ": treated as 2.0", this);
                    this.version = 20;
                }
            }
        }
    }

    public int getEffectiveVersion() {
        if (this.version == -1) {
            NodeImpl node = this.getParent();
            if (node instanceof StyleElement) {
                this.version = ((StyleElement)node).getEffectiveVersion();
            } else {
                return 20;
            }
        }
        return this.version;
    }

    public String getEffectiveVersionAsString() {
        return Double.toString(this.getEffectiveVersion() / 10);
    }

    protected int validateValidationAttribute(String value) {
        int code = Validation.getCode(value);
        if (code == -1) {
            String prefix = this instanceof LiteralResultElement ? "xsl:" : "";
            this.compileError("Invalid value of " + prefix + "validation attribute: '" + value + "'", "XTSE0020");
            code = this.getDefaultValidation();
        }
        if (!this.isSchemaAware()) {
            if (code == 1) {
                this.compileError("To perform validation, a schema-aware XSLT processor is needed", "XTSE1660");
            }
            code = 4;
        }
        return code;
    }

    public boolean forwardsCompatibleModeIsEnabled() {
        return this.getEffectiveVersion() > 30;
    }

    public boolean xPath10ModeIsEnabled() {
        return this.getEffectiveVersion() < 20;
    }

    protected void processDefaultCollationAttribute() throws XPathException {
        String ns = this.getURI().equals("http://www.w3.org/1999/XSL/Transform") ? "" : "http://www.w3.org/1999/XSL/Transform";
        String v = this.getAttributeValue(ns, "default-collation");
        StringBuilder reasons = new StringBuilder();
        if (v != null) {
            StringTokenizer st = new StringTokenizer(v, " \t\n\r", false);
            while (st.hasMoreTokens()) {
                String uri = st.nextToken();
                if (uri.equals("http://www.w3.org/2005/xpath-functions/collation/codepoint")) {
                    this.defaultCollationName = uri;
                    return;
                }
                try {
                    URI collationURI = new URI(uri);
                    if (!collationURI.isAbsolute()) {
                        URI base = new URI(this.getBaseURI());
                        collationURI = base.resolve(collationURI);
                        uri = collationURI.toString();
                    }
                }
                catch (URISyntaxException err) {
                    this.compileError("default collation '" + uri + "' is not a valid URI");
                    uri = "http://www.w3.org/2005/xpath-functions/collation/codepoint";
                }
                try {
                    if (this.getConfiguration().getCollation(uri) != null) {
                        this.defaultCollationName = uri;
                        return;
                    }
                    if (reasons.length() != 0) {
                        reasons.append("; ");
                    }
                    reasons.append("Collation ").append(uri).append(" is not recognized");
                }
                catch (XPathException e2) {
                    if (reasons.length() != 0) {
                        reasons.append("; ");
                    }
                    reasons.append("Collation ").append(uri).append(" is not recognized (").append(e2.getMessage()).append(")");
                }
            }
            String msg = "No recognized collation URI found in default-collation attribute";
            if (reasons.length() != 0) {
                msg = msg + ". ";
                msg = msg + reasons.toString();
            }
            this.compileErrorInAttribute(msg, "XTSE0125", new StructuredQName("", ns, "default-collation").getClarkName());
        }
    }

    protected String getDefaultCollationName() {
        StyleElement e2 = this;
        while (true) {
            if (e2.defaultCollationName != null) {
                return e2.defaultCollationName;
            }
            NodeImpl p = e2.getParent();
            if (!(p instanceof StyleElement)) break;
            e2 = (StyleElement)p;
        }
        return this.getConfiguration().getDefaultCollationName();
    }

    public StringCollator findCollation(String name, String baseURI) throws XPathException {
        return this.getConfiguration().getCollation(name, baseURI);
    }

    protected void processDefaultMode() throws XPathException {
        String ns = this.getURI().equals("http://www.w3.org/1999/XSL/Transform") ? "" : "http://www.w3.org/1999/XSL/Transform";
        String v = this.getAttributeValue(ns, "default-mode");
        if (v != null) {
            this.defaultMode = v.equals("#unnamed") ? Mode.UNNAMED_MODE_NAME : this.makeQName(v);
        }
        PrincipalStylesheetModule psm = this.compilation.getPrincipalStylesheetModule();
        StructuredQName checkedName = this.defaultMode;
        if (psm != null && psm.isDeclaredModes()) {
            psm.addFixupAction(() -> {
                if (psm.getRuleManager().obtainMode(checkedName, false) == null) {
                    XPathException err = new XPathException("Mode " + checkedName.getDisplayName() + " is not declared in an xsl:mode declaration", "XTSE3085");
                    err.setLocation(this);
                    throw err;
                }
            });
        }
    }

    public StructuredQName getDefaultMode() throws XPathException {
        if (this.defaultMode == null) {
            this.processDefaultMode();
            if (this.defaultMode == null) {
                NodeImpl p = this.getParent();
                if (p instanceof StyleElement) {
                    this.defaultMode = ((StyleElement)p).getDefaultMode();
                    return this.defaultMode;
                }
                this.defaultMode = Mode.UNNAMED_MODE_NAME;
                return this.defaultMode;
            }
        }
        return this.defaultMode;
    }

    protected boolean definesExtensionElement(String uri) {
        if (this.extensionNamespaces == null) {
            return false;
        }
        for (String extensionNamespace : this.extensionNamespaces) {
            if (!extensionNamespace.equals(uri)) continue;
            return true;
        }
        return false;
    }

    public boolean isExtensionNamespace(String uri) {
        NodeInfo anc = this;
        while (anc instanceof StyleElement) {
            if (anc.definesExtensionElement(uri)) {
                return true;
            }
            anc = anc.getParent();
        }
        return false;
    }

    protected boolean definesExcludedNamespace(String uri) {
        if (this.excludedNamespaces == null) {
            return false;
        }
        for (String excludedNamespace : this.excludedNamespaces) {
            if (!excludedNamespace.equals(uri)) continue;
            return true;
        }
        return false;
    }

    public boolean isExcludedNamespace(String uri) {
        if (uri.equals("http://www.w3.org/1999/XSL/Transform") || uri.equals("http://www.w3.org/XML/1998/namespace")) {
            return true;
        }
        if (this.isExtensionNamespace(uri)) {
            return true;
        }
        NodeInfo anc = this;
        while (anc instanceof StyleElement) {
            if (anc.definesExcludedNamespace(uri)) {
                return true;
            }
            anc = anc.getParent();
        }
        return false;
    }

    protected void processDefaultXPathNamespaceAttribute(String ns) {
        String v = this.getAttributeValue(ns, "xpath-default-namespace");
        if (v != null) {
            this.defaultXPathNamespace = v;
        }
    }

    public String getDefaultXPathNamespace() {
        NodeInfo anc = this;
        while (anc instanceof StyleElement) {
            String x = anc.defaultXPathNamespace;
            if (x != null) {
                return x;
            }
            anc = anc.getParent();
        }
        return "";
    }

    protected void processExpandTextAttribute(String ns) {
        NodeImpl parent;
        String v = this.getAttributeValue(ns, "expand-text");
        this.expandText = v != null ? this.processBooleanAttribute("expand-text", v) : (parent = this.getParent()) instanceof StyleElement && ((StyleElement)parent).expandText;
    }

    protected void processDefaultValidationAttribute(String ns) {
        String v = this.getAttributeValue(ns, "default-validation");
        if (v != null) {
            int val = Validation.getCode(v);
            if (val == 4 || val == 3) {
                this.defaultValidation = val;
            } else {
                this.compileErrorInAttribute("@default-validation must be preserve|strip", "XTSE0020", "default-validation");
            }
        }
    }

    public boolean isExpandingText() {
        return this.expandText;
    }

    public SchemaType getSchemaType(String typeAtt) throws XPathException {
        try {
            String lname;
            String uri;
            if (typeAtt.startsWith("Q{")) {
                StructuredQName q = this.makeQName(typeAtt);
                uri = q.getURI();
                lname = q.getLocalPart();
            } else {
                String[] parts = NameChecker.getQNameParts(typeAtt);
                lname = parts[1];
                if ("".equals(parts[0])) {
                    uri = this.getDefaultXPathNamespace();
                } else {
                    uri = this.getURIForPrefix(parts[0], false);
                    if (uri == null) {
                        this.compileError("Namespace prefix for type annotation is undeclared", "XTSE1520");
                        return null;
                    }
                }
            }
            if (uri.equals("http://www.w3.org/2001/XMLSchema")) {
                SchemaType t = BuiltInType.getSchemaTypeByLocalName(lname);
                if (t == null) {
                    this.compileError("Unknown built-in type " + typeAtt, "XTSE1520");
                    return null;
                }
                return t;
            }
            if (!this.getPrincipalStylesheetModule().isImportedSchema(uri)) {
                this.compileError("There is no imported schema for the namespace of type " + typeAtt, "XTSE1520");
                return null;
            }
            StructuredQName qName = new StructuredQName("", uri, lname);
            SchemaType stype = this.getConfiguration().getSchemaType(qName);
            if (stype == null) {
                this.compileError("There is no type named " + typeAtt + " in an imported schema", "XTSE1520");
            }
            return stype;
        }
        catch (QNameException err) {
            this.compileError("Invalid type name. " + err.getMessage(), "XTSE1520");
            return null;
        }
    }

    public SimpleType getTypeAnnotation(SchemaType schemaType) {
        return (SimpleType)schemaType;
    }

    public void validate(ComponentDeclaration decl) throws XPathException {
    }

    public void postValidate() throws XPathException {
    }

    public void index(ComponentDeclaration decl, PrincipalStylesheetModule top) throws XPathException {
    }

    public Expression typeCheck(String name, Expression exp) throws XPathException {
        if (exp == null) {
            return null;
        }
        Configuration config = this.getConfiguration();
        if (config.getBooleanProperty(Feature.STRICT_STREAMABILITY)) {
            return exp;
        }
        try {
            exp = exp.typeCheck(this.makeExpressionVisitor(), config.makeContextItemStaticInfo(Type.ITEM_TYPE, true));
            exp = ExpressionTool.resolveCallsToCurrentFunction(exp);
            CodeInjector injector = this.getCompilation().getCompilerInfo().getCodeInjector();
            if (injector != null) {
                return injector.inject(exp, this.getStaticContext(), 2011, new StructuredQName("", "", name));
            }
            return exp;
        }
        catch (XPathException err) {
            if (err.isReportableStatically()) {
                err.setLocation(new AttributeLocation(this, StructuredQName.fromClarkName(name)));
                this.compileError(err);
                return exp;
            }
            ErrorExpression erexp = new ErrorExpression(err);
            erexp.setLocation(this.allocateLocation());
            return erexp;
        }
    }

    public void allocateLocalSlots(Expression exp) {
        SlotManager slotManager = this.getContainingSlotManager();
        if (slotManager == null) {
            throw new AssertionError((Object)"Slot manager has not been allocated");
        }
        int firstSlot = slotManager.getNumberOfVariables();
        int highWater = ExpressionTool.allocateSlots(exp, firstSlot, slotManager);
        if (highWater > firstSlot) {
            slotManager.setNumberOfVariables(highWater);
        }
    }

    public Pattern typeCheck(String name, Pattern pattern) throws XPathException {
        if (pattern == null) {
            return null;
        }
        try {
            ItemType cit = Type.ITEM_TYPE;
            pattern = pattern.typeCheck(this.makeExpressionVisitor(), this.getConfiguration().makeContextItemStaticInfo(cit, true));
            boolean usesCurrent = false;
            for (Operand o : pattern.operands()) {
                Expression filter = o.getChildExpression();
                if (!ExpressionTool.callsFunction(filter, Current.FN_CURRENT, false)) continue;
                usesCurrent = true;
                break;
            }
            if (usesCurrent) {
                PatternThatSetsCurrent p2 = new PatternThatSetsCurrent(pattern);
                pattern.bindCurrent(p2.getCurrentBinding());
                pattern = p2;
            }
            return pattern;
        }
        catch (XPathException err) {
            if (err.isReportableStatically()) {
                XPathException e2 = new XPathException("Error in " + name + " pattern", err);
                e2.setLocator(this);
                e2.setErrorCodeQName(err.getErrorCodeQName());
                throw e2;
            }
            BasePatternWithPredicate p = new BasePatternWithPredicate(new NodeTestPattern(ErrorType.getInstance()), new ErrorExpression(err));
            p.setLocation(this.allocateLocation());
            return p;
        }
    }

    public void fixupReferences() throws XPathException {
        this.iterateAxis((byte)3).forEachOrFail(child -> {
            if (child instanceof StyleElement) {
                ((StyleElement)child).fixupReferences();
            }
        });
    }

    public SlotManager getContainingSlotManager() {
        NodeImpl node = this;
        while (true) {
            NodeImpl next = node.getParent();
            assert (next != null);
            if (next instanceof XSLModuleRoot || next.getFingerprint() == 186) {
                if (node instanceof StylesheetComponent) {
                    return ((StylesheetComponent)((Object)node)).getSlotManager();
                }
                return null;
            }
            node = next;
        }
    }

    public void validateSubtree(ComponentDeclaration decl, boolean excludeStylesheet) throws XPathException {
        if (this.isActionCompleted(1)) {
            return;
        }
        this.setActionCompleted(1);
        if (this.validationError != null) {
            if (this.reportingCircumstances == 1) {
                this.compileError(this.validationError);
            } else if (this.reportingCircumstances == 2 && !this.forwardsCompatibleModeIsEnabled()) {
                this.compileError(this.validationError);
            } else if (this.reportingCircumstances == 4) {
                NodeInfo child2;
                boolean hasFallback = false;
                AxisIterator kids = this.iterateAxis((byte)3);
                while ((child2 = kids.next()) != null) {
                    if (!(child2 instanceof XSLFallback)) continue;
                    hasFallback = true;
                    ((XSLFallback)child2).validateSubtree(decl, false);
                }
                if (!hasFallback) {
                    this.compileError(this.validationError);
                }
            } else if (this.reportingCircumstances == 5) {
                this.iterateAxis((byte)3).forEachOrFail(child -> {
                    if (child instanceof XSLFallback) {
                        ((XSLFallback)child).validateSubtree(decl, false);
                    }
                });
            }
        } else {
            try {
                this.validate(decl);
            }
            catch (XPathException err) {
                this.compileError(err);
            }
            this.validateChildren(decl, excludeStylesheet);
            if (this.getCompilation().getErrorCount() == 0) {
                this.postValidate();
            }
        }
    }

    protected void validateChildren(ComponentDeclaration decl, boolean excludeStylesheet) throws XPathException {
        NodeInfo child;
        boolean containsInstructions = this.mayContainSequenceConstructor();
        AxisIterator kids = this.iterateAxis((byte)3);
        StyleElement lastChild = null;
        boolean endsWithTextTemplate = false;
        while ((child = kids.next()) != null) {
            if (child instanceof StyleElement) {
                if (excludeStylesheet && child instanceof XSLStylesheet) continue;
                endsWithTextTemplate = false;
                if (containsInstructions && !((StyleElement)child).isInstruction() && !this.isPermittedChild((StyleElement)child)) {
                    ((StyleElement)child).compileError("An " + this.getDisplayName() + " element must not contain an " + child.getDisplayName() + " element", "XTSE0010");
                }
                ((StyleElement)child).validateSubtree(decl, excludeStylesheet);
                lastChild = (StyleElement)child;
                continue;
            }
            endsWithTextTemplate = this.examineTextNode(child);
        }
        if (lastChild instanceof XSLLocalVariable && !(this instanceof XSLStylesheet) && !endsWithTextTemplate) {
            lastChild.compileWarning("A variable with no following sibling instructions has no effect", "SXWN9001");
        }
    }

    private boolean examineTextNode(NodeInfo node) throws XPathException {
        if (node instanceof TextValueTemplateNode) {
            ((TextValueTemplateNode)node).validate();
            return !(((TextValueTemplateNode)node).getContentExpression() instanceof Literal);
        }
        return false;
    }

    protected boolean isPermittedChild(StyleElement child) {
        return false;
    }

    public PrincipalStylesheetModule getPrincipalStylesheetModule() {
        return this.getCompilation().getPrincipalStylesheetModule();
    }

    public StylesheetPackage getContainingPackage() {
        PrincipalStylesheetModule psm = this.getPrincipalStylesheetModule();
        return psm == null ? null : psm.getStylesheetPackage();
    }

    protected void checkSortComesFirst(boolean sortRequired) {
        NodeInfo child;
        AxisIterator kids = this.iterateAxis((byte)3);
        boolean sortFound = false;
        boolean nonSortFound = false;
        while ((child = kids.next()) != null) {
            if (child instanceof XSLSort) {
                if (nonSortFound) {
                    ((XSLSort)child).compileError("Within " + this.getDisplayName() + ", xsl:sort elements must come before other instructions", "XTSE0010");
                }
                sortFound = true;
                continue;
            }
            if (child.getNodeKind() == 3) {
                if (Whitespace.isWhite(child.getStringValueCS())) continue;
                nonSortFound = true;
                continue;
            }
            nonSortFound = true;
        }
        if (sortRequired && !sortFound) {
            this.compileError(this.getDisplayName() + " must have at least one xsl:sort child", "XTSE0010");
        }
    }

    public void checkTopLevel(String errorCode, boolean allowOverride) {
        NodeImpl parent = this.getParent();
        assert (parent != null);
        if (parent.getFingerprint() == 186) {
            if (!allowOverride) {
                this.compileError("Element " + this.getDisplayName() + " is not allowed as a child of xsl:override");
            }
        } else if (!this.isTopLevel()) {
            this.compileError("Element " + this.getDisplayName() + " must be top-level (a child of xsl:stylesheet, xsl:transform, or xsl:package)", errorCode);
        }
    }

    public void checkEmpty() {
        if (this.hasChildNodes()) {
            this.compileError("Element must be empty", "XTSE0260");
        }
    }

    public void reportAbsence(String attribute) {
        this.compileError("Element must have an " + Err.wrap(attribute, 2) + " attribute", "XTSE0010");
    }

    public Expression compile(Compilation compilation, ComponentDeclaration decl) throws XPathException {
        return null;
    }

    protected boolean isWithinDeclaredStreamableConstruct() {
        String streamableAtt = this.getAttributeValue("streamable");
        if (streamableAtt != null) {
            return this.processStreamableAtt(streamableAtt);
        }
        NodeImpl parent = this.getParent();
        return parent instanceof StyleElement && ((StyleElement)parent).isWithinDeclaredStreamableConstruct();
    }

    protected String generateId() {
        FastStringBuffer buff = new FastStringBuffer(16);
        this.generateId(buff);
        return buff.toString();
    }

    public void compileDeclaration(Compilation compilation, ComponentDeclaration decl) throws XPathException {
    }

    public Expression compileSequenceConstructor(Compilation compilation, ComponentDeclaration decl, boolean includeParams) throws XPathException {
        NodeInfo child;
        boolean containsEmptyTest = false;
        boolean containsLocalVariable = false;
        AxisIterator kids = this.iterateAxis((byte)3);
        while ((child = kids.next()) != null) {
            int fp = child.getFingerprint();
            if (fp == 206) {
                containsLocalVariable = true;
            }
            if (fp != 183 && fp != 184) continue;
            containsEmptyTest = true;
        }
        if (containsEmptyTest) {
            ArrayList vars = new ArrayList();
            ArrayList onEmpties = new ArrayList();
            ArrayList others = new ArrayList();
            this.iterateAxis((byte)3).forEach((T kid) -> {
                int fp = kid.getFingerprint();
                if (fp == 206 || fp == 189) {
                    vars.add(kid);
                } else if (fp == 183) {
                    onEmpties.add(kid);
                } else {
                    others.add(kid);
                }
            });
            vars.addAll(others);
            vars.addAll(onEmpties);
            return this.compileSequenceConstructor(compilation, decl, new ListIterator(vars), includeParams);
        }
        return this.compileSequenceConstructor(compilation, decl, this.iterateAxis((byte)3), includeParams);
    }

    public Expression compileSequenceConstructor(Compilation compilation, ComponentDeclaration decl, SequenceIterator iter, boolean includeParams) throws XPathException {
        NodeInfo node;
        Location locationId = this.allocateLocation();
        ArrayList<Expression> contents = new ArrayList<Expression>(10);
        boolean containsSpecials = false;
        while ((node = (NodeInfo)iter.next()) != null) {
            Expression child;
            if (node.getNodeKind() == 3) {
                if (this.isExpandingText()) {
                    this.compileContentValueTemplate((TextImpl)node, contents);
                    continue;
                }
                AxisIterator lookahead = node.iterateAxis((byte)7);
                NodeInfo sibling = lookahead.next();
                if (sibling instanceof XSLLocalParam || sibling instanceof XSLSort || sibling instanceof XSLContextItem || sibling instanceof XSLOnCompletion) continue;
                Expression text = new ValueOf(new StringLiteral(node.getStringValue()), false, false);
                text.setLocation(this.allocateLocation());
                CodeInjector injector = this.getCompilation().getCompilerInfo().getCodeInjector();
                if (injector != null) {
                    Expression tracer = injector.inject(text, this.getStaticContext(), 201, null);
                    tracer.setLocation(text.getLocation());
                    text = tracer;
                }
                contents.add(text);
                continue;
            }
            if (node instanceof XSLLocalVariable) {
                XSLLocalVariable var = (XSLLocalVariable)node;
                SourceBinding sourceBinding = var.getSourceBinding();
                var.compileLocalVariable(compilation, decl);
                Expression tail = this.compileSequenceConstructor(compilation, decl, iter, includeParams);
                if (tail == null || Literal.isEmptySequence(tail)) continue;
                LetExpression let = new LetExpression();
                let.setInstruction(true);
                let.setRequiredType(var.getRequiredType());
                let.setVariableQName(sourceBinding.getVariableQName());
                let.setSequence(sourceBinding.getSelectExpression());
                let.setAction(tail);
                sourceBinding.fixupBinding(let);
                locationId = ((StyleElement)node).allocateLocation();
                let.setLocation(locationId);
                if (this.getCompilation().getCompilerInfo().isCompileWithTracing()) {
                    TraceExpression t = new TraceExpression(let);
                    t.setConstructType(2013);
                    t.setObjectName(var.getSourceBinding().getVariableQName());
                    t.setNamespaceResolver(this.getNamespaceResolver());
                    contents.add(t);
                } else {
                    contents.add(let);
                }
                if (!var.changesRetainedStaticContext()) continue;
                let.setRetainedStaticContext(this.makeRetainedStaticContext());
                continue;
            }
            if (!(node instanceof StyleElement)) continue;
            StyleElement snode = (StyleElement)node;
            int fp = snode.getFingerprint();
            if (fp == 183 || fp == 184) {
                containsSpecials = true;
            }
            if (snode.validationError != null && !(snode instanceof AbsentExtensionElement)) {
                child = snode.reportingCircumstances == 3 ? new ErrorExpression(snode.validationError) : this.fallbackProcessing(compilation, decl, snode);
            } else {
                child = snode.compile(compilation, decl);
                if (child != null) {
                    if (snode.changesRetainedStaticContext()) {
                        child.setRetainedStaticContext(snode.makeRetainedStaticContext());
                    }
                    if ((includeParams || !(node instanceof XSLLocalParam)) && this.getCompilation().getCompilerInfo().isCompileWithTracing()) {
                        child = StyleElement.makeTraceInstruction(snode, child);
                    }
                }
            }
            if (child == null) continue;
            contents.add(child);
        }
        if (containsSpecials) {
            return new ConditionalBlock(contents);
        }
        Expression block = Block.makeBlock(contents);
        if (block.getLocation() == null) {
            block.setLocation(locationId);
        }
        if (block.getLocalRetainedStaticContext() == null) {
            block.setRetainedStaticContext(this.makeRetainedStaticContext());
        }
        return block;
    }

    public void compileContentValueTemplate(TextImpl node, List<Expression> contents) {
        if (node instanceof TextValueTemplateNode) {
            Expression exp = ((TextValueTemplateNode)node).getContentExpression();
            if (this.getConfiguration().getBooleanProperty(Feature.STRICT_STREAMABILITY) && !(exp instanceof Literal)) {
                exp = new SequenceInstr(exp);
            }
            contents.add(exp);
        } else {
            contents.add(new StringLiteral(node.getStringValue()));
        }
    }

    protected static Expression makeTraceInstruction(StyleElement source, Expression child) {
        if (child instanceof TraceExpression && !(source instanceof StylesheetComponent)) {
            return child;
        }
        if (source instanceof XSLOnEmpty || source instanceof XSLOnNonEmpty) {
            return child;
        }
        CodeInjector injector = source.getCompilation().getCompilerInfo().getCodeInjector();
        if (injector != null) {
            int construct = source.getFingerprint();
            if (source instanceof LiteralResultElement) {
                construct = 2006;
            }
            Expression tracer = injector.inject(child, source.getStaticContext(), construct, source.getObjectName());
            tracer.setLocation(source.allocateLocation());
            return tracer;
        }
        return child;
    }

    protected Expression fallbackProcessing(Compilation exec, ComponentDeclaration decl, StyleElement instruction) throws XPathException {
        NodeInfo child;
        Expression fallback = null;
        AxisIterator kids = instruction.iterateAxis((byte)3);
        while ((child = kids.next()) != null) {
            if (!(child instanceof XSLFallback)) continue;
            Expression b = ((XSLFallback)child).compileSequenceConstructor(exec, decl, true);
            if (b == null) {
                b = Literal.makeEmptySequence();
            }
            if (fallback == null) {
                fallback = b;
                continue;
            }
            fallback = Block.makeBlock(fallback, b);
            fallback.setLocation(this.allocateLocation());
        }
        if (fallback != null) {
            return fallback;
        }
        return new ErrorExpression(instruction.validationError);
    }

    protected Location allocateLocation() {
        if (this.savedLocation == null) {
            this.savedLocation = new ExplicitLocation(this);
        }
        return this.savedLocation;
    }

    public SortKeyDefinitionList makeSortKeys(Compilation compilation, ComponentDeclaration decl) throws XPathException {
        NodeInfo child;
        int numberOfSortKeys = 0;
        AxisIterator kids = this.iterateAxis((byte)3);
        while ((child = kids.next()) != null) {
            if (!(child instanceof XSLSortOrMergeKey)) continue;
            ((XSLSortOrMergeKey)child).compile(compilation, decl);
            if (child instanceof XSLSort && numberOfSortKeys != 0 && ((XSLSort)child).getStable() != null) {
                this.compileError("stable attribute may appear only on the first xsl:sort element", "XTSE1017");
            }
            ++numberOfSortKeys;
        }
        if (numberOfSortKeys > 0) {
            SortKeyDefinition[] keys = new SortKeyDefinition[numberOfSortKeys];
            kids = this.iterateAxis((byte)3);
            int k = 0;
            while ((child = kids.next()) != null) {
                if (!(child instanceof XSLSortOrMergeKey)) continue;
                keys[k++] = (SortKeyDefinition)((XSLSortOrMergeKey)child).getSortKeyDefinition().simplify();
            }
            return new SortKeyDefinitionList(keys);
        }
        return null;
    }

    protected StructuredQName[] getUsedAttributeSets(String use) {
        ArrayList<StructuredQName> nameList = new ArrayList<StructuredQName>(4);
        StringTokenizer st = new StringTokenizer(use, " \t\n\r", false);
        while (st.hasMoreTokens()) {
            StructuredQName name;
            String asetname = st.nextToken();
            try {
                name = this.makeQName(asetname);
            }
            catch (XPathException err) {
                this.compileError(err.getMessage(), "XTSE0710");
                name = null;
            }
            nameList.add(name);
        }
        return nameList.toArray(new StructuredQName[0]);
    }

    protected Visibility interpretVisibilityValue(String s, String flags) {
        for (Visibility v : Visibility.values()) {
            if (!v.visibilityStr.equals(s) || !flags.contains("h") && s.equals("hidden") || !flags.contains("a") && s.equals("absent")) continue;
            return v;
        }
        this.invalidAttribute("visibility", "public|final|private|abstract" + (flags.contains("h") ? "|hidden" : "") + (flags.contains("a") ? "|absent" : ""));
        return null;
    }

    public WithParam[] getWithParamInstructions(Expression parent, Compilation compilation, ComponentDeclaration decl, boolean tunnel) throws XPathException {
        NodeInfo child;
        int count = 0;
        AxisIterator kids = this.iterateAxis((byte)3);
        while ((child = kids.next()) != null) {
            XSLWithParam wp;
            if (!(child instanceof XSLWithParam) || (wp = (XSLWithParam)child).getSourceBinding().hasProperty(8) != tunnel) continue;
            ++count;
        }
        if (count == 0) {
            return WithParam.EMPTY_ARRAY;
        }
        WithParam[] array = new WithParam[count];
        count = 0;
        kids = this.iterateAxis((byte)3);
        while ((child = kids.next()) != null) {
            XSLWithParam wp;
            if (!(child instanceof XSLWithParam) || (wp = (XSLWithParam)child).getSourceBinding().hasProperty(8) != tunnel) continue;
            WithParam p = wp.compileWithParam(parent, compilation, decl);
            array[count++] = p;
        }
        return array;
    }

    public void compileError(XPathException error) {
        Location container2;
        error.setIsStaticError(true);
        if (error.getLocator() == null || (error.getLocator() instanceof ExplicitLocation || error.getLocator() instanceof Expression) && !(this instanceof StylesheetComponent)) {
            error.setLocator(this);
        }
        if (error.getLocator() instanceof AttributeLocation) {
            ((AttributeLocation)error.getLocator()).setElementNode(this);
        }
        if (error.getLocator() instanceof XPathParser.NestedLocation && (container2 = ((XPathParser.NestedLocation)error.getLocator()).getContainingLocation()) instanceof AttributeLocation) {
            ((AttributeLocation)container2).setElementNode(this);
        }
        this.getCompilation().reportError(error);
    }

    public void compileError(String message) {
        this.compileError(message, "XTSE0010");
    }

    public void compileError(String message, StructuredQName errorCode) {
        XPathException tce = new XPathException(message);
        tce.setErrorCodeQName(errorCode);
        tce.setLocator(this);
        this.compileError(tce);
    }

    public void compileError(String message, String errorCode) {
        this.compileError(new XPathException(message, errorCode, this));
    }

    public void compileErrorInAttribute(String message, String errorCode, String attributeName) {
        StructuredQName att = StructuredQName.fromClarkName(attributeName);
        AttributeLocation location = new AttributeLocation(this, att);
        this.compileError(new XPathException(message, errorCode, location));
    }

    protected void invalidAttribute(String attributeName, String allowedValues) {
        this.compileErrorInAttribute("Attribute " + this.getDisplayName() + "/@" + attributeName + " must be " + allowedValues, "XTSE0020", attributeName);
    }

    protected void undeclaredNamespaceError(String prefix, String errorCode, String attributeName) {
        if (errorCode == null) {
            errorCode = "XTSE0280";
        }
        this.compileErrorInAttribute("Undeclared namespace prefix " + Err.wrap(prefix), errorCode, attributeName);
    }

    public void compileWarning(String message, StructuredQName errorCode) {
        XPathException tce = new XPathException(message);
        tce.setErrorCodeQName(errorCode);
        tce.setLocator(this);
        this.getCompilation().reportWarning(tce);
    }

    public void compileWarning(String message, String errorCode) {
        XPathException tce = new XPathException(message);
        tce.setErrorCode(errorCode);
        tce.setLocator(this);
        this.getCompilation().reportWarning(tce);
    }

    protected void issueWarning(XPathException error) {
        if (error.getLocator() == null) {
            error.setLocator(this);
        }
        this.getCompilation().reportWarning(error);
    }

    protected void issueWarning(String message, SourceLocator locator) {
        XPathException tce = new XPathException(message);
        if (locator == null) {
            tce.setLocator(this);
        } else {
            tce.setLocator(locator);
        }
        this.issueWarning(tce);
    }

    public boolean isTopLevel() {
        return this.getParent() instanceof XSLModuleRoot;
    }

    public boolean isConstructingComplexContent() {
        if (!this.isInstruction()) {
            return false;
        }
        NodeInfo parent = this.getParent();
        while (parent instanceof StyleElement && ((StyleElement)parent).isInstruction()) {
            if (parent instanceof XSLGeneralVariable) {
                return ((XSLGeneralVariable)parent).getAttributeValue("as") == null;
            }
            if (parent instanceof XSLElement || parent instanceof LiteralResultElement || parent instanceof XSLDocument || parent instanceof XSLCopy) {
                return true;
            }
            parent = parent.getParent();
        }
        return false;
    }

    public SourceBinding getBindingInformation(StructuredQName name) {
        return null;
    }

    public SourceBinding bindVariable(StructuredQName qName) {
        SourceBinding decl = this.bindLocalVariable(qName);
        if (decl != null) {
            return decl;
        }
        SourceBinding binding = this.getPrincipalStylesheetModule().getGlobalVariableBinding(qName);
        if (binding == null || Navigator.isAncestorOrSelf(binding.getSourceElement(), this)) {
            return null;
        }
        return binding;
    }

    public SourceBinding bindLocalVariable(StructuredQName qName) {
        block6: {
            NodeInfo curr = this;
            NodeInfo prev = this;
            SourceBinding implicit = this.hasImplicitBinding(qName);
            if (implicit != null) {
                return implicit;
            }
            if (!this.isTopLevel()) {
                SourceBinding sourceBinding;
                AxisIterator preceding = curr.iterateAxis((byte)11);
                do {
                    curr = preceding.next();
                    while (curr == null) {
                        curr = prev.getParent();
                        if (curr instanceof StyleElement && (implicit = ((StyleElement)curr).hasImplicitBinding(qName)) != null) {
                            return implicit;
                        }
                        while (curr instanceof StyleElement && !((StyleElement)curr).seesAvuncularVariables()) {
                            curr = curr.getParent();
                        }
                        prev = curr;
                        if (curr.getParent() instanceof XSLModuleRoot) break;
                        preceding = curr.iterateAxis((byte)11);
                        curr = preceding.next();
                    }
                    if (curr.getParent() instanceof XSLModuleRoot) break block6;
                } while (!(curr instanceof XSLGeneralVariable) || (sourceBinding = ((XSLGeneralVariable)curr).getBindingInformation(qName)) == null);
                return sourceBinding;
            }
        }
        return null;
    }

    protected boolean seesAvuncularVariables() {
        return true;
    }

    protected SourceBinding hasImplicitBinding(StructuredQName name) {
        return null;
    }

    public int getConstructType() {
        return this.getFingerprint();
    }

    public StructuredQName getObjectName() {
        return this.objectName;
    }

    public void setObjectName(StructuredQName qName) {
        this.objectName = qName;
    }

    public Object getProperty(String name) {
        return this.getAttributeValue("", name);
    }

    public Iterator<String> getProperties() {
        ArrayList list = new ArrayList(10);
        this.iterateAxis((byte)2).forEach((T a) -> list.add(NameOfNode.makeName(a).getStructuredQName().getClarkName()));
        return list.iterator();
    }

    public boolean isActionCompleted(int action) {
        return (this.actionsCompleted & action) != 0;
    }

    public void setActionCompleted(int action) {
        this.actionsCompleted |= action;
    }
}

