/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.tree.linked;

import net.sf.saxon.event.Receiver;
import net.sf.saxon.expr.parser.Location;
import net.sf.saxon.om.AttributeCollection;
import net.sf.saxon.om.CopyOptions;
import net.sf.saxon.om.NameOfNode;
import net.sf.saxon.om.NamespaceBinding;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.NodeName;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.linked.ElementImpl;
import net.sf.saxon.tree.linked.NodeImpl;
import net.sf.saxon.tree.linked.ParentNodeImpl;
import net.sf.saxon.tree.util.AttributeCollectionImpl;
import net.sf.saxon.tree.util.FastStringBuffer;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.MissingComponentException;
import net.sf.saxon.type.SchemaType;
import net.sf.saxon.type.SimpleType;

public class AttributeImpl
extends NodeImpl {
    public AttributeImpl(ElementImpl element, int index) {
        this.setRawParent(element);
        this.setSiblingPosition(index);
    }

    @Override
    public NodeName getNodeName() {
        if (this.getRawParent() == null || this.getSiblingPosition() == -1) {
            return null;
        }
        return ((ElementImpl)this.getRawParent()).getAttributeList().getNodeName(this.getSiblingPosition());
    }

    @Override
    public int getFingerprint() {
        if (this.getRawParent() == null || this.getSiblingPosition() == -1) {
            return -1;
        }
        return ((ElementImpl)this.getRawParent()).getAttributeList().getFingerprint(this.getSiblingPosition());
    }

    @Override
    public SchemaType getSchemaType() {
        return ((ElementImpl)this.getRawParent()).getAttributeList().getTypeAnnotation(this.getSiblingPosition());
    }

    @Override
    public boolean isId() {
        try {
            return this.getFingerprint() == 388 || this.getSchemaType().isIdType();
        }
        catch (MissingComponentException e2) {
            return false;
        }
    }

    @Override
    public boolean isIdref() {
        AttributeCollection alist = ((ElementImpl)this.getRawParent()).getAttributeList();
        if ((alist.getProperties(this.getSiblingPosition()) & 0x1000) != 0) {
            return true;
        }
        try {
            return this.getSchemaType().isIdRefType();
        }
        catch (MissingComponentException e2) {
            return false;
        }
    }

    @Override
    public boolean equals(Object other) {
        if (!(other instanceof AttributeImpl)) {
            return false;
        }
        if (this == other) {
            return true;
        }
        AttributeImpl otherAtt = (AttributeImpl)other;
        return this.getRawParent().equals(otherAtt.getRawParent()) && this.getSiblingPosition() == otherAtt.getSiblingPosition();
    }

    @Override
    public int hashCode() {
        return this.getRawParent().hashCode() ^ this.getSiblingPosition() << 16;
    }

    @Override
    protected long getSequenceNumber() {
        long parseq = this.getRawParent().getSequenceNumber();
        return parseq == -1L ? parseq : parseq + 32768L + (long)this.getSiblingPosition();
    }

    @Override
    public final int getNodeKind() {
        return 2;
    }

    @Override
    public String getStringValue() {
        return ((ElementImpl)this.getRawParent()).getAttributeList().getValue(this.getSiblingPosition());
    }

    @Override
    public NodeImpl getNextSibling() {
        return null;
    }

    @Override
    public NodeImpl getPreviousSibling() {
        return null;
    }

    @Override
    public NodeImpl getPreviousInDocument() {
        return this.getParent();
    }

    @Override
    public NodeImpl getNextInDocument(NodeImpl anchor) {
        if (anchor == this) {
            return null;
        }
        return this.getParent().getNextInDocument(anchor);
    }

    @Override
    public void generateId(FastStringBuffer buffer) {
        this.getParent().generateId(buffer);
        buffer.append('a');
        buffer.append(Integer.toString(this.getSiblingPosition()));
    }

    @Override
    public void copy(Receiver out, int copyOptions, Location locationId) throws XPathException {
        BuiltInAtomicType typeCode = CopyOptions.includes(copyOptions, 4) ? (SimpleType)this.getSchemaType() : BuiltInAtomicType.UNTYPED_ATOMIC;
        out.attribute(NameOfNode.makeName(this), typeCode, this.getStringValue(), locationId, 0);
    }

    @Override
    public void delete() {
        if (this.getRawParent() != null) {
            this.getRawParent().removeAttribute(this);
        }
        this.setRawParent(null);
        this.setSiblingPosition(-1);
    }

    @Override
    public boolean isDeleted() {
        return this.getSiblingPosition() == -1 || this.getFingerprint() == -1 || this.getRawParent() != null && this.getRawParent().isDeleted();
    }

    @Override
    public void replace(NodeInfo[] replacement, boolean inherit) {
        if (this.isDeleted()) {
            throw new IllegalStateException("Cannot replace a deleted node");
        }
        if (this.getParent() == null) {
            throw new IllegalStateException("Cannot replace a parentless node");
        }
        ParentNodeImpl element = this.getRawParent();
        this.delete();
        for (NodeInfo n : replacement) {
            if (n.getNodeKind() != 2) {
                throw new IllegalArgumentException("Replacement nodes must be attributes");
            }
            element.addAttribute(NameOfNode.makeName(n), BuiltInAtomicType.UNTYPED_ATOMIC, n.getStringValue(), 0);
        }
    }

    @Override
    public void rename(NodeName newNameCode) {
        if (this.getRawParent() != null) {
            ((AttributeCollectionImpl)((ElementImpl)this.getRawParent()).getAttributeList()).renameAttribute(this.getSiblingPosition(), newNameCode);
            String newURI = newNameCode.getURI();
            if (!newURI.isEmpty()) {
                String newPrefix = newNameCode.getPrefix();
                NamespaceBinding newBinding = new NamespaceBinding(newPrefix, newURI);
                String oldURI = ((ElementImpl)this.getRawParent()).getURIForPrefix(newPrefix, false);
                if (oldURI == null) {
                    this.getRawParent().addNamespace(newBinding, false);
                } else if (!oldURI.equals(newURI)) {
                    throw new IllegalArgumentException("Namespace binding of new name conflicts with existing namespace binding");
                }
            }
        }
    }

    @Override
    public void replaceStringValue(CharSequence stringValue) {
        if (this.getRawParent() != null) {
            AttributeCollectionImpl atts = (AttributeCollectionImpl)((ElementImpl)this.getRawParent()).getAttributeList();
            atts.replaceAttribute(this.getSiblingPosition(), stringValue);
        }
    }

    @Override
    public void removeTypeAnnotation() {
        if (this.getRawParent() != null) {
            AttributeCollectionImpl atts = (AttributeCollectionImpl)((ElementImpl)this.getRawParent()).getAttributeList();
            atts.setTypeAnnotation(this.getSiblingPosition(), BuiltInAtomicType.UNTYPED_ATOMIC);
            this.getRawParent().removeTypeAnnotation();
        }
    }

    @Override
    public void setTypeAnnotation(SchemaType type) {
        if (this.getRawParent() != null) {
            AttributeCollectionImpl atts = (AttributeCollectionImpl)((ElementImpl)this.getRawParent()).getAttributeList();
            atts.setTypeAnnotation(this.getSiblingPosition(), (SimpleType)type);
        }
    }
}

