/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.tree.tiny;

import net.sf.saxon.Configuration;
import net.sf.saxon.event.ComplexContentOutputter;
import net.sf.saxon.event.CopyInformee;
import net.sf.saxon.event.CopyNamespaceSensitiveException;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.event.SequenceWriter;
import net.sf.saxon.expr.parser.ExplicitLocation;
import net.sf.saxon.expr.parser.Location;
import net.sf.saxon.om.AtomicSequence;
import net.sf.saxon.om.CodedName;
import net.sf.saxon.om.CopyOptions;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.om.NamespaceBinding;
import net.sf.saxon.om.NamespaceResolver;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.tiny.TinyDocumentImpl;
import net.sf.saxon.tree.tiny.TinyNodeImpl;
import net.sf.saxon.tree.tiny.TinyParentNodeImpl;
import net.sf.saxon.tree.tiny.TinyTextImpl;
import net.sf.saxon.tree.tiny.TinyTree;
import net.sf.saxon.tree.tiny.WhitespaceTextImpl;
import net.sf.saxon.tree.util.NamespaceIterator;
import net.sf.saxon.tree.util.Navigator;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.SchemaType;
import net.sf.saxon.type.SimpleType;
import net.sf.saxon.type.Untyped;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.z.IntHashMap;

public class TinyElementImpl
extends TinyParentNodeImpl {
    public TinyElementImpl(TinyTree tree, int nodeNr) {
        this.tree = tree;
        this.nodeNr = nodeNr;
    }

    @Override
    public final int getNodeKind() {
        return 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getBaseURI() {
        TinyTree tinyTree = this.tree;
        synchronized (tinyTree) {
            String uri;
            if (this.tree.knownBaseUris == null) {
                this.tree.knownBaseUris = new IntHashMap();
            }
            if ((uri = this.tree.knownBaseUris.get(this.nodeNr)) == null) {
                uri = Navigator.getBaseURI(this, n -> this.tree.isTopWithinEntity(((TinyElementImpl)n).getNodeNumber()));
                this.tree.knownBaseUris.put(this.nodeNr, uri);
            }
            return uri;
        }
    }

    @Override
    public SchemaType getSchemaType() {
        return this.tree.getSchemaType(this.nodeNr);
    }

    @Override
    public AtomicSequence atomize() throws XPathException {
        return this.tree.getTypedValueOfElement(this);
    }

    @Override
    public NamespaceBinding[] getDeclaredNamespaces(NamespaceBinding[] buffer) {
        return TinyElementImpl.getDeclaredNamespaces(this.tree, this.nodeNr, buffer);
    }

    public static NamespaceBinding[] getDeclaredNamespaces(TinyTree tree, int nodeNr, NamespaceBinding[] buffer) {
        int ns = tree.beta[nodeNr];
        if (ns > 0) {
            int count = 0;
            while (ns < tree.numberOfNamespaces && tree.namespaceParent[ns] == nodeNr) {
                ++count;
                ++ns;
            }
            if (count == 0) {
                return NamespaceBinding.EMPTY_ARRAY;
            }
            if (buffer != null && count <= buffer.length) {
                System.arraycopy(tree.namespaceBinding, tree.beta[nodeNr], buffer, 0, count);
                if (count < buffer.length) {
                    buffer[count] = null;
                }
                return buffer;
            }
            NamespaceBinding[] array = new NamespaceBinding[count];
            System.arraycopy(tree.namespaceBinding, tree.beta[nodeNr], array, 0, count);
            return array;
        }
        return NamespaceBinding.EMPTY_ARRAY;
    }

    public boolean hasUniformNamespaces() {
        int nr = this.nodeNr;
        int ns = this.tree.beta[nr];
        TinyElementImpl anc = this;
        while (ns == -1) {
            TinyNodeImpl parent = anc.getParent();
            if (parent instanceof TinyDocumentImpl) {
                return !this.tree.usesNamespaces;
            }
            nr = parent.nodeNr;
            ns = this.tree.beta[nr];
            anc = (TinyElementImpl)parent;
        }
        while (ns < this.tree.numberOfNamespaces && this.tree.namespaceParent[ns] == nr) {
            ++ns;
        }
        return ns >= this.tree.numberOfNamespaces || !this.isAncestorOrSelf(this.tree.getNode(this.tree.namespaceParent[ns]));
    }

    @Override
    public String getAttributeValue(String uri, String local) {
        int a = this.tree.alpha[this.nodeNr];
        if (a < 0) {
            return null;
        }
        NamePool pool = this.getNamePool();
        while (a < this.tree.numberOfAttributes && this.tree.attParent[a] == this.nodeNr) {
            int nc = this.tree.attCode[a];
            StructuredQName name = pool.getUnprefixedQName(nc);
            if (name.getLocalPart().equals(local) && name.hasURI(uri)) {
                return this.tree.attValue[a].toString();
            }
            ++a;
        }
        return null;
    }

    public String getAttributeValue(int fp) {
        int a = this.tree.alpha[this.nodeNr];
        if (a < 0) {
            return null;
        }
        while (a < this.tree.numberOfAttributes && this.tree.attParent[a] == this.nodeNr) {
            if (fp == (this.tree.attCode[a] & 0xFFFFF)) {
                return this.tree.attValue[a].toString();
            }
            ++a;
        }
        return null;
    }

    private int subtreeSize() {
        int next = this.tree.next[this.nodeNr];
        while (next < this.nodeNr) {
            if (next < 0) {
                return this.tree.numberOfNodes - this.nodeNr;
            }
            next = this.tree.next[next];
        }
        return this.nodeNr - next;
    }

    @Override
    public void copy(Receiver receiver, int copyOptions, Location location) throws XPathException {
        boolean copyTypes = CopyOptions.includes(copyOptions, 4);
        boolean fastCopied = this.tryBulkCopy(copyOptions, receiver);
        if (fastCopied) {
            return;
        }
        short level = -1;
        boolean closePending = false;
        short startLevel = this.tree.depth[this.nodeNr];
        boolean first = true;
        boolean disallowNamespaceSensitiveContent = (copyOptions & 4) != 0 && (copyOptions & 3) == 0;
        boolean foundElementInDefaultNamespace = false;
        Configuration config = this.tree.getConfiguration();
        NamePool pool = config.getNamePool();
        int next = this.nodeNr;
        CopyInformee informee = (CopyInformee)receiver.getPipelineConfiguration().getComponent(CopyInformee.class.getName());
        SchemaType elementType = Untyped.getInstance();
        SimpleType attributeType = BuiltInAtomicType.UNTYPED_ATOMIC;
        do {
            short nodeLevel = this.tree.depth[next];
            if (closePending) {
                level = (short)(level + 1);
            }
            while (level > nodeLevel) {
                receiver.endElement();
                level = (short)(level - 1);
            }
            level = nodeLevel;
            byte kind = this.tree.nodeKind[next];
            switch (kind) {
                case 1: 
                case 17: {
                    int options;
                    Location loc;
                    if (copyTypes) {
                        elementType = this.tree.getSchemaType(next);
                        if (disallowNamespaceSensitiveContent) {
                            try {
                                this.checkNotNamespaceSensitiveElement(elementType, next);
                            }
                            catch (CopyNamespaceSensitiveException e2) {
                                int lang = receiver.getPipelineConfiguration().getHostLanguage();
                                e2.setErrorCode(lang == 50 ? "XTTE0950" : "XQTY0086");
                                throw e2;
                            }
                        }
                    }
                    if (informee != null && (loc = (Location)informee.notifyElementNode(this.tree.getNode(next))) != null) {
                        location = loc;
                    }
                    int nameCode = this.tree.nameCode[next];
                    int fp = nameCode & 0xFFFFF;
                    String prefix = this.tree.getPrefix(next);
                    int n = options = !first && (copyOptions & 3) != 0 ? 64 : 0;
                    if (location.getLineNumber() < this.tree.getLineNumber(next)) {
                        String systemId = location.getSystemId() == null ? this.getSystemId() : location.getSystemId();
                        location = new ExplicitLocation(systemId, this.tree.getLineNumber(next), this.getColumnNumber());
                    }
                    receiver.startElement(new CodedName(fp, prefix, pool), elementType, location, options);
                    if (kind == 17) {
                        closePending = false;
                        receiver.startContent();
                        CharSequence value = TinyTextImpl.getStringValue(this.tree, next);
                        receiver.characters(value, location, 1024);
                        receiver.endElement();
                        break;
                    }
                    closePending = true;
                    if ((copyOptions & 3) != 0 && this.tree.usesNamespaces) {
                        String defaultNS = null;
                        if (prefix.isEmpty() && !(defaultNS = this.getNamePool().getURI(fp)).isEmpty()) {
                            foundElementInDefaultNamespace = true;
                        }
                        if (first) {
                            if ((copyOptions & 1) != 0) {
                                NamespaceBinding[] localNamespaces;
                                for (NamespaceBinding ns : localNamespaces = this.getDeclaredNamespaces(null)) {
                                    if (ns == null) break;
                                    receiver.namespace(ns, 0);
                                }
                            } else if ((copyOptions & 2) != 0) {
                                NamespaceIterator.sendNamespaces(this, receiver);
                            }
                        } else {
                            int ns = this.tree.beta[next];
                            if (ns > 0) {
                                while (ns < this.tree.numberOfNamespaces && this.tree.namespaceParent[ns] == next) {
                                    NamespaceBinding nscode = this.tree.namespaceBinding[ns];
                                    receiver.namespace(nscode, 0);
                                    ++ns;
                                }
                            }
                        }
                    }
                    first = false;
                    int att = this.tree.alpha[next];
                    if (att >= 0) {
                        while (att < this.tree.numberOfAttributes && this.tree.attParent[att] == next) {
                            int attCode = this.tree.attCode[att];
                            int attfp = attCode & 0xFFFFF;
                            if (copyTypes) {
                                attributeType = this.tree.getAttributeType(att);
                                if (disallowNamespaceSensitiveContent) {
                                    try {
                                        this.checkNotNamespaceSensitiveAttribute(attributeType, att);
                                    }
                                    catch (CopyNamespaceSensitiveException e3) {
                                        int lang = receiver.getPipelineConfiguration().getHostLanguage();
                                        e3.setErrorCode(lang == 50 ? "XTTE0950" : "XQTY0086");
                                        throw e3;
                                    }
                                }
                            }
                            String attPrefix = this.tree.prefixPool.getPrefix(attCode >> 20);
                            receiver.attribute(new CodedName(attfp, attPrefix, pool), attributeType, this.tree.attValue[att], location, 0x100000);
                            ++att;
                        }
                    }
                    receiver.startContent();
                    break;
                }
                case 33: {
                    closePending = false;
                    this.tree.externalNodes.get(this.tree.alpha[next]).copy(receiver, copyOptions, location);
                    break;
                }
                case 3: {
                    closePending = false;
                    CharSequence value = TinyTextImpl.getStringValue(this.tree, next);
                    receiver.characters(value, location, 1024);
                    break;
                }
                case 4: {
                    closePending = false;
                    CharSequence value = WhitespaceTextImpl.getStringValueCS(this.tree, next);
                    receiver.characters(value, location, 1024);
                    break;
                }
                case 8: {
                    closePending = false;
                    int start = this.tree.alpha[next];
                    int len = this.tree.beta[next];
                    if (len > 0) {
                        receiver.comment(this.tree.commentBuffer.subSequence(start, start + len), location, 0);
                        break;
                    }
                    receiver.comment("", ExplicitLocation.UNKNOWN_LOCATION, 0);
                    break;
                }
                case 7: {
                    closePending = false;
                    TinyNodeImpl pi2 = this.tree.getNode(next);
                    receiver.processingInstruction(pi2.getLocalPart(), pi2.getStringValue(), location, 0);
                    break;
                }
                case 12: {
                    closePending = false;
                }
            }
        } while (++next < this.tree.numberOfNodes && this.tree.depth[next] > startLevel);
        if (closePending) {
            level = (short)(level + 1);
        }
        while (level > startLevel) {
            receiver.endElement();
            level = (short)(level - 1);
        }
    }

    private boolean tryGraft(int copyOptions, Receiver out) throws XPathException {
        if (this.subtreeSize() < 100) {
            return false;
        }
        if (TinyTree.useGraft && (copyOptions & 8) == 0 && (copyOptions & 2) != 0 && this.tree.externalNodes == null) {
            if (this.isSkipValidator(out)) {
                return false;
            }
            if (this.tree.isTyped()) {
                return false;
            }
            if (out instanceof SequenceWriter && ((SequenceWriter)out).isReadyForGrafting()) {
                ((SequenceWriter)out).graftElementNode(this, copyOptions);
                return true;
            }
            if (out instanceof ComplexContentOutputter && ((ComplexContentOutputter)out).isReadyForGrafting()) {
                ((ComplexContentOutputter)out).graftElementNode(this, copyOptions);
                return true;
            }
        }
        return false;
    }

    private boolean tryBulkCopy(int copyOptions, Receiver out) throws XPathException {
        if ((copyOptions & 8) == 0 && (copyOptions & 2) != 0 && this.tree.externalNodes == null) {
            if (this.isSkipValidator(out)) {
                return false;
            }
            if (this.tree.isTyped()) {
                return false;
            }
            if (this.nodeNr == this.tree.numberOfNodes - 1) {
                return false;
            }
            if (out instanceof SequenceWriter && ((SequenceWriter)out).isReadyForBulkCopy()) {
                ((SequenceWriter)out).bulkCopyElementNode(this, copyOptions);
                return true;
            }
            if (out instanceof ComplexContentOutputter && ((ComplexContentOutputter)out).isReadyForBulkCopy()) {
                ((ComplexContentOutputter)out).bulkCopyElementNode(this, copyOptions);
                return true;
            }
        }
        return false;
    }

    protected void checkNotNamespaceSensitiveElement(SchemaType type, int nodeNr) throws XPathException {
        if (type instanceof SimpleType && ((SimpleType)type).isNamespaceSensitive()) {
            if (type.isAtomicType()) {
                throw new CopyNamespaceSensitiveException("Cannot copy QName or NOTATION values without copying namespaces");
            }
            AtomicSequence value = this.tree.getTypedValueOfElement(nodeNr);
            for (AtomicValue val : value) {
                if (!val.getPrimitiveType().isNamespaceSensitive()) continue;
                throw new CopyNamespaceSensitiveException("Cannot copy QName or NOTATION values without copying namespaces");
            }
        }
    }

    private void checkNotNamespaceSensitiveAttribute(SimpleType type, int nodeNr) throws XPathException {
        if (type.isNamespaceSensitive()) {
            if (type.isAtomicType()) {
                throw new CopyNamespaceSensitiveException("Cannot copy QName or NOTATION values without copying namespaces");
            }
            AtomicSequence value = this.tree.getTypedValueOfAttribute(null, nodeNr);
            for (AtomicValue val : value) {
                if (!val.getPrimitiveType().isNamespaceSensitive()) continue;
                throw new CopyNamespaceSensitiveException("Cannot copy QName or NOTATION values without copying namespaces");
            }
        }
    }

    public String getURIForPrefix(String prefix, boolean useDefault) {
        TinyNodeImpl parent;
        if (!useDefault && (prefix == null || prefix.isEmpty())) {
            return "";
        }
        int ns = this.tree.beta[this.nodeNr];
        if (ns > 0) {
            while (ns < this.tree.numberOfNamespaces && this.tree.namespaceParent[ns] == this.nodeNr) {
                NamespaceBinding nscode = this.tree.namespaceBinding[ns];
                if (nscode.getPrefix().equals(prefix)) {
                    String uri = nscode.getURI();
                    if (uri.isEmpty()) {
                        if (prefix.isEmpty()) {
                            return "";
                        }
                        return null;
                    }
                    return uri;
                }
                ++ns;
            }
        }
        if ((parent = this.getParent()) instanceof NamespaceResolver) {
            return ((NamespaceResolver)((Object)parent)).getURIForPrefix(prefix, useDefault);
        }
        return null;
    }

    @Override
    public boolean isId() {
        return this.tree.isIdElement(this.nodeNr);
    }

    @Override
    public boolean isIdref() {
        return this.tree.isIdrefElement(this.nodeNr);
    }

    private boolean isSkipValidator(Receiver r) {
        return false;
    }
}

