/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper.jmx;

import java.lang.management.ManagementFactory;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.management.JMException;
import javax.management.MBeanServer;
import javax.management.MBeanServerFactory;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.apache.zookeeper.jmx.ZKMBeanInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MBeanRegistry {
    private static final Logger LOG = LoggerFactory.getLogger(MBeanRegistry.class);
    private static MBeanRegistry instance = new MBeanRegistry();
    private Map<ZKMBeanInfo, String> mapBean2Path = new ConcurrentHashMap<ZKMBeanInfo, String>();
    private Map<String, ZKMBeanInfo> mapName2Bean = new ConcurrentHashMap<String, ZKMBeanInfo>();
    private MBeanServer mBeanServer;

    public static MBeanRegistry getInstance() {
        return instance;
    }

    public MBeanRegistry() {
        try {
            this.mBeanServer = ManagementFactory.getPlatformMBeanServer();
        }
        catch (Error e2) {
            this.mBeanServer = MBeanServerFactory.createMBeanServer();
        }
    }

    public MBeanServer getPlatformMBeanServer() {
        return this.mBeanServer;
    }

    public void register(ZKMBeanInfo bean, ZKMBeanInfo parent) throws JMException {
        assert (bean != null);
        String path = null;
        if (parent != null) {
            path = this.mapBean2Path.get(parent);
            assert (path != null);
        }
        path = this.makeFullPath(path, parent);
        if (bean.isHidden()) {
            return;
        }
        ObjectName oname = this.makeObjectName(path, bean);
        try {
            this.mBeanServer.registerMBean(bean, oname);
            this.mapBean2Path.put(bean, path);
            this.mapName2Bean.put(bean.getName(), bean);
        }
        catch (JMException e2) {
            LOG.warn("Failed to register MBean " + bean.getName());
            throw e2;
        }
    }

    private void unregister(String path, ZKMBeanInfo bean) throws JMException {
        if (path == null) {
            return;
        }
        if (!bean.isHidden()) {
            try {
                this.mBeanServer.unregisterMBean(this.makeObjectName(path, bean));
            }
            catch (JMException e2) {
                LOG.warn("Failed to unregister MBean " + bean.getName());
                throw e2;
            }
        }
    }

    public void unregister(ZKMBeanInfo bean) {
        if (bean == null) {
            return;
        }
        String path = this.mapBean2Path.get(bean);
        try {
            this.unregister(path, bean);
        }
        catch (JMException e2) {
            LOG.warn("Error during unregister", e2);
        }
        this.mapBean2Path.remove(bean);
        this.mapName2Bean.remove(bean.getName());
    }

    public void unregisterAll() {
        for (Map.Entry<ZKMBeanInfo, String> e2 : this.mapBean2Path.entrySet()) {
            try {
                this.unregister(e2.getValue(), e2.getKey());
            }
            catch (JMException e1) {
                LOG.warn("Error during unregister", e1);
            }
        }
        this.mapBean2Path.clear();
        this.mapName2Bean.clear();
    }

    public String makeFullPath(String prefix, String ... name) {
        StringBuilder sb = new StringBuilder(prefix == null ? "/" : (prefix.equals("/") ? prefix : prefix + "/"));
        boolean first = true;
        for (String s : name) {
            if (s == null) continue;
            if (!first) {
                sb.append("/");
            } else {
                first = false;
            }
            sb.append(s);
        }
        return sb.toString();
    }

    protected String makeFullPath(String prefix, ZKMBeanInfo bean) {
        return this.makeFullPath(prefix, bean == null ? null : bean.getName());
    }

    private int tokenize(StringBuilder sb, String path, int index) {
        String[] tokens2;
        for (String s : tokens2 = path.split("/")) {
            if (s.length() == 0) continue;
            sb.append("name").append(index++).append("=").append(s).append(",");
        }
        return index;
    }

    protected ObjectName makeObjectName(String path, ZKMBeanInfo bean) throws MalformedObjectNameException {
        if (path == null) {
            return null;
        }
        StringBuilder beanName = new StringBuilder("org.apache.ZooKeeperService:");
        int counter = 0;
        counter = this.tokenize(beanName, path, counter);
        this.tokenize(beanName, bean.getName(), counter);
        beanName.deleteCharAt(beanName.length() - 1);
        try {
            return new ObjectName(beanName.toString());
        }
        catch (MalformedObjectNameException e2) {
            LOG.warn("Invalid name \"" + beanName.toString() + "\" for class " + bean.getClass().toString());
            throw e2;
        }
    }
}

