/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.component.factory.java;

import java.lang.reflect.Modifier;
import org.codehaus.classworlds.ClassRealm;
import org.codehaus.plexus.PlexusContainer;
import org.codehaus.plexus.component.factory.AbstractComponentFactory;
import org.codehaus.plexus.component.factory.ComponentInstantiationException;
import org.codehaus.plexus.component.repository.ComponentDescriptor;

public class JavaComponentFactory
extends AbstractComponentFactory {
    public Object newInstance(ComponentDescriptor componentDescriptor, ClassRealm classRealm, PlexusContainer container2) throws ComponentInstantiationException {
        Class implementationClass = null;
        try {
            String implementation = componentDescriptor.getImplementation();
            implementationClass = classRealm.loadClass(implementation);
            int modifiers = implementationClass.getModifiers();
            if (Modifier.isInterface(modifiers)) {
                throw new ComponentInstantiationException("Cannot instanciate implementation '" + implementation + "' because the class is a interface.");
            }
            if (Modifier.isAbstract(modifiers)) {
                throw new ComponentInstantiationException("Cannot instanciate implementation '" + implementation + "' because the class is abstract.");
            }
            Object instance = implementationClass.newInstance();
            return instance;
        }
        catch (InstantiationException e2) {
            throw this.makeException(classRealm, componentDescriptor, implementationClass, e2);
        }
        catch (ClassNotFoundException e3) {
            throw this.makeException(classRealm, componentDescriptor, implementationClass, e3);
        }
        catch (IllegalAccessException e4) {
            throw this.makeException(classRealm, componentDescriptor, implementationClass, e4);
        }
        catch (LinkageError e5) {
            throw this.makeException(classRealm, componentDescriptor, implementationClass, e5);
        }
    }

    private ComponentInstantiationException makeException(ClassRealm componentClassRealm, ComponentDescriptor componentDescriptor, Class implementationClass, Throwable e2) {
        componentClassRealm.display();
        String msg = "Could not instanciate component: " + componentDescriptor.getHumanReadableKey();
        return new ComponentInstantiationException(msg, e2);
    }
}

