/*
 * Decompiled with CFR 0.152.
 */
package org.dataone.cn.index.processor;

import org.apache.log4j.Logger;
import org.dataone.cn.index.processor.IndexTaskProcessor;
import org.quartz.DisallowConcurrentExecution;
import org.quartz.InterruptableJob;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.quartz.UnableToInterruptJobException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.support.ClassPathXmlApplicationContext;

@DisallowConcurrentExecution
public class IndexTaskProcessorJob
implements InterruptableJob {
    private static Logger logger = Logger.getLogger(IndexTaskProcessorJob.class.getName());
    private static ApplicationContext context;
    private static IndexTaskProcessor processor;
    private static int jobIdentityHash;

    @Override
    public void execute(JobExecutionContext arg0) throws JobExecutionException {
        logger.warn("processing job [" + jobIdentityHash + "/" + this + "] executing index task with processor [" + processor + "]");
        IndexTaskProcessorJob.setContext();
        processor.processIndexTaskQueue();
        logger.warn("processing job [" + this + "] finished execution of index task processor [" + processor + "]");
    }

    private static void setContext() {
        if (context == null || processor == null) {
            context = new ClassPathXmlApplicationContext("processor-daemon-context.xml");
            processor = (IndexTaskProcessor)context.getBean("indexTaskProcessor");
        }
    }

    @Override
    public void interrupt() throws UnableToInterruptJobException {
        logger.warn("IndexTaskProcessorJob [" + this + "] interrupted, shutting down processor [" + processor + "]");
        IndexTaskProcessorJob.interruptCurrent();
    }

    public static void interruptCurrent() throws UnableToInterruptJobException {
        try {
            logger.warn("IndexTaskProcessorJob class [" + jobIdentityHash + "] interruptCurrent called, shutting down processor [" + processor + "]");
            processor.shutdownExecutor();
        }
        catch (Throwable t) {
            UnableToInterruptJobException e2 = new UnableToInterruptJobException("Unable to shutdown the executorService that is processing index tasks.");
            e2.initCause(t);
            throw e2;
        }
    }

    static {
        jobIdentityHash = System.identityHashCode(IndexTaskProcessorJob.class);
    }
}

