/*
 * Decompiled with CFR 0.152.
 */
package org.dataone.cn.index.task;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.util.Calendar;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Table;
import javax.persistence.Transient;
import javax.persistence.Version;
import org.apache.commons.lang.time.FastDateFormat;
import org.apache.log4j.Logger;
import org.dataone.exceptions.MarshallingException;
import org.dataone.service.types.v2.SystemMetadata;
import org.dataone.service.util.TypeMarshaller;

@Entity
@Table(name="index_task")
public class IndexTask
implements Serializable {
    private static final long serialVersionUID = -6319197619205919972L;
    @Transient
    private static Logger logger = Logger.getLogger(IndexTask.class.getName());
    @Transient
    private final FastDateFormat format = FastDateFormat.getInstance("MM/dd/yyyy:HH:mm:ss:SS");
    @Transient
    private static final String FORMAT_RESOURCE_MAP = "http://www.openarchives.org/ore/terms";
    @Transient
    private static final int ALLOWED_RETRIES = 2;
    @Id
    @GeneratedValue(strategy=GenerationType.AUTO)
    private Long id;
    @Version
    @Column(nullable=false)
    private int version;
    @Column(columnDefinition="TEXT", nullable=false)
    private String pid;
    private String formatId;
    @Column(columnDefinition="TEXT")
    private String sysMetadata;
    @Column(columnDefinition="TEXT")
    private String objectPath;
    private long dateSysMetaModified;
    private long taskModifiedDate = System.currentTimeMillis();
    private long nextExecution = 0L;
    private int tryCount = 0;
    private boolean deleted = false;
    private int priority;
    private static final int PRIORITY_UPDATE = 1;
    private static final int PRIORITY_ADD = 2;
    private static final int PRIOIRTY_UPDATE_RESOURCE_MAP = 3;
    private static final int PRIORITY_ADD_RESOURCE_MAP = 4;
    private static final int PRIORITY_NONE = 99;
    private String status = "NEW";
    public static final String STATUS_NEW = "NEW";
    public static final String STATUS_IN_PROCESS = "IN PROCESS";
    public static final String STATUS_COMPLETE = "COMPLETE";
    public static final String STATUS_FAILED = "FAILED";

    public IndexTask() {
    }

    public IndexTask(SystemMetadata smd, String objectPath) {
        this();
        if (smd.getIdentifier() != null) {
            this.pid = smd.getIdentifier().getValue();
        }
        if (smd.getFormatId() != null) {
            this.formatId = smd.getFormatId().getValue();
        }
        if (smd.getDateSysMetadataModified() != null) {
            this.dateSysMetaModified = smd.getDateSysMetadataModified().getTime();
        }
        this.marshalSystemMetadata(smd);
        this.setObjectPath(objectPath);
        this.priority = 99;
    }

    @Transient
    public SystemMetadata unMarshalSystemMetadata() {
        ByteArrayInputStream is = new ByteArrayInputStream(this.sysMetadata.getBytes());
        SystemMetadata smd = null;
        try {
            smd = TypeMarshaller.unmarshalTypeFromStream(SystemMetadata.class, is);
        }
        catch (IOException e2) {
            logger.error(e2.getMessage(), e2);
        }
        catch (InstantiationException e3) {
            logger.error(e3.getMessage(), e3);
        }
        catch (IllegalAccessException e4) {
            logger.error(e4.getMessage(), e4);
        }
        catch (MarshallingException e5) {
            logger.error(e5.getMessage(), e5);
        }
        return smd;
    }

    @Transient
    private void marshalSystemMetadata(SystemMetadata smd) {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        try {
            TypeMarshaller.marshalTypeToOutputStream(smd, os);
        }
        catch (MarshallingException ex) {
            logger.error(ex.getMessage(), ex);
        }
        catch (IOException ioEx) {
            logger.error(ioEx.getMessage(), ioEx);
        }
        try {
            this.sysMetadata = os.toString("UTF-8");
        }
        catch (UnsupportedEncodingException e2) {
            logger.error(e2.getMessage());
        }
    }

    @Transient
    private boolean isArchived() {
        boolean archived = false;
        SystemMetadata smd = this.unMarshalSystemMetadata();
        if (smd.getArchived() != null && smd.getArchived().booleanValue()) {
            archived = true;
        }
        return archived;
    }

    @Transient
    public boolean isDeleteTask() {
        return this.isDeleted() || this.isArchived();
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getPid() {
        return this.pid;
    }

    public void setPid(String pid) {
        this.pid = pid;
    }

    public boolean isDeleted() {
        return this.deleted;
    }

    public void setDeleted(boolean deleted) {
        this.deleted = deleted;
    }

    public String getFormatId() {
        return this.formatId;
    }

    public void setFormatId(String formatid) {
        this.formatId = formatid;
    }

    public String getSysMetadata() {
        return this.sysMetadata;
    }

    public void setSysMetadata(String sysMetadata) {
        this.sysMetadata = sysMetadata;
    }

    public String getObjectPath() {
        return this.objectPath;
    }

    public void setObjectPath(String objectPath) {
        this.objectPath = objectPath;
    }

    public long getDateSysMetaModified() {
        return this.dateSysMetaModified;
    }

    public void setDateSysMetaModified(long dateSysMetaModified) {
        this.dateSysMetaModified = dateSysMetaModified;
    }

    public long getNextExecution() {
        return this.nextExecution;
    }

    public void setNextExection(long next) {
        this.nextExecution = next;
    }

    public int getTryCount() {
        return this.tryCount;
    }

    public void setTryCount(int count) {
        this.tryCount = count;
    }

    public int getPriority() {
        return this.priority;
    }

    public void setPriority(int priority) {
        this.priority = priority;
    }

    @Transient
    public void setUpdatePriority() {
        this.priority = this.isResourceMap() ? 3 : 1;
    }

    @Transient
    public void setAddPriority() {
        this.priority = this.isResourceMap() ? 4 : 2;
    }

    @Transient
    private boolean isResourceMap() {
        return FORMAT_RESOURCE_MAP.equals(this.formatId);
    }

    public long getTaskModifiedDate() {
        return this.taskModifiedDate;
    }

    public void setTaskModifiedDate(long taskModifiedDate) {
        this.taskModifiedDate = taskModifiedDate;
    }

    @Transient
    public String getTaskModDateString() {
        return this.format.format(this.getTaskModifiedDate());
    }

    public String getStatus() {
        return this.status;
    }

    public void setStatus(String status) {
        if (status != null) {
            this.taskModifiedDate = System.currentTimeMillis();
            this.status = status;
        }
    }

    private void setBackoffExectionTime() {
        Calendar cal = Calendar.getInstance();
        cal.setTimeInMillis(System.currentTimeMillis());
        int tryCount = this.getTryCount();
        if (tryCount == 2) {
            cal.add(12, 20);
            this.setNextExection(cal.getTimeInMillis());
        } else if (tryCount == 3) {
            cal.add(10, 2);
            this.setNextExection(cal.getTimeInMillis());
        } else if (tryCount == 4) {
            cal.add(10, 8);
            this.setNextExection(cal.getTimeInMillis());
        } else if (tryCount >= 5 && tryCount <= 7) {
            cal.add(10, 24);
            this.setNextExection(cal.getTimeInMillis());
        } else if (tryCount > 7) {
            cal.add(5, 7);
            this.setNextExection(cal.getTimeInMillis());
        }
    }

    private boolean timeForRetryBackoff(String status) {
        return this.getTryCount() >= 2 && !STATUS_COMPLETE.equals(status) && !STATUS_IN_PROCESS.equals(status);
    }

    public void markInProgress() {
        this.setStatus(STATUS_IN_PROCESS);
        ++this.tryCount;
    }

    public void markNew() {
        this.setStatus(STATUS_NEW);
        if (this.timeForRetryBackoff(this.status)) {
            logger.info("Even tough it was masked new, it is still considered failed for id " + this.pid + " since it was tried to many times.");
            this.status = STATUS_FAILED;
            this.setBackoffExectionTime();
        }
    }

    public void markFailed() {
        this.setStatus(STATUS_FAILED);
        if (this.timeForRetryBackoff(this.status)) {
            this.status = STATUS_FAILED;
            this.setBackoffExectionTime();
        }
    }

    public int getVersion() {
        return this.version;
    }

    public void setVersion(int version2) {
        this.version = version2;
    }

    public String toString() {
        return "IndexTask [id=" + this.id + ", pid=" + this.pid + ", formatid=" + this.formatId + ", objectPath=" + this.objectPath + ", dateSysMetaModified=" + this.dateSysMetaModified + ", deleted=" + this.deleted + ", taskModifiedDate=" + this.taskModifiedDate + ", priority=" + this.priority + ", status=" + this.status + "]";
    }
}

