/*
 * Decompiled with CFR 0.152.
 */
package org.dataone.cn.indexer.parser;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.dataone.cn.indexer.parser.ISolrField;
import org.dataone.cn.indexer.parser.SolrField;
import org.dataone.cn.indexer.parser.utility.SpatialBoxParsingUtility;
import org.dataone.cn.indexer.solrhttp.SolrElementField;
import org.w3c.dom.Document;

public class DublinCoreSpatialBoxBoundingCoordinatesSolrField
extends SolrField
implements ISolrField {
    private static Logger logger = Logger.getLogger(DublinCoreSpatialBoxBoundingCoordinatesSolrField.class.getName());
    private static SpatialBoxParsingUtility boxParsingUtility = new SpatialBoxParsingUtility();

    public DublinCoreSpatialBoxBoundingCoordinatesSolrField() {
    }

    public DublinCoreSpatialBoxBoundingCoordinatesSolrField(String xpath) {
        this.xpath = xpath;
    }

    @Override
    public List<SolrElementField> getFields(Document doc, String identifier) throws Exception {
        return this.parseBox(doc);
    }

    private List<SolrElementField> parseBox(Document doc) {
        ArrayList<SolrElementField> fields = new ArrayList<SolrElementField>();
        String nodeValue = boxParsingUtility.extractNodeValue(doc, this.xPathExpression);
        this.setBoundingBoxCoordinate(nodeValue, fields, "northlimit", "northBoundCoord");
        this.setBoundingBoxCoordinate(nodeValue, fields, "southlimit", "southBoundCoord");
        this.setBoundingBoxCoordinate(nodeValue, fields, "eastlimit", "eastBoundCoord");
        this.setBoundingBoxCoordinate(nodeValue, fields, "westlimit", "westBoundCoord");
        return fields;
    }

    private void setBoundingBoxCoordinate(String nodeValue, List<SolrElementField> fields, String boxDirectionProperty, String indexDirectionProperty) {
        String directionValue = boxParsingUtility.extractDublinCoreDirectionalValue(nodeValue, boxDirectionProperty);
        if (directionValue != null && StringUtils.isNotEmpty(directionValue) && StringUtils.isNotEmpty(directionValue)) {
            fields.add(new SolrElementField(indexDirectionProperty, directionValue));
        }
    }
}

