/*
 * Decompiled with CFR 0.152.
 */
package org.dataone.cn.indexer.parser;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.xpath.XPathExpressionException;
import org.apache.commons.codec.EncoderException;
import org.apache.log4j.Logger;
import org.dataone.cn.hazelcast.HazelcastClientFactory;
import org.dataone.cn.index.processor.IndexTaskDeleteProcessor;
import org.dataone.cn.index.task.IndexTask;
import org.dataone.cn.index.util.PerformanceLogger;
import org.dataone.cn.indexer.XmlDocumentUtility;
import org.dataone.cn.indexer.parser.IDocumentSubprocessor;
import org.dataone.cn.indexer.parser.SubprocessorUtility;
import org.dataone.cn.indexer.parser.utility.SeriesIdResolver;
import org.dataone.cn.indexer.resourcemap.ResourceMap;
import org.dataone.cn.indexer.resourcemap.ResourceMapFactory;
import org.dataone.cn.indexer.solrhttp.HTTPService;
import org.dataone.cn.indexer.solrhttp.SolrDoc;
import org.dataone.service.types.v1.Identifier;
import org.dataone.service.types.v2.SystemMetadata;
import org.dspace.foresite.OREParserException;
import org.springframework.beans.factory.annotation.Autowired;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public class ResourceMapSubprocessor
implements IDocumentSubprocessor {
    private static Logger logger = Logger.getLogger(ResourceMapSubprocessor.class.getName());
    @Autowired
    private HTTPService httpService = null;
    @Autowired
    private String solrQueryUri = null;
    @Autowired
    private IndexTaskDeleteProcessor deleteProcessor;
    @Autowired
    private SubprocessorUtility processorUtility;
    private PerformanceLogger perfLog = PerformanceLogger.getInstance();
    private List<String> matchDocuments = null;
    private List<String> fieldsToMerge = new ArrayList<String>();

    @Override
    public SolrDoc mergeWithIndexedDocument(SolrDoc indexDocument) throws IOException, EncoderException, XPathExpressionException {
        return this.processorUtility.mergeWithIndexedDocument(indexDocument, this.fieldsToMerge);
    }

    @Override
    public Map<String, SolrDoc> processDocument(String identifier, Map<String, SolrDoc> docs, InputStream is) throws XPathExpressionException, IOException, EncoderException {
        SolrDoc resourceMapDoc = docs.get(identifier);
        List<Object> processedDocs = new ArrayList();
        try {
            long fetchXmlStart = System.currentTimeMillis();
            Document doc = XmlDocumentUtility.generateXmlDocument(is);
            this.perfLog.log("ResourceMapSubprocessor.processDocument() XmlDocumentUtility.generateXmlDocument() for id " + identifier, System.currentTimeMillis() - fetchXmlStart);
            long procResMapStart = System.currentTimeMillis();
            processedDocs = this.processResourceMap(resourceMapDoc, doc);
            this.perfLog.log("ResourceMapSubprocessor.processResourceMap() for id " + identifier, System.currentTimeMillis() - procResMapStart);
        }
        catch (OREParserException oreException) {
            logger.error("Unable to parse resource map: " + identifier + ".  Unrecoverable parse exception:  task will not be re-tried.");
        }
        catch (SAXException e2) {
            logger.error("Unable to parse resource map: " + identifier + ".  Unrecoverable parse exception:  task will not be re-tried.");
        }
        HashMap<String, SolrDoc> processedDocsMap = new HashMap<String, SolrDoc>();
        for (SolrDoc processedDoc : processedDocs) {
            processedDocsMap.put(processedDoc.getIdentifier(), processedDoc);
        }
        return processedDocsMap;
    }

    private List<SolrDoc> processResourceMap(SolrDoc indexDocument, Document resourceMapDocument) throws OREParserException, XPathExpressionException, IOException, EncoderException {
        long buildResMapStart = System.currentTimeMillis();
        ResourceMap resourceMap = ResourceMapFactory.buildResourceMap(resourceMapDocument);
        this.perfLog.log("ResourceMapFactory.buildResourceMap() create ResourceMap from Document", System.currentTimeMillis() - buildResMapStart);
        long getReferencedStart = System.currentTimeMillis();
        List<String> documentIds = resourceMap.getAllDocumentIDs();
        this.perfLog.log("ResourceMap.getAllDocumentIDs() referenced in ResourceMap", System.currentTimeMillis() - getReferencedStart);
        long clearSidChainStart = System.currentTimeMillis();
        this.clearSidChain(indexDocument.getIdentifier(), documentIds);
        this.perfLog.log("ResourceMapSubprocessor.clearSidChain() removing obsoletes chain from Solr index", System.currentTimeMillis() - clearSidChainStart);
        long getSolrDocsStart = System.currentTimeMillis();
        List<SolrDoc> updateDocuments = this.httpService.getDocumentsById(this.solrQueryUri, documentIds);
        this.perfLog.log("HttpService.getDocumentsById() get existing referenced ids' Solr docs", System.currentTimeMillis() - getSolrDocsStart);
        List<SolrDoc> mergedDocuments = resourceMap.mergeIndexedDocuments(updateDocuments);
        mergedDocuments.add(indexDocument);
        return mergedDocuments;
    }

    private void clearSidChain(String resourceMapIdentifier, List<String> relatedDocs) {
        Identifier identifier = new Identifier();
        identifier.setValue(resourceMapIdentifier);
        boolean containsSeriesId = false;
        for (String relatedDoc : relatedDocs) {
            Identifier relatedPid = new Identifier();
            relatedPid.setValue(relatedDoc);
            if (!SeriesIdResolver.isSeriesId(relatedPid)) continue;
            containsSeriesId = true;
            break;
        }
        if (containsSeriesId) {
            Identifier pidToProcess = identifier;
            while (pidToProcess != null) {
                SystemMetadata sysmeta = HazelcastClientFactory.getSystemMetadataMap().get(pidToProcess);
                if (sysmeta != null) {
                    String objectPath = HazelcastClientFactory.getObjectPathMap().get(pidToProcess);
                    logger.debug("Removing pidToProcess===" + pidToProcess.getValue());
                    logger.debug("Removing objectPath===" + objectPath);
                    IndexTask task = new IndexTask(sysmeta, objectPath);
                    try {
                        this.deleteProcessor.process(task);
                    }
                    catch (Exception e2) {
                        logger.error(e2.getMessage(), e2);
                    }
                    pidToProcess = sysmeta.getObsoletes();
                    continue;
                }
                pidToProcess = null;
            }
        }
    }

    public List<String> getMatchDocuments() {
        return this.matchDocuments;
    }

    public void setMatchDocuments(List<String> matchDocuments) {
        this.matchDocuments = matchDocuments;
    }

    @Override
    public boolean canProcess(String formatId) {
        return this.matchDocuments.contains(formatId);
    }

    public List<String> getFieldsToMerge() {
        return this.fieldsToMerge;
    }

    public void setFieldsToMerge(List<String> fieldsToMerge) {
        this.fieldsToMerge = fieldsToMerge;
    }
}

