/*
 * Decompiled with CFR 0.152.
 */
package org.dataone.cn.indexer.parser.utility;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dataone.cn.indexer.parser.utility.FilterProcessor;
import org.dataone.cn.indexer.parser.utility.LeafElement;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class FilterGroupProcessor {
    private String name;
    private String matchElement;
    private String delimiter = " ";
    private List<LeafElement> leafs = new ArrayList<LeafElement>();
    private List<FilterProcessor> filters = null;
    private Log log = LogFactory.getLog(FilterGroupProcessor.class);

    public String getFilterGroupValue(Object docOrNode, List<FilterProcessor> filters, FilterGroupProcessor filterGroup, String idFilterMatch, String isPartOfFilterMatch, String xPath) throws XPathExpressionException {
        XPathFactory xpathFactory = XPathFactory.newInstance();
        XPath xpath = xpathFactory.newXPath();
        String localName = "./*[local-name()]";
        XPathExpression xPathExpression = xpath.compile(localName);
        NodeList topNodes = (NodeList)xPathExpression.evaluate(docOrNode, XPathConstants.NODESET);
        xPathExpression = xpath.compile(xPath);
        this.log.trace("FilterGroupProcessor.getFilterGroupValue xpath: " + xPath);
        NodeList nodeList = (NodeList)xPathExpression.evaluate(docOrNode, XPathConstants.NODESET);
        String idFilterValue = null;
        String isPartOfFilterValue = null;
        String filterValue = null;
        String mainFilterValue = null;
        String completeFilterValue = null;
        HashSet<String> idFilterMatchingFields = new HashSet<String>();
        if (idFilterMatch != null && !idFilterMatch.isEmpty()) {
            String[] tokens2;
            for (String token : tokens2 = idFilterMatch.split(",")) {
                idFilterMatchingFields.add(token);
            }
        }
        HashSet<String> isPartOfMatchingFields = new HashSet<String>();
        if (isPartOfFilterMatch != null && !isPartOfFilterMatch.isEmpty()) {
            String[] tokens3;
            for (String token : tokens3 = isPartOfFilterMatch.split(",")) {
                isPartOfMatchingFields.add(token);
            }
        }
        String operator = "AND";
        Boolean exclude = false;
        XPath xpath2 = xpathFactory.newXPath();
        XPathExpression xPathExpression2 = xpath2.compile(".//definition/operator | operator");
        NodeList nl = (NodeList)xPathExpression2.evaluate(docOrNode, XPathConstants.NODESET);
        if (nl.getLength() > 0) {
            operator = nl.item(0).getTextContent();
            this.log.trace("Setting operator to: " + operator);
        }
        if ((nl = (NodeList)(xPathExpression2 = xpath2.compile(".//definition/exclude | exclude")).evaluate(docOrNode, XPathConstants.NODESET)).getLength() > 0) {
            exclude = Boolean.parseBoolean(nl.item(0).getTextContent());
            this.log.trace("Setting exclude to: " + exclude);
        }
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Matcher m1;
            Pattern p;
            Node node = nodeList.item(i);
            this.log.trace("Processing node: " + node.getNodeName());
            Boolean foundNode = false;
            for (FilterProcessor filterProcessor : filters) {
                if (!node.getNodeName().equalsIgnoreCase(filterProcessor.getMatchElement())) continue;
                foundNode = true;
                filterProcessor.initXPathExpressions();
                filterValue = filterProcessor.getFilterValue(node);
                this.log.trace("nodename: " + node.getNodeName() + " returned filterValue: " + filterValue);
                break;
            }
            if (!foundNode.booleanValue() && node.getNodeName().equalsIgnoreCase(filterGroup.getMatchElement())) {
                filterValue = filterGroup.getFilterGroupValue(node, filters, filterGroup, idFilterMatch, isPartOfFilterMatch, xPath);
                this.log.trace("returned filterGroup filterValue: " + filterValue);
            }
            if (filterValue == null) continue;
            Boolean idFilter = false;
            Boolean isPartOfFilter = false;
            if (!idFilterMatchingFields.isEmpty()) {
                this.log.trace("filter matches idFilter");
                for (String term : idFilterMatchingFields) {
                    p = Pattern.compile("[(-]" + term + ":|^" + term + ":");
                    m1 = null;
                    m1 = p.matcher(filterValue);
                    if (!m1.find()) continue;
                    idFilter = true;
                    if (idFilterValue == null) {
                        idFilterValue = filterValue;
                        continue;
                    }
                    idFilterValue = idFilterValue + " OR " + filterValue;
                }
            }
            if (!isPartOfMatchingFields.isEmpty()) {
                this.log.trace("filter matches isPartOf");
                for (String term : isPartOfMatchingFields) {
                    p = Pattern.compile("[(-]" + term + ":|^" + term + ":");
                    m1 = null;
                    m1 = p.matcher(filterValue);
                    if (!m1.find()) continue;
                    isPartOfFilter = true;
                    if (isPartOfFilterValue == null) {
                        isPartOfFilterValue = filterValue;
                        continue;
                    }
                    isPartOfFilterValue = isPartOfFilterValue + " OR " + filterValue;
                }
            }
            if (idFilter.booleanValue() || isPartOfFilter.booleanValue()) continue;
            mainFilterValue = mainFilterValue == null ? filterValue : mainFilterValue + " " + operator + " " + filterValue;
        }
        if (mainFilterValue != null) {
            completeFilterValue = mainFilterValue;
        }
        if ((nodeList.getLength() > 1 || exclude.booleanValue()) && completeFilterValue != null) {
            completeFilterValue = "(" + completeFilterValue + ")";
        }
        if (idFilterValue != null) {
            completeFilterValue = completeFilterValue != null ? "((" + completeFilterValue + ") OR " + idFilterValue + ")" : idFilterValue;
        }
        if (exclude.booleanValue() && completeFilterValue != null) {
            completeFilterValue = "(-" + completeFilterValue + " AND *:* )";
        }
        if (isPartOfFilterValue != null && !isPartOfFilterValue.isEmpty()) {
            completeFilterValue = completeFilterValue != null ? completeFilterValue + " OR " + isPartOfFilterValue : isPartOfFilterValue;
        }
        return completeFilterValue;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public List<LeafElement> getLeafs() {
        return this.leafs;
    }

    public void setLeafs(List<LeafElement> leafs) {
        this.leafs = leafs;
    }

    public List<FilterProcessor> getFilters() {
        return this.filters;
    }

    public void setFilters(List<FilterProcessor> filters) {
        this.filters = filters;
    }

    public String getMatchElement() {
        return this.matchElement;
    }

    public void setMatchElement(String matchElement) {
        this.matchElement = matchElement;
    }
}

