/*
 * Decompiled with CFR 0.152.
 */
package org.dataone.cn.indexer.resourcemap;

import java.io.StringWriter;
import java.util.HashSet;
import java.util.Set;
import org.dataone.cn.indexer.resourcemap.IndexVisibilityDelegate;
import org.dataone.cn.indexer.resourcemap.ResourceEntry;
import org.dataone.cn.indexer.resourcemap.ResourceMap;
import org.dataone.cn.indexer.resourcemap.XPathResourceMap;
import org.dataone.service.types.v1.Identifier;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class XPathResourceEntry
implements ResourceEntry {
    private Element entry = null;
    private String identifier = null;
    private Set<String> resourceMaps = new HashSet<String>();
    private Set<String> documents = new HashSet<String>();
    private Set<String> isDocumentedBy = new HashSet<String>();
    private String about = null;
    private XPathResourceMap parentMap = null;
    private IndexVisibilityDelegate indexVisibilityDelegate = null;

    public XPathResourceEntry(Element entry, ResourceMap parentMap, IndexVisibilityDelegate ivd) {
        this.getResourceMaps().add(parentMap.getIdentifier());
        this.setParentMap(parentMap);
        this.entry = entry;
        this.indexVisibilityDelegate = ivd;
        this.initEntry();
    }

    private void initEntry() {
        this.setAbout(this.entry.getAttributeNS("http://www.w3.org/1999/02/22-rdf-syntax-ns#", "about"));
        this.setIdentifier(this.entry.getElementsByTagNameNS("http://purl.org/dc/terms/", "identifier").item(0).getTextContent());
        NodeList nlDocuments = this.entry.getElementsByTagNameNS("http://purl.org/spar/cito/", "documents");
        this.documents = this.parseDocuments(nlDocuments);
        NodeList nlIsDocumentedBy = this.entry.getElementsByTagNameNS("http://purl.org/spar/cito/", "isDocumentedBy");
        this.isDocumentedBy = this.parseIsDocumentedBy(nlIsDocumentedBy);
    }

    private Set<String> parseIsDocumentedBy(NodeList nlIsDocumentedBy) {
        HashSet<String> isDocumentedByStrings = new HashSet<String>();
        for (int i = 0; i < nlIsDocumentedBy.getLength(); ++i) {
            Element isDocumentedByElement = (Element)nlIsDocumentedBy.item(i);
            String isDocumentedByString = isDocumentedByElement.getAttributeNS("http://www.w3.org/1999/02/22-rdf-syntax-ns#", "resource");
            String id = this.parentMap.getIdentifierFromResource(isDocumentedByString);
            Identifier pid = new Identifier();
            pid.setValue(id);
            if (!this.indexVisibilityDelegate.isDocumentVisible(pid)) continue;
            isDocumentedByStrings.add(id);
        }
        return isDocumentedByStrings;
    }

    private Set<String> parseDocuments(NodeList nlDocuments) {
        HashSet<String> documetsStrings = new HashSet<String>();
        for (int i = 0; i < nlDocuments.getLength(); ++i) {
            Element documentsElement = (Element)nlDocuments.item(i);
            String resource = documentsElement.getAttributeNS("http://www.w3.org/1999/02/22-rdf-syntax-ns#", "resource");
            String id = this.parentMap.getIdentifierFromResource(resource);
            Identifier pid = new Identifier();
            pid.setValue(id);
            if (!this.indexVisibilityDelegate.isDocumentVisible(pid)) continue;
            documetsStrings.add(id);
        }
        return documetsStrings;
    }

    Element getEntry() {
        return this.entry;
    }

    void setEntry(Element entry) {
        this.entry = entry;
    }

    @Override
    public Set<String> getResourceMaps() {
        if (this.resourceMaps == null) {
            this.resourceMaps = new HashSet<String>();
        }
        return this.resourceMaps;
    }

    @Override
    public void setResourceMaps(Set<String> resourceMaps) {
        this.resourceMaps = resourceMaps;
    }

    @Override
    public String getIdentifier() {
        return this.identifier;
    }

    @Override
    public void setIdentifier(String identifier) {
        this.identifier = identifier;
    }

    @Override
    public Set<String> getDocuments() {
        return this.documents;
    }

    void setDocuments(Set<String> documents) {
        this.documents = documents;
    }

    @Override
    public Set<String> getDocumentedBy() {
        return this.isDocumentedBy;
    }

    void setDocumentedBy(Set<String> documentedBy) {
        this.isDocumentedBy = documentedBy;
    }

    public String getAbout() {
        return this.about;
    }

    void setAbout(String about) {
        this.about = about;
    }

    @Override
    public String toString() {
        StringWriter sw = new StringWriter();
        sw.write("\tRESOURCE MAP ENTITY: ");
        sw.append(this.identifier);
        sw.write("\n");
        sw.write("\t\tDocuments: ");
        sw.write("\n");
        for (String documentString : this.documents) {
            sw.write("\t\t\t");
            sw.append(documentString);
            sw.write("\n");
        }
        sw.write("\t\tisDocumentedByString: ");
        sw.write("\n");
        for (String isDocumentedByString : this.isDocumentedBy) {
            sw.write("\t\t\t");
            sw.append(isDocumentedByString);
            sw.write("\n");
        }
        sw.write("\t\tResource Maps: ");
        sw.write("\n");
        for (String resourceMap : this.resourceMaps) {
            sw.write("\t\t\t");
            sw.append(resourceMap);
            sw.write("\n");
        }
        return sw.toString();
    }

    @Override
    public ResourceMap getParentMap() {
        return this.parentMap;
    }

    void setParentMap(ResourceMap parentMap) {
        this.parentMap = (XPathResourceMap)parentMap;
    }
}

