/*
 * Decompiled with CFR 0.152.
 */
package org.dataone.service.types.v1;

import java.io.Serializable;
import javax.security.auth.x500.X500Principal;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.XmlValue;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="Subject", propOrder={"value"})
@XmlRootElement(name="subject")
public class Subject
implements Serializable,
Comparable {
    private static final long serialVersionUID = 10000000L;
    @XmlValue
    protected String value;

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public boolean equals(Object other) {
        if (other == null || other.getClass() != this.getClass()) {
            return false;
        }
        Subject otherSubject = (Subject)other;
        String standardizedOtherSubject = this.standardizeDN(otherSubject.getValue());
        String standardizedSubject = this.standardizeDN(this.value);
        if (standardizedSubject == null) {
            return standardizedOtherSubject == null;
        }
        return standardizedSubject.equals(standardizedOtherSubject);
    }

    public int hashCode() {
        if (this.value == null) {
            return 0;
        }
        String standardizedSubject = this.standardizeDN(this.value);
        return standardizedSubject.hashCode();
    }

    public int compareTo(Object other) throws ClassCastException {
        Subject otherSubject = (Subject)other;
        String standardizedOtherSubject = this.standardizeDN(otherSubject.getValue());
        String standardizedSubject = this.standardizeDN(this.value);
        return standardizedSubject.compareTo(standardizedOtherSubject);
    }

    private String standardizeDN(String name) {
        String standardizedName = null;
        try {
            X500Principal principal = new X500Principal(name);
            standardizedName = principal.getName("RFC2253");
        }
        catch (IllegalArgumentException e2) {
            standardizedName = name;
        }
        return standardizedName;
    }
}

