/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.stat;

import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.hibernate.stat.CategorizedStatistics;
import org.hibernate.stat.QueryStatistics;

public class ConcurrentQueryStatisticsImpl
extends CategorizedStatistics
implements QueryStatistics {
    private final AtomicLong cacheHitCount = new AtomicLong();
    private final AtomicLong cacheMissCount = new AtomicLong();
    private final AtomicLong cachePutCount = new AtomicLong();
    private final AtomicLong executionCount = new AtomicLong();
    private final AtomicLong executionRowCount = new AtomicLong();
    private final AtomicLong executionMaxTime = new AtomicLong();
    private final AtomicLong executionMinTime = new AtomicLong(Long.MAX_VALUE);
    private final AtomicLong totalExecutionTime = new AtomicLong();
    private final Lock readLock;
    private final Lock writeLock;

    ConcurrentQueryStatisticsImpl(String query2) {
        super(query2);
        ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
        this.readLock = lock.readLock();
        this.writeLock = lock.writeLock();
    }

    public long getExecutionCount() {
        return this.executionCount.get();
    }

    public long getCacheHitCount() {
        return this.cacheHitCount.get();
    }

    public long getCachePutCount() {
        return this.cachePutCount.get();
    }

    public long getCacheMissCount() {
        return this.cacheMissCount.get();
    }

    public long getExecutionRowCount() {
        return this.executionRowCount.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getExecutionAvgTime() {
        this.writeLock.lock();
        try {
            long avgExecutionTime = 0L;
            if (this.executionCount.get() > 0L) {
                avgExecutionTime = this.totalExecutionTime.get() / this.executionCount.get();
            }
            long l = avgExecutionTime;
            Object var6_3 = null;
            this.writeLock.unlock();
            return l;
        }
        catch (Throwable throwable) {
            Object var6_4 = null;
            this.writeLock.unlock();
            throw throwable;
        }
    }

    public long getExecutionMaxTime() {
        return this.executionMaxTime.get();
    }

    public long getExecutionMinTime() {
        return this.executionMinTime.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void executed(long rows, long time) {
        this.readLock.lock();
        try {
            long old = this.executionMinTime.get();
            while (time < old && !this.executionMinTime.compareAndSet(old, time)) {
                old = this.executionMinTime.get();
            }
            old = this.executionMaxTime.get();
            while (time > old && !this.executionMaxTime.compareAndSet(old, time)) {
                old = this.executionMaxTime.get();
            }
            this.executionCount.getAndIncrement();
            this.executionRowCount.addAndGet(rows);
            this.totalExecutionTime.addAndGet(time);
            Object var8_4 = null;
            this.readLock.unlock();
        }
        catch (Throwable throwable) {
            Object var8_5 = null;
            this.readLock.unlock();
            throw throwable;
        }
    }

    public String toString() {
        return "QueryStatistics" + "[cacheHitCount=" + this.cacheHitCount + ",cacheMissCount=" + this.cacheMissCount + ",cachePutCount=" + this.cachePutCount + ",executionCount=" + this.executionCount + ",executionRowCount=" + this.executionRowCount + ",executionAvgTime=" + this.getExecutionAvgTime() + ",executionMaxTime=" + this.executionMaxTime + ",executionMinTime=" + this.executionMinTime + ']';
    }

    void incrementCacheHitCount() {
        this.cacheHitCount.getAndIncrement();
    }

    void incrementCacheMissCount() {
        this.cacheMissCount.getAndIncrement();
    }

    void incrementCachePutCount() {
        this.cachePutCount.getAndIncrement();
    }
}

