/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.util;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import org.hibernate.util.ArrayHelper;
import org.hibernate.util.StringHelper;

public final class PropertiesHelper {
    private static final String PLACEHOLDER_START = "${";

    private PropertiesHelper() {
    }

    public static String getString(String propertyName, Properties properties, String defaultValue) {
        String value = PropertiesHelper.extractPropertyValue(propertyName, properties);
        return value == null ? defaultValue : value;
    }

    public static String extractPropertyValue(String propertyName, Properties properties) {
        String value = properties.getProperty(propertyName);
        if (value == null) {
            return null;
        }
        if (StringHelper.isEmpty(value = value.trim())) {
            return null;
        }
        return value;
    }

    public static boolean getBoolean(String propertyName, Properties properties) {
        return PropertiesHelper.getBoolean(propertyName, properties, false);
    }

    public static boolean getBoolean(String propertyName, Properties properties, boolean defaultValue) {
        String value = PropertiesHelper.extractPropertyValue(propertyName, properties);
        return value == null ? defaultValue : Boolean.valueOf(value);
    }

    public static int getInt(String propertyName, Properties properties, int defaultValue) {
        String value = PropertiesHelper.extractPropertyValue(propertyName, properties);
        return value == null ? defaultValue : Integer.parseInt(value);
    }

    public static Integer getInteger(String propertyName, Properties properties) {
        String value = PropertiesHelper.extractPropertyValue(propertyName, properties);
        return value == null ? null : Integer.valueOf(value);
    }

    public static Map toMap(String propertyName, String delim, Properties properties) {
        HashMap<String, String> map = new HashMap<String, String>();
        String value = PropertiesHelper.extractPropertyValue(propertyName, properties);
        if (value != null) {
            StringTokenizer tokens2 = new StringTokenizer(value, delim);
            while (tokens2.hasMoreTokens()) {
                map.put(tokens2.nextToken(), tokens2.hasMoreElements() ? tokens2.nextToken() : "");
            }
        }
        return map;
    }

    public static String[] toStringArray(String propertyName, String delim, Properties properties) {
        return PropertiesHelper.toStringArray(PropertiesHelper.extractPropertyValue(propertyName, properties), delim);
    }

    public static String[] toStringArray(String stringForm, String delim) {
        if (stringForm != null) {
            return StringHelper.split(delim, stringForm);
        }
        return ArrayHelper.EMPTY_STRING_ARRAY;
    }

    public static Properties maskOut(Properties props, String key) {
        Properties clone = (Properties)props.clone();
        if (clone.get(key) != null) {
            clone.setProperty(key, "****");
        }
        return clone;
    }

    public static void resolvePlaceHolders(Properties properties) {
        Iterator<Map.Entry<Object, Object>> itr = properties.entrySet().iterator();
        while (itr.hasNext()) {
            String resolved;
            Map.Entry<Object, Object> entry = itr.next();
            Object value = entry.getValue();
            if (value == null || !String.class.isInstance(value) || value.equals(resolved = PropertiesHelper.resolvePlaceHolder((String)value))) continue;
            if (resolved == null) {
                itr.remove();
                continue;
            }
            entry.setValue(resolved);
        }
    }

    public static String resolvePlaceHolder(String property) {
        String rtn;
        if (property.indexOf(PLACEHOLDER_START) < 0) {
            return property;
        }
        StringBuffer buff = new StringBuffer();
        char[] chars = property.toCharArray();
        for (int pos = 0; pos < chars.length; ++pos) {
            if (chars[pos] == '$' && chars[pos + 1] == '{') {
                int x;
                String systemPropertyName = "";
                for (x = pos + 2; x < chars.length && chars[x] != '}'; ++x) {
                    systemPropertyName = systemPropertyName + chars[x];
                    if (x != chars.length - 1) continue;
                    throw new IllegalArgumentException("unmatched placeholder start [" + property + "]");
                }
                String systemProperty = PropertiesHelper.extractFromSystem(systemPropertyName);
                buff.append(systemProperty == null ? "" : systemProperty);
                pos = x + 1;
                if (pos >= chars.length) break;
            }
            buff.append(chars[pos]);
        }
        return StringHelper.isEmpty(rtn = buff.toString()) ? null : rtn;
    }

    private static String extractFromSystem(String systemPropertyName) {
        try {
            return System.getProperty(systemPropertyName);
        }
        catch (Throwable t) {
            return null;
        }
    }
}

