/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.repository.config;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.context.annotation.ClassPathScanningCandidateComponentProvider;
import org.springframework.core.io.ResourceLoader;
import org.springframework.core.type.filter.RegexPatternTypeFilter;
import org.springframework.data.repository.config.NamedQueriesBeanDefinitionBuilder;
import org.springframework.data.repository.config.RepositoryConfiguration;
import org.springframework.data.repository.config.RepositoryConfigurationExtension;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class RepositoryBeanDefinitionBuilder {
    private static final Logger LOGGER = LoggerFactory.getLogger(RepositoryBeanDefinitionBuilder.class);
    private final RepositoryConfiguration<?> configuration;
    private final RepositoryConfigurationExtension extension;

    public RepositoryBeanDefinitionBuilder(RepositoryConfiguration<?> configuration, RepositoryConfigurationExtension extension) {
        Assert.notNull(configuration);
        Assert.notNull(extension);
        this.configuration = configuration;
        this.extension = extension;
    }

    public BeanDefinitionBuilder build(BeanDefinitionRegistry registry, ResourceLoader resourceLoader) {
        Assert.notNull(registry, "BeanDefinitionRegistry must not be null!");
        Assert.notNull(resourceLoader, "ResourceLoader must not be null!");
        String factoryBeanName = this.configuration.getRepositoryFactoryBeanName();
        factoryBeanName = StringUtils.hasText(factoryBeanName) ? factoryBeanName : this.extension.getRepositoryFactoryClassName();
        BeanDefinitionBuilder builder = BeanDefinitionBuilder.rootBeanDefinition(factoryBeanName);
        builder.getRawBeanDefinition().setSource(this.configuration.getSource());
        builder.addPropertyValue("repositoryInterface", this.configuration.getRepositoryInterface());
        builder.addPropertyValue("queryLookupStrategyKey", this.configuration.getQueryLookupStrategyKey());
        NamedQueriesBeanDefinitionBuilder definitionBuilder = new NamedQueriesBeanDefinitionBuilder(this.extension.getDefaultNamedQueryLocation());
        if (StringUtils.hasText(this.configuration.getNamedQueriesLocation())) {
            definitionBuilder.setLocations(this.configuration.getNamedQueriesLocation());
        }
        builder.addPropertyValue("namedQueries", definitionBuilder.build(this.configuration.getSource()));
        String customImplementationBeanName = this.registerCustomImplementation(registry, resourceLoader);
        if (customImplementationBeanName != null) {
            builder.addPropertyReference("customImplementation", customImplementationBeanName);
            builder.addDependsOn(customImplementationBeanName);
        }
        return builder;
    }

    private String registerCustomImplementation(BeanDefinitionRegistry registry, ResourceLoader resourceLoader) {
        String beanName = this.configuration.getImplementationBeanName();
        if (registry.containsBeanDefinition(beanName)) {
            return beanName;
        }
        AbstractBeanDefinition beanDefinition = this.detectCustomImplementation(registry, resourceLoader);
        if (null == beanDefinition) {
            return null;
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Registering custom repository implementation: " + this.configuration.getImplementationBeanName() + " " + beanDefinition.getBeanClassName());
        }
        beanDefinition.setSource(this.configuration.getSource());
        registry.registerBeanDefinition(beanName, beanDefinition);
        return beanName;
    }

    private AbstractBeanDefinition detectCustomImplementation(BeanDefinitionRegistry registry, ResourceLoader loader) {
        Pattern pattern = Pattern.compile(".*\\." + this.configuration.getImplementationClassName());
        ClassPathScanningCandidateComponentProvider provider = new ClassPathScanningCandidateComponentProvider(false);
        provider.setResourceLoader(loader);
        provider.addIncludeFilter(new RegexPatternTypeFilter(pattern));
        HashSet<BeanDefinition> definitions = new HashSet<BeanDefinition>();
        for (String basePackage : this.configuration.getBasePackages()) {
            definitions.addAll(provider.findCandidateComponents(basePackage));
        }
        if (definitions.isEmpty()) {
            return null;
        }
        if (definitions.size() == 1) {
            return (AbstractBeanDefinition)definitions.iterator().next();
        }
        ArrayList<String> implementationClassNames = new ArrayList<String>();
        for (BeanDefinition bean : definitions) {
            implementationClassNames.add(bean.getBeanClassName());
        }
        throw new IllegalStateException(String.format("Ambiguous custom implementations detected! Found %s but expected a single implementation!", StringUtils.collectionToCommaDelimitedString(implementationClassNames)));
    }
}

