/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.repository.core.support;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.PropertyValue;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.config.InstantiationAwareBeanPostProcessorAdapter;
import org.springframework.beans.factory.config.TypedStringValue;
import org.springframework.core.PriorityOrdered;
import org.springframework.data.repository.core.support.RepositoryFactoryBeanSupport;
import org.springframework.util.ClassUtils;

class RepositoryInterfaceAwareBeanPostProcessor
extends InstantiationAwareBeanPostProcessorAdapter
implements BeanFactoryAware,
PriorityOrdered {
    private static final Logger LOGGER = LoggerFactory.getLogger(RepositoryInterfaceAwareBeanPostProcessor.class);
    private static final Class<?> REPOSITORY_TYPE = RepositoryFactoryBeanSupport.class;
    private final Map<String, Class<?>> cache = new ConcurrentHashMap();
    private ConfigurableListableBeanFactory context;

    RepositoryInterfaceAwareBeanPostProcessor() {
    }

    @Override
    public void setBeanFactory(BeanFactory beanFactory) {
        if (beanFactory instanceof ConfigurableListableBeanFactory) {
            this.context = (ConfigurableListableBeanFactory)beanFactory;
        }
    }

    @Override
    public Class<?> predictBeanType(Class<?> beanClass, String beanName) {
        if (null == this.context || !REPOSITORY_TYPE.isAssignableFrom(beanClass)) {
            return null;
        }
        BeanDefinition definition = this.context.getBeanDefinition(beanName);
        PropertyValue value = definition.getPropertyValues().getPropertyValue("repositoryInterface");
        Class<?> resolvedBeanClass = this.cache.get(beanName);
        if (this.cache.containsKey(beanName)) {
            return this.cache.get(beanName);
        }
        resolvedBeanClass = this.getClassForPropertyValue(value, beanName);
        this.cache.put(beanName, resolvedBeanClass);
        return resolvedBeanClass == Void.class ? null : resolvedBeanClass;
    }

    private Class<?> getClassForPropertyValue(PropertyValue propertyValue, String beanName) {
        Object value = propertyValue.getValue();
        String className = null;
        if (value instanceof TypedStringValue) {
            className = ((TypedStringValue)value).getValue();
        } else if (value instanceof String) {
            className = (String)value;
        } else {
            if (value instanceof Class) {
                return (Class)value;
            }
            return Void.class;
        }
        try {
            return ClassUtils.resolveClassName(className, this.context.getBeanClassLoader());
        }
        catch (IllegalArgumentException ex) {
            LOGGER.warn(String.format("Couldn't load class %s referenced as repository interface in bean %s!", className, beanName));
            return Void.class;
        }
    }

    @Override
    public int getOrder() {
        return 0x7FFFFFFE;
    }
}

