/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.http.converter;

import java.io.IOException;
import java.io.InputStream;
import javax.activation.FileTypeMap;
import javax.activation.MimetypesFileTypeMap;
import org.springframework.core.io.ByteArrayResource;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;
import org.springframework.http.HttpInputMessage;
import org.springframework.http.HttpOutputMessage;
import org.springframework.http.MediaType;
import org.springframework.http.converter.AbstractHttpMessageConverter;
import org.springframework.http.converter.HttpMessageNotReadableException;
import org.springframework.http.converter.HttpMessageNotWritableException;
import org.springframework.util.ClassUtils;
import org.springframework.util.FileCopyUtils;
import org.springframework.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResourceHttpMessageConverter
extends AbstractHttpMessageConverter<Resource> {
    private static final boolean jafPresent = ClassUtils.isPresent("javax.activation.FileTypeMap", ResourceHttpMessageConverter.class.getClassLoader());

    public ResourceHttpMessageConverter() {
        super(MediaType.ALL);
    }

    @Override
    protected boolean supports(Class<?> clazz) {
        return Resource.class.isAssignableFrom(clazz);
    }

    @Override
    protected Resource readInternal(Class<? extends Resource> clazz, HttpInputMessage inputMessage) throws IOException, HttpMessageNotReadableException {
        byte[] body = FileCopyUtils.copyToByteArray(inputMessage.getBody());
        return new ByteArrayResource(body);
    }

    @Override
    protected MediaType getDefaultContentType(Resource resource) {
        if (jafPresent) {
            return ActivationMediaTypeFactory.getMediaType(resource);
        }
        return MediaType.APPLICATION_OCTET_STREAM;
    }

    @Override
    protected Long getContentLength(Resource resource, MediaType contentType) throws IOException {
        return resource.contentLength();
    }

    @Override
    protected void writeInternal(Resource resource, HttpOutputMessage outputMessage) throws IOException, HttpMessageNotWritableException {
        FileCopyUtils.copy(resource.getInputStream(), outputMessage.getBody());
        outputMessage.getBody().flush();
    }

    private static class ActivationMediaTypeFactory {
        private static final FileTypeMap fileTypeMap = ActivationMediaTypeFactory.loadFileTypeMapFromContextSupportModule();

        private ActivationMediaTypeFactory() {
        }

        /*
         * Loose catch block
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private static FileTypeMap loadFileTypeMapFromContextSupportModule() {
            ClassPathResource mappingLocation = new ClassPathResource("org/springframework/mail/javamail/mime.types");
            if (!mappingLocation.exists()) return FileTypeMap.getDefaultFileTypeMap();
            InputStream inputStream = null;
            inputStream = mappingLocation.getInputStream();
            MimetypesFileTypeMap mimetypesFileTypeMap = new MimetypesFileTypeMap(inputStream);
            if (inputStream == null) return mimetypesFileTypeMap;
            try {
                inputStream.close();
                return mimetypesFileTypeMap;
            }
            catch (IOException iOException) {}
            return mimetypesFileTypeMap;
            catch (IOException iOException) {
                try {
                    if (inputStream == null) return FileTypeMap.getDefaultFileTypeMap();
                }
                catch (Throwable throwable) {
                    if (inputStream == null) throw throwable;
                    try {
                        inputStream.close();
                        throw throwable;
                    }
                    catch (IOException iOException2) {}
                    throw throwable;
                }
                try {
                    inputStream.close();
                    return FileTypeMap.getDefaultFileTypeMap();
                }
                catch (IOException iOException3) {}
                return FileTypeMap.getDefaultFileTypeMap();
            }
        }

        public static MediaType getMediaType(Resource resource) {
            String mediaType = fileTypeMap.getContentType(resource.getFilename());
            return StringUtils.hasText(mediaType) ? MediaType.parseMediaType(mediaType) : null;
        }
    }
}

