/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.test.context.support;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.support.ResourcePatternUtils;
import org.springframework.test.context.ContextConfigurationAttributes;
import org.springframework.test.context.SmartContextLoader;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractContextLoader
implements SmartContextLoader {
    private static final Log logger = LogFactory.getLog(AbstractContextLoader.class);
    private static final String[] EMPTY_STRING_ARRAY = new String[0];
    private static final String SLASH = "/";

    @Override
    public void processContextConfiguration(ContextConfigurationAttributes configAttributes) {
        String[] processedLocations = this.processLocations(configAttributes.getDeclaringClass(), configAttributes.getLocations());
        configAttributes.setLocations(processedLocations);
    }

    @Override
    public final String[] processLocations(Class<?> clazz, String ... locations) {
        return ObjectUtils.isEmpty(locations) && this.isGenerateDefaultLocations() ? this.generateDefaultLocations(clazz) : this.modifyLocations(clazz, locations);
    }

    protected String[] generateDefaultLocations(Class<?> clazz) {
        Assert.notNull(clazz, "Class must not be null");
        String suffix = this.getResourceSuffix();
        Assert.hasText(suffix, "Resource suffix must not be empty");
        String resourcePath = SLASH + ClassUtils.convertClassNameToResourcePath(clazz.getName()) + suffix;
        String prefixedResourcePath = "classpath:" + resourcePath;
        ClassPathResource classPathResource = new ClassPathResource(resourcePath, clazz);
        if (classPathResource.exists()) {
            if (logger.isInfoEnabled()) {
                logger.info(String.format("Detected default resource location \"%s\" for test class [%s].", prefixedResourcePath, clazz.getName()));
            }
            return new String[]{prefixedResourcePath};
        }
        if (logger.isInfoEnabled()) {
            logger.info(String.format("Could not detect default resource locations for test class [%s]: %s does not exist.", clazz.getName(), classPathResource));
        }
        return EMPTY_STRING_ARRAY;
    }

    protected String[] modifyLocations(Class<?> clazz, String ... locations) {
        String[] modifiedLocations = new String[locations.length];
        int i = 0;
        while (i < locations.length) {
            String path = locations[i];
            modifiedLocations[i] = path.startsWith(SLASH) ? "classpath:" + path : (!ResourcePatternUtils.isUrl(path) ? "classpath:/" + StringUtils.cleanPath(String.valueOf(ClassUtils.classPackageAsResourcePath(clazz)) + SLASH + path) : StringUtils.cleanPath(path));
            ++i;
        }
        return modifiedLocations;
    }

    protected boolean isGenerateDefaultLocations() {
        return true;
    }

    protected abstract String getResourceSuffix();
}

