/*
 * Decompiled with CFR 0.152.
 */
package tdb;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.sparql.core.Quad;
import com.hp.hpl.jena.tdb.solver.SolverLib;
import com.hp.hpl.jena.tdb.solver.stats.Stats;
import com.hp.hpl.jena.tdb.solver.stats.StatsCollectorNodeId;
import com.hp.hpl.jena.tdb.solver.stats.StatsResults;
import com.hp.hpl.jena.tdb.store.DatasetGraphTDB;
import com.hp.hpl.jena.tdb.store.NodeId;
import com.hp.hpl.jena.tdb.store.nodetable.NodeTable;
import com.hp.hpl.jena.tdb.store.nodetupletable.NodeTupleTable;
import java.util.Iterator;
import org.apache.jena.atlas.lib.Tuple;
import org.apache.jena.atlas.logging.Log;
import tdb.cmdline.CmdTDB;
import tdb.cmdline.CmdTDBGraph;

public class tdbstats
extends CmdTDBGraph {
    public static void main(String ... argv) {
        CmdTDB.init();
        new tdbstats(argv).mainRun();
    }

    protected tdbstats(String[] argv) {
        super(argv);
    }

    @Override
    protected String getSummary() {
        return null;
    }

    public static StatsResults stats(DatasetGraphTDB dsg, Node gn) {
        NodeTable nt = dsg.getTripleTable().getNodeTupleTable().getNodeTable();
        StatsCollectorNodeId stats = new StatsCollectorNodeId(nt);
        if (gn == null) {
            Iterator<Tuple<NodeId>> iter = dsg.getTripleTable().getNodeTupleTable().findAll();
            while (iter.hasNext()) {
                Tuple<NodeId> t = iter.next();
                stats.record(null, t.get(0), t.get(1), t.get(2));
            }
        } else {
            Iterator<Tuple<NodeId>> iter;
            boolean unionGraph = Quad.isUnionGraph(gn);
            NodeId gnid = null;
            if (!unionGraph && NodeId.isDoesNotExist(gnid = nt.getNodeIdForNode(gn))) {
                Log.warn(tdbstats.class, "No such graph: " + gn);
            }
            NodeTupleTable ntt = dsg.getQuadTable().getNodeTupleTable();
            Iterator<Tuple<NodeId>> iterator = iter = unionGraph ? SolverLib.unionGraph(ntt) : ntt.find(gnid, null, null, null);
            while (iter.hasNext()) {
                Tuple<NodeId> t = iter.next();
                stats.record(t.get(0), t.get(1), t.get(2), t.get(3));
            }
        }
        return stats.results();
    }

    @Override
    protected void exec() {
        DatasetGraphTDB dsg = this.getDatasetGraphTDB();
        Node gn = this.getGraphName();
        StatsResults results = tdbstats.stats(dsg, gn);
        Stats.write(System.out, results);
    }
}

