/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.impl;

import com.hazelcast.config.SemaphoreConfig;
import com.hazelcast.core.DistributedTask;
import com.hazelcast.core.HazelcastException;
import com.hazelcast.core.Instance;
import com.hazelcast.core.InstanceDestroyedException;
import com.hazelcast.core.MapEntry;
import com.hazelcast.core.Member;
import com.hazelcast.core.MemberLeftException;
import com.hazelcast.core.OperationTimeoutException;
import com.hazelcast.core.RuntimeInterruptedException;
import com.hazelcast.core.SemaphoreFactory;
import com.hazelcast.impl.AtomicNumberProxy;
import com.hazelcast.impl.BaseManager;
import com.hazelcast.impl.CMap;
import com.hazelcast.impl.ClusterOperation;
import com.hazelcast.impl.Constants;
import com.hazelcast.impl.Entries;
import com.hazelcast.impl.FallThroughRunnable;
import com.hazelcast.impl.Keys;
import com.hazelcast.impl.MProxy;
import com.hazelcast.impl.MemberImpl;
import com.hazelcast.impl.NearCache;
import com.hazelcast.impl.Node;
import com.hazelcast.impl.PartitionManager;
import com.hazelcast.impl.PartitionServiceImpl;
import com.hazelcast.impl.Processable;
import com.hazelcast.impl.Record;
import com.hazelcast.impl.Request;
import com.hazelcast.impl.SemaphoreProxy;
import com.hazelcast.impl.ThreadContext;
import com.hazelcast.impl.TransactionImpl;
import com.hazelcast.impl.Util;
import com.hazelcast.impl.base.AddressAwareException;
import com.hazelcast.impl.base.CallStateAware;
import com.hazelcast.impl.base.CpuUtilization;
import com.hazelcast.impl.base.DataRecordEntry;
import com.hazelcast.impl.base.DistributedCountDownLatch;
import com.hazelcast.impl.base.DistributedLock;
import com.hazelcast.impl.base.DistributedSemaphore;
import com.hazelcast.impl.base.KeyValue;
import com.hazelcast.impl.base.PacketProcessor;
import com.hazelcast.impl.base.Pairs;
import com.hazelcast.impl.base.ScheduledAction;
import com.hazelcast.impl.base.SystemLogService;
import com.hazelcast.impl.base.Values;
import com.hazelcast.impl.concurrentmap.GetAllCallable;
import com.hazelcast.impl.concurrentmap.IllegalPartitionState;
import com.hazelcast.impl.concurrentmap.LocalLock;
import com.hazelcast.impl.concurrentmap.MapQueryCallable;
import com.hazelcast.impl.concurrentmap.MapSizeCallable;
import com.hazelcast.impl.concurrentmap.MapSystemLogFactory;
import com.hazelcast.impl.concurrentmap.MultiData;
import com.hazelcast.impl.concurrentmap.PutAllCallable;
import com.hazelcast.impl.concurrentmap.QueryException;
import com.hazelcast.impl.concurrentmap.RecordFactory;
import com.hazelcast.impl.concurrentmap.ValueHolder;
import com.hazelcast.impl.executor.ParallelExecutor;
import com.hazelcast.impl.monitor.AtomicNumberOperationsCounter;
import com.hazelcast.impl.monitor.CountDownLatchOperationsCounter;
import com.hazelcast.impl.monitor.LocalMapStatsImpl;
import com.hazelcast.impl.monitor.SemaphoreOperationsCounter;
import com.hazelcast.impl.partition.PartitionInfo;
import com.hazelcast.impl.wan.WanMergeListener;
import com.hazelcast.merge.MergePolicy;
import com.hazelcast.nio.Address;
import com.hazelcast.nio.Data;
import com.hazelcast.nio.IOUtil;
import com.hazelcast.nio.Packet;
import com.hazelcast.nio.Serializer;
import com.hazelcast.query.Index;
import com.hazelcast.query.MapIndexService;
import com.hazelcast.query.Predicate;
import com.hazelcast.query.QueryContext;
import com.hazelcast.util.Clock;
import com.hazelcast.util.DistributedTimeoutException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.logging.Level;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConcurrentMapManager
extends BaseManager {
    private static final String BATCH_OPS_EXECUTOR_NAME = "hz.batch";
    final int partitionCount;
    final int maxBackupCount;
    final long globalRemoveDelayMillis;
    final boolean backupRedoEnabled;
    final boolean logState;
    long lastLogStateTime = Clock.currentTimeMillis();
    final ConcurrentMap<String, CMap> maps;
    final ConcurrentMap<String, NearCache> mapCaches;
    final PartitionServiceImpl partitionServiceImpl;
    final PartitionManager partitionManager;
    long newRecordId = 0L;
    final ParallelExecutor storeExecutor;
    final ParallelExecutor evictionExecutor;
    final RecordFactory recordFactory;
    final Collection<WanMergeListener> colWanMergeListeners = new CopyOnWriteArrayList<WanMergeListener>();

    ConcurrentMapManager(Node node) {
        super(node);
        this.recordFactory = node.initializer.getRecordFactory();
        this.storeExecutor = node.executorManager.newParallelExecutor(node.groupProperties.EXECUTOR_STORE_THREAD_COUNT.getInteger());
        this.evictionExecutor = node.executorManager.newParallelExecutor(node.groupProperties.EXECUTOR_STORE_THREAD_COUNT.getInteger());
        this.partitionCount = node.groupProperties.CONCURRENT_MAP_PARTITION_COUNT.getInteger();
        this.maxBackupCount = 6;
        this.backupRedoEnabled = node.groupProperties.BACKUP_REDO_ENABLED.getBoolean();
        int removeDelaySeconds = node.groupProperties.REMOVE_DELAY_SECONDS.getInteger();
        if (removeDelaySeconds <= 0) {
            this.logger.log(Level.WARNING, "hazelcast.map.remove.delay.seconds must be greater than zero. Setting to 1.");
            removeDelaySeconds = 1;
        }
        this.globalRemoveDelayMillis = (long)removeDelaySeconds * 1000L;
        this.logState = node.groupProperties.LOG_STATE.getBoolean();
        this.maps = new ConcurrentHashMap<String, CMap>(10, 0.75f, 1);
        this.mapCaches = new ConcurrentHashMap<String, NearCache>(10, 0.75f, 1);
        this.partitionManager = new PartitionManager(this);
        this.partitionServiceImpl = new PartitionServiceImpl(this);
        node.executorManager.getScheduledExecutorService().scheduleAtFixedRate(new Runnable(){

            public void run() {
                ConcurrentMapManager.this.startCleanup(true, false);
            }
        }, 1L, 1L, TimeUnit.SECONDS);
        this.registerPacketProcessor(ClusterOperation.CONCURRENT_MAP_GET_MAP_ENTRY, new GetMapEntryOperationHandler());
        this.registerPacketProcessor(ClusterOperation.CONCURRENT_MAP_GET_DATA_RECORD_ENTRY, new GetDataRecordEntryOperationHandler());
        this.registerPacketProcessor(ClusterOperation.CONCURRENT_MAP_GET, new GetOperationHandler());
        this.registerPacketProcessor(ClusterOperation.CONCURRENT_MAP_ASYNC_MERGE, new AsyncMergePacketProcessor());
        this.registerPacketProcessor(ClusterOperation.CONCURRENT_MAP_WAN_MERGE, new WanMergePacketProcessor());
        this.registerPacketProcessor(ClusterOperation.CONCURRENT_MAP_MERGE, new MergeOperationHandler());
        this.registerPacketProcessor(ClusterOperation.CONCURRENT_MAP_TRY_PUT, new PutOperationHandler());
        this.registerPacketProcessor(ClusterOperation.CONCURRENT_MAP_SET, new PutOperationHandler());
        this.registerPacketProcessor(ClusterOperation.CONCURRENT_MAP_PUT, new PutOperationHandler());
        this.registerPacketProcessor(ClusterOperation.CONCURRENT_MAP_PUT_AND_UNLOCK, new PutOperationHandler());
        this.registerPacketProcessor(ClusterOperation.CONCURRENT_MAP_PUT_IF_ABSENT, new PutOperationHandler());
        this.registerPacketProcessor(ClusterOperation.CONCURRENT_MAP_REPLACE_IF_NOT_NULL, new PutOperationHandler());
        this.registerPacketProcessor(ClusterOperation.CONCURRENT_MAP_PUT_TRANSIENT, new PutTransientOperationHandler());
        this.registerPacketProcessor(ClusterOperation.CONCURRENT_MAP_PUT_FROM_LOAD, new PutFromLoadOperationHandler());
        this.registerPacketProcessor(ClusterOperation.CONCURRENT_MAP_REPLACE_IF_SAME, new ReplaceOperationHandler());
        this.registerPacketProcessor(ClusterOperation.CONCURRENT_MAP_PUT_MULTI, new PutMultiOperationHandler());
        this.registerPacketProcessor(ClusterOperation.CONCURRENT_MAP_REMOVE, new RemoveOperationHandler());
        this.registerPacketProcessor(ClusterOperation.CONCURRENT_MAP_EVICT, new EvictOperationHandler());
        this.registerPacketProcessor(ClusterOperation.CONCURRENT_MAP_REMOVE_IF_SAME, new RemoveIfSameOperationHandler());
        this.registerPacketProcessor(ClusterOperation.CONCURRENT_MAP_REMOVE_ITEM, new RemoveItemOperationHandler());
        this.registerPacketProcessor(ClusterOperation.CONCURRENT_MAP_BACKUP_PUT, new BackupOperationHandler());
        this.registerPacketProcessor(ClusterOperation.CONCURRENT_MAP_BACKUP_PUT_AND_UNLOCK, new BackupOperationHandler());
        this.registerPacketProcessor(ClusterOperation.CONCURRENT_MAP_BACKUP_ADD, new BackupOperationHandler());
        this.registerPacketProcessor(ClusterOperation.CONCURRENT_MAP_BACKUP_REMOVE_MULTI, new BackupOperationHandler());
        this.registerPacketProcessor(ClusterOperation.CONCURRENT_MAP_BACKUP_REMOVE, new BackupOperationHandler());
        this.registerPacketProcessor(ClusterOperation.CONCURRENT_MAP_BACKUP_LOCK, new BackupOperationHandler());
        this.registerPacketProcessor(ClusterOperation.CONCURRENT_MAP_LOCK, new LockOperationHandler());
        this.registerPacketProcessor(ClusterOperation.CONCURRENT_MAP_IS_KEY_LOCKED, new IsKeyLockedOperationHandler());
        this.registerPacketProcessor(ClusterOperation.CONCURRENT_MAP_TRY_LOCK_AND_GET, new LockOperationHandler());
        this.registerPacketProcessor(ClusterOperation.CONCURRENT_MAP_UNLOCK, new UnlockOperationHandler());
        this.registerPacketProcessor(ClusterOperation.CONCURRENT_MAP_FORCE_UNLOCK, new ForceUnlockOperationHandler());
        this.registerPacketProcessor(ClusterOperation.CONCURRENT_MAP_LOCK_MAP, new LockMapOperationHandler());
        this.registerPacketProcessor(ClusterOperation.CONCURRENT_MAP_UNLOCK_MAP, new LockMapOperationHandler());
        this.registerPacketProcessor(ClusterOperation.CONCURRENT_MAP_REMOVE_MULTI, new RemoveMultiOperationHandler());
        this.registerPacketProcessor(ClusterOperation.CONCURRENT_MAP_ADD_TO_LIST, new AddOperationHandler());
        this.registerPacketProcessor(ClusterOperation.CONCURRENT_MAP_ADD_TO_SET, new AddOperationHandler());
        this.registerPacketProcessor(ClusterOperation.CONCURRENT_MAP_CONTAINS_KEY, new ContainsKeyOperationHandler());
        this.registerPacketProcessor(ClusterOperation.CONCURRENT_MAP_CONTAINS_ENTRY, new ContainsEntryOperationHandler());
        this.registerPacketProcessor(ClusterOperation.CONCURRENT_MAP_CONTAINS_VALUE, new ContainsValueOperationHandler());
        this.registerPacketProcessor(ClusterOperation.CONCURRENT_MAP_VALUE_COUNT, new ValueCountOperationHandler());
        this.registerPacketProcessor(ClusterOperation.CONCURRENT_MAP_INVALIDATE, new InvalidateOperationHandler());
        this.registerPacketProcessor(ClusterOperation.CONCURRENT_MAP_CLEAR_QUICK, new ClearQuickOperationHandler());
        this.registerPacketProcessor(ClusterOperation.ATOMIC_NUMBER_ADD_AND_GET, new AtomicNumberAddAndGetOperationHandler());
        this.registerPacketProcessor(ClusterOperation.ATOMIC_NUMBER_COMPARE_AND_SET, new AtomicNumberCompareAndSetOperationHandler());
        this.registerPacketProcessor(ClusterOperation.ATOMIC_NUMBER_GET_AND_ADD, new AtomicNumberGetAndAddOperationHandler());
        this.registerPacketProcessor(ClusterOperation.ATOMIC_NUMBER_GET_AND_SET, new AtomicNumberGetAndSetOperationHandler());
        this.registerPacketProcessor(ClusterOperation.COUNT_DOWN_LATCH_AWAIT, new CountDownLatchAwaitOperationHandler());
        this.registerPacketProcessor(ClusterOperation.COUNT_DOWN_LATCH_COUNT_DOWN, new CountDownLatchCountDownOperationHandler());
        this.registerPacketProcessor(ClusterOperation.COUNT_DOWN_LATCH_DESTROY, new CountDownLatchDestroyOperationHandler());
        this.registerPacketProcessor(ClusterOperation.COUNT_DOWN_LATCH_GET_COUNT, new CountDownLatchGetCountOperationHandler());
        this.registerPacketProcessor(ClusterOperation.COUNT_DOWN_LATCH_GET_OWNER, new CountDownLatchGetOwnerOperationHandler());
        this.registerPacketProcessor(ClusterOperation.COUNT_DOWN_LATCH_SET_COUNT, new CountDownLatchSetCountOperationHandler());
        this.registerPacketProcessor(ClusterOperation.SEMAPHORE_ATTACH_DETACH_PERMITS, new SemaphoreAttachDetachOperationHandler());
        this.registerPacketProcessor(ClusterOperation.SEMAPHORE_CANCEL_ACQUIRE, new SemaphoreCancelAcquireOperationHandler());
        this.registerPacketProcessor(ClusterOperation.SEMAPHORE_DESTROY, new SemaphoreDestroyOperationHandler());
        this.registerPacketProcessor(ClusterOperation.SEMAPHORE_DRAIN_PERMITS, new SemaphoreDrainOperationHandler());
        this.registerPacketProcessor(ClusterOperation.SEMAPHORE_GET_ATTACHED_PERMITS, new SemaphoreGetAttachedOperationHandler());
        this.registerPacketProcessor(ClusterOperation.SEMAPHORE_GET_AVAILABLE_PERMITS, new SemaphoreGetAvailableOperationHandler());
        this.registerPacketProcessor(ClusterOperation.SEMAPHORE_REDUCE_PERMITS, new SemaphoreReduceOperationHandler());
        this.registerPacketProcessor(ClusterOperation.SEMAPHORE_RELEASE, new SemaphoreReleaseOperationHandler());
        this.registerPacketProcessor(ClusterOperation.SEMAPHORE_TRY_ACQUIRE, new SemaphoreTryAcquireOperationHandler());
    }

    public PartitionManager getPartitionManager() {
        return this.partitionManager;
    }

    public void addWanMergeListener(WanMergeListener listener) {
        this.colWanMergeListeners.add(listener);
    }

    public void removeWanMergeListener(WanMergeListener listener) {
        this.colWanMergeListeners.remove(listener);
    }

    public void onRestart() {
        this.enqueueAndWait(new Processable(){

            public void process() {
                ConcurrentMapManager.this.partitionManager.reset();
                for (CMap cmap : ConcurrentMapManager.this.maps.values()) {
                    cmap.reset(false);
                }
            }
        }, 5);
    }

    public void reset() {
        this.maps.clear();
        this.mapCaches.clear();
        this.partitionManager.reset();
    }

    public void shutdown() {
        for (CMap cmap : this.maps.values()) {
            try {
                this.logger.log(Level.FINEST, "Destroying CMap[" + cmap.name + "]");
                this.flush(cmap.name);
                cmap.destroy();
            }
            catch (Throwable e) {
                if (!this.node.isActive()) continue;
                this.logger.log(Level.SEVERE, e.getMessage(), e);
            }
        }
        this.reset();
        this.partitionManager.shutdown();
    }

    public void flush(String name) {
        CMap cmap = this.getMap(name);
        if (cmap != null && cmap.store != null && cmap.writeDelayMillis > 0L) {
            HashSet<Record> dirtyRecords = new HashSet<Record>();
            for (Record record : cmap.mapRecords.values()) {
                PartitionInfo partition;
                Address owner;
                if (!record.isDirty() || (owner = (partition = this.partitionManager.getPartition(record.getBlockId())).getOwner()) == null || !this.thisAddress.equals(owner)) continue;
                dirtyRecords.add(record);
                record.setDirty(false);
            }
            try {
                cmap.runStoreUpdate(dirtyRecords);
            }
            catch (Throwable e) {
                for (Record dirtyRecord : dirtyRecords) {
                    dirtyRecord.setDirty(true);
                }
                Util.throwUncheckedException(e);
            }
        }
    }

    public void syncForDead(MemberImpl deadMember) {
        this.syncForDeadSemaphores(deadMember.getAddress());
        this.syncForDeadCountDownLatches(deadMember.getAddress());
        this.partitionManager.syncForDead(deadMember);
    }

    void syncForDeadSemaphores(Address deadAddress) {
        CMap cmap = (CMap)this.maps.get("c:__hz_SemaphoreMap");
        if (cmap != null) {
            for (Record record : cmap.mapRecords.values()) {
                DistributedSemaphore semaphore = (DistributedSemaphore)record.getValue();
                if (!semaphore.onDisconnect(deadAddress)) continue;
                record.setValueData(IOUtil.toData(semaphore));
                record.incrementVersion();
            }
        }
    }

    void syncForDeadCountDownLatches(Address deadAddress) {
        CMap cmap = (CMap)this.maps.get("c:__hz_CountDownLatchMap");
        if (deadAddress != null && cmap != null) {
            for (Record record : cmap.mapRecords.values()) {
                DistributedCountDownLatch cdl = (DistributedCountDownLatch)record.getValue();
                if (cdl == null || !cdl.isOwnerOrMemberAddress(deadAddress)) continue;
                List<ScheduledAction> scheduledActions = record.getScheduledActions();
                if (scheduledActions != null) {
                    for (ScheduledAction sa : scheduledActions) {
                        this.node.clusterManager.deregisterScheduledAction(sa);
                        Request sr = sa.getRequest();
                        sr.clearForResponse();
                        sr.lockAddress = deadAddress;
                        sr.longValue = 3L;
                        this.returnResponse(sr);
                    }
                    scheduledActions.clear();
                }
                cdl.setOwnerLeft();
            }
        }
    }

    public void syncForAdd() {
        this.partitionManager.syncForAdd();
    }

    void logState() {
        long now = Clock.currentTimeMillis();
        if (this.logState && now - this.lastLogStateTime > 15000L) {
            StringBuffer sbState = new StringBuffer(this.thisAddress + " State[" + new Date(now));
            sbState.append("]");
            Collection calls = this.mapCalls.values();
            sbState.append("\nCall Count:").append(calls.size());
            sbState.append(this.partitionManager.toString());
            Collection cmaps = this.maps.values();
            for (CMap cmap : cmaps) {
                cmap.appendState(sbState);
            }
            CpuUtilization cpuUtilization = this.node.getCpuUtilization();
            this.node.connectionManager.appendState(sbState);
            this.node.executorManager.appendState(sbState);
            this.node.clusterManager.appendState(sbState);
            long total = Runtime.getRuntime().totalMemory();
            long free = Runtime.getRuntime().freeMemory();
            sbState.append("\nCluster Size:").append(this.lsMembers.size());
            sbState.append("\n").append(cpuUtilization);
            sbState.append("\nUsed Memory:");
            sbState.append((total - free) / 1024L / 1024L);
            sbState.append("MB");
            this.logger.log(Level.INFO, sbState.toString());
            this.lastLogStateTime = now;
        }
    }

    public void mergeWanRecord(DataRecordEntry mergingEntry) {
        String name = mergingEntry.getName();
        DataRecordEntry existingEntry = new MGetDataRecordEntry().get(name, mergingEntry.getKeyData());
        CMap cmap = this.node.concurrentMapManager.getMap(name);
        MProxy mproxy = (MProxy)this.node.factory.getOrCreateProxyByName(name);
        MergePolicy mergePolicy = cmap.wanMergePolicy;
        if (mergePolicy == null) {
            this.logger.log(Level.SEVERE, "Received wan merge but no merge policy defined!");
        } else {
            Object winner = mergePolicy.merge(cmap.getName(), mergingEntry, existingEntry);
            if (winner != null) {
                if (winner == MergePolicy.REMOVE_EXISTING) {
                    mproxy.removeForSync(mergingEntry.getKey());
                    this.notifyWanMergeListeners(WanMergeListener.EventType.REMOVED);
                } else {
                    mproxy.putForSync(mergingEntry.getKeyData(), winner);
                    this.notifyWanMergeListeners(WanMergeListener.EventType.UPDATED);
                }
            } else {
                this.notifyWanMergeListeners(WanMergeListener.EventType.IGNORED);
            }
        }
    }

    void notifyWanMergeListeners(WanMergeListener.EventType eventType) {
        for (WanMergeListener wanMergeListener : this.colWanMergeListeners) {
            if (eventType == WanMergeListener.EventType.UPDATED) {
                wanMergeListener.entryUpdated();
                continue;
            }
            if (eventType == WanMergeListener.EventType.REMOVED) {
                wanMergeListener.entryRemoved();
                continue;
            }
            wanMergeListener.entryIgnored();
        }
    }

    public int getPartitionCount() {
        return this.partitionCount;
    }

    public Map<String, CMap> getCMaps() {
        return this.maps;
    }

    Object tryLockAndGet(String name, Object key, long timeout) throws TimeoutException {
        try {
            MLock mlock = new MLock();
            boolean locked = mlock.lockAndGetValue(name, key, timeout);
            if (!locked) {
                throw new TimeoutException();
            }
            return IOUtil.toObject(mlock.oldValue);
        }
        catch (OperationTimeoutException e) {
            throw new TimeoutException();
        }
    }

    void putAndUnlock(String name, Object key, Object value) {
        ThreadContext tc = ThreadContext.get();
        Data dataKey = IOUtil.toData(key);
        CMap cmap = this.getMap(name);
        LocalLock localLock = (LocalLock)cmap.mapLocalLocks.get(dataKey);
        boolean shouldUnlock = localLock != null && localLock.getThreadId() == tc.getThreadId();
        boolean shouldRemove = shouldUnlock && localLock.getCount() == 1;
        MPut mput = tc.getCallCache(this.node.factory).getMPut();
        if (shouldRemove) {
            mput.txnalPut(ClusterOperation.CONCURRENT_MAP_PUT_AND_UNLOCK, name, key, value, -1L, -1L);
            cmap.mapLocalLocks.remove(dataKey, localLock);
        } else if (shouldUnlock) {
            mput.txnalPut(ClusterOperation.CONCURRENT_MAP_PUT, name, key, value, -1L, -1L);
            localLock.decrementAndGet();
        } else {
            mput.clearRequest();
            String error = "Current thread is not owner of lock. putAndUnlock could not be completed! Thread-Id: " + tc.getThreadId() + ", LocalLock: " + localLock;
            this.logger.log(Level.WARNING, error);
            throw new IllegalStateException(error);
        }
        mput.clearRequest();
    }

    public void destroyEndpointThreads(Address endpoint, Set<Integer> threadIds) {
        this.node.clusterManager.invalidateScheduledActionsFor(endpoint, threadIds);
        for (CMap cmap : this.maps.values()) {
            for (Record record : cmap.mapRecords.values()) {
                DistributedLock lock = record.getLock();
                if (lock == null || !lock.isLocked() || !endpoint.equals(record.getLockAddress()) || !threadIds.contains(record.getLock().getLockThreadId())) continue;
                record.clearLock();
                cmap.fireScheduledActions(record);
            }
        }
    }

    public PartitionInfo getPartitionInfo(int partitionId) {
        return this.partitionManager.getPartition(partitionId);
    }

    public void startCleanup(boolean now, final boolean force) {
        if (now) {
            for (CMap cMap : this.maps.values()) {
                cMap.startCleanup(force);
            }
        } else {
            this.node.executorManager.executeNow(new Runnable(){

                public void run() {
                    for (CMap cMap : ConcurrentMapManager.this.maps.values()) {
                        cMap.startCleanup(force);
                    }
                }
            });
        }
    }

    public void executeCleanup(final CMap cmap, final boolean force) {
        this.node.executorManager.executeNow(new Runnable(){

            public void run() {
                cmap.startCleanup(force);
            }
        });
    }

    public boolean lock(String name, Object key, long timeout) {
        MLock mlock = new MLock();
        boolean booleanCall = timeout >= 0L;
        try {
            boolean locked = mlock.lock(name, key, timeout);
            if (!locked && !booleanCall) {
                throw new OperationTimeoutException(mlock.request.operation.toString(), "Lock request is timed out! t: " + mlock.request.timeout);
            }
            return locked;
        }
        catch (OperationTimeoutException e) {
            if (!booleanCall) {
                throw e;
            }
            return false;
        }
    }

    public void putTransient(String name, Object key, Object value, long ttl) {
        MPut mput = new MPut();
        mput.putTransient(name, key, value, ttl);
    }

    public boolean putFromLoad(String name, Object key, Object value) {
        try {
            MPut mput = new MPut();
            return (Boolean)mput.putFromLoad(name, key, value);
        }
        catch (OperationTimeoutException e) {
            return false;
        }
    }

    private void putFromLoad(Request request) {
        MPut mput = new MPut();
        try {
            mput.request.setFromRequest(request);
            mput.request.timeout = 0L;
            mput.request.ttl = -1L;
            mput.request.local = true;
            mput.request.operation = ClusterOperation.CONCURRENT_MAP_PUT_FROM_LOAD;
            mput.request.longValue = request.value == null ? Integer.MIN_VALUE : (long)request.value.hashCode();
            request.setBooleanRequest();
            Data value = request.value;
            mput.doOp();
            boolean success = mput.getResultAsBoolean();
            if (success) {
                mput.request.value = value;
                mput.backup(ClusterOperation.CONCURRENT_MAP_BACKUP_PUT);
            }
        }
        catch (OperationTimeoutException e) {
            this.logger.log(Level.FINEST, "Put-after-load for Operation[" + (Object)((Object)request.operation) + "] has been timed out!");
        }
    }

    Map getAll(String name, Set keys) {
        Object key;
        Object value;
        HashSet theKeys = keys;
        HashMap<Object, Object> map = new HashMap<Object, Object>(keys.size());
        CMap cmap = this.getMap(name);
        if (cmap != null && cmap.nearCache != null) {
            theKeys = new HashSet(keys);
            Iterator iterator = theKeys.iterator();
            while (iterator.hasNext()) {
                Object key2 = iterator.next();
                Object value2 = cmap.nearCache.get(key2);
                if (value2 == null) continue;
                map.put(key2, value2);
                iterator.remove();
            }
        }
        if (theKeys.size() > 1) {
            NearCache nearCache;
            Pairs results = this.getAllPairs(name, theKeys);
            final List<KeyValue> lsKeyValues = results.getKeyValues();
            cmap = this.getMap(name);
            if (lsKeyValues.size() > 0 && cmap != null && (nearCache = cmap.nearCache) != null) {
                final HashMap<Data, Object> keyObjects = new HashMap<Data, Object>(lsKeyValues.size());
                for (KeyValue keyValue : lsKeyValues) {
                    keyObjects.put(keyValue.getKeyData(), keyValue.getKey());
                }
                this.enqueueAndReturn(new Processable(){

                    public void process() {
                        for (KeyValue keyValue : lsKeyValues) {
                            Object key = keyObjects.get(keyValue.getKeyData());
                            if (key == null) continue;
                            nearCache.put(key, keyValue.getKeyData(), keyValue.getValueData());
                        }
                    }
                });
            }
            for (KeyValue keyValue : lsKeyValues) {
                map.put(keyValue.getKey(), keyValue.getValue());
            }
        } else if (theKeys.size() == 1 && (value = new MGet().get(name, key = theKeys.iterator().next(), -1L)) != null) {
            map.put(key, value);
        }
        return map;
    }

    Pairs getAllPairs(String name, Set keys) {
        while (true) {
            try {
                return this.doGetAll(name, keys);
            }
            catch (Throwable e) {
                if (e instanceof MemberLeftException) {
                    try {
                        Thread.sleep(this.redoWaitMillis);
                    }
                    catch (InterruptedException e1) {
                        this.handleInterruptedException(true, ClusterOperation.CONCURRENT_MAP_GET_ALL);
                    }
                    continue;
                }
                if (e instanceof InterruptedException) {
                    this.handleInterruptedException(true, ClusterOperation.CONCURRENT_MAP_GET_ALL);
                    continue;
                }
                if (e instanceof RuntimeException) {
                    throw (RuntimeException)e;
                }
                throw new RuntimeException(e);
            }
            break;
        }
    }

    Pairs doGetAll(String name, Set keys) throws ExecutionException, InterruptedException {
        Pairs results = new Pairs(keys.size());
        HashMap<Member, Keys> targetMembers = new HashMap<Member, Keys>(10);
        for (Object key : keys) {
            Keys targetKeys;
            Data data = IOUtil.toData(key);
            Member owner = this.partitionServiceImpl.getPartition(data).getOwner();
            if (owner == null) {
                owner = this.thisMember;
            }
            if ((targetKeys = (Keys)targetMembers.get(owner)) == null) {
                targetKeys = new Keys();
                targetMembers.put(owner, targetKeys);
            }
            targetKeys.add(data);
        }
        ArrayList<DistributedTask<Pairs>> lsFutures = new ArrayList<DistributedTask<Pairs>>(targetMembers.size());
        for (Member member : targetMembers.keySet()) {
            Keys targetKeys = (Keys)targetMembers.get(member);
            GetAllCallable callable = new GetAllCallable(name, targetKeys);
            DistributedTask<Pairs> dt = new DistributedTask<Pairs>(callable, member);
            lsFutures.add(dt);
            this.node.factory.getExecutorService(BATCH_OPS_EXECUTOR_NAME).execute(dt);
        }
        for (Future future : lsFutures) {
            Pairs pairs = (Pairs)future.get();
            if (pairs == null || pairs.getKeyValues() == null) continue;
            for (KeyValue keyValue : pairs.getKeyValues()) {
                results.addKeyValue(keyValue);
            }
        }
        return results;
    }

    int size(String name) {
        while (true) {
            try {
                int size = this.trySize(name);
                TransactionImpl txn = ThreadContext.get().getCallContext().getTransaction();
                if (txn != null) {
                    size += txn.size(name);
                }
                return size;
            }
            catch (Throwable e) {
                if (e instanceof MemberLeftException || e instanceof IllegalPartitionState) {
                    try {
                        Thread.sleep(this.redoWaitMillis);
                    }
                    catch (InterruptedException e1) {
                        this.handleInterruptedException(true, ClusterOperation.CONCURRENT_MAP_SIZE);
                    }
                    continue;
                }
                if (e instanceof InterruptedException) {
                    this.handleInterruptedException(true, ClusterOperation.CONCURRENT_MAP_SIZE);
                    continue;
                }
                Util.throwUncheckedException(e);
                return -1;
            }
            break;
        }
    }

    int trySize(String name) throws ExecutionException, InterruptedException {
        int totalSize = 0;
        Set<Member> members = this.node.getClusterImpl().getMembers();
        ArrayList<DistributedTask<Integer>> lsFutures = new ArrayList<DistributedTask<Integer>>();
        int expectedPartitionVersion = this.partitionManager.getVersion();
        for (Member member : members) {
            if (member.isLiteMember()) continue;
            MapSizeCallable callable = new MapSizeCallable(name, expectedPartitionVersion);
            DistributedTask<Integer> dt = new DistributedTask<Integer>(callable, member);
            lsFutures.add(dt);
            this.node.factory.getExecutorService(BATCH_OPS_EXECUTOR_NAME).execute(dt);
        }
        for (Future future : lsFutures) {
            Integer partialSize = (Integer)future.get();
            if (partialSize == null) continue;
            if (partialSize == -1) {
                throw new IllegalPartitionState("Unexpected partition version!");
            }
            totalSize += partialSize.intValue();
        }
        return totalSize;
    }

    Entries query(String name, ClusterOperation operation, Predicate predicate) {
        Data predicateData = IOUtil.toData(predicate);
        while (true) {
            try {
                Entries entries = new Entries(this, name, operation, predicate);
                this.tryQuery(entries, name, operation, predicateData);
                return entries;
            }
            catch (Throwable e) {
                if (e instanceof MemberLeftException || e instanceof IllegalPartitionState) {
                    try {
                        Thread.sleep(this.redoWaitMillis);
                    }
                    catch (InterruptedException e1) {
                        this.handleInterruptedException(true, operation);
                    }
                    continue;
                }
                if (e instanceof InterruptedException) {
                    this.handleInterruptedException(true, operation);
                    continue;
                }
                if (e instanceof ExecutionException) {
                    Throwable cause = e.getCause();
                    if (cause != null && cause instanceof RuntimeException) {
                        throw (RuntimeException)cause;
                    }
                    throw new RuntimeException(e);
                }
                Util.throwUncheckedException(e);
                return null;
            }
            break;
        }
    }

    void tryQuery(Entries entries, String name, ClusterOperation operation, Data predicateData) throws ExecutionException, InterruptedException {
        Set<Member> members = this.node.getClusterImpl().getMembers();
        ArrayList<DistributedTask<Pairs>> lsFutures = new ArrayList<DistributedTask<Pairs>>();
        int expectedPartitionVersion = this.partitionManager.getVersion();
        for (Member member : members) {
            if (member.isLiteMember()) continue;
            MapQueryCallable callable = new MapQueryCallable(name, operation, predicateData, expectedPartitionVersion);
            DistributedTask<Pairs> dt = new DistributedTask<Pairs>(callable, member);
            lsFutures.add(dt);
            this.node.factory.getExecutorService(BATCH_OPS_EXECUTOR_NAME).execute(dt);
        }
        for (Future future : lsFutures) {
            Pairs pairs = (Pairs)future.get();
            if (pairs == null) {
                throw new IllegalPartitionState("Unexpected partition version!");
            }
            entries.addEntries(pairs);
        }
    }

    Entries queryLocal(String name, ClusterOperation operation, Predicate predicate) {
        Entries entries = new Entries(this, name, operation, predicate);
        CMap cmap = this.getMap(name);
        if (cmap == null) {
            return entries;
        }
        PartitionManager partitionManager = this.getPartitionManager();
        while (true) {
            int partitionVersion = partitionManager.getVersion();
            Pairs pairs = this.queryMap(cmap, operation, predicate);
            if (partitionManager.getVersion() == partitionVersion) {
                entries.addEntries(pairs);
                return entries;
            }
            entries.clearEntries();
        }
    }

    void doPutAll(String name, Map entries) {
        Pairs pairs = new Pairs(entries.size());
        for (Object key : entries.keySet()) {
            Object value = entries.get(key);
            pairs.addKeyValue(new KeyValue(IOUtil.toData(key), IOUtil.toData(value)));
        }
        while (true) {
            try {
                this.doPutAll(name, pairs);
                return;
            }
            catch (Exception e) {
                if (e instanceof MemberLeftException) {
                    try {
                        Thread.sleep(this.redoWaitMillis);
                    }
                    catch (InterruptedException e1) {
                        this.handleInterruptedException(true, ClusterOperation.CONCURRENT_MAP_PUT_ALL);
                    }
                    continue;
                }
                if (e instanceof InterruptedException) {
                    this.handleInterruptedException(true, ClusterOperation.CONCURRENT_MAP_PUT_ALL);
                    continue;
                }
                if (e instanceof RuntimeException) {
                    throw (RuntimeException)e;
                }
                throw new RuntimeException(e);
            }
            break;
        }
    }

    /*
     * WARNING - void declaration
     */
    void doPutAll(String name, Pairs pairs) throws ExecutionException, InterruptedException {
        Pairs targetPairs;
        HashMap<void, Pairs> targetMembers = new HashMap<void, Pairs>(10);
        for (KeyValue keyValue : pairs.getKeyValues()) {
            void var6_6;
            Member member = this.partitionServiceImpl.getPartition(keyValue.getKeyData()).getOwner();
            if (member == null) {
                MemberImpl memberImpl = this.thisMember;
            }
            if ((targetPairs = (Pairs)targetMembers.get(var6_6)) == null) {
                targetPairs = new Pairs();
                targetMembers.put(var6_6, targetPairs);
            }
            targetPairs.addKeyValue(keyValue);
        }
        ArrayList<DistributedTask<Boolean>> lsFutures = new ArrayList<DistributedTask<Boolean>>(targetMembers.size());
        for (Member member : targetMembers.keySet()) {
            targetPairs = (Pairs)targetMembers.get(member);
            if (targetPairs == null || targetMembers.size() <= 0) continue;
            PutAllCallable callable = new PutAllCallable(name, targetPairs);
            DistributedTask<Boolean> dt = new DistributedTask<Boolean>(callable, member);
            lsFutures.add(dt);
            this.node.factory.getExecutorService(BATCH_OPS_EXECUTOR_NAME).execute(dt);
        }
        for (Future future : lsFutures) {
            future.get();
        }
    }

    public void destroy(String name) {
        CMap cmap = (CMap)this.maps.remove(name);
        if (cmap != null) {
            cmap.destroy();
        }
        this.mapCaches.remove(name);
    }

    boolean isMapIndexed(String name) {
        CMap cmap = this.getMap(name);
        return cmap != null && cmap.getMapIndexService().hasIndexedAttributes();
    }

    void setIndexValues(Request request, Object value) {
        Long[] indexes;
        CMap cmap = this.getMap(request.name);
        if (cmap != null && (indexes = cmap.getMapIndexService().getIndexValues(value)) != null) {
            byte[] indexTypes = cmap.getMapIndexService().getIndexTypes();
            request.setIndexes(indexes, indexTypes);
            for (byte b : indexTypes) {
                if (b != -1) continue;
                throw new RuntimeException("Index type cannot be -1: " + b);
            }
        }
    }

    protected Address getBackupMember(int partitionId, int replicaIndex) {
        return this.partitionManager.getPartition(partitionId).getReplicaAddress(replicaIndex);
    }

    final void fireMapEvent(Map<Address, Boolean> mapListeners, int eventType, Data oldValue, Record record, Address callerAddress) {
        if (record.getListeners() == null && (mapListeners == null || mapListeners.size() == 0)) {
            return;
        }
        this.fireMapEvent(mapListeners, record.getName(), eventType, record.getKeyData(), oldValue, record.getValueData(), record.getListeners(), callerAddress);
    }

    public LocalMapStatsImpl getLocalMapStats(String name) {
        CMap cmap = this.getMap(name);
        if (cmap == null) {
            return new LocalMapStatsImpl();
        }
        return cmap.getLocalMapStats();
    }

    public Address getKeyOwner(Request req) {
        int partitionId = this.getPartitionId(req);
        return this.getPartitionOwner(partitionId);
    }

    public Address getPartitionOwner(int partitionId) {
        return this.partitionManager.getOwner(partitionId);
    }

    public Address getKeyOwner(Data key) {
        int partitionId = this.getPartitionId(key);
        return this.getPartitionOwner(partitionId);
    }

    public boolean isMigrating(Request req) {
        return this.isMigrating(req, 0);
    }

    @Override
    public boolean isMigrating(Request req, int replica) {
        Data key = req.key;
        return key != null && this.partitionManager.isPartitionMigrating(this.getPartitionId(req), replica);
    }

    public int getPartitionId(Request req) {
        req.blockId = this.getPartitionId(req.key);
        return req.blockId;
    }

    public final int getPartitionId(Data key) {
        int hash = key.getPartitionHash();
        return hash == Integer.MIN_VALUE ? 0 : Math.abs(hash) % this.partitionCount;
    }

    public long newRecordId() {
        this.checkServiceThread();
        return this.newRecordId++;
    }

    void evictAsync(final String name, final Data key) {
        this.evictionExecutor.execute(new FallThroughRunnable(){

            public void doRun() {
                MEvict mEvict = new MEvict();
                mEvict.evict(name, key);
            }
        });
    }

    public CMap getMap(String name) {
        return (CMap)this.maps.get(name);
    }

    public CMap getOrCreateMap(String name) {
        this.checkServiceThread();
        CMap map = (CMap)this.maps.get(name);
        if (map == null) {
            map = new CMap(this, name);
            this.maps.put(name, map);
        }
        return map;
    }

    @Override
    void registerListener(boolean add, String name, Data key, Address address, boolean includeValue) {
        CMap cmap = this.getOrCreateMap(name);
        if (add) {
            cmap.addListener(key, address, includeValue);
        } else {
            cmap.removeListener(key, address);
        }
    }

    private boolean processBackupRequest(Request request) {
        CMap cmap = this.getOrCreateMap(request.name);
        return cmap.backup(request);
    }

    void scheduleRequest(final SchedulableOperationHandler handler, Request request) {
        Record record = this.ensureRecord(request);
        request.scheduled = true;
        ScheduledAction scheduledAction = new ScheduledAction(request){

            public boolean consume() {
                handler.handle(this.request);
                return true;
            }

            public void onExpire() {
                handler.onNoTimeToSchedule(this.request);
            }

            public void onMigrate() {
                ConcurrentMapManager.this.returnRedoResponse(this.request, Constants.RedoType.REDO_PARTITION_MIGRATING);
            }
        };
        record.addScheduledAction(scheduledAction);
        this.node.clusterManager.registerScheduledAction(scheduledAction);
    }

    public Pairs queryMap(CMap cmap, ClusterOperation operation, Predicate predicate) throws QueryException {
        try {
            QueryContext queryContext = new QueryContext(cmap.getName(), predicate, cmap.getMapIndexService());
            Set<MapEntry> results = cmap.getMapIndexService().doQuery(queryContext);
            boolean evaluateValues = predicate != null && !queryContext.isStrong();
            return this.createResultPairs(operation, results, evaluateValues, predicate);
        }
        catch (Throwable e) {
            throw new QueryException(e);
        }
    }

    private Pairs createResultPairs(ClusterOperation operation, Collection<MapEntry> colRecords, boolean evaluateEntries, Predicate predicate) {
        Pairs pairs = new Pairs();
        if (colRecords != null) {
            long now = Clock.currentTimeMillis();
            for (MapEntry mapEntry : colRecords) {
                int size;
                Record record = (Record)mapEntry;
                if (!record.isActive() || !record.isValid(now)) continue;
                if (record.getKeyData() == null || record.getKeyData().size() == 0) {
                    throw new RuntimeException("Key cannot be null or zero-size: " + record.getKeyData());
                }
                boolean match2 = !evaluateEntries || predicate.apply(record);
                if (!match2) continue;
                boolean onlyKeys = operation == ClusterOperation.CONCURRENT_MAP_ITERATE_KEYS_ALL || operation == ClusterOperation.CONCURRENT_MAP_ITERATE_KEYS;
                Data key = record.getKeyData();
                if (record.hasValueData()) {
                    Data value = onlyKeys ? null : record.getValueData();
                    pairs.addKeyValue(new KeyValue(key, value));
                    continue;
                }
                if (record.getMultiValues() == null || (size = record.getMultiValues().size()) <= 0) continue;
                if (operation == ClusterOperation.CONCURRENT_MAP_ITERATE_KEYS) {
                    pairs.addKeyValue(new KeyValue(key, null));
                    continue;
                }
                Collection<ValueHolder> values = record.getMultiValues();
                for (ValueHolder valueHolder : values) {
                    pairs.addKeyValue(new KeyValue(key, valueHolder.getData()));
                }
            }
        }
        return pairs;
    }

    Record recordExist(Request req) {
        CMap cmap = (CMap)this.maps.get(req.name);
        if (cmap == null) {
            return null;
        }
        return cmap.getRecord(req);
    }

    Record ensureRecord(Request req) {
        return this.ensureRecord(req, req.value);
    }

    Record ensureRecord(Request req, Data defaultValue) {
        this.checkServiceThread();
        CMap cmap = this.getOrCreateMap(req.name);
        Record record = cmap.getRecord(req);
        if (record == null || !record.isActive() || !record.isValid()) {
            Map<Address, Boolean> listeners = record != null ? record.getListeners() : null;
            record = cmap.createAndAddNewRecord(req.key, defaultValue);
            record.setMapListeners(listeners);
        }
        return record;
    }

    private boolean testLock(Request req) {
        Record record = this.recordExist(req);
        return record == null || record.testLock(req.lockThreadId, req.lockAddress);
    }

    abstract class MigrationAwareExecutedOperationHandler
    extends ExecutedOperationHandler {
        MigrationAwareExecutedOperationHandler() {
        }

        public void handle(Request request) {
            CMap cmap = ConcurrentMapManager.this.getOrCreateMap(request.name);
            boolean isMigrating = ConcurrentMapManager.this.isMigrating(request);
            if (cmap.isNotLocked(request) && !isMigrating) {
                super.handle(request);
            } else {
                ConcurrentMapManager.this.returnRedoResponse(request, isMigrating ? Constants.RedoType.REDO_PARTITION_MIGRATING : Constants.RedoType.REDO_MAP_LOCKED);
            }
        }
    }

    abstract class ExecutedOperationHandler
    extends BaseManager.ResponsiveOperationHandler {
        ExecutedOperationHandler() {
        }

        public void process(Packet packet) {
            Request request = Request.copyFromPacket(packet);
            request.local = false;
            this.handle(request);
        }

        public void handle(Request request) {
            ConcurrentMapManager.this.node.executorManager.executeQueryTask(this.createRunnable(request));
        }

        abstract Runnable createRunnable(Request var1);
    }

    class ContainsValueOperationHandler
    extends MigrationAwareExecutedOperationHandler {
        ContainsValueOperationHandler() {
        }

        Runnable createRunnable(Request request) {
            return new ContainsValueTask(request);
        }

        class ContainsValueTask
        implements Runnable {
            final Request request;

            ContainsValueTask(Request request) {
                this.request = request;
            }

            public void run() {
                CMap cmap = ConcurrentMapManager.this.getMap(this.request.name);
                Data value = this.request.value;
                this.request.response = Boolean.FALSE;
                if (cmap != null) {
                    MapIndexService mapIndexService = cmap.getMapIndexService();
                    long now = Clock.currentTimeMillis();
                    if (cmap.isMultiMap()) {
                        Collection<Record> records = mapIndexService.getOwnedRecords();
                        ValueHolder theValueHolder = new ValueHolder(value);
                        for (Record record : records) {
                            Collection<ValueHolder> collection;
                            if (!record.isActive() || !record.isValid(now) || (collection = record.getMultiValues()) == null || !collection.contains(theValueHolder)) continue;
                            this.request.response = Boolean.TRUE;
                            break;
                        }
                    } else {
                        Collection<MapEntry> results = null;
                        Index index = mapIndexService.getValueIndex();
                        results = index != null ? index.getRecords(Long.valueOf(value.hashCode())) : mapIndexService.getOwnedRecords();
                        if (results != null) {
                            Object obj = IOUtil.toObject(value);
                            for (MapEntry mapEntry : results) {
                                Record record = (Record)mapEntry;
                                if (!record.isActive() || !record.isValid(now) || !obj.equals(record.getValue())) continue;
                                this.request.response = Boolean.TRUE;
                                break;
                            }
                        }
                    }
                }
                ConcurrentMapManager.this.returnResponse(this.request);
            }
        }
    }

    class ContainsEntryOperationHandler
    extends BaseManager.ResponsiveOperationHandler {
        ContainsEntryOperationHandler() {
        }

        public void handle(Request request) {
            CMap cmap = ConcurrentMapManager.this.getOrCreateMap(request.name);
            boolean isMigrating = ConcurrentMapManager.this.isMigrating(request);
            if (cmap.isNotLocked(request) && !isMigrating) {
                Record record = cmap.getRecord(request);
                if (record == null || !record.isActive() || !record.isValid()) {
                    request.response = Boolean.FALSE;
                    ConcurrentMapManager.this.returnResponse(request);
                } else {
                    ConcurrentMapManager.this.node.executorManager.executeQueryTask(new ContainsEntryTask(request, record));
                }
            } else {
                ConcurrentMapManager.this.returnRedoResponse(request, isMigrating ? Constants.RedoType.REDO_PARTITION_MIGRATING : Constants.RedoType.REDO_MAP_LOCKED);
            }
        }

        class ContainsEntryTask
        implements Runnable {
            final Request request;
            final Record record;

            ContainsEntryTask(Request request, Record record) {
                this.request = request;
                this.record = record;
            }

            public void run() {
                CMap cmap = ConcurrentMapManager.this.getMap(this.request.name);
                Data value = this.request.value;
                this.request.response = Boolean.FALSE;
                if (cmap.isMultiMap()) {
                    Collection<ValueHolder> multiValues = this.record.getMultiValues();
                    if (multiValues != null) {
                        ValueHolder theValueHolder = new ValueHolder(value);
                        this.request.response = multiValues.contains(theValueHolder);
                    }
                } else {
                    Object obj = IOUtil.toObject(value);
                    this.request.response = obj.equals(this.record.getValue());
                }
                ConcurrentMapManager.this.returnResponse(this.request);
            }
        }
    }

    abstract class SchedulableOperationHandler
    extends MTargetAwareOperationHandler {
        SchedulableOperationHandler() {
        }

        protected boolean shouldSchedule(Request request) {
            return !ConcurrentMapManager.this.testLock(request);
        }

        protected void onNoTimeToSchedule(Request request) {
            request.response = request.local ? ConcurrentMapManager.this.distributedTimeoutException : ConcurrentMapManager.this.dataTimeoutException;
            ConcurrentMapManager.this.returnResponse(request);
        }

        protected void schedule(Request request) {
            ConcurrentMapManager.this.scheduleRequest(this, request);
        }

        public void handle(Request request) {
            boolean shouldSchedule = this.shouldSchedule(request);
            SystemLogService css = ConcurrentMapManager.this.systemLogService;
            if (css.shouldLog(SystemLogService.Level.TRACE)) {
                css.logObject(request, SystemLogService.Level.TRACE, "ShouldSchedule ");
            }
            if (shouldSchedule) {
                if (request.hasEnoughTimeToSchedule()) {
                    if (css.shouldLog(SystemLogService.Level.INFO)) {
                        css.info((CallStateAware)request, MapSystemLogFactory.newScheduleRequest(request, ConcurrentMapManager.this.recordExist(request)));
                    }
                    this.schedule(request);
                } else {
                    if (css.shouldLog(SystemLogService.Level.INFO)) {
                        css.info(request, "NoTimeToSchedule", request.name, (Object)request.operation);
                    }
                    this.onNoTimeToSchedule(request);
                }
            } else {
                this.doOperation(request);
                ConcurrentMapManager.this.returnResponse(request);
            }
        }
    }

    class IsKeyLockedOperationHandler
    extends MTargetAwareOperationHandler {
        IsKeyLockedOperationHandler() {
        }

        void doOperation(Request request) {
            CMap cmap = ConcurrentMapManager.this.getOrCreateMap(request.name);
            if (cmap.isNotLocked(request)) {
                Record record = cmap.getRecord(request.key);
                request.response = record != null && record.isLocked();
                ConcurrentMapManager.this.returnResponse(request);
            } else {
                ConcurrentMapManager.this.returnRedoResponse(request, Constants.RedoType.REDO_MAP_LOCKED);
            }
        }
    }

    class LockOperationHandler
    extends SchedulableOperationHandler {
        LockOperationHandler() {
        }

        protected void onNoTimeToSchedule(Request request) {
            request.response = -1L;
            ConcurrentMapManager.this.returnResponse(request);
        }

        public void handle(Request request) {
            CMap cmap = ConcurrentMapManager.this.getOrCreateMap(request.name);
            if (cmap.isNotLocked(request)) {
                if (this.shouldSchedule(request)) {
                    if (request.hasEnoughTimeToSchedule()) {
                        if (ConcurrentMapManager.this.systemLogService.shouldLog(SystemLogService.Level.INFO)) {
                            ConcurrentMapManager.this.systemLogService.info((CallStateAware)request, MapSystemLogFactory.newScheduleRequest(request, cmap.getRecord(request)));
                        }
                        this.schedule(request);
                    } else {
                        if (ConcurrentMapManager.this.systemLogService.shouldLog(SystemLogService.Level.INFO)) {
                            ConcurrentMapManager.this.systemLogService.info(request, "NoTimeToSchedule", request.name, (Object)request.operation);
                        }
                        this.onNoTimeToSchedule(request);
                    }
                } else {
                    Record record = cmap.getRecord(request.key);
                    if (!(request.operation != ClusterOperation.CONCURRENT_MAP_TRY_LOCK_AND_GET || cmap.loader == null || record != null && record.hasValueData())) {
                        ConcurrentMapManager.this.storeExecutor.execute(new TryLockAndGetLoader(cmap, request), request.key.hashCode());
                    } else if (cmap.isMultiMap() && request.value != null) {
                        Collection<ValueHolder> col = record.getMultiValues();
                        if (col != null && col.size() > 0) {
                            ConcurrentMapManager.this.storeExecutor.execute(new MultiMapContainsTask(request, col), request.key.hashCode());
                        } else {
                            this.doOperation(request);
                            ConcurrentMapManager.this.returnResponse(request);
                        }
                    } else {
                        this.doOperation(request);
                        ConcurrentMapManager.this.returnResponse(request);
                    }
                }
            } else {
                ConcurrentMapManager.this.returnRedoResponse(request, Constants.RedoType.REDO_MAP_LOCKED);
            }
        }

        void doOperation(Request request) {
            CMap cmap = ConcurrentMapManager.this.getOrCreateMap(request.name);
            cmap.lock(request);
        }

        class TryLockAndGetLoader
        extends AbstractMapStoreOperation {
            Data valueData;

            TryLockAndGetLoader(CMap cmap, Request request) {
                super(cmap, request);
                this.valueData = null;
            }

            void doMapStoreOperation() {
                Object value = this.cmap.loader.load(IOUtil.toObject(this.request.key));
                this.valueData = IOUtil.toData(value);
            }

            public void process() {
                Record record = this.cmap.getRecord(this.request);
                if (record != null && !record.testLock(this.request.lockThreadId, this.request.lockAddress)) {
                    ConcurrentMapManager.this.returnRedoResponse(this.request, Constants.RedoType.REDO_MAP_LOCKED);
                } else {
                    if (this.valueData != null) {
                        if (record == null) {
                            this.cmap.createAndAddNewRecord(this.request.key, this.valueData);
                        } else {
                            record.setValueData(this.valueData);
                        }
                    }
                    LockOperationHandler.this.doOperation(this.request);
                    this.request.value = this.valueData;
                    ConcurrentMapManager.this.returnResponse(this.request);
                }
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        class MultiMapContainsTask
        implements Runnable,
        Processable {
            private final Request request;
            private final Collection<ValueHolder> values;

            MultiMapContainsTask(Request request, Collection<ValueHolder> values) {
                this.request = request;
                this.values = values;
            }

            @Override
            public void run() {
                if (!this.values.contains(new ValueHolder(this.request.value))) {
                    this.request.value = null;
                }
                ConcurrentMapManager.this.enqueueAndReturn(this);
            }

            @Override
            public void process() {
                LockOperationHandler.this.doOperation(this.request);
                ConcurrentMapManager.this.returnResponse(this.request);
            }
        }
    }

    class ForceUnlockOperationHandler
    extends SchedulableOperationHandler {
        ForceUnlockOperationHandler() {
        }

        protected boolean shouldSchedule(Request request) {
            return false;
        }

        void doOperation(Request request) {
            DistributedLock lock;
            boolean unlocked = false;
            CMap cmap = ConcurrentMapManager.this.getOrCreateMap(request.name);
            Record record = cmap.getRecord(request);
            if (record != null && (lock = record.getLock()) != null && lock.getLockCount() > 0) {
                record.clearLock();
                unlocked = true;
                record.incrementVersion();
                request.version = record.getVersion();
                request.lockCount = 0;
                if (record.valueCount() == 0 && !record.hasScheduledAction()) {
                    cmap.markAsEvicted(record);
                }
                cmap.fireScheduledActions(record);
            }
            request.response = unlocked ? Boolean.TRUE : Boolean.FALSE;
        }
    }

    class UnlockOperationHandler
    extends SchedulableOperationHandler {
        UnlockOperationHandler() {
        }

        protected boolean shouldSchedule(Request request) {
            return false;
        }

        void doOperation(Request request) {
            boolean unlocked = true;
            CMap cmap = ConcurrentMapManager.this.getOrCreateMap(request.name);
            Record record = cmap.getRecord(request);
            if (record != null && (unlocked = record.unlock(request.lockThreadId, request.lockAddress))) {
                record.incrementVersion();
                request.version = record.getVersion();
                request.lockCount = record.getLockCount();
                if (record.valueCount() == 0 && record.isEvictable()) {
                    cmap.markAsEvicted(record);
                }
                cmap.fireScheduledActions(record);
            }
            request.response = unlocked ? Boolean.TRUE : Boolean.FALSE;
        }
    }

    class ValueCountOperationHandler
    extends MTargetAwareOperationHandler {
        ValueCountOperationHandler() {
        }

        void doOperation(Request request) {
            CMap cmap = ConcurrentMapManager.this.getOrCreateMap(request.name);
            request.response = cmap.valueCount(request.key);
        }
    }

    abstract class AbstractMapStoreOperation
    implements Runnable,
    Processable {
        protected final CMap cmap;
        protected final Request request;
        protected boolean success = true;

        protected AbstractMapStoreOperation(CMap cmap, Request request) {
            this.cmap = cmap;
            this.request = request;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                this.doMapStoreOperation();
            }
            catch (Exception e) {
                CMap cmap;
                this.success = false;
                if (e instanceof ClassCastException && (cmap = ConcurrentMapManager.this.getMap(this.request.name)).isMapForQueue() && e.getMessage().contains("java.lang.Long cannot be")) {
                    ConcurrentMapManager.this.logger.log(Level.SEVERE, "This is MapStore for Queue. Make sure you treat the key as Long");
                }
                ConcurrentMapManager.this.logger.log(Level.WARNING, "Store thrown exception for " + (Object)((Object)this.request.operation), e);
                this.request.response = IOUtil.toData(new AddressAwareException(e, ConcurrentMapManager.this.thisAddress));
            }
            finally {
                ConcurrentMapManager.this.enqueueAndReturn(this);
            }
        }

        abstract void doMapStoreOperation();

        protected final void afterMapStore() {
            Record storedRecord = this.cmap.getRecord(this.request);
            if (storedRecord != null) {
                storedRecord.setLastStoredTime(Clock.currentTimeMillis());
                storedRecord.setDirty(false);
            }
        }
    }

    class ContainsKeyOperationHandler
    extends MTargetAwareOperationHandler {
        ContainsKeyOperationHandler() {
        }

        public void handle(Request request) {
            CMap cmap = ConcurrentMapManager.this.getOrCreateMap(request.name);
            if (cmap.isNotLocked(request)) {
                Record record = cmap.getRecord(request);
                if (cmap.loader != null && (record == null || record.isLoadable())) {
                    ConcurrentMapManager.this.storeExecutor.execute(new ContainsKeyLoader(cmap, request), request.key.hashCode());
                } else {
                    this.doOperation(request);
                    ConcurrentMapManager.this.returnResponse(request);
                }
            } else {
                ConcurrentMapManager.this.returnRedoResponse(request, Constants.RedoType.REDO_MAP_LOCKED);
            }
        }

        void doOperation(Request request) {
            CMap cmap = ConcurrentMapManager.this.getOrCreateMap(request.name);
            request.response = cmap.containsKey(request);
        }

        class ContainsKeyLoader
        extends AbstractMapStoreOperation {
            ContainsKeyLoader(CMap cmap, Request request) {
                super(cmap, request);
            }

            void doMapStoreOperation() {
                Object value = this.cmap.loader.load(IOUtil.toObject(this.request.key));
                if (value != null) {
                    ConcurrentMapManager.this.setIndexValues(this.request, value);
                    this.request.value = IOUtil.toData(value);
                    ConcurrentMapManager.this.putFromLoad(this.request);
                } else {
                    this.success = false;
                }
            }

            public void process() {
                this.request.response = this.success ? Boolean.TRUE : Boolean.FALSE;
                ConcurrentMapManager.this.returnResponse(this.request);
            }
        }
    }

    class GetOperationHandler
    extends MTargetAwareOperationHandler {
        GetOperationHandler() {
        }

        public void handle(Request request) {
            CMap cmap = ConcurrentMapManager.this.getOrCreateMap(request.name);
            Record record = cmap.getRecord(request);
            if (cmap.loader != null && (record == null || record.isLoadable())) {
                ConcurrentMapManager.this.storeExecutor.execute(new GetLoader(cmap, request), request.key.hashCode());
            } else {
                this.doOperation(request);
                ConcurrentMapManager.this.returnResponse(request);
            }
        }

        void doOperation(Request request) {
            CMap cmap = ConcurrentMapManager.this.getOrCreateMap(request.name);
            Data value = cmap.get(request);
            request.clearForResponse();
            request.response = value;
        }

        class GetLoader
        extends AbstractMapStoreOperation {
            GetLoader(CMap cmap, Request request) {
                super(cmap, request);
            }

            void doMapStoreOperation() {
                Object value = this.cmap.loader.load(IOUtil.toObject(this.request.key));
                if (value != null) {
                    ConcurrentMapManager.this.setIndexValues(this.request, value);
                    this.request.value = IOUtil.toData(value);
                    ConcurrentMapManager.this.putFromLoad(this.request);
                } else {
                    this.success = false;
                }
            }

            public void process() {
                if (this.success) {
                    this.request.response = this.request.value;
                }
                ConcurrentMapManager.this.returnResponse(this.request);
            }
        }
    }

    class GetDataRecordEntryOperationHandler
    extends MTargetAwareOperationHandler {
        GetDataRecordEntryOperationHandler() {
        }

        public void handle(Request request) {
            CMap cmap = ConcurrentMapManager.this.getOrCreateMap(request.name);
            if (cmap.isNotLocked(request)) {
                Record record = cmap.getRecord(request);
                if (cmap.loader != null && (record == null || record.isLoadable())) {
                    ConcurrentMapManager.this.storeExecutor.execute(new GetDataRecordEntryLoader(cmap, request), request.key.hashCode());
                } else {
                    this.doOperation(request);
                    ConcurrentMapManager.this.returnResponse(request);
                }
            } else {
                ConcurrentMapManager.this.returnRedoResponse(request, Constants.RedoType.REDO_MAP_LOCKED);
            }
        }

        void doOperation(Request request) {
            CMap cmap = ConcurrentMapManager.this.getOrCreateMap(request.name);
            Record record = cmap.getRecord(request.key);
            request.response = record == null ? null : new DataRecordEntry(record);
        }

        class GetDataRecordEntryLoader
        extends AbstractMapStoreOperation {
            GetDataRecordEntryLoader(CMap cmap, Request request) {
                super(cmap, request);
            }

            void doMapStoreOperation() {
                Object value = this.cmap.loader.load(IOUtil.toObject(this.request.key));
                if (value != null) {
                    ConcurrentMapManager.this.setIndexValues(this.request, value);
                    this.request.value = IOUtil.toData(value);
                } else {
                    this.success = false;
                }
            }

            public void process() {
                if (this.success) {
                    Record record = this.cmap.createNewTransientRecord(this.request.key, this.request.value);
                    record.setIndexes(this.request.indexes, this.request.indexTypes);
                    this.request.response = new DataRecordEntry(record);
                } else {
                    this.request.response = null;
                }
                ConcurrentMapManager.this.returnResponse(this.request);
            }
        }
    }

    class GetMapEntryOperationHandler
    extends MTargetAwareOperationHandler {
        GetMapEntryOperationHandler() {
        }

        public void handle(Request request) {
            CMap cmap = ConcurrentMapManager.this.getOrCreateMap(request.name);
            Record record = cmap.getRecord(request);
            if (cmap.loader != null && (record == null || record.isLoadable())) {
                ConcurrentMapManager.this.storeExecutor.execute(new GetMapEntryLoader(cmap, request), request.key.hashCode());
            } else {
                this.doOperation(request);
                ConcurrentMapManager.this.returnResponse(request);
            }
        }

        void doOperation(Request request) {
            CMap cmap = ConcurrentMapManager.this.getOrCreateMap(request.name);
            request.response = cmap.getMapEntry(request);
        }

        class GetMapEntryLoader
        extends AbstractMapStoreOperation {
            GetMapEntryLoader(CMap cmap, Request request) {
                super(cmap, request);
            }

            void doMapStoreOperation() {
                Object value = this.cmap.loader.load(IOUtil.toObject(this.request.key));
                if (value != null) {
                    ConcurrentMapManager.this.setIndexValues(this.request, value);
                    this.request.value = IOUtil.toData(value);
                    ConcurrentMapManager.this.putFromLoad(this.request);
                } else {
                    this.success = false;
                }
            }

            public void process() {
                if (this.success) {
                    Record record = this.cmap.createNewTransientRecord(this.request.key, this.request.value);
                    this.request.response = new CMap.CMapEntry(record);
                } else {
                    this.request.response = null;
                }
                ConcurrentMapManager.this.returnResponse(this.request);
            }
        }
    }

    class MergeOperationHandler
    extends MTargetAwareOperationHandler {
        MergeOperationHandler() {
        }

        public void handle(Request request) {
            CMap cmap = ConcurrentMapManager.this.getOrCreateMap(request.name);
            if (cmap.isNotLocked(request)) {
                Record record = cmap.getRecord(request);
                boolean doesNotExist = record == null || !record.isActive() || !record.isValid() || !record.hasValueData();
                DataRecordEntry existing = doesNotExist ? null : new DataRecordEntry(record);
                ConcurrentMapManager.this.node.executorManager.executeNow(new MergeLoader(cmap, request, existing));
            } else {
                ConcurrentMapManager.this.returnRedoResponse(request, Constants.RedoType.REDO_MAP_LOCKED);
            }
        }

        void doOperation(Request request) {
        }

        class MergeLoader
        extends AbstractMapStoreOperation {
            private DataRecordEntry existingRecord;

            MergeLoader(CMap cmap, Request request, DataRecordEntry existingRecord) {
                super(cmap, request);
                this.existingRecord = existingRecord;
            }

            void doMapStoreOperation() {
                Object winner = null;
                this.success = false;
                if (this.cmap.mergePolicy != null) {
                    DataRecordEntry newEntry;
                    Object key;
                    if (this.existingRecord == null && this.cmap.loader != null) {
                        this.existingRecord = new MGetDataRecordEntry().get(this.request.name, this.request.key);
                    }
                    if ((key = (newEntry = (DataRecordEntry)IOUtil.toObject(this.request.value)).getKey()) != null && newEntry.hasValue() && (winner = this.cmap.mergePolicy.merge(this.cmap.getName(), newEntry, this.existingRecord)) != null) {
                        if (this.cmap.isMultiMap()) {
                            MPutMulti mput = ConcurrentMapManager.this.node.concurrentMapManager.new MPutMulti();
                            mput.put(this.request.name, this.request.key, winner);
                        } else {
                            MPut mput = ConcurrentMapManager.this.node.concurrentMapManager.new MPut();
                            mput.put(this.request.name, this.request.key, winner, -1L);
                        }
                        this.success = true;
                    }
                }
            }

            public void process() {
                this.request.response = this.success ? Boolean.TRUE : Boolean.FALSE;
                ConcurrentMapManager.this.returnResponse(this.request);
            }
        }
    }

    class EvictOperationHandler
    extends MTargetAwareOperationHandler {
        EvictOperationHandler() {
        }

        public void handle(Request request) {
            CMap cmap = ConcurrentMapManager.this.getOrCreateMap(request.name);
            if (cmap.isNotLocked(request)) {
                Record record = cmap.getRecord(request);
                if (record != null && record.isActive() && cmap.loader != null && cmap.writeDelayMillis > 0L && record.isValid() && record.isDirty()) {
                    record.setDirty(false);
                    request.value = record.getValueData();
                    ConcurrentMapManager.this.storeExecutor.execute(new EvictStorer(cmap, request), request.key.hashCode());
                } else {
                    this.doOperation(request);
                    ConcurrentMapManager.this.returnResponse(request);
                }
            } else {
                ConcurrentMapManager.this.returnRedoResponse(request, Constants.RedoType.REDO_MAP_LOCKED);
            }
        }

        void doOperation(Request request) {
            if (!ConcurrentMapManager.this.testLock(request)) {
                request.response = Boolean.FALSE;
            } else {
                CMap cmap = ConcurrentMapManager.this.getOrCreateMap(request.name);
                request.response = cmap.evict(request);
            }
        }

        class EvictStorer
        extends AbstractMapStoreOperation {
            EvictStorer(CMap cmap, Request request) {
                super(cmap, request);
            }

            void doMapStoreOperation() {
                Object key = IOUtil.toObject(this.request.key);
                Object value = IOUtil.toObject(this.request.value);
                this.cmap.store.store(key, value);
                this.afterMapStore();
            }

            public void process() {
                if (this.success) {
                    EvictOperationHandler.this.doOperation(this.request);
                }
                ConcurrentMapManager.this.returnResponse(this.request);
            }
        }
    }

    class AddOperationHandler
    extends MTargetAwareOperationHandler {
        AddOperationHandler() {
        }

        void doOperation(Request request) {
            CMap cmap = ConcurrentMapManager.this.getOrCreateMap(request.name);
            request.response = cmap.add(request, false);
        }
    }

    class SemaphoreTryAcquireOperationHandler
    extends SemaphoreOperationHandler {
        SemaphoreTryAcquireOperationHandler() {
        }

        void doSemaphoreOperation(Request request, DistributedSemaphore semaphore) {
            Address attachAddress;
            int permits = (int)request.longValue;
            Boolean attach = SemaphoreProxy.DATA_TRUE.equals(request.value);
            Address address = attachAddress = attach != false ? request.caller : null;
            if (semaphore.tryAcquire(permits, attachAddress)) {
                this.doResponse(request, semaphore, 0L, true);
            } else {
                request.lockThreadId = ThreadContext.get().getThreadId();
                this.schedule(request);
            }
        }
    }

    class SemaphoreReleaseOperationHandler
    extends SemaphoreOperationHandler {
        SemaphoreReleaseOperationHandler() {
        }

        void doSemaphoreOperation(Request request, DistributedSemaphore semaphore) {
            int permits = (int)request.longValue;
            boolean detach = SemaphoreProxy.DATA_TRUE.equals(request.value);
            Address detachAddress = detach ? request.caller : null;
            semaphore.release(permits, detachAddress);
            this.doResponse(request, semaphore, 0L, true);
        }
    }

    class SemaphoreReduceOperationHandler
    extends SemaphoreOperationHandler {
        SemaphoreReduceOperationHandler() {
        }

        void doSemaphoreOperation(Request request, DistributedSemaphore semaphore) {
            int permits = (int)request.longValue;
            semaphore.reduce(permits);
            this.doResponse(request, semaphore, 0L, permits > 0);
        }
    }

    class SemaphoreGetAvailableOperationHandler
    extends SemaphoreOperationHandler {
        SemaphoreGetAvailableOperationHandler() {
        }

        void doSemaphoreOperation(Request request, DistributedSemaphore semaphore) {
            this.doResponse(request, semaphore, semaphore.getAvailable(), false);
        }
    }

    class SemaphoreGetAttachedOperationHandler
    extends SemaphoreOperationHandler {
        SemaphoreGetAttachedOperationHandler() {
        }

        void doSemaphoreOperation(Request request, DistributedSemaphore semaphore) {
            this.doResponse(request, semaphore, semaphore.getAttached(request.caller), false);
        }
    }

    class SemaphoreDrainOperationHandler
    extends SemaphoreOperationHandler {
        SemaphoreDrainOperationHandler() {
        }

        void doSemaphoreOperation(Request request, DistributedSemaphore semaphore) {
            int drainedPermits = semaphore.drain();
            this.doResponse(request, semaphore, drainedPermits, drainedPermits > 0);
        }
    }

    class SemaphoreDestroyOperationHandler
    extends SemaphoreOperationHandler {
        SemaphoreDestroyOperationHandler() {
        }

        void doSemaphoreOperation(Request request, DistributedSemaphore semaphore) {
            List<ScheduledAction> scheduledActions = request.record.getScheduledActions();
            if (scheduledActions != null) {
                for (ScheduledAction sa : scheduledActions) {
                    Request sr = sa.getRequest();
                    if (!sr.caller.equals(request.caller) || sr.lockThreadId != ThreadContext.get().getThreadId()) continue;
                    ConcurrentMapManager.this.node.clusterManager.deregisterScheduledAction(sa);
                    this.doResponse(sr, null, 2L, false);
                }
            }
            request.clearForResponse();
            ConcurrentMapManager.this.returnResponse(request);
        }
    }

    class SemaphoreCancelAcquireOperationHandler
    extends SemaphoreOperationHandler {
        SemaphoreCancelAcquireOperationHandler() {
        }

        void doSemaphoreOperation(Request request, DistributedSemaphore semaphore) {
            long retValue = 0L;
            List<ScheduledAction> scheduledActions = request.record.getScheduledActions();
            if (scheduledActions != null) {
                int threadId = ThreadContext.get().getThreadId();
                Iterator<ScheduledAction> i = scheduledActions.iterator();
                while (i.hasNext()) {
                    ScheduledAction sa = i.next();
                    Request sr = sa.getRequest();
                    if (sr.lockThreadId != threadId || !sr.caller.equals(request.caller)) continue;
                    ConcurrentMapManager.this.node.clusterManager.deregisterScheduledAction(sa);
                    this.doResponse(sr, null, 1L, false);
                    i.remove();
                    retValue = 1L;
                    break;
                }
            }
            request.clearForResponse();
            request.longValue = retValue;
            ConcurrentMapManager.this.returnResponse(request);
        }
    }

    class SemaphoreAttachDetachOperationHandler
    extends SemaphoreOperationHandler {
        SemaphoreAttachDetachOperationHandler() {
        }

        void doSemaphoreOperation(Request request, DistributedSemaphore semaphore) {
            int permitsDelta = (int)request.longValue;
            semaphore.attachDetach(permitsDelta, request.caller);
            this.doResponse(request, semaphore, 0L, true);
        }
    }

    abstract class SemaphoreOperationHandler
    extends SchedulableOperationHandler {
        SemaphoreOperationHandler() {
        }

        abstract void doSemaphoreOperation(Request var1, DistributedSemaphore var2);

        public void handle(final Request request) {
            request.record = ConcurrentMapManager.this.ensureRecord(request, null);
            if (request.record.getValue() == null) {
                final String name = (String)IOUtil.toObject(request.key);
                final SemaphoreConfig sc = ConcurrentMapManager.this.node.getConfig().getSemaphoreConfig(name);
                int configInitialPermits = sc.getInitialPermits();
                if (sc.isFactoryEnabled()) {
                    ConcurrentMapManager.this.node.executorManager.executeNow(new Runnable(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        public void run() {
                            try {
                                SemaphoreOperationHandler.this.initSemaphore(sc, request, name);
                            }
                            catch (Exception e) {
                                try {
                                    ConcurrentMapManager.this.logger.log(Level.SEVERE, e.getMessage(), e);
                                }
                                catch (Throwable throwable) {
                                    ConcurrentMapManager.this.enqueueAndReturn(new Processable(){

                                        public void process() {
                                            SemaphoreOperationHandler.this.handle(request);
                                        }
                                    });
                                    throw throwable;
                                }
                                ConcurrentMapManager.this.enqueueAndReturn(new /* invalid duplicate definition of identical inner class */);
                            }
                            ConcurrentMapManager.this.enqueueAndReturn(new /* invalid duplicate definition of identical inner class */);
                        }
                    });
                    return;
                }
                request.record.setValue(new DistributedSemaphore(configInitialPermits));
            }
            this.doOperation(request);
        }

        synchronized void initSemaphore(SemaphoreConfig sc, Request request, String name) throws Exception {
            if (request.record.getValue() == null) {
                String factoryClassName;
                int configInitialPermits = sc.getInitialPermits();
                SemaphoreFactory factory = sc.getFactoryImplementation();
                if (factory == null && (factoryClassName = sc.getFactoryClassName()) != null && factoryClassName.length() != 0) {
                    ClassLoader cl = ConcurrentMapManager.this.node.getConfig().getClassLoader();
                    Class<?> factoryClass = Serializer.loadClass(cl, factoryClassName);
                    factory = (SemaphoreFactory)factoryClass.newInstance();
                }
                if (factory != null) {
                    int initialPermits = factory.getInitialPermits(name, configInitialPermits);
                    request.record.setValue(new DistributedSemaphore(initialPermits));
                }
            }
        }

        void doOperation(Request request) {
            this.doSemaphoreOperation(request, (DistributedSemaphore)request.record.getValue());
        }

        protected void onNoTimeToSchedule(Request request) {
            this.doResponse(request, null, 1L, false);
            ConcurrentMapManager.this.returnResponse(request);
        }

        protected void doResponse(Request request, DistributedSemaphore semaphore, long retValue, boolean changed) {
            boolean wasScheduled = request.scheduled;
            Record record = request.record;
            List<ScheduledAction> scheduledActions = record.getScheduledActions();
            request.clearForResponse();
            if (changed) {
                record.setValueData(IOUtil.toData(semaphore));
                record.incrementVersion();
                request.version = record.getVersion();
                request.response = record.getValueData();
            }
            request.longValue = retValue;
            ConcurrentMapManager.this.returnResponse(request);
            if (!wasScheduled && scheduledActions != null) {
                int remaining = scheduledActions.size();
                while (remaining-- > 0 && semaphore.getAvailable() > 0) {
                    ScheduledAction sa = scheduledActions.remove(0);
                    ConcurrentMapManager.this.node.clusterManager.deregisterScheduledAction(sa);
                    if (!sa.expired()) {
                        sa.consume();
                        continue;
                    }
                    sa.onExpire();
                }
            }
        }
    }

    class CountDownLatchSetCountOperationHandler
    extends CountDownLatchOperationHandler {
        CountDownLatchSetCountOperationHandler() {
        }

        void doCountDownLatchOperation(Request request, DistributedCountDownLatch cdl) {
            boolean countSet = cdl.setCount((int)request.longValue, request.caller, request.lockAddress);
            this.doResponse(request, cdl, countSet ? 1 : 0, countSet);
        }
    }

    class CountDownLatchGetOwnerOperationHandler
    extends CountDownLatchOperationHandler {
        CountDownLatchGetOwnerOperationHandler() {
        }

        void doCountDownLatchOperation(Request request, DistributedCountDownLatch cdl) {
            request.clearForResponse();
            request.response = cdl.getOwnerAddress();
            ConcurrentMapManager.this.returnResponse(request);
        }
    }

    class CountDownLatchGetCountOperationHandler
    extends CountDownLatchOperationHandler {
        CountDownLatchGetCountOperationHandler() {
        }

        void doCountDownLatchOperation(Request request, DistributedCountDownLatch cdl) {
            this.doResponse(request, cdl, cdl.getCount(), false);
        }
    }

    class CountDownLatchDestroyOperationHandler
    extends CountDownLatchOperationHandler {
        CountDownLatchDestroyOperationHandler() {
        }

        void doCountDownLatchOperation(Request request, DistributedCountDownLatch cdl) {
            List<ScheduledAction> scheduledActions = request.record.getScheduledActions();
            if (scheduledActions != null) {
                for (ScheduledAction sa : scheduledActions) {
                    ConcurrentMapManager.this.node.clusterManager.deregisterScheduledAction(sa);
                    this.doResponse(sa.getRequest(), null, 2L, false);
                }
            }
            request.clearForResponse();
            ConcurrentMapManager.this.returnResponse(request);
        }
    }

    class CountDownLatchCountDownOperationHandler
    extends CountDownLatchOperationHandler {
        CountDownLatchCountDownOperationHandler() {
        }

        void doCountDownLatchOperation(Request request, DistributedCountDownLatch cdl) {
            this.doResponse(request, cdl, 0L, cdl.countDown());
        }
    }

    class CountDownLatchAwaitOperationHandler
    extends CountDownLatchOperationHandler {
        CountDownLatchAwaitOperationHandler() {
        }

        void doCountDownLatchOperation(Request request, DistributedCountDownLatch cdl) {
            if (cdl.ownerLeft()) {
                request.clearForResponse();
                this.doResponse(request, null, 3L, false);
            } else if (cdl.getCount() == 0) {
                request.clearForResponse();
                this.doResponse(request, null, 0L, false);
            } else {
                request.lockThreadId = ThreadContext.get().getThreadId();
                this.schedule(request);
            }
        }
    }

    abstract class CountDownLatchOperationHandler
    extends SchedulableOperationHandler {
        CountDownLatchOperationHandler() {
        }

        abstract void doCountDownLatchOperation(Request var1, DistributedCountDownLatch var2);

        public void handle(Request request) {
            request.record = ConcurrentMapManager.this.ensureRecord(request, DistributedCountDownLatch.newInstanceData);
            this.doOperation(request);
        }

        void doOperation(Request request) {
            this.doCountDownLatchOperation(request, (DistributedCountDownLatch)request.record.getValue());
        }

        protected void onNoTimeToSchedule(Request request) {
            this.doResponse(request, null, 1L, false);
        }

        protected void doResponse(Request request, DistributedCountDownLatch cdl, long retValue, boolean changed) {
            Record record = request.record;
            request.clearForResponse();
            if (changed) {
                record.setValueData(IOUtil.toData(cdl));
                record.incrementVersion();
                request.version = record.getVersion();
                request.response = record.getValueData();
            }
            request.longValue = retValue;
            if (changed && request.operation == ClusterOperation.COUNT_DOWN_LATCH_COUNT_DOWN && cdl.getCount() == 0) {
                request.longValue = this.releaseThreads(record);
            }
            ConcurrentMapManager.this.returnResponse(request);
        }

        private int releaseThreads(Record record) {
            int threadsReleased = 0;
            List<ScheduledAction> scheduledActions = record.getScheduledActions();
            if (scheduledActions != null) {
                for (ScheduledAction sa : scheduledActions) {
                    ConcurrentMapManager.this.node.clusterManager.deregisterScheduledAction(sa);
                    if (!sa.expired()) {
                        sa.consume();
                        ++threadsReleased;
                        continue;
                    }
                    sa.onExpire();
                }
                scheduledActions.clear();
            }
            return threadsReleased;
        }
    }

    class AtomicNumberCompareAndSetOperationHandler
    extends AtomicNumberOperationHandler {
        AtomicNumberCompareAndSetOperationHandler() {
        }

        long getNewValue(long oldValue, long value) {
            return value;
        }

        long getResponseValue(long oldValue, long value) {
            return 1L;
        }
    }

    class AtomicNumberGetAndSetOperationHandler
    extends AtomicNumberOperationHandler {
        AtomicNumberGetAndSetOperationHandler() {
        }

        long getNewValue(long oldValue, long value) {
            return value;
        }

        long getResponseValue(long oldValue, long value) {
            return oldValue;
        }
    }

    class AtomicNumberGetAndAddOperationHandler
    extends AtomicNumberOperationHandler {
        AtomicNumberGetAndAddOperationHandler() {
        }

        long getNewValue(long oldValue, long value) {
            return oldValue + value;
        }

        long getResponseValue(long oldValue, long value) {
            return oldValue;
        }
    }

    class AtomicNumberAddAndGetOperationHandler
    extends AtomicNumberOperationHandler {
        AtomicNumberAddAndGetOperationHandler() {
        }

        long getNewValue(long oldValue, long value) {
            return oldValue + value;
        }

        long getResponseValue(long oldValue, long value) {
            return oldValue + value;
        }
    }

    abstract class AtomicNumberOperationHandler
    extends MTargetAwareOperationHandler {
        AtomicNumberOperationHandler() {
        }

        abstract long getNewValue(long var1, long var3);

        abstract long getResponseValue(long var1, long var3);

        void doOperation(Request request) {
            Record record = ConcurrentMapManager.this.ensureRecord(request, AtomicNumberProxy.DATA_LONG_ZERO);
            Data oldValueData = record.getValueData();
            Data expectedValue = request.value;
            long value = request.longValue;
            request.clearForResponse();
            if (expectedValue == null || expectedValue.equals(oldValueData)) {
                long oldValue = (Long)IOUtil.toObject(oldValueData);
                long newValue = this.getNewValue(oldValue, value);
                request.longValue = this.getResponseValue(oldValue, value);
                if (oldValue != newValue) {
                    record.setValueData(IOUtil.toData(newValue));
                    record.incrementVersion();
                    request.version = record.getVersion();
                    request.response = record.getValueData();
                }
            } else {
                request.longValue = 0L;
            }
        }
    }

    class PutOperationHandler
    extends SchedulableOperationHandler {
        PutOperationHandler() {
        }

        void doOperation(Request request) {
            CMap cmap = ConcurrentMapManager.this.getOrCreateMap(request.name);
            SystemLogService css = ConcurrentMapManager.this.node.getSystemLogService();
            if (css.shouldLog(SystemLogService.Level.TRACE)) {
                css.logObject(request, SystemLogService.Level.TRACE, "Calling cmap.put");
            }
            cmap.put(request);
            if (request.operation == ClusterOperation.CONCURRENT_MAP_TRY_PUT || request.operation == ClusterOperation.CONCURRENT_MAP_PUT_AND_UNLOCK) {
                request.response = Boolean.TRUE;
            }
            if (css.shouldLog(SystemLogService.Level.INFO)) {
                css.info(request, "req.response", request.response);
            }
        }

        public void handle(Request request) {
            CMap cmap = ConcurrentMapManager.this.getOrCreateMap(request.name);
            SystemLogService css = ConcurrentMapManager.this.systemLogService;
            if (css.shouldLog(SystemLogService.Level.TRACE)) {
                css.logObject(request, SystemLogService.Level.TRACE, cmap);
            }
            boolean checkCapacity = request.operation != ClusterOperation.CONCURRENT_MAP_REPLACE_IF_NOT_NULL;
            boolean overCapacity = checkCapacity && cmap.overCapacity();
            boolean cmapNotLocked = cmap.isNotLocked(request);
            if (css.shouldLog(SystemLogService.Level.TRACE)) {
                css.trace(request, "OverCapacity/CmapNotLocked", overCapacity, cmapNotLocked);
            }
            if (cmapNotLocked) {
                if (!overCapacity) {
                    if (this.shouldSchedule(request)) {
                        if (request.hasEnoughTimeToSchedule()) {
                            if (css.shouldLog(SystemLogService.Level.INFO)) {
                                css.info((CallStateAware)request, MapSystemLogFactory.newScheduleRequest(request, cmap.getRecord(request)));
                            }
                            this.schedule(request);
                        } else {
                            if (css.shouldLog(SystemLogService.Level.INFO)) {
                                css.info(request, "NoTimeToSchedule", request.name, (Object)request.operation);
                            }
                            this.onNoTimeToSchedule(request);
                        }
                        return;
                    }
                    Record record = cmap.getRecord(request);
                    if (css.shouldLog(SystemLogService.Level.TRACE)) {
                        css.trace(request, "Record is", record);
                    }
                    if ((record == null || record.isLoadable()) && cmap.loader != null && request.operation != ClusterOperation.CONCURRENT_MAP_SET) {
                        if (css.shouldLog(SystemLogService.Level.TRACE)) {
                            css.trace((CallStateAware)request, "Will Load");
                        }
                        ConcurrentMapManager.this.storeExecutor.execute(new PutLoader(cmap, request), request.key.hashCode());
                    } else {
                        this.storeProceed(cmap, request);
                    }
                } else if (request.operation == ClusterOperation.CONCURRENT_MAP_TRY_PUT) {
                    request.response = Boolean.FALSE;
                    ConcurrentMapManager.this.returnResponse(request);
                } else {
                    ConcurrentMapManager.this.returnRedoResponse(request, Constants.RedoType.REDO_MAP_OVER_CAPACITY);
                }
            } else {
                ConcurrentMapManager.this.returnRedoResponse(request, Constants.RedoType.REDO_MAP_LOCKED);
            }
        }

        void storeProceed(CMap cmap, Request request) {
            if (cmap.store != null && cmap.writeDelayMillis == 0L && cmap.isApplicable(request.operation, request, Clock.currentTimeMillis())) {
                ConcurrentMapManager.this.storeExecutor.execute(new PutStorer(cmap, request), request.key.hashCode());
            } else {
                this.doOperation(request);
                ConcurrentMapManager.this.returnResponse(request);
            }
        }

        class PutStorer
        extends AbstractMapStoreOperation {
            PutStorer(CMap cmap, Request request) {
                super(cmap, request);
            }

            void doMapStoreOperation() {
                Object value;
                if (this.request.operation == ClusterOperation.CONCURRENT_MAP_REPLACE_IF_SAME) {
                    MultiData multiData = (MultiData)IOUtil.toObject(this.request.value);
                    value = IOUtil.toObject(multiData.getData(1));
                } else {
                    value = IOUtil.toObject(this.request.value);
                }
                Object key = IOUtil.toObject(this.request.key);
                this.cmap.store.store(key, value);
                this.afterMapStore();
            }

            public void process() {
                if (this.success) {
                    PutOperationHandler.this.doOperation(this.request);
                }
                ConcurrentMapManager.this.returnResponse(this.request);
            }
        }

        class PutLoader
        extends AbstractMapStoreOperation {
            Data valueData;

            PutLoader(CMap cmap, Request request) {
                super(cmap, request);
                this.valueData = null;
            }

            void doMapStoreOperation() {
                Object key = IOUtil.toObject(this.request.key);
                Object value = this.cmap.loader.load(key);
                this.valueData = IOUtil.toData(value);
            }

            public void process() {
                if (this.valueData != null) {
                    Record record = this.cmap.getRecord(this.request);
                    if (record == null) {
                        record = this.cmap.createAndAddNewRecord(this.request.key, this.valueData);
                    } else {
                        record.setValueData(this.valueData);
                    }
                }
                PutOperationHandler.this.storeProceed(this.cmap, this.request);
            }
        }
    }

    class PutFromLoadOperationHandler
    extends SchedulableOperationHandler {
        PutFromLoadOperationHandler() {
        }

        protected void onNoTimeToSchedule(Request request) {
            request.response = Boolean.FALSE;
            ConcurrentMapManager.this.returnResponse(request);
        }

        void doOperation(Request request) {
            CMap cmap = ConcurrentMapManager.this.getOrCreateMap(request.name);
            if (cmap.overCapacity()) {
                request.value = null;
                request.response = Boolean.FALSE;
            } else {
                Record record = ConcurrentMapManager.this.ensureRecord(request);
                cmap.put(request);
                if (record != null) {
                    record.setDirty(false);
                    record.setLastStoredTime(Clock.currentTimeMillis());
                }
                request.value = null;
                request.response = Boolean.TRUE;
            }
        }
    }

    class PutTransientOperationHandler
    extends SchedulableOperationHandler {
        PutTransientOperationHandler() {
        }

        void doOperation(Request request) {
            CMap cmap = ConcurrentMapManager.this.getOrCreateMap(request.name);
            if (!cmap.isNotLocked(request)) {
                ConcurrentMapManager.this.setRedoResponse(request, Constants.RedoType.REDO_MAP_LOCKED);
            } else if (cmap.overCapacity()) {
                ConcurrentMapManager.this.setRedoResponse(request, Constants.RedoType.REDO_MAP_OVER_CAPACITY);
            } else {
                Record record = ConcurrentMapManager.this.ensureRecord(request);
                boolean dirty = record != null && record.isDirty();
                cmap.put(request);
                if (record != null) {
                    record.setDirty(dirty);
                    if (!dirty) {
                        record.setLastStoredTime(Clock.currentTimeMillis());
                    }
                }
                request.value = null;
                request.response = Boolean.TRUE;
            }
        }
    }

    class RemoveIfSameOperationHandler
    extends SchedulableOperationHandler {
        RemoveIfSameOperationHandler() {
        }

        public void handle(Request request) {
            if (this.shouldSchedule(request)) {
                if (request.hasEnoughTimeToSchedule()) {
                    this.schedule(request);
                } else {
                    this.onNoTimeToSchedule(request);
                }
            } else {
                this.doOperation(request);
            }
        }

        void doOperation(Request request) {
            CMap cmap = ConcurrentMapManager.this.getOrCreateMap(request.name);
            Record record = cmap.getRecord(request);
            if (record == null) {
                request.response = Boolean.FALSE;
                ConcurrentMapManager.this.returnResponse(request);
            } else {
                ConcurrentMapManager.this.storeExecutor.execute(new RemoveIfSameTask(request, record, cmap), request.key.hashCode());
            }
        }

        class RemoveIfSameTask
        extends AbstractMapStoreOperation {
            final Record record;

            RemoveIfSameTask(Request request, Record record, CMap cmap) {
                super(cmap, request);
                this.record = record;
            }

            public void doMapStoreOperation() {
                Object expectedValue = IOUtil.toObject(this.request.value);
                this.request.response = expectedValue.equals(this.record.getValue());
                if (this.cmap.store != null && this.cmap.writeDelayMillis == 0L) {
                    this.cmap.store.delete(IOUtil.toObject(this.request.key));
                    this.afterMapStore();
                }
            }

            public void process() {
                this.request.value = null;
                if (this.request.response == Boolean.TRUE && this.record.isActive()) {
                    this.cmap.remove(this.request);
                    this.request.response = Boolean.TRUE;
                } else {
                    this.request.response = Boolean.FALSE;
                }
                ConcurrentMapManager.this.returnResponse(this.request);
            }
        }
    }

    class ReplaceOperationHandler
    extends SchedulableOperationHandler {
        ReplaceOperationHandler() {
        }

        public void handle(Request request) {
            if (this.shouldSchedule(request)) {
                if (request.hasEnoughTimeToSchedule()) {
                    this.schedule(request);
                } else {
                    this.onNoTimeToSchedule(request);
                }
            } else {
                this.doOperation(request);
            }
        }

        void doOperation(Request request) {
            CMap cmap = ConcurrentMapManager.this.getOrCreateMap(request.name);
            Record record = cmap.getRecord(request);
            if (record == null) {
                request.response = Boolean.FALSE;
                ConcurrentMapManager.this.returnResponse(request);
            } else {
                ConcurrentMapManager.this.storeExecutor.execute(new ReplaceTask(request, record, cmap), request.key.hashCode());
            }
        }

        class ReplaceTask
        extends AbstractMapStoreOperation {
            final Record record;

            ReplaceTask(Request request, Record record, CMap cmap) {
                super(cmap, request);
                this.record = record;
            }

            public void doMapStoreOperation() {
                MultiData multiData = (MultiData)IOUtil.toObject(this.request.value);
                Object expectedValue = IOUtil.toObject(multiData.getData(0));
                this.request.value = multiData.getData(1);
                this.request.response = expectedValue.equals(this.record.getValue());
                if (this.request.response == Boolean.TRUE) {
                    this.record.setValueData(this.request.value);
                }
                if (this.cmap.store != null && this.cmap.writeDelayMillis == 0L) {
                    this.cmap.store.store(IOUtil.toObject(this.request.key), IOUtil.toObject(this.request.value));
                    this.afterMapStore();
                }
            }

            public void process() {
                if (this.request.response == Boolean.TRUE) {
                    this.cmap.put(this.request);
                    this.request.response = Boolean.TRUE;
                }
                this.request.value = null;
                ConcurrentMapManager.this.returnResponse(this.request);
            }
        }
    }

    class PutMultiOperationHandler
    extends SchedulableOperationHandler {
        PutMultiOperationHandler() {
        }

        public void handle(Request request) {
            if (this.shouldSchedule(request)) {
                if (request.hasEnoughTimeToSchedule()) {
                    this.schedule(request);
                } else {
                    this.onNoTimeToSchedule(request);
                }
            } else {
                this.doOperation(request);
            }
        }

        void doOperation(Request request) {
            CMap cmap = ConcurrentMapManager.this.getOrCreateMap(request.name);
            if (!cmap.multiMapSet) {
                cmap.putMulti(request);
                request.response = Boolean.TRUE;
                ConcurrentMapManager.this.returnResponse(request);
            } else {
                Record record = cmap.getRecord(request);
                if (record == null || record.getMultiValues() == null || !record.isValid()) {
                    cmap.putMulti(request);
                    request.response = Boolean.TRUE;
                    ConcurrentMapManager.this.returnResponse(request);
                } else {
                    ConcurrentMapManager.this.storeExecutor.execute(new PutMultiSetMapTask(request, record, cmap), request.key.hashCode());
                }
            }
        }

        class PutMultiSetMapTask
        implements Runnable,
        Processable {
            final CMap cmap;
            final Request request;
            final Record record;

            PutMultiSetMapTask(Request request, Record record, CMap cmap) {
                this.request = request;
                this.record = record;
                this.cmap = cmap;
            }

            public void run() {
                this.request.response = Boolean.TRUE;
                Collection<ValueHolder> multiValues = this.record.getMultiValues();
                if (multiValues != null) {
                    this.request.response = !multiValues.contains(new ValueHolder(this.request.value));
                }
                ConcurrentMapManager.this.enqueueAndReturn(this);
            }

            public void process() {
                if (this.request.response == Boolean.TRUE) {
                    this.cmap.putMulti(this.request);
                }
                ConcurrentMapManager.this.returnResponse(this.request);
            }
        }
    }

    class RemoveMultiOperationHandler
    extends SchedulableOperationHandler {
        RemoveMultiOperationHandler() {
        }

        public void handle(Request request) {
            if (this.shouldSchedule(request)) {
                if (request.hasEnoughTimeToSchedule()) {
                    this.schedule(request);
                } else {
                    this.onNoTimeToSchedule(request);
                }
            } else {
                this.doOperation(request);
            }
        }

        void doOperation(Request request) {
            CMap cmap = ConcurrentMapManager.this.getOrCreateMap(request.name);
            Record record = cmap.getRecord(request);
            if (record == null || record.getMultiValues() == null) {
                request.response = Boolean.FALSE;
                ConcurrentMapManager.this.returnResponse(request);
            } else {
                ConcurrentMapManager.this.storeExecutor.execute(new RemoveMultiSetMapTask(request, record, cmap), request.key.hashCode());
            }
        }

        class RemoveMultiSetMapTask
        implements Runnable,
        Processable {
            final CMap cmap;
            final Request request;
            final Record record;

            RemoveMultiSetMapTask(Request request, Record record, CMap cmap) {
                this.request = request;
                this.record = record;
                this.cmap = cmap;
            }

            public void run() {
                Collection<ValueHolder> multiValues = this.record.getMultiValues();
                if (multiValues == null) {
                    this.request.response = Boolean.FALSE;
                    ConcurrentMapManager.this.returnResponse(this.request);
                } else {
                    this.request.response = multiValues.remove(new ValueHolder(this.request.value));
                    ConcurrentMapManager.this.enqueueAndReturn(this);
                }
            }

            public void process() {
                if (this.request.response == Boolean.TRUE) {
                    this.cmap.onRemoveMulti(this.request, this.record);
                }
                ConcurrentMapManager.this.returnResponse(this.request);
            }
        }
    }

    class RemoveOperationHandler
    extends SchedulableOperationHandler {
        RemoveOperationHandler() {
        }

        void doOperation(Request request) {
            CMap cmap = ConcurrentMapManager.this.getOrCreateMap(request.name);
            cmap.remove(request);
        }

        public void handle(Request request) {
            CMap cmap = ConcurrentMapManager.this.getOrCreateMap(request.name);
            if (cmap.isNotLocked(request)) {
                if (this.shouldSchedule(request)) {
                    if (request.hasEnoughTimeToSchedule()) {
                        if (ConcurrentMapManager.this.systemLogService.shouldLog(SystemLogService.Level.INFO)) {
                            ConcurrentMapManager.this.systemLogService.info((CallStateAware)request, MapSystemLogFactory.newScheduleRequest(request, cmap.getRecord(request)));
                        }
                        this.schedule(request);
                    } else {
                        if (ConcurrentMapManager.this.systemLogService.shouldLog(SystemLogService.Level.INFO)) {
                            ConcurrentMapManager.this.systemLogService.info(request, "NoTimeToSchedule", request.name, (Object)request.operation);
                        }
                        this.onNoTimeToSchedule(request);
                    }
                    return;
                }
                Record record = cmap.getRecord(request);
                if ((record == null || record.isLoadable()) && cmap.loader != null) {
                    ConcurrentMapManager.this.storeExecutor.execute(new RemoveLoader(cmap, request), request.key.hashCode());
                } else {
                    this.storeProceed(cmap, request);
                }
            } else {
                ConcurrentMapManager.this.returnRedoResponse(request, Constants.RedoType.REDO_MAP_LOCKED);
            }
        }

        void storeProceed(CMap cmap, Request request) {
            if (cmap.store != null && cmap.writeDelayMillis == 0L) {
                ConcurrentMapManager.this.storeExecutor.execute(new RemoveStorer(cmap, request), request.key.hashCode());
            } else {
                this.doOperation(request);
                ConcurrentMapManager.this.returnResponse(request);
            }
        }

        class RemoveStorer
        extends AbstractMapStoreOperation {
            RemoveStorer(CMap cmap, Request request) {
                super(cmap, request);
            }

            void doMapStoreOperation() {
                Object key = IOUtil.toObject(this.request.key);
                this.cmap.store.delete(key);
                this.afterMapStore();
            }

            public void process() {
                if (this.success) {
                    RemoveOperationHandler.this.doOperation(this.request);
                }
                ConcurrentMapManager.this.returnResponse(this.request);
            }
        }

        class RemoveLoader
        extends AbstractMapStoreOperation {
            Data valueData;

            RemoveLoader(CMap cmap, Request request) {
                super(cmap, request);
                this.valueData = null;
            }

            void doMapStoreOperation() {
                Object key = IOUtil.toObject(this.request.key);
                Object value = this.cmap.loader.load(key);
                this.valueData = IOUtil.toData(value);
            }

            public void process() {
                Record record = this.cmap.getRecord(this.request);
                if (this.valueData != null) {
                    if (record == null) {
                        record = this.cmap.createAndAddNewRecord(this.request.key, this.valueData);
                    } else {
                        record.setValueData(this.valueData);
                    }
                    record.setActive();
                }
                if (record != null) {
                    if (record.isActive() && !record.isValid()) {
                        record.setExpirationTime(Long.MAX_VALUE);
                        record.setMaxIdle(Long.MAX_VALUE);
                    }
                    RemoveOperationHandler.this.storeProceed(this.cmap, this.request);
                } else {
                    ConcurrentMapManager.this.returnResponse(this.request);
                }
            }
        }
    }

    class ClearQuickOperationHandler
    extends BaseManager.MigrationAwareOperationHandler {
        ClearQuickOperationHandler() {
        }

        void doOperation(Request request) {
            CMap cmap = ConcurrentMapManager.this.getOrCreateMap(request.name);
            cmap.clearQuick();
            request.response = true;
            ConcurrentMapManager.this.returnResponse(request);
        }

        public void handle(Request request) {
            CMap cmap = ConcurrentMapManager.this.getOrCreateMap(request.name);
            if (cmap.isNotLocked(request)) {
                this.doOperation(request);
            } else {
                ConcurrentMapManager.this.returnRedoResponse(request, Constants.RedoType.REDO_MAP_LOCKED);
            }
        }
    }

    class RemoveItemOperationHandler
    extends RemoveOperationHandler {
        RemoveItemOperationHandler() {
        }

        void doOperation(Request request) {
            CMap cmap = ConcurrentMapManager.this.getOrCreateMap(request.name);
            request.response = cmap.removeItem(request);
        }

        protected void onNoTimeToSchedule(Request request) {
            request.response = Boolean.FALSE;
            ConcurrentMapManager.this.returnResponse(request);
        }
    }

    abstract class MTargetAwareOperationHandler
    extends BaseManager.TargetAwareOperationHandler {
        MTargetAwareOperationHandler() {
        }

        boolean isRightRemoteTarget(Request request) {
            return ConcurrentMapManager.this.thisAddress.equals(ConcurrentMapManager.this.getKeyOwner(request));
        }
    }

    class InvalidateOperationHandler
    implements PacketProcessor {
        InvalidateOperationHandler() {
        }

        public void process(Packet packet) {
            NearCache nearCache;
            CMap cmap = ConcurrentMapManager.this.getMap(packet.name);
            if (cmap != null && (nearCache = cmap.nearCache) != null) {
                nearCache.invalidate(packet.getKeyData());
            }
            ConcurrentMapManager.this.releasePacket(packet);
        }
    }

    class WanMergePacketProcessor
    implements PacketProcessor {
        final ParallelExecutor parallelExecutor;

        WanMergePacketProcessor() {
            this.parallelExecutor = ConcurrentMapManager.this.node.executorManager.newParallelExecutor(20);
        }

        public void process(Packet packet) {
            final DataRecordEntry dataRecordEntry = (DataRecordEntry)IOUtil.toObject(packet.getValueData());
            ConcurrentMapManager.this.node.concurrentMapManager.getOrCreateMap(packet.name);
            this.parallelExecutor.execute(new Runnable(){

                public void run() {
                    ConcurrentMapManager.this.mergeWanRecord(dataRecordEntry);
                }
            });
        }
    }

    class AsyncMergePacketProcessor
    implements PacketProcessor {
        AsyncMergePacketProcessor() {
        }

        public void process(Packet packet) {
            packet.operation = ClusterOperation.CONCURRENT_MAP_WAN_MERGE;
            Data key = packet.getKeyData();
            Address address = ConcurrentMapManager.this.getKeyOwner(key);
            if (ConcurrentMapManager.this.thisAddress.equals(address)) {
                WanMergePacketProcessor p = (WanMergePacketProcessor)ConcurrentMapManager.this.getPacketProcessor(ClusterOperation.CONCURRENT_MAP_WAN_MERGE);
                p.process(packet);
            } else {
                ConcurrentMapManager.this.sendOrReleasePacket(packet, address);
            }
        }
    }

    class BackupOperationHandler
    extends BaseManager.TargetAwareOperationHandler {
        BackupOperationHandler() {
        }

        boolean isCallerKnownMember(Request request) {
            return !ConcurrentMapManager.this.backupRedoEnabled || super.isCallerKnownMember(request);
        }

        boolean isRightRemoteTarget(Request request) {
            if (!ConcurrentMapManager.this.backupRedoEnabled) {
                return true;
            }
            int partitionId = ConcurrentMapManager.this.getPartitionId(request);
            PartitionInfo partition = ConcurrentMapManager.this.partitionManager.getPartition(partitionId);
            return ConcurrentMapManager.this.thisAddress.equals(partition.getReplicaAddress(this.getReplicaIndex(request)));
        }

        boolean isPartitionMigrating(Request request) {
            return ConcurrentMapManager.this.backupRedoEnabled && ConcurrentMapManager.this.isMigrating(request, this.getReplicaIndex(request));
        }

        private int getReplicaIndex(Request request) {
            return (int)request.longValue;
        }

        public void handle(Request request) {
            this.doOperation(request);
            if (request.callId != -1L) {
                ConcurrentMapManager.this.returnResponse(request);
            }
        }

        void doOperation(Request request) {
            Boolean value = ConcurrentMapManager.this.processBackupRequest(request);
            request.clearForResponse();
            request.response = value;
        }
    }

    class LockMapOperationHandler
    extends BaseManager.MigrationAwareOperationHandler {
        LockMapOperationHandler() {
        }

        void doOperation(Request request) {
            CMap cmap = ConcurrentMapManager.this.getOrCreateMap(request.name);
            cmap.lockMap(request);
        }
    }

    public class MEmpty {
        public boolean isEmpty(String name) {
            NearCache nearCache = (NearCache)ConcurrentMapManager.this.mapCaches.get(name);
            if (nearCache != null && !nearCache.isEmpty()) {
                return false;
            }
            CMap cMap = (CMap)ConcurrentMapManager.this.maps.get(name);
            if (cMap != null) {
                long now = Clock.currentTimeMillis();
                for (Record record : cMap.mapRecords.values()) {
                    if (!record.isActive() || !record.isValid(now) || !record.hasValueData()) continue;
                    if (cMap.isReadBackupData()) {
                        return false;
                    }
                    PartitionServiceImpl.PartitionProxy partition = ConcurrentMapManager.this.partitionServiceImpl.getPartition(record.getBlockId());
                    if (partition == null || partition.getOwner() == null || !partition.getOwner().localMember()) continue;
                    return false;
                }
            }
            return ConcurrentMapManager.this.size(name) == 0;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class MLockMap
    extends BaseManager.MultiCall<Boolean> {
        private final String name;
        private final ClusterOperation operation;
        private volatile boolean result;

        public MLockMap(String name, boolean lock) {
            this.name = name;
            this.operation = lock ? ClusterOperation.CONCURRENT_MAP_LOCK_MAP : ClusterOperation.CONCURRENT_MAP_UNLOCK_MAP;
        }

        @Override
        BaseManager.SubCall createNewTargetAwareOp(Address target) {
            return new MTargetLockMap(target);
        }

        @Override
        boolean onResponse(Object response) {
            return Boolean.TRUE.equals(response);
        }

        @Override
        void onCall() {
        }

        @Override
        void onComplete() {
            this.result = true;
        }

        @Override
        Boolean returnResult() {
            return this.result;
        }

        @Override
        protected boolean excludeLiteMember() {
            return true;
        }

        @Override
        protected Address getFirstAddressToMakeCall() {
            return ConcurrentMapManager.this.node.getMasterAddress();
        }

        class MTargetLockMap
        extends BaseManager.SubCall {
            public MTargetLockMap(Address target) {
                super(target);
                this.setLocal(MLockMap.this.operation, MLockMap.this.name, null, null, 0L, -1L);
                this.request.setBooleanRequest();
            }

            protected final boolean canTimeout() {
                return false;
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class MContainsValue
    extends BaseManager.MultiCall<Boolean> {
        boolean contains = false;
        final String name;
        final Object value;

        public MContainsValue(String name, Object value) {
            this.name = name;
            this.value = value;
        }

        @Override
        BaseManager.SubCall createNewTargetAwareOp(Address target) {
            return new MGetContainsValue(target);
        }

        @Override
        boolean onResponse(Object response) {
            if (response == Boolean.TRUE) {
                this.contains = true;
                return false;
            }
            return true;
        }

        @Override
        void onCall() {
            this.contains = false;
        }

        @Override
        Boolean returnResult() {
            return this.contains;
        }

        @Override
        protected boolean excludeLiteMember() {
            return true;
        }

        class MGetContainsValue
        extends MigrationAwareSubCall {
            public MGetContainsValue(Address target) {
                super(target);
                this.setLocal(ClusterOperation.CONCURRENT_MAP_CONTAINS_VALUE, MContainsValue.this.name, null, MContainsValue.this.value, 0L, -1L);
                this.request.setBooleanRequest();
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class MClearQuick
    extends BaseManager.MultiCall<Boolean> {
        final String name;
        boolean result;

        public MClearQuick(String name) {
            this.name = name;
        }

        @Override
        BaseManager.SubCall createNewTargetAwareOp(Address target) {
            return new MTargetClearQuickMap(target);
        }

        @Override
        boolean onResponse(Object response) {
            return true;
        }

        @Override
        Object returnResult() {
            return this.result;
        }

        @Override
        void onComplete() {
            this.result = true;
        }

        @Override
        protected boolean excludeLiteMember() {
            return true;
        }

        class MTargetClearQuickMap
        extends BaseManager.SubCall {
            public MTargetClearQuickMap(Address target) {
                super(target);
                this.setLocal(ClusterOperation.CONCURRENT_MAP_CLEAR_QUICK, MClearQuick.this.name, null, null, 0L, -1L);
                this.request.setBooleanRequest();
            }
        }
    }

    abstract class MigrationAwareSubCall
    extends BaseManager.SubCall {
        protected MigrationAwareSubCall(Address target) {
            super(target);
        }

        public void process() {
            this.request.blockId = -1;
            super.process();
        }

        public boolean isMigrationAware() {
            return true;
        }
    }

    abstract class MBackupAwareOp
    extends MTargetAwareOp {
        protected volatile int backupCount;
        protected volatile int asyncBackupCount;

        MBackupAwareOp() {
            this.backupCount = 0;
            this.asyncBackupCount = 0;
        }

        protected void backup(ClusterOperation operation) {
            int i;
            int localBackupCount = this.backupCount;
            int localAsyncBackupCount = this.asyncBackupCount;
            int totalBackupCount = localBackupCount + localAsyncBackupCount;
            if (localBackupCount <= 0 && localAsyncBackupCount <= 0) {
                return;
            }
            if (totalBackupCount > ConcurrentMapManager.this.maxBackupCount) {
                String msg = "Max backup is " + ConcurrentMapManager.this.maxBackupCount + " but total backupCount is " + totalBackupCount;
                ConcurrentMapManager.this.logger.log(Level.SEVERE, msg);
                throw new HazelcastException(msg);
            }
            if (this.request.key == null || this.request.key.size() == 0) {
                throw new HazelcastException("Key is null! " + this.request.key);
            }
            MBackup[] backupOps = new MBackup[localBackupCount];
            for (i = 0; i < totalBackupCount; ++i) {
                int replicaIndex = i + 1;
                if (i < localBackupCount) {
                    MBackup backupOp;
                    backupOps[i] = backupOp = new MBackup();
                    backupOp.sendBackup(operation, replicaIndex, this.request);
                    continue;
                }
                Request reqBackup = Request.copyFromRequest(this.request);
                reqBackup.operation = operation;
                ConcurrentMapManager.this.enqueueAndReturn(new AsyncBackupProcessable(reqBackup, replicaIndex));
            }
            for (i = 0; i < localBackupCount; ++i) {
                MBackup backupOp = backupOps[i];
                try {
                    if (backupOp.getResultAsBoolean() || !ConcurrentMapManager.this.logger.isLoggable(Level.FINEST)) continue;
                    ConcurrentMapManager.this.logger.log(Level.FINEST, "Backup failed -> " + this.request);
                    continue;
                }
                catch (HazelcastException e) {
                    Level level = ConcurrentMapManager.this.backupRedoEnabled ? Level.WARNING : Level.FINEST;
                    ConcurrentMapManager.this.logger.log(level, "Backup operation [" + (Object)((Object)operation) + "] has failed! " + e.getClass().getName() + ": " + e.getMessage());
                    ConcurrentMapManager.this.logger.log(Level.FINEST, e.getMessage(), e);
                }
            }
            if (totalBackupCount > 0 && this.shouldRedoWhenOwnerDies() && this.target != null && ConcurrentMapManager.this.node.getClusterImpl().getMember(this.target) == null) {
                ConcurrentMapManager.this.logger.log(Level.WARNING, "Target[" + this.target + "] is dead! " + "Hazelcast will retry " + (Object)((Object)this.request.operation));
                this.doOp();
                this.getRedoAwareResult();
            }
        }

        protected boolean shouldRedoWhenOwnerDies() {
            return false;
        }

        void prepareForBackup() {
            int localBackupCount = 0;
            int localAsyncBackupCount = 0;
            int maxBackup = ConcurrentMapManager.this.dataMemberCount.get() - 1;
            if (maxBackup > 0) {
                CMap map = ConcurrentMapManager.this.getOrCreateMap(this.request.name);
                localBackupCount = Math.min(map.getBackupCount(), maxBackup);
                localAsyncBackupCount = Math.min(map.getAsyncBackupCount(), maxBackup - localBackupCount);
            }
            this.backupCount = localBackupCount > 0 ? localBackupCount : 0;
            this.asyncBackupCount = localAsyncBackupCount > 0 ? localAsyncBackupCount : 0;
        }

        public void process() {
            this.prepareForBackup();
            this.request.blockId = ConcurrentMapManager.this.getPartitionId(this.request);
            super.process();
        }

        public void handleNoneRedoResponse(Packet packet) {
            this.handleRemoteResponse(packet);
            super.handleNoneRedoResponse(packet);
        }

        public void handleRemoteResponse(Packet packet) {
            this.request.local = true;
            this.request.version = packet.version;
            this.request.lockCount = packet.lockCount;
            this.request.longValue = packet.longValue;
        }
    }

    class AsyncBackupProcessable
    implements Processable {
        final Request request;
        final int replicaIndex;

        AsyncBackupProcessable(Request request, int replicaIndex) {
            this.request = request;
            this.replicaIndex = replicaIndex;
        }

        public void process() {
            Address target = ConcurrentMapManager.this.getBackupMember(this.request.blockId, this.replicaIndex);
            if (target != null) {
                if (ConcurrentMapManager.this.thisAddress.equals(target)) {
                    ConcurrentMapManager.this.processBackupRequest(this.request);
                } else {
                    Packet packet = ConcurrentMapManager.this.obtainPacket();
                    packet.setFromRequest(this.request);
                    packet.callId = -1L;
                    ConcurrentMapManager.this.sendOrReleasePacket(packet, target);
                }
            }
        }
    }

    class MBackup
    extends MTargetAwareOp {
        protected int replicaIndex;

        MBackup() {
            this.replicaIndex = 0;
        }

        public void sendBackup(ClusterOperation operation, int replicaIndex, Request reqBackup) {
            this.reset();
            this.replicaIndex = replicaIndex;
            SystemLogService css = ConcurrentMapManager.this.node.getSystemLogService();
            if (css.shouldLog(SystemLogService.Level.TRACE)) {
                css.trace(this, "SendingBackup callId.", this.callId);
            }
            this.request.setFromRequest(reqBackup);
            this.request.operation = operation;
            this.request.caller = ConcurrentMapManager.this.thisAddress;
            this.request.longValue = replicaIndex;
            this.request.setBooleanRequest();
            this.doOp();
        }

        public void reset() {
            super.reset();
            this.replicaIndex = 0;
        }

        public void process() {
            this.target = ConcurrentMapManager.this.getBackupMember(this.request.blockId, this.replicaIndex);
            if (this.target == null) {
                if (ConcurrentMapManager.this.backupRedoEnabled && this.isValidBackup()) {
                    this.setRedoResult(Constants.RedoType.REDO_TARGET_UNKNOWN);
                } else {
                    this.setResult(Boolean.FALSE);
                }
            } else if (this.target.equals(ConcurrentMapManager.this.thisAddress)) {
                this.doLocalOp();
            } else {
                this.invoke();
            }
        }

        boolean isValidBackup() {
            int maxBackupCount = ConcurrentMapManager.this.dataMemberCount.get() - 1;
            if (maxBackupCount > 0) {
                CMap map = ConcurrentMapManager.this.getOrCreateMap(this.request.name);
                maxBackupCount = Math.min(map.getBackupCount(), maxBackupCount);
            }
            maxBackupCount = maxBackupCount > 0 ? maxBackupCount : 0;
            return this.replicaIndex <= maxBackupCount;
        }

        boolean isMigrationAware() {
            return ConcurrentMapManager.this.backupRedoEnabled;
        }

        boolean isPartitionMigrating() {
            return ConcurrentMapManager.this.isMigrating(this.request, this.replicaIndex);
        }

        protected final void handleInterruption() {
            ConcurrentMapManager.this.logger.log(Level.WARNING, Thread.currentThread().getName() + " is interrupted! " + "Hazelcast intentionally suppresses interruption during backup operations. " + "Operation: " + (Object)((Object)this.request.operation));
        }
    }

    abstract class MTargetAwareOp
    extends BaseManager.TargetAwareOp {
        MTargetAwareOp() {
        }

        public void doOp() {
            this.target = null;
            super.doOp();
        }

        public void setTarget() {
            if (this.target == null) {
                this.target = ConcurrentMapManager.this.getKeyOwner(this.request);
            }
        }
    }

    abstract class MDefaultBackupAndMigrationAwareOp
    extends MBackupAndMigrationAwareOp {
        MDefaultBackupAndMigrationAwareOp() {
        }

        void prepareForBackup() {
            this.backupCount = Math.min(1, ConcurrentMapManager.this.dataMemberCount.get() - 1);
        }
    }

    abstract class MBackupAndMigrationAwareOp
    extends MBackupAwareOp {
        MBackupAndMigrationAwareOp() {
        }

        public boolean isMigrationAware() {
            return true;
        }
    }

    class MRemoveMulti
    extends MBackupAndMigrationAwareOp {
        MRemoveMulti() {
        }

        public Collection remove(String name, Object key) {
            ThreadContext tc = ThreadContext.get();
            TransactionImpl txn = tc.getCallContext().getTransaction();
            if (txn != null && txn.getStatus() == 1) {
                Collection committedValues = null;
                if (!txn.has(name, key)) {
                    MLock mlock = new MLock();
                    boolean locked = mlock.lockAndGetValue(name, key, 30000L);
                    if (!locked) {
                        this.throwTxTimeoutException(key);
                    }
                    committedValues = (Collection)IOUtil.toObject(mlock.oldValue);
                } else {
                    Object value = this.objectCall(ClusterOperation.CONCURRENT_MAP_GET, name, key, null, 0L, -1L);
                    if (value instanceof AddressAwareException) {
                        ConcurrentMapManager.this.rethrowException(this.request.operation, (AddressAwareException)value);
                    }
                    committedValues = (Collection)value;
                }
                ArrayList allValues = new ArrayList();
                int removedValueCount = 1;
                if (committedValues != null) {
                    allValues.addAll(committedValues);
                    removedValueCount = committedValues.size();
                }
                txn.getMulti(name, key, allValues);
                txn.attachRemoveOp(name, key, null, false, removedValueCount);
                return allValues;
            }
            Collection result = (Collection)this.objectCall(ClusterOperation.CONCURRENT_MAP_REMOVE, name, key, null, -1L, -1L);
            if (result != null) {
                this.backup(ClusterOperation.CONCURRENT_MAP_BACKUP_REMOVE);
            }
            return result;
        }

        boolean remove(String name, Object key, Object value) {
            ThreadContext threadContext = ThreadContext.get();
            TransactionImpl txn = threadContext.getCallContext().getTransaction();
            if (txn != null && txn.getStatus() == 1) {
                if (!txn.has(name, key)) {
                    Data oldValue;
                    MLock mlock = new MLock();
                    boolean locked = mlock.lockAndGetValue(name, key, value, 30000L);
                    if (!locked) {
                        this.throwTxTimeoutException(key);
                    }
                    boolean existingRecord = (oldValue = mlock.oldValue) != null;
                    txn.attachRemoveOp(name, key, IOUtil.toData(value), !existingRecord);
                    return existingRecord;
                }
                MContainsKey mContainsKey = new MContainsKey();
                boolean containsEntry = mContainsKey.containsEntry(name, key, value);
                txn.attachRemoveOp(name, key, IOUtil.toData(value), !containsEntry);
                return containsEntry;
            }
            boolean result = this.booleanCall(ClusterOperation.CONCURRENT_MAP_REMOVE_MULTI, name, key, value, -1L, -1L);
            if (result) {
                this.backup(ClusterOperation.CONCURRENT_MAP_BACKUP_REMOVE_MULTI);
            }
            return result;
        }

        protected boolean shouldRedoWhenOwnerDies() {
            return true;
        }
    }

    class MPut
    extends MBackupAndMigrationAwareOp {
        MPut() {
        }

        public boolean replace(String name, Object key, Object oldValue, Object newValue) {
            Object result = this.txnalReplaceIfSame(ClusterOperation.CONCURRENT_MAP_REPLACE_IF_SAME, name, key, newValue, oldValue);
            return result == Boolean.TRUE;
        }

        public Object replace(String name, Object key, Object value) {
            return this.txnalPut(ClusterOperation.CONCURRENT_MAP_REPLACE_IF_NOT_NULL, name, key, value, -1L, -1L);
        }

        public Object putIfAbsent(String name, Object key, Object value, long ttl) {
            return this.txnalPut(ClusterOperation.CONCURRENT_MAP_PUT_IF_ABSENT, name, key, value, -1L, ttl);
        }

        public Object put(String name, Object key, Object value, long ttl) {
            return this.txnalPut(ClusterOperation.CONCURRENT_MAP_PUT, name, key, value, -1L, ttl);
        }

        public Object putAfterCommit(String name, Object key, Object value, long ttl, long txnId) {
            Object result = null;
            if (txnId != -1L) {
                boolean shouldRemove;
                ThreadContext tc = ThreadContext.get();
                Data dataKey = IOUtil.toData(key);
                CMap cmap = ConcurrentMapManager.this.getMap(name);
                LocalLock localLock = (LocalLock)cmap.mapLocalLocks.get(dataKey);
                boolean shouldUnlock = localLock != null && localLock.getThreadId() == tc.getThreadId();
                boolean bl = shouldRemove = shouldUnlock && localLock.getCount() == 1;
                if (shouldRemove) {
                    result = this.txnalPut(ClusterOperation.CONCURRENT_MAP_PUT_AND_UNLOCK, name, key, value, -1L, ttl, txnId);
                    cmap.mapLocalLocks.remove(dataKey, localLock);
                } else if (shouldUnlock) {
                    result = this.txnalPut(ClusterOperation.CONCURRENT_MAP_PUT, name, key, value, -1L, ttl, -1L);
                    localLock.decrementAndGet();
                } else {
                    String error = "Could not commit put operation! Current thread is not owner of transaction lock! Thread-Id: " + tc.getThreadId() + ", LocalLock: " + localLock;
                    ConcurrentMapManager.this.logger.log(Level.WARNING, error);
                    throw new IllegalStateException(error);
                }
            }
            return result;
        }

        public Object putForSync(String name, Object key, Object value) {
            Object result = this.txnalPut(ClusterOperation.CONCURRENT_MAP_SET, name, key, value, -1L, -1L, Long.MIN_VALUE);
            return result == Boolean.TRUE;
        }

        public Object putTransient(String name, Object key, Object value, long ttl) {
            return this.txnalPut(ClusterOperation.CONCURRENT_MAP_PUT_TRANSIENT, name, key, value, -1L, ttl);
        }

        public Object putFromLoad(String name, Object key, Object value) {
            return this.txnalPut(ClusterOperation.CONCURRENT_MAP_PUT_FROM_LOAD, name, key, value, 0L, -1L);
        }

        public boolean set(String name, Object key, Object value, long ttl) {
            Object result = this.txnalPut(ClusterOperation.CONCURRENT_MAP_SET, name, key, value, -1L, ttl);
            return result == Boolean.TRUE;
        }

        public void merge(Record record) {
            if (BaseManager.getInstanceType(record.getName()).isMultiMap()) {
                Collection<ValueHolder> values = record.getMultiValues();
                if (values != null && values.size() > 0) {
                    for (ValueHolder valueHolder : values) {
                        this.mergeOne(record, valueHolder.getData());
                    }
                }
            } else {
                this.mergeOne(record, record.getValueData());
            }
        }

        public void mergeOne(Record record, Data valueData) {
            DataRecordEntry dataRecordEntry = new DataRecordEntry(record, valueData, false);
            this.request.setFromRecord(record);
            this.request.operation = ClusterOperation.CONCURRENT_MAP_MERGE;
            this.request.value = IOUtil.toData(dataRecordEntry);
            this.request.setBooleanRequest();
            this.doOp();
            Boolean returnObject = this.getResultAsBoolean();
            if (returnObject.booleanValue()) {
                this.request.value = valueData;
                this.backup(ClusterOperation.CONCURRENT_MAP_BACKUP_PUT);
            }
        }

        public boolean tryPut(String name, Object key, Object value, long timeout, long ttl) {
            try {
                Object result = this.txnalPut(ClusterOperation.CONCURRENT_MAP_TRY_PUT, name, key, value, timeout, ttl);
                return result == Boolean.TRUE;
            }
            catch (OperationTimeoutException e) {
                return false;
            }
        }

        private Object txnalReplaceIfSame(ClusterOperation operation, String name, Object key, Object newValue, Object expectedValue) {
            ThreadContext threadContext = ThreadContext.get();
            TransactionImpl txn = threadContext.getCallContext().getTransaction();
            if (txn != null && txn.getStatus() == 1) {
                if (!txn.has(name, key)) {
                    MLock mlock = new MLock();
                    boolean locked = mlock.lockAndGetValue(name, key, 30000L);
                    if (!locked) {
                        this.throwTxTimeoutException(key);
                    }
                    Data oldObject = null;
                    Data oldValue = mlock.oldValue;
                    if (oldValue != null) {
                        Data data = oldObject = threadContext.isClient() ? oldValue : threadContext.toObject(oldValue);
                    }
                    if (oldObject == null) {
                        return Boolean.FALSE;
                    }
                    if (expectedValue.equals(oldObject)) {
                        txn.attachPutOp(name, key, IOUtil.toData(newValue), false);
                        return Boolean.TRUE;
                    }
                    return Boolean.FALSE;
                }
                if (expectedValue.equals(IOUtil.toObject(txn.get(name, key)))) {
                    txn.attachPutOp(name, key, IOUtil.toData(newValue), false);
                    return Boolean.TRUE;
                }
                return Boolean.FALSE;
            }
            Data dataExpected = IOUtil.toData(expectedValue);
            Data dataNew = IOUtil.toData(newValue);
            this.setLocal(operation, name, key, new MultiData(dataExpected, dataNew), -1L, -1L);
            this.request.longValue = this.request.value == null ? Integer.MIN_VALUE : (long)dataNew.hashCode();
            ConcurrentMapManager.this.setIndexValues(this.request, newValue);
            this.request.setBooleanRequest();
            this.doOp();
            Boolean returnObject = this.getResultAsBoolean();
            if (!Boolean.FALSE.equals(returnObject)) {
                this.request.value = dataNew;
                this.backup(ClusterOperation.CONCURRENT_MAP_BACKUP_PUT);
            }
            return returnObject;
        }

        Object txnalPut(ClusterOperation operation, String name, Object key, Object value, long timeout, long ttl) {
            return this.txnalPut(operation, name, key, value, timeout, ttl, -1L);
        }

        Object txnalPut(ClusterOperation operation, String name, Object key, Object value, long timeout, long ttl, long txnId) {
            ThreadContext threadContext = ThreadContext.get();
            TransactionImpl txn = threadContext.getTransaction();
            SystemLogService css = ConcurrentMapManager.this.node.getSystemLogService();
            if (css.shouldLog(SystemLogService.Level.INFO)) {
                css.logObject(this, SystemLogService.Level.INFO, (Object)operation);
            }
            if (txn != null && txn.getStatus() == 1) {
                Data existingValue;
                if (!txn.has(name, key)) {
                    MLock mlock = new MLock();
                    boolean locked = mlock.lockAndGetValue(name, key, 30000L);
                    if (!locked) {
                        this.throwTxTimeoutException(key);
                    }
                    Data oldObject = null;
                    Data oldValue = mlock.oldValue;
                    if (oldValue != null) {
                        Data data = oldObject = threadContext.isClient() ? oldValue : threadContext.toObject(oldValue);
                    }
                    if (operation == ClusterOperation.CONCURRENT_MAP_PUT_IF_ABSENT && oldObject != null) {
                        txn.attachPutOp(name, key, oldValue, 0, ttl, false);
                    } else {
                        txn.attachPutOp(name, key, IOUtil.toData(value), 0, ttl, oldObject == null);
                    }
                    if (operation == ClusterOperation.CONCURRENT_MAP_TRY_PUT) {
                        return Boolean.TRUE;
                    }
                    return oldObject;
                }
                if (operation == ClusterOperation.CONCURRENT_MAP_PUT_IF_ABSENT && (existingValue = txn.get(name, key)) != null) {
                    return threadContext.isClient() ? existingValue : threadContext.toObject(existingValue);
                }
                Data resultData = txn.attachPutOp(name, key, IOUtil.toData(value), false);
                if (operation == ClusterOperation.CONCURRENT_MAP_TRY_PUT) {
                    return Boolean.TRUE;
                }
                return threadContext.isClient() ? resultData : threadContext.toObject(resultData);
            }
            this.setLocal(operation, name, key, value, timeout, ttl);
            this.request.txnId = txnId;
            ConcurrentMapManager.this.setIndexValues(this.request, value);
            if (operation == ClusterOperation.CONCURRENT_MAP_TRY_PUT || operation == ClusterOperation.CONCURRENT_MAP_SET || operation == ClusterOperation.CONCURRENT_MAP_PUT_AND_UNLOCK || operation == ClusterOperation.CONCURRENT_MAP_PUT_FROM_LOAD || operation == ClusterOperation.CONCURRENT_MAP_PUT_TRANSIENT) {
                this.request.setBooleanRequest();
                Data valueData = this.request.value;
                this.doOp();
                Boolean successful = this.getResultAsBoolean();
                if (successful.booleanValue()) {
                    this.request.value = valueData;
                    if (operation == ClusterOperation.CONCURRENT_MAP_PUT_AND_UNLOCK) {
                        this.backup(ClusterOperation.CONCURRENT_MAP_BACKUP_PUT_AND_UNLOCK);
                    } else {
                        this.backup(ClusterOperation.CONCURRENT_MAP_BACKUP_PUT);
                    }
                }
                return successful;
            }
            this.request.setObjectRequest();
            if (css.shouldLog(SystemLogService.Level.TRACE)) {
                css.logObject(this, SystemLogService.Level.TRACE, "Calling doOp");
            }
            this.doOp();
            if (css.shouldLog(SystemLogService.Level.TRACE)) {
                css.logObject(this, SystemLogService.Level.TRACE, "Done doOp");
            }
            Object returnObject = this.getResultAsObject();
            if (css.shouldLog(SystemLogService.Level.INFO)) {
                css.logObject(this, SystemLogService.Level.INFO, returnObject);
            }
            if (operation == ClusterOperation.CONCURRENT_MAP_REPLACE_IF_NOT_NULL && returnObject == null) {
                return null;
            }
            if (returnObject instanceof AddressAwareException) {
                ConcurrentMapManager.this.rethrowException(operation, (AddressAwareException)returnObject);
            }
            this.request.longValue = Long.MIN_VALUE;
            this.backup(ClusterOperation.CONCURRENT_MAP_BACKUP_PUT);
            if (css.shouldLog(SystemLogService.Level.TRACE)) {
                css.logObject(this, SystemLogService.Level.TRACE, "Backups completed returning result");
            }
            return returnObject;
        }

        protected final boolean canTimeout() {
            switch (this.request.operation) {
                case CONCURRENT_MAP_PUT_AND_UNLOCK: 
                case CONCURRENT_MAP_BACKUP_PUT_AND_UNLOCK: {
                    return false;
                }
            }
            return true;
        }

        protected boolean shouldRedoWhenOwnerDies() {
            return true;
        }
    }

    class MSemaphore
    extends MDefaultBackupAndMigrationAwareOp {
        SemaphoreOperationsCounter operationsCounter;
        long begin;

        MSemaphore() {
        }

        public void attachDetach(Data name, int permitsDelta) {
            this.doSemaphoreOp(ClusterOperation.SEMAPHORE_ATTACH_DETACH_PERMITS, name, permitsDelta, null, -1L);
            this.operationsCounter.incrementNonAcquires(Clock.currentTimeMillis() - this.begin, permitsDelta);
        }

        public boolean cancelAcquire(Data name) {
            this.setLocal(ClusterOperation.SEMAPHORE_CANCEL_ACQUIRE, "c:__hz_SemaphoreMap", name, null, -1L, -1L);
            this.doOp();
            this.getResult();
            return this.request.longValue == 1L;
        }

        public int drainPermits(Data name) {
            int drainedPermits = this.doSemaphoreOp(ClusterOperation.SEMAPHORE_DRAIN_PERMITS, name, -1L, null, -1L);
            this.operationsCounter.incrementNonAcquires(Clock.currentTimeMillis() - this.begin, 0);
            return drainedPermits;
        }

        public int getAvailable(Data name) {
            int availablePermits = this.doSemaphoreOp(ClusterOperation.SEMAPHORE_GET_AVAILABLE_PERMITS, name, -1L, null, -1L);
            this.operationsCounter.incrementNonAcquires(Clock.currentTimeMillis() - this.begin, 0);
            return availablePermits;
        }

        public int getAttached(Data name) {
            int attachedPermits = this.doSemaphoreOp(ClusterOperation.SEMAPHORE_GET_ATTACHED_PERMITS, name, -1L, false, -1L);
            this.operationsCounter.incrementNonAcquires(Clock.currentTimeMillis() - this.begin, 0);
            return attachedPermits;
        }

        public void reduce(Data name, int permits) {
            this.doSemaphoreOp(ClusterOperation.SEMAPHORE_REDUCE_PERMITS, name, permits, null, -1L);
            this.operationsCounter.incrementPermitsReduced(Clock.currentTimeMillis() - this.begin, 0);
        }

        public void release(Data name, int permits, Boolean detach) {
            this.doSemaphoreOp(ClusterOperation.SEMAPHORE_RELEASE, name, permits, detach, -1L);
            this.operationsCounter.incrementReleases(Clock.currentTimeMillis() - this.begin, permits, detach);
        }

        public boolean tryAcquire(Data name, int permits, boolean attach, long timeout) throws InstanceDestroyedException {
            try {
                int acquireResult = this.doSemaphoreOp(ClusterOperation.SEMAPHORE_TRY_ACQUIRE, name, permits, attach, timeout);
                switch (acquireResult) {
                    case 2: {
                        this.operationsCounter.incrementRejectedAcquires(Clock.currentTimeMillis() - this.begin);
                        throw new InstanceDestroyedException(Instance.InstanceType.SEMAPHORE, (String)IOUtil.toObject(name));
                    }
                    case 0: {
                        this.operationsCounter.incrementAcquires(Clock.currentTimeMillis() - this.begin, permits, attach);
                        return true;
                    }
                }
                this.operationsCounter.incrementRejectedAcquires(Clock.currentTimeMillis() - this.begin);
                return false;
            }
            catch (RuntimeInterruptedException e) {
                this.operationsCounter.incrementRejectedAcquires(Clock.currentTimeMillis() - this.begin);
                throw e;
            }
        }

        public void destroy(Data name) {
            this.doSemaphoreOp(ClusterOperation.SEMAPHORE_DESTROY, name, -1L, null, -1L);
            new MRemove().remove("c:__hz_SemaphoreMap", name);
        }

        void setOperationsCounter(SemaphoreOperationsCounter operationsCounter) {
            this.operationsCounter = operationsCounter;
        }

        private int doSemaphoreOp(ClusterOperation op, Data name, long longValue, Object value, long timeout) {
            this.begin = Clock.currentTimeMillis();
            int responseValue = 1;
            if (longValue != 0L) {
                this.setLocal(op, "c:__hz_SemaphoreMap", name, value, timeout, -1L);
                this.request.longValue = longValue;
                this.doOp();
                Data backup = (Data)this.getResultAsIs();
                responseValue = (int)this.request.longValue;
                if (backup != null) {
                    this.request.value = backup;
                    this.request.longValue = 0L;
                    this.backup(ClusterOperation.CONCURRENT_MAP_BACKUP_PUT);
                    this.operationsCounter.incrementModified(Clock.currentTimeMillis() - this.begin);
                } else {
                    this.operationsCounter.incrementNonModified(Clock.currentTimeMillis() - this.begin);
                }
            }
            return responseValue;
        }

        protected boolean isInterruptible() {
            return false;
        }

        protected boolean canTimeout() {
            return false;
        }
    }

    class MCountDownLatch
    extends MDefaultBackupAndMigrationAwareOp {
        CountDownLatchOperationsCounter operationsCounter;
        long begin;

        MCountDownLatch() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean await(Data name, long timeout, TimeUnit unit) throws InstanceDestroyedException, MemberLeftException {
            try {
                int awaitResult = this.doCountDownLatchOp(ClusterOperation.COUNT_DOWN_LATCH_AWAIT, name, 0, unit.toMillis(timeout));
                switch (awaitResult) {
                    case 2: {
                        throw new InstanceDestroyedException(Instance.InstanceType.COUNT_DOWN_LATCH, (String)IOUtil.toObject(name));
                    }
                    case 3: {
                        MemberImpl owner = new MemberImpl(this.request.lockAddress, ConcurrentMapManager.this.thisAddress.equals(this.request.lockAddress));
                        throw new MemberLeftException(owner);
                    }
                    case 0: {
                        boolean bl = true;
                        return bl;
                    }
                }
                boolean bl = false;
                return bl;
            }
            finally {
                this.operationsCounter.incrementAwait(Clock.currentTimeMillis() - this.begin);
            }
        }

        public boolean countDown(Data name) {
            int threadsReleased = this.doCountDownLatchOp(ClusterOperation.COUNT_DOWN_LATCH_COUNT_DOWN, name, 0, -1L);
            this.operationsCounter.incrementCountDown(Clock.currentTimeMillis() - this.begin, threadsReleased);
            return threadsReleased > 0;
        }

        public int getCount(Data name) {
            int count = this.doCountDownLatchOp(ClusterOperation.COUNT_DOWN_LATCH_GET_COUNT, name, 0, -1L);
            this.operationsCounter.incrementOther(Clock.currentTimeMillis() - this.begin);
            return count;
        }

        public Address getOwnerAddress(Data name) {
            this.begin = Clock.currentTimeMillis();
            this.setLocal(ClusterOperation.COUNT_DOWN_LATCH_GET_OWNER, "c:__hz_CountDownLatchMap", name, null, 0L, -1L);
            this.doOp();
            return (Address)this.getResultAsObject(false);
        }

        public boolean setCount(Data name, int count, Address ownerAddress) {
            int countSet = this.doCountDownLatchOp(ClusterOperation.COUNT_DOWN_LATCH_SET_COUNT, name, count, -1L, ownerAddress);
            this.operationsCounter.incrementOther(Clock.currentTimeMillis() - this.begin);
            return countSet == 1;
        }

        public void destroy(Data name) {
            this.doCountDownLatchOp(ClusterOperation.COUNT_DOWN_LATCH_DESTROY, name, 0, -1L);
        }

        void setOperationsCounter(CountDownLatchOperationsCounter operationsCounter) {
            this.operationsCounter = operationsCounter;
        }

        private int doCountDownLatchOp(ClusterOperation op, Data name, int value, long timeout) {
            return this.doCountDownLatchOp(op, name, value, timeout, ConcurrentMapManager.this.thisAddress);
        }

        private int doCountDownLatchOp(ClusterOperation op, Data name, int value, long timeout, Address endPoint) {
            this.begin = Clock.currentTimeMillis();
            this.setLocal(op, "c:__hz_CountDownLatchMap", name, null, timeout, -1L);
            this.request.longValue = value;
            this.request.lockAddress = endPoint;
            this.doOp();
            Data backup = (Data)this.getResultAsIs();
            int responseValue = (int)this.request.longValue;
            if (backup != null) {
                this.request.value = backup;
                this.request.longValue = 0L;
                this.backup(ClusterOperation.CONCURRENT_MAP_BACKUP_PUT);
            }
            return responseValue;
        }

        protected boolean isInterruptible() {
            return false;
        }

        protected boolean canTimeout() {
            return false;
        }
    }

    class MAtomicNumber
    extends MDefaultBackupAndMigrationAwareOp {
        AtomicNumberOperationsCounter operationsCounter;

        MAtomicNumber() {
        }

        public long addAndGet(Data name, long delta) {
            return this.doAtomicOp(ClusterOperation.ATOMIC_NUMBER_ADD_AND_GET, name, delta, null);
        }

        public boolean compareAndSet(Data name, long expectedValue, long newValue) {
            return this.doAtomicOp(ClusterOperation.ATOMIC_NUMBER_COMPARE_AND_SET, name, newValue, IOUtil.toData(expectedValue)) == 1L;
        }

        public long getAndAdd(Data name, long delta) {
            return this.doAtomicOp(ClusterOperation.ATOMIC_NUMBER_GET_AND_ADD, name, delta, null);
        }

        public long getAndSet(Data name, long newValue) {
            return this.doAtomicOp(ClusterOperation.ATOMIC_NUMBER_GET_AND_SET, name, newValue, null);
        }

        public void destroy(Data name) {
            new MRemove().remove("c:__hz_AtomicLongMap", name);
        }

        void setOperationsCounter(AtomicNumberOperationsCounter operationsCounter) {
            this.operationsCounter = operationsCounter;
        }

        private long doAtomicOp(ClusterOperation op, Data name, long value, Data expected) {
            long begin = Clock.currentTimeMillis();
            this.setLocal(op, "c:__hz_AtomicLongMap", name, expected, 0L, 0L);
            this.request.longValue = value;
            this.doOp();
            Data backup = (Data)this.getResultAsIs();
            long responseValue = this.request.longValue;
            if (backup != null) {
                this.request.value = backup;
                this.request.longValue = 0L;
                this.backup(ClusterOperation.CONCURRENT_MAP_BACKUP_PUT);
                this.operationsCounter.incrementModified(Clock.currentTimeMillis() - begin);
            } else {
                this.operationsCounter.incrementNonModified(Clock.currentTimeMillis() - begin);
            }
            return responseValue;
        }
    }

    class MPutMulti
    extends MBackupAndMigrationAwareOp {
        MPutMulti() {
        }

        boolean put(String name, Object key, Object value) {
            ThreadContext threadContext = ThreadContext.get();
            TransactionImpl txn = threadContext.getCallContext().getTransaction();
            if (txn != null && txn.getStatus() == 1) {
                MLock mlock;
                boolean locked;
                if (!txn.has(name, key) && !(locked = (mlock = new MLock()).lock(name, key, 30000L))) {
                    this.throwTxTimeoutException(key);
                }
                if (txn.has(name, key, value)) {
                    return false;
                }
                txn.attachPutMultiOp(name, key, IOUtil.toData(value));
                return true;
            }
            boolean result = this.booleanCall(ClusterOperation.CONCURRENT_MAP_PUT_MULTI, name, key, value, -1L, -1L);
            if (result) {
                this.backup(ClusterOperation.CONCURRENT_MAP_BACKUP_PUT);
            }
            return result;
        }

        protected boolean shouldRedoWhenOwnerDies() {
            return true;
        }
    }

    class MMultiGet
    extends MTargetAwareOp {
        MMultiGet() {
        }

        public Collection get(String name, Object key) {
            ThreadContext tc = ThreadContext.get();
            TransactionImpl txn = tc.getCallContext().getTransaction();
            Object value = this.objectCall(ClusterOperation.CONCURRENT_MAP_GET, name, key, null, 0L, -1L);
            if (value instanceof AddressAwareException) {
                ConcurrentMapManager.this.rethrowException(this.request.operation, (AddressAwareException)value);
            }
            Set currentValues = (Set)value;
            if (txn != null && txn.getStatus() == 1) {
                ArrayList allValues = new ArrayList();
                if (currentValues != null) {
                    allValues.addAll(currentValues);
                }
                txn.getMulti(name, key, allValues);
                return allValues;
            }
            return currentValues != null ? currentValues : Collections.emptySet();
        }

        public boolean isMigrationAware() {
            return true;
        }

        protected boolean isInterruptible() {
            return true;
        }
    }

    class MRemove
    extends MBackupAndMigrationAwareOp {
        MRemove() {
        }

        public Object remove(String name, Object key) {
            return this.txnalRemove(ClusterOperation.CONCURRENT_MAP_REMOVE, name, key, null, -1L, -1L);
        }

        public boolean removeIfSame(String name, Object key, Object value) {
            return this.txnalRemove(ClusterOperation.CONCURRENT_MAP_REMOVE_IF_SAME, name, key, value, -1L, -1L) == Boolean.TRUE;
        }

        public Object tryRemove(String name, Object key, long timeout) throws TimeoutException {
            try {
                return this.txnalRemove(ClusterOperation.CONCURRENT_MAP_REMOVE, name, key, null, timeout, -1L);
            }
            catch (OperationTimeoutException e) {
                throw new TimeoutException(e.getMessage());
            }
        }

        public void removeForSync(String name, Object key) {
            this.txnalRemove(ClusterOperation.CONCURRENT_MAP_REMOVE, name, key, null, -1L, Long.MIN_VALUE);
        }

        private Object txnalRemove(ClusterOperation operation, String name, Object key, Object value, long timeout, long txnId) {
            ThreadContext threadContext = ThreadContext.get();
            TransactionImpl txn = threadContext.getCallContext().getTransaction();
            if (txn != null && txn.getStatus() == 1) {
                if (!txn.has(name, key)) {
                    MLock mlock = new MLock();
                    boolean locked = mlock.lockAndGetValue(name, key, 30000L);
                    if (!locked) {
                        this.throwTxTimeoutException(key);
                    }
                    Data oldObject = null;
                    Data oldValue = mlock.oldValue;
                    if (oldValue != null) {
                        oldObject = threadContext.isClient() ? oldValue : threadContext.toObject(oldValue);
                    }
                    int removedValueCount = 0;
                    if (oldObject != null) {
                        if (oldObject instanceof DistributedTimeoutException) {
                            return oldObject;
                        }
                        if (oldObject instanceof Values) {
                            Values values = (Values)((Object)oldObject);
                            removedValueCount = values.size();
                        } else {
                            removedValueCount = 1;
                        }
                    }
                    txn.attachRemoveOp(name, key, IOUtil.toData(value), oldObject == null, removedValueCount);
                    return oldObject;
                }
                Data oldValue = txn.attachRemoveOp(name, key, IOUtil.toData(value), false);
                Data oldObject = threadContext.isClient() ? oldValue : threadContext.toObject(oldValue);
                return oldObject;
            }
            this.setLocal(operation, name, key, value, timeout, -1L);
            if (txnId != -1L) {
                this.request.txnId = txnId;
            }
            if (operation == ClusterOperation.CONCURRENT_MAP_REMOVE) {
                this.request.setObjectRequest();
                this.doOp();
                Object oldValue = this.getResultAsObject();
                if (oldValue != null) {
                    if (oldValue instanceof AddressAwareException) {
                        ConcurrentMapManager.this.rethrowException(operation, (AddressAwareException)oldValue);
                    }
                    if (!(oldValue instanceof DistributedTimeoutException)) {
                        this.backup(ClusterOperation.CONCURRENT_MAP_BACKUP_REMOVE);
                    }
                }
                return oldValue;
            }
            this.request.setBooleanRequest();
            this.doOp();
            boolean success = this.getResultAsBoolean();
            if (success) {
                this.backup(ClusterOperation.CONCURRENT_MAP_BACKUP_REMOVE);
            }
            return success;
        }

        public final void handleNoneRedoResponse(Packet packet) {
            NearCache nearCache = (NearCache)ConcurrentMapManager.this.mapCaches.get(this.request.name);
            if (nearCache != null) {
                nearCache.invalidate(this.request.key);
            }
            super.handleNoneRedoResponse(packet);
        }

        protected boolean shouldRedoWhenOwnerDies() {
            return true;
        }
    }

    class MRemoveItem
    extends MBackupAndMigrationAwareOp {
        MRemoveItem() {
        }

        public boolean removeItem(String name, Object key) {
            return this.removeItem(name, key, null);
        }

        public boolean removeItem(String name, Object key, Object value) {
            ThreadContext threadContext = ThreadContext.get();
            TransactionImpl txn = threadContext.getCallContext().getTransaction();
            if (txn != null && txn.getStatus() == 1) {
                try {
                    if (!txn.has(name, key)) {
                        MLock mlock = new MLock();
                        boolean locked = mlock.lockAndGetValue(name, key, 30000L);
                        if (!locked) {
                            this.throwTxTimeoutException(key);
                        }
                        Data oldObject = null;
                        Data oldValue = mlock.oldValue;
                        if (oldValue != null) {
                            oldObject = threadContext.isClient() ? oldValue : threadContext.toObject(oldValue);
                        }
                        txn.attachRemoveOp(name, key, null, oldObject == null);
                        return oldObject != null;
                    }
                    return txn.attachRemoveOp(name, key, null, false) != null;
                }
                catch (Exception e1) {
                    ConcurrentMapManager.this.logger.log(Level.WARNING, e1.getMessage(), e1);
                    return false;
                }
            }
            boolean removed = this.booleanCall(ClusterOperation.CONCURRENT_MAP_REMOVE_ITEM, name, key, value, 0L, -1L);
            if (removed) {
                this.backup(ClusterOperation.CONCURRENT_MAP_BACKUP_REMOVE);
            }
            return removed;
        }

        protected boolean shouldRedoWhenOwnerDies() {
            return true;
        }
    }

    class MValueCount
    extends MTargetAwareOp {
        MValueCount() {
        }

        public Object count(String name, Object key, long timeout) {
            this.request.setLongRequest();
            return this.objectCall(ClusterOperation.CONCURRENT_MAP_VALUE_COUNT, name, key, null, timeout, -1L);
        }

        public boolean isMigrationAware() {
            return true;
        }

        protected boolean isInterruptible() {
            return true;
        }
    }

    class MGet
    extends MTargetAwareOp {
        Object keyObject = null;

        MGet() {
        }

        public Object get(String name, Object key, long timeout) {
            Object value;
            this.keyObject = key;
            ThreadContext tc = ThreadContext.get();
            TransactionImpl txn = tc.getCallContext().getTransaction();
            if (txn != null && txn.getStatus() == 1) {
                if (txn.has(name, key)) {
                    Data value2 = txn.get(name, key);
                    return tc.isClient() ? value2 : IOUtil.toObject(value2);
                }
                MLock mlock = new MLock();
                boolean locked = mlock.lockAndGetValue(name, key, 30000L);
                if (!locked) {
                    this.throwTxTimeoutException(key);
                }
                Data oldObject = null;
                Data oldValue = mlock.oldValue;
                if (oldValue != null) {
                    oldObject = tc.isClient() ? oldValue : tc.toObject(oldValue);
                    txn.attachPutOp(name, key, oldValue, false);
                } else {
                    txn.attachPutOp(name, key, null, false);
                }
                return oldObject;
            }
            CMap cMap = (CMap)ConcurrentMapManager.this.maps.get(name);
            Data dataKey = null;
            if (cMap != null) {
                Data valueData;
                Record record;
                Object value3;
                cMap.incrementGetCount();
                NearCache nearCache = cMap.nearCache;
                if (nearCache != null && (value3 = nearCache.get(key)) != null) {
                    return value3;
                }
                dataKey = IOUtil.toData(key);
                Record ownedRecord = cMap.getOwnedRecord(dataKey);
                if (ownedRecord != null && ownedRecord.isActive() && ownedRecord.isValid()) {
                    long version = ownedRecord.getVersion();
                    Object result = null;
                    if (tc.isClient()) {
                        Data valueData2 = ownedRecord.getValueData();
                        if (valueData2 != null && valueData2.size() > 0) {
                            result = valueData2;
                        }
                    } else {
                        Object value4 = ownedRecord.getValue();
                        if (value4 != null) {
                            result = value4;
                        }
                    }
                    if (result != null && ownedRecord.getVersion() == version) {
                        ownedRecord.setLastAccessed();
                        return result;
                    }
                }
                if (cMap.isReadBackupData() && (record = (Record)cMap.mapRecords.get(dataKey)) != null && record.isActive() && record.isValid() && (valueData = record.getValueData()) != null && valueData.size() > 0) {
                    return tc.isClient() ? valueData : IOUtil.toObject(valueData);
                }
            }
            if (dataKey == null) {
                dataKey = IOUtil.toData(key);
            }
            if ((value = this.objectCall(ClusterOperation.CONCURRENT_MAP_GET, name, dataKey, null, timeout, -1L)) instanceof AddressAwareException) {
                ConcurrentMapManager.this.rethrowException(this.request.operation, (AddressAwareException)value);
            }
            return value;
        }

        public void reset() {
            this.keyObject = null;
            super.reset();
        }

        public final void handleNoneRedoResponse(Packet packet) {
            Data value;
            NearCache nearCache;
            CMap cMap = (CMap)ConcurrentMapManager.this.maps.get(this.request.name);
            if (cMap != null && (nearCache = cMap.nearCache) != null && (value = packet.getValueData()) != null && value.size() > 0) {
                nearCache.put(this.keyObject, this.request.key, packet.getValueData());
            }
            super.handleNoneRedoResponse(packet);
        }

        public boolean isMigrationAware() {
            return true;
        }

        protected boolean isInterruptible() {
            return true;
        }
    }

    class MAddKeyListener
    extends MTargetAwareOp {
        MAddKeyListener() {
        }

        public boolean addListener(String name, boolean add, Object key, boolean includeValue) {
            ClusterOperation operation = add ? ClusterOperation.ADD_LISTENER : ClusterOperation.REMOVE_LISTENER;
            this.setLocal(operation, name, key, null, -1L, -1L);
            this.request.longValue = includeValue ? 1L : 0L;
            this.request.setBooleanRequest();
            this.doOp();
            return this.getResultAsBoolean();
        }

        public boolean isMigrationAware() {
            return true;
        }
    }

    class MGetDataRecordEntry
    extends MTargetAwareOp {
        MGetDataRecordEntry() {
        }

        public DataRecordEntry get(String name, Object key) {
            Object result = this.objectCall(ClusterOperation.CONCURRENT_MAP_GET_DATA_RECORD_ENTRY, name, key, null, 0L, -1L);
            if (result instanceof Data) {
                result = IOUtil.toObject((Data)result);
            }
            return (DataRecordEntry)result;
        }
    }

    class MGetMapEntry
    extends MTargetAwareOp {
        MGetMapEntry() {
        }

        public MapEntry get(String name, Object key) {
            CMap.CMapEntry mapEntry;
            Object result = this.objectCall(ClusterOperation.CONCURRENT_MAP_GET_MAP_ENTRY, name, key, null, 0L, -1L);
            if (result instanceof Data) {
                result = IOUtil.toObject((Data)result);
            }
            if ((mapEntry = (CMap.CMapEntry)result) != null) {
                mapEntry.setHazelcastInstance(ConcurrentMapManager.this.node.factory);
                mapEntry.set(name, key);
            }
            return mapEntry;
        }

        protected boolean isInterruptible() {
            return true;
        }
    }

    class MEvict
    extends MBackupAndMigrationAwareOp {
        MEvict() {
        }

        public boolean evict(String name, Object key) {
            try {
                return this.evict(ClusterOperation.CONCURRENT_MAP_EVICT, name, key);
            }
            catch (OperationTimeoutException e) {
                return false;
            }
        }

        private boolean evict(ClusterOperation operation, String name, Object key) {
            Data k = key instanceof Data ? (Data)key : IOUtil.toData(key);
            this.request.setLocal(operation, name, k, null, 0, ConcurrentMapManager.this.maxOperationTimeout, -1L, ConcurrentMapManager.this.thisAddress);
            this.request.setBooleanRequest();
            this.doOp();
            boolean result = this.getResultAsBoolean();
            if (result) {
                this.backup(ClusterOperation.CONCURRENT_MAP_BACKUP_REMOVE);
            }
            return result;
        }

        public final void handleNoneRedoResponse(Packet packet) {
            NearCache nearCache = (NearCache)ConcurrentMapManager.this.mapCaches.get(this.request.name);
            if (nearCache != null) {
                nearCache.invalidate(this.request.key);
            }
            super.handleNoneRedoResponse(packet);
        }
    }

    class MContainsKey
    extends MTargetAwareOp {
        Object keyObject = null;
        NearCache nearCache = null;

        MContainsKey() {
        }

        public boolean containsEntry(String name, Object key, Object value) {
            return this.booleanCall(ClusterOperation.CONCURRENT_MAP_CONTAINS_ENTRY, name, key, value, 0L, -1L);
        }

        public boolean containsKey(String name, Object key) {
            Record record;
            this.keyObject = key;
            this.nearCache = (NearCache)ConcurrentMapManager.this.mapCaches.get(name);
            Data dataKey = IOUtil.toData(key);
            if (this.nearCache != null && this.nearCache.containsKey(key)) {
                return true;
            }
            CMap cMap = (CMap)ConcurrentMapManager.this.maps.get(name);
            if (cMap != null && (record = cMap.getOwnedRecord(dataKey)) != null && record.isActive() && record.isValid() && record.hasValueData()) {
                if (cMap.isReadBackupData()) {
                    return true;
                }
                PartitionServiceImpl.PartitionProxy partition = ConcurrentMapManager.this.partitionServiceImpl.getPartition(record.getBlockId());
                if (partition != null && !ConcurrentMapManager.this.partitionManager.isOwnedPartitionMigrating(partition.getPartitionId()) && partition.getOwner() != null && partition.getOwner().localMember()) {
                    return true;
                }
            }
            return this.booleanCall(ClusterOperation.CONCURRENT_MAP_CONTAINS_KEY, name, dataKey, null, 0L, -1L);
        }

        public void reset() {
            this.keyObject = null;
            this.nearCache = null;
            super.reset();
        }

        protected void setResult(Object obj) {
            if (obj != null && obj == Boolean.TRUE && this.nearCache != null) {
                this.nearCache.setContainsKey(this.keyObject, this.request.key);
            }
            super.setResult(obj);
        }

        public boolean isMigrationAware() {
            return true;
        }

        protected boolean isInterruptible() {
            return true;
        }
    }

    class MLock
    extends MBackupAndMigrationAwareOp {
        volatile Data oldValue = null;

        MLock() {
        }

        public boolean unlock(String name, Object key, long timeout) {
            Data dataKey = IOUtil.toData(key);
            ThreadContext tc = ThreadContext.get();
            CMap cmap = ConcurrentMapManager.this.getMap(name);
            if (cmap == null) {
                return false;
            }
            LocalLock localLock = (LocalLock)cmap.mapLocalLocks.get(dataKey);
            if (localLock != null && localLock.getThreadId() == tc.getThreadId()) {
                if (localLock.decrementAndGet() > 0) {
                    return true;
                }
                boolean unlocked = this.booleanCall(ClusterOperation.CONCURRENT_MAP_UNLOCK, name, dataKey, null, timeout, -1L);
                cmap.mapLocalLocks.remove(dataKey, localLock);
                if (unlocked) {
                    this.request.lockAddress = null;
                    this.request.lockCount = 0;
                    this.backup(ClusterOperation.CONCURRENT_MAP_BACKUP_LOCK);
                }
                return unlocked;
            }
            return false;
        }

        public boolean forceUnlock(String name, Object key) {
            Data dataKey = IOUtil.toData(key);
            boolean unlocked = this.booleanCall(ClusterOperation.CONCURRENT_MAP_FORCE_UNLOCK, name, dataKey, null, 0L, -1L);
            if (unlocked) {
                this.backup(ClusterOperation.CONCURRENT_MAP_BACKUP_LOCK);
            }
            return unlocked;
        }

        public boolean lock(String name, Object key, long timeout) {
            return this.lock(ClusterOperation.CONCURRENT_MAP_LOCK, name, key, null, timeout);
        }

        public boolean lockAndGetValue(String name, Object key, long timeout) {
            return this.lock(ClusterOperation.CONCURRENT_MAP_TRY_LOCK_AND_GET, name, key, null, timeout);
        }

        public boolean lockAndGetValue(String name, Object key, Object value, long timeout) {
            return this.lock(ClusterOperation.CONCURRENT_MAP_TRY_LOCK_AND_GET, name, key, value, timeout);
        }

        public boolean lock(ClusterOperation op, String name, Object key, Object value, long timeout) {
            LocalLock localLock;
            Data dataKey = IOUtil.toData(key);
            ThreadContext tc = ThreadContext.get();
            this.setLocal(op, name, dataKey, value, timeout, -1L);
            this.request.setLongRequest();
            this.doOp();
            long result = (Long)this.getResultAsObject();
            if (result == -1L) {
                return false;
            }
            CMap cmap = ConcurrentMapManager.this.getMap(name);
            if (result == 0L) {
                cmap.mapLocalLocks.remove(dataKey);
            }
            if ((localLock = (LocalLock)cmap.mapLocalLocks.get(dataKey)) == null || localLock.getThreadId() != tc.getThreadId()) {
                localLock = new LocalLock(tc.getThreadId());
                cmap.mapLocalLocks.put(dataKey, localLock);
            }
            if (localLock.incrementAndGet() == 1) {
                this.backup(ClusterOperation.CONCURRENT_MAP_BACKUP_LOCK);
            }
            return true;
        }

        public boolean isLocked(String name, Object key) {
            LocalLock localLock;
            Data dataKey = IOUtil.toData(key);
            CMap cmap = ConcurrentMapManager.this.getMap(name);
            if (cmap != null && (localLock = (LocalLock)cmap.mapLocalLocks.get(dataKey)) != null && localLock.getCount() > 0) {
                return true;
            }
            this.setLocal(ClusterOperation.CONCURRENT_MAP_IS_KEY_LOCKED, name, dataKey, null, -1L, -1L);
            this.request.setBooleanRequest();
            this.doOp();
            return (Boolean)this.getResultAsObject();
        }

        public void afterGettingResult(Request request) {
            if (request.operation == ClusterOperation.CONCURRENT_MAP_TRY_LOCK_AND_GET && this.oldValue == null) {
                this.oldValue = request.value;
            }
            super.afterGettingResult(request);
        }

        public void handleNoneRedoResponse(Packet packet) {
            if (this.request.operation == ClusterOperation.CONCURRENT_MAP_TRY_LOCK_AND_GET) {
                this.oldValue = packet.getValueData();
                this.request.value = packet.getValueData();
            }
            super.handleNoneRedoResponse(packet);
        }

        protected final void handleInterruption() {
            ConcurrentMapManager.this.logger.log(Level.WARNING, Thread.currentThread().getName() + " is interrupted! " + "Hazelcast intentionally suppresses interruption during lock operations " + "to avoid dead-lock conditions. Operation: " + (Object)((Object)this.request.operation));
        }

        protected final boolean isInterruptible() {
            return false;
        }

        protected final boolean canTimeout() {
            return false;
        }
    }
}

