/*
 * Decompiled with CFR 0.152.
 */
package org.dataone.configuration;

import java.io.IOException;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.Enumeration;
import org.apache.commons.configuration.AbstractConfiguration;
import org.apache.commons.configuration.CompositeConfiguration;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.DefaultConfigurationBuilder;
import org.apache.commons.configuration.PropertiesConfiguration;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class Settings {
    private static Log log = LogFactory.getLog(Settings.class);
    private static CompositeConfiguration configuration = null;
    public static String STD_CONFIG_PATH = "org/dataone/configuration";

    private Settings() {
    }

    public static Configuration getConfiguration() {
        if (configuration == null) {
            configuration = new CompositeConfiguration();
            try {
                configuration = Settings.loadTestConfigurations(configuration);
            }
            catch (ConfigurationException e1) {
                return new CompositeConfiguration();
            }
            String configResourceName = STD_CONFIG_PATH + "/config.xml";
            Enumeration<URL> configURLs = null;
            try {
                configURLs = Settings.class.getClassLoader().getResources(configResourceName);
                while (configURLs.hasMoreElements()) {
                    URL configURL = configURLs.nextElement();
                    log.debug("Loading configuration: " + configURL);
                    DefaultConfigurationBuilder factory = new DefaultConfigurationBuilder();
                    factory.setURL(configURL);
                    Configuration config = null;
                    try {
                        config = factory.getConfiguration();
                        configuration.addConfiguration(config);
                    }
                    catch (ConfigurationException e) {
                        log.error("Problem loading configuration: " + configURL, e);
                    }
                }
            }
            catch (IOException e) {
                log.error("No configuration resources found for: " + configResourceName, e);
            }
        }
        return configuration;
    }

    public static Configuration getResetConfiguration() {
        configuration = null;
        return Settings.getConfiguration();
    }

    private static CompositeConfiguration loadTestConfigurations(CompositeConfiguration configuration) throws ConfigurationException {
        try {
            ClassLoader myClassLoader = Thread.currentThread().getContextClassLoader();
            log.debug("ClassLoader type: " + myClassLoader.getClass().getSimpleName());
            Class<?> testSettings = myClassLoader.loadClass("org.dataone.configuration.TestSettings");
            try {
                Method getTestConfigurations = testSettings.getMethod("getConfiguration", null);
                configuration = (CompositeConfiguration)getTestConfigurations.invoke(null, (Object[])null);
            }
            catch (Exception e) {
                String message = "General Problem loading TestSettings. " + e.getClass().getSimpleName() + ": " + e.getMessage();
                log.error(message, e);
                throw new ConfigurationException(message);
            }
        }
        catch (ClassNotFoundException e) {
            log.debug("TestSettings not found: assume production context");
        }
        return configuration;
    }

    public static void augmentConfiguration(String fileName) throws ConfigurationException {
        PropertiesConfiguration config = new PropertiesConfiguration(fileName);
        CompositeConfiguration compositeConfiguration = new CompositeConfiguration();
        compositeConfiguration.addConfiguration(config);
        int size = ((CompositeConfiguration)Settings.getConfiguration()).getNumberOfConfigurations();
        for (int i = 0; i < size; ++i) {
            Configuration c = ((CompositeConfiguration)Settings.getConfiguration()).getConfiguration(i);
            compositeConfiguration.addConfiguration(c);
        }
        configuration = compositeConfiguration;
    }

    static {
        AbstractConfiguration.setDefaultListDelimiter(';');
    }
}

