/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ejb.util;

import java.io.ObjectInputStream;
import java.io.Serializable;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import javax.persistence.PersistenceException;
import javax.persistence.spi.LoadState;
import org.hibernate.AssertionFailure;
import org.hibernate.collection.PersistentCollection;
import org.hibernate.intercept.FieldInterceptionHelper;
import org.hibernate.intercept.FieldInterceptor;
import org.hibernate.proxy.HibernateProxy;
import org.hibernate.proxy.LazyInitializer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PersistenceUtilHelper {
    public static LoadState isLoadedWithoutReference(Object proxy, String property, MetadataCache cache) {
        Object entity;
        boolean sureFromUs = false;
        if (proxy instanceof HibernateProxy) {
            LazyInitializer li = ((HibernateProxy)proxy).getHibernateLazyInitializer();
            if (li.isUninitialized()) {
                return LoadState.NOT_LOADED;
            }
            entity = li.getImplementation();
            sureFromUs = true;
        } else {
            entity = proxy;
        }
        if (FieldInterceptionHelper.isInstrumented(entity)) {
            LoadState state;
            boolean isInitialized;
            FieldInterceptor interceptor = FieldInterceptionHelper.extractFieldInterceptor(entity);
            boolean bl = isInitialized = interceptor == null || interceptor.isInitialized(property);
            if (isInitialized && interceptor != null) {
                state = PersistenceUtilHelper.isLoaded(PersistenceUtilHelper.get(entity, property, cache));
                if (state == LoadState.UNKNOWN) {
                    state = LoadState.LOADED;
                }
            } else if (interceptor != null && !isInitialized) {
                state = LoadState.NOT_LOADED;
            } else if (sureFromUs) {
                state = PersistenceUtilHelper.isLoaded(PersistenceUtilHelper.get(entity, property, cache));
                if (state == LoadState.UNKNOWN) {
                    state = LoadState.LOADED;
                }
            } else {
                state = LoadState.UNKNOWN;
            }
            return state;
        }
        return LoadState.UNKNOWN;
    }

    public static LoadState isLoadedWithReference(Object proxy, String property, MetadataCache cache) {
        Object object = PersistenceUtilHelper.get(proxy, property, cache);
        return PersistenceUtilHelper.isLoaded(object);
    }

    private static Object get(Object proxy, String property, MetadataCache cache) {
        Class<?> clazz = proxy.getClass();
        try {
            Member member = cache.getMember(clazz, property);
            if (member instanceof Field) {
                return ((Field)member).get(proxy);
            }
            if (member instanceof Method) {
                return ((Method)member).invoke(proxy, new Object[0]);
            }
            throw new AssertionFailure("Member object neither Field nor Method: " + member);
        }
        catch (IllegalAccessException e) {
            throw new PersistenceException("Unable to access field or method: " + clazz + "#" + property, e);
        }
        catch (InvocationTargetException e) {
            throw new PersistenceException("Unable to access field or method: " + clazz + "#" + property, e);
        }
    }

    private static void setAccessibility(Member member) {
        ((AccessibleObject)((Object)member)).setAccessible(true);
    }

    public static LoadState isLoaded(Object o) {
        if (o instanceof HibernateProxy) {
            boolean isInitialized = !((HibernateProxy)o).getHibernateLazyInitializer().isUninitialized();
            return isInitialized ? LoadState.LOADED : LoadState.NOT_LOADED;
        }
        if (o instanceof PersistentCollection) {
            boolean isInitialized = ((PersistentCollection)o).wasInitialized();
            return isInitialized ? LoadState.LOADED : LoadState.NOT_LOADED;
        }
        return LoadState.UNKNOWN;
    }

    private static Method getMethod(Class<?> clazz, String methodName) {
        try {
            char[] string = methodName.toCharArray();
            string[0] = Character.toUpperCase(string[0]);
            methodName = new String(string);
            try {
                return clazz.getDeclaredMethod("get" + methodName, new Class[0]);
            }
            catch (NoSuchMethodException e) {
                return clazz.getDeclaredMethod("is" + methodName, new Class[0]);
            }
        }
        catch (NoSuchMethodException e) {
            return null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class MetadataCache
    implements Serializable {
        private transient Map<Class<?>, ClassCache> classCache = new WeakHashMap();

        private void readObject(ObjectInputStream stream) {
            this.classCache = new WeakHashMap();
        }

        Member getMember(Class<?> clazz, String property) {
            Member member;
            ClassCache cache = this.classCache.get(clazz);
            if (cache == null) {
                cache = new ClassCache(clazz);
                this.classCache.put(clazz, cache);
            }
            if ((member = cache.members.get(property)) == null) {
                member = this.findMember(clazz, property);
                cache.members.put(property, member);
            }
            return member;
        }

        private Member findMember(Class<?> clazz, String property) {
            List<Class<?>> classes = this.getClassHierarchy(clazz);
            for (Class<?> current : classes) {
                try {
                    Field field = current.getDeclaredField(property);
                    PersistenceUtilHelper.setAccessibility(field);
                    return field;
                }
                catch (NoSuchFieldException e) {
                    Method method = PersistenceUtilHelper.getMethod(current, property);
                    if (method == null) continue;
                    PersistenceUtilHelper.setAccessibility(method);
                    return method;
                }
            }
            throw new PersistenceException("Unable to find field or method: " + clazz + "#" + property);
        }

        private List<Class<?>> getClassHierarchy(Class<?> clazz) {
            ClassCache cache = this.classCache.get(clazz);
            if (cache == null) {
                cache = new ClassCache(clazz);
                this.classCache.put(clazz, cache);
            }
            return cache.classHierarchy;
        }

        private static List<Class<?>> findClassHierarchy(Class<?> clazz) {
            ArrayList classes = new ArrayList();
            Class<?> current = clazz;
            do {
                classes.add(current);
            } while ((current = current.getSuperclass()) != null);
            return classes;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private static class ClassCache {
            List<Class<?>> classHierarchy;
            Map<String, Member> members = new HashMap<String, Member>();

            public ClassCache(Class<?> clazz) {
                this.classHierarchy = MetadataCache.findClassHierarchy(clazz);
            }
        }
    }
}

