/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.jpa.repository.support;

import com.mysema.query.jpa.EclipseLinkTemplates;
import com.mysema.query.jpa.HQLTemplates;
import com.mysema.query.jpa.JPQLQuery;
import com.mysema.query.jpa.JPQLTemplates;
import com.mysema.query.jpa.OpenJPATemplates;
import com.mysema.query.jpa.impl.JPAQuery;
import com.mysema.query.types.EntityPath;
import com.mysema.query.types.Expression;
import com.mysema.query.types.Order;
import com.mysema.query.types.OrderSpecifier;
import com.mysema.query.types.Path;
import com.mysema.query.types.path.EntityPathBase;
import com.mysema.query.types.path.PathBuilder;
import java.util.LinkedHashSet;
import javax.persistence.EntityManager;
import javax.persistence.metamodel.Attribute;
import javax.persistence.metamodel.EntityType;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.jpa.repository.support.PersistenceProvider;
import org.springframework.util.Assert;

public class Querydsl {
    private final EntityManager em;
    private final PersistenceProvider provider;
    private final PathBuilder<?> builder;

    public Querydsl(EntityManager em, PathBuilder<?> builder) {
        Assert.notNull(em);
        Assert.notNull(builder);
        this.em = em;
        this.provider = PersistenceProvider.fromEntityManager(em);
        this.builder = builder;
    }

    public JPQLQuery createQuery() {
        switch (this.provider) {
            case ECLIPSELINK: {
                return new JPAQuery(this.em, EclipseLinkTemplates.DEFAULT);
            }
            case HIBERNATE: {
                return new JPAQuery(this.em, (JPQLTemplates)HQLTemplates.DEFAULT);
            }
            case OPEN_JPA: {
                return new JPAQuery(this.em, OpenJPATemplates.DEFAULT);
            }
        }
        return new JPAQuery(this.em);
    }

    public JPQLQuery createQuery(EntityPath<?> ... paths) {
        return (JPQLQuery)this.createQuery().from(paths);
    }

    public JPQLQuery applyPagination(Pageable pageable, JPQLQuery query) {
        if (pageable == null) {
            return query;
        }
        query.offset((long)pageable.getOffset());
        query.limit((long)pageable.getPageSize());
        return this.applySorting(pageable.getSort(), query);
    }

    public JPQLQuery applySorting(Sort sort, JPQLQuery query) {
        if (sort == null) {
            return query;
        }
        for (Sort.Order order : sort) {
            query.orderBy(new OrderSpecifier[]{this.toOrder(order, query)});
        }
        return query;
    }

    private OrderSpecifier<?> toOrder(Sort.Order order, JPQLQuery query) {
        Expression<?> property = this.createExpressionAndPotentionallyAddLeftJoinForReferencedAssociation(order, query);
        return new OrderSpecifier(order.isAscending() ? Order.ASC : Order.DESC, property);
    }

    private Expression<?> createExpressionAndPotentionallyAddLeftJoinForReferencedAssociation(Sort.Order order, JPQLQuery query) {
        Assert.notNull(order, "Order must not be null!");
        Assert.notNull(query, "JPQLQuery must not be null!");
        if (!order.getProperty().contains(".")) {
            return order.isIgnoreCase() ? this.builder.getString(order.getProperty()).lower() : this.builder.get(order.getProperty());
        }
        EntityType entitytype = this.em.getMetamodel().entity(this.builder.getType());
        LinkedHashSet combinedAttributes = new LinkedHashSet();
        combinedAttributes.addAll(entitytype.getSingularAttributes());
        combinedAttributes.addAll(entitytype.getPluralAttributes());
        for (Attribute attribute : combinedAttributes) {
            if (!order.getProperty().startsWith(attribute.getName() + ".")) continue;
            switch (attribute.getPersistentAttributeType()) {
                case EMBEDDED: {
                    return this.builder.get(order.getProperty());
                }
            }
            return this.createLeftJoinForAttributeInOrderBy(attribute, order, query);
        }
        throw new IllegalArgumentException(String.format("Could not create property expression for %s", order.getProperty()));
    }

    private Expression<?> createLeftJoinForAttributeInOrderBy(Attribute<?, ?> attribute, Sort.Order order, JPQLQuery query) {
        EntityPathBase associationPathRoot = new EntityPathBase(attribute.getJavaType(), attribute.getName());
        query.leftJoin((EntityPath)this.builder.get(attribute.getName()), (Path)associationPathRoot);
        PathBuilder attributePathBuilder = new PathBuilder(attribute.getJavaType(), associationPathRoot.getMetadata());
        String nestedAttributePath = order.getProperty().substring(attribute.getName().length() + 1);
        return order.isIgnoreCase() ? attributePathBuilder.getString(nestedAttributePath).lower() : attributePathBuilder.get(nestedAttributePath);
    }
}

