/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.impl;

import com.hazelcast.impl.FallThroughRunnable;
import com.hazelcast.impl.Joiner;
import com.hazelcast.impl.Node;
import com.hazelcast.logging.ILogger;
import com.hazelcast.util.Clock;
import java.util.logging.Level;

public class SplitBrainHandler
implements Runnable {
    private final Node node;
    private final ILogger logger;
    private volatile long lastRun = 0L;
    private volatile boolean inProgress = false;
    private final long FIRST_RUN_DELAY_MILLIS;
    private final long NEXT_RUN_DELAY_MILLIS;

    public SplitBrainHandler(Node node) {
        this.node = node;
        this.logger = node.getLogger(SplitBrainHandler.class.getName());
        this.FIRST_RUN_DELAY_MILLIS = node.getGroupProperties().MERGE_FIRST_RUN_DELAY_SECONDS.getLong() * 1000L;
        this.NEXT_RUN_DELAY_MILLIS = node.getGroupProperties().MERGE_NEXT_RUN_DELAY_SECONDS.getLong() * 1000L;
        this.lastRun = Clock.currentTimeMillis() + this.FIRST_RUN_DELAY_MILLIS;
    }

    public void run() {
        if (this.node.isMaster() && this.node.joined() && this.node.isActive()) {
            long now2 = Clock.currentTimeMillis();
            if (!this.inProgress && now2 - this.lastRun > this.NEXT_RUN_DELAY_MILLIS && this.node.clusterManager.shouldTryMerge()) {
                this.inProgress = true;
                this.node.executorManager.executeNow(new FallThroughRunnable(){

                    public void doRun() {
                        SplitBrainHandler.this.searchForOtherClusters();
                        SplitBrainHandler.this.lastRun = Clock.currentTimeMillis();
                        SplitBrainHandler.this.inProgress = false;
                    }
                });
            }
        }
    }

    private void searchForOtherClusters() {
        Joiner joiner = this.node.getJoiner();
        if (joiner != null) {
            this.logger.log(Level.FINEST, "Searching for other clusters.");
            this.node.getSystemLogService().logJoin("Searching for other clusters.");
            joiner.searchForOtherClusters(this);
        }
    }

    public void restart() {
        this.lastRun = Clock.currentTimeMillis() + this.FIRST_RUN_DELAY_MILLIS;
        this.node.factory.restartToMerge();
    }
}

