/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.tdb.base.file;

import com.hp.hpl.jena.tdb.base.file.BufferAllocator;
import com.hp.hpl.jena.tdb.base.file.FileBase;
import com.hp.hpl.jena.tdb.base.file.FileException;
import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;

public final class BufferAllocatorMapped
implements BufferAllocator {
    private final List<MappedByteBuffer> segments;
    private final int segmentSize = 0x800000;
    private final int blockSize;
    private final int blocksPerSegment;
    private final File tmpFile;
    private FileBase file;
    private int seq = 0;

    public BufferAllocatorMapped(int blockSize) {
        if (blockSize == 0 || blockSize > 0x800000) {
            throw new IllegalArgumentException("Illegal block size: " + blockSize);
        }
        if (0x800000 % blockSize != 0) {
            throw new IllegalArgumentException(String.format("BufferAllocatorMapped: Segement size(%d) not a multiple of blocksize (%d)", 0x800000, blockSize));
        }
        this.blockSize = blockSize;
        this.blocksPerSegment = 0x800000 / blockSize;
        this.segments = new ArrayList<MappedByteBuffer>();
        this.tmpFile = this.getNewTemporaryFile();
        this.tmpFile.deleteOnExit();
    }

    private final File getNewTemporaryFile() {
        File sysTempDir = new File(System.getProperty("java.io.tmpdir"));
        File tmpFile = new File(sysTempDir, "JenaTempByteBuffer-" + UUID.randomUUID().toString() + ".tmp");
        return tmpFile;
    }

    private final int segment(int id) {
        return id / this.blocksPerSegment;
    }

    private final int byteOffset(int id) {
        return id % this.blocksPerSegment * this.blockSize;
    }

    private final long fileLocation(long segmentNumber) {
        return segmentNumber * 0x800000L;
    }

    @Override
    public ByteBuffer allocate(int blkSize) {
        MappedByteBuffer segBuffer;
        if (blkSize != this.blockSize) {
            throw new FileException("Fixed blocksize only: request= " + blkSize + "fixed size=" + this.blockSize);
        }
        if (null == this.file) {
            this.file = FileBase.create(this.tmpFile.getPath());
        }
        int id = this.seq++;
        int seg = this.segment(id);
        int segOff = this.byteOffset(id);
        if (seg >= this.segments.size()) {
            try {
                long offset = this.fileLocation(seg);
                segBuffer = this.file.channel().map(FileChannel.MapMode.READ_WRITE, offset, 0x800000L);
                this.segments.add(segBuffer);
            }
            catch (IOException e2) {
                throw new FileException("MappedFile.allocate: Segment= " + seg, e2);
            }
        } else {
            segBuffer = this.segments.get(seg);
        }
        segBuffer.position(segOff);
        segBuffer.limit(segOff + this.blockSize);
        ByteBuffer toReturn = segBuffer.slice();
        segBuffer.limit(segBuffer.capacity());
        return toReturn;
    }

    @Override
    public void clear() {
        this.seq = 0;
    }

    @Override
    public void close() {
        this.clear();
        this.segments.clear();
        this.file.close();
        this.file = null;
        this.tmpFile.delete();
    }
}

