/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.tdb.store;

import com.hp.hpl.jena.datatypes.xsd.XSDDatatype;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.sparql.util.Named;
import com.hp.hpl.jena.tdb.TDBException;

public enum NodeType implements Named
{
    BNODE{

        @Override
        public XSDDatatype getDatatype() {
            return null;
        }

        @Override
        public int getTypeId() {
            return 1;
        }

        @Override
        public String getName() {
            return "BNode";
        }
    }
    ,
    URI{

        @Override
        public XSDDatatype getDatatype() {
            return null;
        }

        @Override
        public int getTypeId() {
            return 2;
        }

        @Override
        public String getName() {
            return "URI";
        }
    }
    ,
    LITERAL{

        @Override
        public XSDDatatype getDatatype() {
            return null;
        }

        @Override
        public int getTypeId() {
            return 3;
        }

        @Override
        public String getName() {
            return "Literal";
        }
    }
    ,
    OTHER{

        @Override
        public XSDDatatype getDatatype() {
            return null;
        }

        @Override
        public int getTypeId() {
            return 50;
        }

        @Override
        public String getName() {
            return "Other";
        }
    };


    public abstract int getTypeId();

    public abstract XSDDatatype getDatatype();

    @Override
    public abstract String getName();

    public String toString() {
        return this.getName();
    }

    public static NodeType lookup(Node n) {
        if (n.isURI()) {
            return URI;
        }
        if (n.isBlank()) {
            return BNODE;
        }
        if (n.isLiteral()) {
            return LITERAL;
        }
        return OTHER;
    }

    public static NodeType lookup(int type) {
        if (type == BNODE.getTypeId()) {
            return BNODE;
        }
        if (type == URI.getTypeId()) {
            return URI;
        }
        if (type == LITERAL.getTypeId()) {
            return LITERAL;
        }
        throw new TDBException("Unknown type (" + type + ")");
    }
}

