/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.style;

import java.util.ArrayList;
import net.sf.saxon.expr.ErrorExpression;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.Literal;
import net.sf.saxon.expr.StringLiteral;
import net.sf.saxon.expr.ValueComparison;
import net.sf.saxon.expr.instruct.Block;
import net.sf.saxon.expr.instruct.Choose;
import net.sf.saxon.expr.parser.ExpressionVisitor;
import net.sf.saxon.expr.parser.RoleDiagnostic;
import net.sf.saxon.expr.parser.TypeChecker;
import net.sf.saxon.functions.SystemFunction;
import net.sf.saxon.lib.Feature;
import net.sf.saxon.ma.map.MapType;
import net.sf.saxon.om.AttributeCollection;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.pattern.AnyNodeTest;
import net.sf.saxon.style.Compilation;
import net.sf.saxon.style.ComponentDeclaration;
import net.sf.saxon.style.StyleElement;
import net.sf.saxon.style.XSLFallback;
import net.sf.saxon.style.XSLLocalParam;
import net.sf.saxon.style.XSLWithParam;
import net.sf.saxon.trans.Err;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.iter.AxisIterator;
import net.sf.saxon.type.AnyItemType;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.value.BooleanValue;
import net.sf.saxon.value.SequenceType;
import net.sf.saxon.value.Whitespace;

public class XSLEvaluate
extends StyleElement {
    Expression xpath = null;
    SequenceType requiredType = SequenceType.ANY_SEQUENCE;
    Expression namespaceContext = null;
    Expression contextItem = null;
    Expression baseUri = null;
    Expression schemaAware = null;
    Expression withParams = null;
    Expression options = null;
    boolean hasFallbackChildren;

    @Override
    public boolean isInstruction() {
        return true;
    }

    @Override
    protected boolean isPermittedChild(StyleElement child) {
        return child instanceof XSLLocalParam;
    }

    protected ItemType getReturnedItemType() {
        return AnyItemType.getInstance();
    }

    @Override
    public boolean mayContainSequenceConstructor() {
        return false;
    }

    @Override
    public void prepareAttributes() throws XPathException {
        AttributeCollection atts = this.getAttributeList();
        String xpathAtt = null;
        String asAtt = null;
        String contextItemAtt = null;
        String baseUriAtt = null;
        String namespaceContextAtt = null;
        String schemaAwareAtt = null;
        String withParamsAtt = null;
        block20: for (int a = 0; a < atts.getLength(); ++a) {
            String f;
            switch (f = atts.getQName(a)) {
                case "xpath": {
                    xpathAtt = atts.getValue(a);
                    this.xpath = this.makeExpression(xpathAtt, a);
                    continue block20;
                }
                case "as": {
                    asAtt = atts.getValue(a);
                    continue block20;
                }
                case "context-item": {
                    contextItemAtt = atts.getValue(a);
                    this.contextItem = this.makeExpression(contextItemAtt, a);
                    continue block20;
                }
                case "base-uri": {
                    baseUriAtt = atts.getValue(a);
                    this.baseUri = this.makeAttributeValueTemplate(baseUriAtt, a);
                    continue block20;
                }
                case "namespace-context": {
                    namespaceContextAtt = atts.getValue(a);
                    this.namespaceContext = this.makeExpression(namespaceContextAtt, a);
                    continue block20;
                }
                case "schema-aware": {
                    schemaAwareAtt = Whitespace.trim(atts.getValue(a));
                    this.schemaAware = this.makeAttributeValueTemplate(schemaAwareAtt, a);
                    continue block20;
                }
                case "with-params": {
                    withParamsAtt = atts.getValue(a);
                    this.withParams = this.makeExpression(withParamsAtt, a);
                    continue block20;
                }
                default: {
                    if (atts.getLocalName(a).equals("options") && atts.getURI(a).equals("http://saxon.sf.net/")) {
                        this.options = this.makeExpression(atts.getValue(a), a);
                        continue block20;
                    }
                    this.checkUnknownAttribute(atts.getNodeName(a));
                }
            }
        }
        if (xpathAtt == null) {
            this.reportAbsence("xpath");
        }
        if (asAtt != null) {
            this.requiredType = this.makeSequenceType(asAtt);
            try {
                this.requiredType = this.makeSequenceType(asAtt);
            }
            catch (XPathException e2) {
                this.compileErrorInAttribute(e2.getMessage(), e2.getErrorCodeLocalPart(), "as");
            }
        }
        if (contextItemAtt == null) {
            this.contextItem = Literal.makeEmptySequence();
        }
        if (schemaAwareAtt == null) {
            this.schemaAware = new StringLiteral("no");
        } else if (this.schemaAware instanceof StringLiteral) {
            this.checkAttributeValue("schema-aware", schemaAwareAtt, true, StyleElement.YES_NO);
        }
        if (withParamsAtt == null) {
            withParamsAtt = "map{}";
            this.withParams = this.makeExpression(withParamsAtt, -1);
        }
        if (this.options == null) {
            this.options = this.makeExpression("map{}", -1);
        }
    }

    @Override
    public void validate(ComponentDeclaration decl) throws XPathException {
        this.getContainingPackage().setRetainUnusedFunctions();
        if (this.xpath == null) {
            this.xpath = new StringLiteral("''");
        }
        this.xpath = this.typeCheck("xpath", this.xpath);
        this.baseUri = this.typeCheck("base-uri", this.baseUri);
        this.contextItem = this.typeCheck("context-item", this.contextItem);
        this.namespaceContext = this.typeCheck("namespace-context", this.namespaceContext);
        this.schemaAware = this.typeCheck("schema-aware", this.schemaAware);
        this.withParams = this.typeCheck("with-params", this.withParams);
        this.options = this.typeCheck("options", this.options);
        this.iterateAxis((byte)3).forEachOrFail(child -> {
            if (!(child instanceof XSLWithParam)) {
                if (child instanceof XSLFallback) {
                    this.hasFallbackChildren = true;
                } else if (child.getNodeKind() == 3) {
                    if (!Whitespace.isWhite(child.getStringValueCS())) {
                        this.compileError("No character data is allowed within xsl:evaluate", "XTSE0010");
                    }
                } else {
                    this.compileError("Child element " + Err.wrap(child.getDisplayName(), 1) + " is not allowed as a child of xsl:evaluate", "XTSE0010");
                }
            }
        });
        try {
            ExpressionVisitor visitor = this.makeExpressionVisitor();
            TypeChecker tc = this.getConfiguration().getTypeChecker(false);
            RoleDiagnostic role = new RoleDiagnostic(4, "xsl:evaluate/xpath", 0);
            this.xpath = tc.staticTypeCheck(this.xpath, SequenceType.SINGLE_STRING, role, visitor);
            role = new RoleDiagnostic(4, "xsl:evaluate/context-item", 0);
            role.setErrorCode("XTTE3210");
            this.contextItem = tc.staticTypeCheck(this.contextItem, SequenceType.OPTIONAL_ITEM, role, visitor);
            role = new RoleDiagnostic(4, "xsl:evaluate/namespace-context", 0);
            role.setErrorCode("XTTE3170");
            if (this.namespaceContext != null) {
                this.namespaceContext = tc.staticTypeCheck(this.namespaceContext, SequenceType.SINGLE_NODE, role, visitor);
            }
            role = new RoleDiagnostic(4, "xsl:evaluate/with-params", 0);
            role.setErrorCode("XTTE3170");
            this.withParams = tc.staticTypeCheck(this.withParams, SequenceType.makeSequenceType(MapType.ANY_MAP_TYPE, 16384), role, visitor);
            role = new RoleDiagnostic(4, "xsl:evaluate/saxon:options", 0);
            this.options = tc.staticTypeCheck(this.options, SequenceType.makeSequenceType(MapType.ANY_MAP_TYPE, 16384), role, visitor);
        }
        catch (XPathException err) {
            this.compileError(err);
        }
    }

    public Expression getTargetExpression() {
        return this.xpath;
    }

    public Expression getContextItemExpression() {
        return this.contextItem;
    }

    public Expression getBaseUriExpression() {
        return this.baseUri;
    }

    public Expression getNamespaceContextExpression() {
        return this.namespaceContext;
    }

    public Expression getSchemaAwareExpression() {
        return this.schemaAware;
    }

    public Expression getWithParamsExpression() {
        return this.withParams;
    }

    public Expression getOptionsExpression() {
        return this.options;
    }

    public SequenceType getRequiredType() {
        return this.requiredType;
    }

    @Override
    public Expression compile(Compilation exec, ComponentDeclaration decl) throws XPathException {
        if (this.getConfiguration().getBooleanProperty(Feature.DISABLE_XSL_EVALUATE)) {
            this.validationError = new XPathException("xsl:evaluate is not available in this configuration", "XTDE3175");
            return this.fallbackProcessing(exec, decl, this);
        }
        Expression evaluateExpr = this.getConfiguration().makeEvaluateInstruction(this, decl);
        if (evaluateExpr instanceof ErrorExpression) {
            return evaluateExpr;
        }
        if (this.hasFallbackChildren) {
            NodeInfo child;
            Expression[] conditions = new Expression[2];
            Expression sysProp = SystemFunction.makeCall("system-property", this.makeRetainedStaticContext(), new StringLiteral("Q{http://www.w3.org/1999/XSL/Transform}supports-dynamic-evaluation"));
            conditions[0] = new ValueComparison(sysProp, 50, new StringLiteral("no"));
            conditions[1] = Literal.makeLiteral(BooleanValue.TRUE);
            Expression[] actions2 = new Expression[2];
            ArrayList<Expression> fallbackExpressions = new ArrayList<Expression>();
            AxisIterator kids = this.iterateChildren(AnyNodeTest.getInstance());
            while ((child = kids.next()) != null) {
                if (!(child instanceof XSLFallback)) continue;
                fallbackExpressions.add(((XSLFallback)child).compileSequenceConstructor(exec, decl, false));
            }
            actions2[0] = new Block(fallbackExpressions.toArray(new Expression[0]));
            actions2[1] = evaluateExpr;
            return new Choose(conditions, actions2);
        }
        return evaluateExpr;
    }
}

