/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.type.descriptor.java;

import java.io.Serializable;
import java.util.UUID;
import org.hibernate.type.descriptor.WrapperOptions;
import org.hibernate.type.descriptor.java.AbstractTypeDescriptor;
import org.hibernate.util.BytesHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UUIDTypeDescriptor
extends AbstractTypeDescriptor<UUID> {
    public static final UUIDTypeDescriptor INSTANCE = new UUIDTypeDescriptor();

    public UUIDTypeDescriptor() {
        super(UUID.class);
    }

    @Override
    public String toString(UUID value) {
        return ToStringTransformer.INSTANCE.transform(value);
    }

    @Override
    public UUID fromString(String string) {
        return ToStringTransformer.INSTANCE.parse(string);
    }

    @Override
    public <X> X unwrap(UUID value, Class<X> type, WrapperOptions options) {
        if (value == null) {
            return null;
        }
        if (UUID.class.isAssignableFrom(type)) {
            return (X)PassThroughTransformer.INSTANCE.transform(value);
        }
        if (String.class.isAssignableFrom(type)) {
            return (X)ToStringTransformer.INSTANCE.transform(value);
        }
        if (byte[].class.isAssignableFrom(type)) {
            return (X)ToBytesTransformer.INSTANCE.transform(value);
        }
        throw this.unknownUnwrap(type);
    }

    @Override
    public <X> UUID wrap(X value, WrapperOptions options) {
        if (value == null) {
            return null;
        }
        if (UUID.class.isInstance(value)) {
            return PassThroughTransformer.INSTANCE.parse(value);
        }
        if (String.class.isInstance(value)) {
            return ToStringTransformer.INSTANCE.parse(value);
        }
        if (byte[].class.isInstance(value)) {
            return ToBytesTransformer.INSTANCE.parse(value);
        }
        throw this.unknownWrap(value.getClass());
    }

    public static class ToBytesTransformer
    implements ValueTransformer {
        public static final ToBytesTransformer INSTANCE = new ToBytesTransformer();

        public byte[] transform(UUID uuid2) {
            byte[] bytes = new byte[16];
            System.arraycopy(BytesHelper.fromLong(uuid2.getMostSignificantBits()), 0, bytes, 0, 8);
            System.arraycopy(BytesHelper.fromLong(uuid2.getLeastSignificantBits()), 0, bytes, 8, 8);
            return bytes;
        }

        public UUID parse(Object value) {
            byte[] msb = new byte[8];
            byte[] lsb = new byte[8];
            System.arraycopy(value, 0, msb, 0, 8);
            System.arraycopy(value, 8, lsb, 0, 8);
            return new UUID(BytesHelper.asLong(msb), BytesHelper.asLong(lsb));
        }
    }

    public static class ToStringTransformer
    implements ValueTransformer {
        public static final ToStringTransformer INSTANCE = new ToStringTransformer();

        public String transform(UUID uuid2) {
            return uuid2.toString();
        }

        public UUID parse(Object value) {
            return UUID.fromString((String)value);
        }
    }

    public static class PassThroughTransformer
    implements ValueTransformer {
        public static final PassThroughTransformer INSTANCE = new PassThroughTransformer();

        public UUID transform(UUID uuid2) {
            return uuid2;
        }

        public UUID parse(Object value) {
            return (UUID)value;
        }
    }

    public static interface ValueTransformer {
        public Serializable transform(UUID var1);

        public UUID parse(Object var1);
    }
}

