/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.reasoner.rulesys.builtins;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.NodeFactory;
import com.hp.hpl.jena.reasoner.rulesys.BindingEnvironment;
import com.hp.hpl.jena.reasoner.rulesys.BuiltinException;
import com.hp.hpl.jena.reasoner.rulesys.RuleContext;
import com.hp.hpl.jena.reasoner.rulesys.builtins.BaseBuiltin;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Regex
extends BaseBuiltin {
    @Override
    public String getName() {
        return "regex";
    }

    @Override
    public int getArgLength() {
        return 0;
    }

    @Override
    public boolean bodyCall(Node[] args, int length, RuleContext context) {
        if (length < 2) {
            throw new BuiltinException(this, context, "Must have at least 2 arguments to " + this.getName());
        }
        String text = this.getString(this.getArg(0, args, context), context);
        String pattern = this.getString(this.getArg(1, args, context), context);
        Matcher m = Pattern.compile(pattern).matcher(text);
        if (!m.matches()) {
            return false;
        }
        if (length > 2) {
            BindingEnvironment env = context.getEnv();
            for (int i = 0; i < Math.min(length - 2, m.groupCount()); ++i) {
                Node match2;
                String gm = m.group(i + 1);
                Node node = match2 = gm != null ? NodeFactory.createLiteral(gm) : NodeFactory.createLiteral("");
                if (env.bind(args[i + 2], match2)) continue;
                return false;
            }
        }
        return true;
    }

    protected String getString(Node n, RuleContext context) {
        if (n.isLiteral()) {
            return n.getLiteralLexicalForm();
        }
        throw new BuiltinException(this, context, this.getName() + " takes only literal arguments");
    }
}

