/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.tdb.base.file;

import com.hp.hpl.jena.tdb.base.StorageException;
import com.hp.hpl.jena.tdb.base.file.BufferChannel;
import java.nio.ByteBuffer;
import org.apache.jena.atlas.lib.ByteBufferLib;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BufferChannelMem
implements BufferChannel {
    private static Logger log = LoggerFactory.getLogger(BufferChannelMem.class);
    private ByteBuffer bytes;
    private String name;
    private static int INIT_SIZE = 1024;
    private static int INC_SIZE = 1024;
    private final boolean TRACKING;

    public static BufferChannel create() {
        return new BufferChannelMem("unnamed");
    }

    public static BufferChannel create(String name) {
        return new BufferChannelMem(name);
    }

    private BufferChannelMem() {
        this.TRACKING = false;
    }

    private BufferChannelMem(String name) {
        this.bytes = ByteBuffer.allocate(1024);
        this.bytes.limit(0);
        this.name = name;
        this.TRACKING = false;
    }

    @Override
    public synchronized BufferChannel duplicate() {
        BufferChannelMem chan = new BufferChannelMem();
        int x = this.bytes.position();
        this.bytes.rewind();
        chan.bytes = this.bytes.slice();
        chan.bytes.position(0);
        this.bytes.position(x);
        return chan;
    }

    @Override
    public synchronized long position() {
        this.checkIfClosed();
        return this.bytes.position();
    }

    @Override
    public synchronized void position(long pos) {
        this.checkIfClosed();
        if (pos < 0L || pos > (long)this.bytes.capacity()) {
            throw new StorageException("Out of range: " + pos);
        }
        this.bytes.position((int)pos);
    }

    @Override
    public synchronized int read(ByteBuffer buffer) {
        this.checkIfClosed();
        if (this.TRACKING) {
            this.log("read<<[" + buffer.capacity() + "]");
        }
        int x = this.bytes.position();
        int len = buffer.limit() - buffer.position();
        if (len > this.bytes.remaining()) {
            len = this.bytes.remaining();
        }
        for (int i = 0; i < len; ++i) {
            byte b = this.bytes.get();
            buffer.put(b);
        }
        if (this.TRACKING) {
            this.log("read>>");
        }
        return len;
    }

    @Override
    public synchronized int read(ByteBuffer buffer, long loc) {
        this.checkIfClosed();
        if (this.TRACKING) {
            this.log("read<<@" + loc);
        }
        if (loc < 0L || loc > (long)this.bytes.limit()) {
            throw new StorageException("Out of range(" + this.name + "[read]): " + loc + " [0," + this.bytes.limit() + ")");
        }
        if (loc == (long)this.bytes.limit()) {
            log.warn("At the limit(" + this.name + "[read]): " + loc);
        }
        int x = this.bytes.position();
        this.bytes.position((int)loc);
        int len = this.read(buffer);
        this.bytes.position(x);
        if (this.TRACKING) {
            this.log("read>>@" + loc);
        }
        return len;
    }

    @Override
    public synchronized int write(ByteBuffer buffer) {
        this.checkIfClosed();
        if (this.TRACKING) {
            this.log("write<<[" + buffer.capacity() + "]");
        }
        int len = buffer.limit() - buffer.position();
        int posn = this.bytes.position();
        int freespace = this.bytes.capacity() - this.bytes.position();
        if (len > freespace) {
            int inc = len - freespace;
            ByteBuffer bb2 = ByteBuffer.allocate(this.bytes.capacity() + (inc += INC_SIZE));
            this.bytes.position(0);
            bb2.put(this.bytes);
            bb2.limit(this.bytes.limit());
            bb2.position(posn);
            this.bytes = bb2;
        }
        if (this.bytes.limit() < posn + len) {
            this.bytes.limit(posn + len);
        }
        this.bytes.put(buffer);
        if (this.TRACKING) {
            this.log("write>>");
        }
        return len;
    }

    @Override
    public synchronized int write(ByteBuffer buffer, long loc) {
        this.checkIfClosed();
        if (this.TRACKING) {
            this.log("write<<@" + loc);
        }
        if (loc < 0L || loc > (long)this.bytes.limit()) {
            throw new StorageException("Out of range(" + this.name + "[write]): " + loc + " [0," + this.bytes.limit() + ")");
        }
        int x = this.bytes.position();
        this.bytes.position((int)loc);
        int len = this.write(buffer);
        this.bytes.position(x);
        if (this.TRACKING) {
            this.log("write>>@" + loc);
        }
        return len;
    }

    @Override
    public synchronized void truncate(long size) {
        this.checkIfClosed();
        int x = (int)size;
        if (x < 0) {
            throw new StorageException("Out of range: " + size);
        }
        if (x > this.bytes.limit()) {
            return;
        }
        if (this.bytes.position() > x) {
            this.bytes.position(x);
        }
        this.bytes.limit(x);
    }

    @Override
    public synchronized long size() {
        this.checkIfClosed();
        return this.bytes.limit();
    }

    @Override
    public synchronized boolean isEmpty() {
        this.checkIfClosed();
        return this.size() == 0L;
    }

    @Override
    public synchronized void sync() {
        this.checkIfClosed();
    }

    @Override
    public synchronized void close() {
        this.checkIfClosed();
        this.bytes = null;
    }

    private void checkIfClosed() {
        if (this.bytes == null) {
            throw new StorageException("Closed: " + this.name);
        }
    }

    @Override
    public synchronized String getLabel() {
        return this.name;
    }

    public synchronized String toString() {
        return this.name;
    }

    @Override
    public String getFilename() {
        return null;
    }

    private void log(String op) {
        if (this.TRACKING) {
            String msg = op + " [" + this.name + "] " + ByteBufferLib.details(this.bytes);
            log.debug(msg);
        }
    }
}

