/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.dom;

import net.sf.saxon.dom.NodeOverNodeInfo;
import net.sf.saxon.om.NamespaceBinding;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.tree.NamespaceNode;
import net.sf.saxon.tree.iter.AxisIterator;
import org.w3c.dom.DOMException;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

class DOMAttributeMap
implements NamedNodeMap {
    private NodeInfo parent;
    private int numberOfNamespaces = -1;
    private boolean excludeNamespaceUndeclarations;

    public DOMAttributeMap(NodeInfo parent) {
        this.parent = parent;
        if (parent.getConfiguration().getXMLVersion() == 10) {
            this.excludeNamespaceUndeclarations = true;
        }
    }

    private NamespaceBinding[] removeUndeclarations(NamespaceBinding[] bindings2) {
        if (this.excludeNamespaceUndeclarations) {
            int keep = 0;
            for (NamespaceBinding b : bindings2) {
                if (b == null || !b.getPrefix().isEmpty() && b.getURI().isEmpty()) continue;
                ++keep;
            }
            NamespaceBinding[] b2 = new NamespaceBinding[keep];
            keep = 0;
            for (NamespaceBinding b : bindings2) {
                if (b == null || !b.getPrefix().isEmpty() && b.getURI().isEmpty()) continue;
                b2[keep++] = b;
            }
            return b2;
        }
        return bindings2;
    }

    @Override
    public Node getNamedItem(String name) {
        NodeInfo att;
        if (name.equals("xmlns")) {
            NamespaceBinding[] nsarray = this.removeUndeclarations(this.parent.getDeclaredNamespaces(null));
            for (int i = 0; i < nsarray.length; ++i) {
                if (nsarray[i] == null) {
                    return null;
                }
                if (!nsarray[i].getPrefix().isEmpty()) continue;
                NamespaceNode nn = new NamespaceNode(this.parent, nsarray[i], i + 1);
                return NodeOverNodeInfo.wrap(nn);
            }
            return null;
        }
        if (name.startsWith("xmlns:")) {
            String prefix = name.substring(6);
            if (prefix.equals("xml")) {
                NamespaceNode nn = new NamespaceNode(this.parent, NamespaceBinding.XML, 0);
                return NodeOverNodeInfo.wrap(nn);
            }
            NamespaceBinding[] nsarray = this.removeUndeclarations(this.parent.getDeclaredNamespaces(null));
            for (int i = 0; i < nsarray.length; ++i) {
                if (nsarray[i] == null) {
                    return null;
                }
                if (!prefix.equals(nsarray[i].getPrefix())) continue;
                NamespaceNode nn = new NamespaceNode(this.parent, nsarray[i], i + 1);
                return NodeOverNodeInfo.wrap(nn);
            }
            return null;
        }
        AxisIterator atts = this.parent.iterateAxis((byte)2);
        do {
            if ((att = atts.next()) != null) continue;
            return null;
        } while (!name.equals(att.getDisplayName()));
        return NodeOverNodeInfo.wrap(att);
    }

    @Override
    public Node item(int index) {
        if (index < 0) {
            return null;
        }
        if (index == 0) {
            NamespaceNode nn = new NamespaceNode(this.parent, NamespaceBinding.XML, 0);
            return NodeOverNodeInfo.wrap(nn);
        }
        int nscount = this.getNumberOfNamespaces();
        if (index < nscount) {
            NamespaceBinding[] nsList = this.removeUndeclarations(this.parent.getDeclaredNamespaces(null));
            NamespaceBinding nscode = nsList[index - 1];
            NamespaceNode nn = new NamespaceNode(this.parent, nscode, index);
            return NodeOverNodeInfo.wrap(nn);
        }
        int pos = 0;
        int attNr = index - nscount;
        AxisIterator atts = this.parent.iterateAxis((byte)2);
        NodeInfo att;
        while ((att = atts.next()) != null) {
            if (pos == attNr) {
                return NodeOverNodeInfo.wrap(att);
            }
            ++pos;
        }
        return null;
    }

    private int getNumberOfNamespaces() {
        if (this.numberOfNamespaces == -1) {
            NamespaceBinding[] nsList = this.removeUndeclarations(this.parent.getDeclaredNamespaces(null));
            int count = nsList.length;
            for (int i = 0; i < count; ++i) {
                if (nsList[i] != null) continue;
                count = i;
                break;
            }
            this.numberOfNamespaces = count + 1;
        }
        return this.numberOfNamespaces;
    }

    @Override
    public int getLength() {
        int length = 0;
        AxisIterator atts = this.parent.iterateAxis((byte)2);
        while (atts.next() != null) {
            ++length;
        }
        return this.getNumberOfNamespaces() + length;
    }

    @Override
    public Node getNamedItemNS(String uri, String localName) {
        NodeInfo att;
        if (uri == null) {
            uri = "";
        }
        if ("http://www.w3.org/2000/xmlns/".equals(uri)) {
            return this.getNamedItem("xmlns:" + localName);
        }
        if (uri.equals("") && localName.equals("xmlns")) {
            return this.getNamedItem("xmlns");
        }
        AxisIterator atts = this.parent.iterateAxis((byte)2);
        do {
            if ((att = atts.next()) != null) continue;
            return null;
        } while (!uri.equals(att.getURI()) || !localName.equals(att.getLocalPart()));
        return NodeOverNodeInfo.wrap(att);
    }

    @Override
    public Node setNamedItem(Node arg) throws DOMException {
        NodeOverNodeInfo.disallowUpdate();
        return null;
    }

    @Override
    public Node removeNamedItem(String name) throws DOMException {
        NodeOverNodeInfo.disallowUpdate();
        return null;
    }

    @Override
    public Node setNamedItemNS(Node arg) throws DOMException {
        NodeOverNodeInfo.disallowUpdate();
        return null;
    }

    @Override
    public Node removeNamedItemNS(String uri, String localName) throws DOMException {
        NodeOverNodeInfo.disallowUpdate();
        return null;
    }
}

